/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.wcdma.rbs.bem.common.config.configitem.antennasystem.resource;

import java.text.MessageFormat;
import se.ericsson.wcdma.rbs.bem.common.config.custparam.BooleanCustomerParameter;
import se.ericsson.wcdma.rbs.bem.common.config.custparam.CustomerParameter;
import se.ericsson.wcdma.rbs.bem.common.config.rbs.Rbs;
import se.ericsson.wcdma.rbs.bem.common.config.resource.AbstractDbControlledAuxillaryUnitRI;
import se.ericsson.wcdma.rbs.bem.common.exception.BemException;
import se.ericsson.wcdma.rbs.bem.common.mohandler.MoHandler;
import se.ericsson.wcdma.rbs.bem.common.mohandler.MoHandlerException;
import se.ericsson.wcdma.rbs.bem.common.nal.ifc.NalNameValue;
import se.ericsson.wcdma.rbs.bem.common.proxy.BemMo;
import se.ericsson.wcdma.rbs.bem.common.util.BemUtil;

public class TmfRI
extends AbstractDbControlledAuxillaryUnitRI {
    public static final String name = "TmfDeviceGroup";
    public static final String piuTypeProductName = "TMF";
    private static final String[] myInstallationPhases = new String[]{"AuxUnitDbControlledCreationPhase", "AuxUnitReconfigureProgramPreparePhase", "UnlockAllUnitsPhase", "AuxUnitDbControlledDeletionPhase", "LockPhase", "UnlockPhase", "AuxPlugInUnitCreationPhase", "AuxUnitDbControlledDeletionPhase", "TmfSettingPhase"};
    private final String deviceGroupLdn;
    private final String tmfDeviceSetLdn;
    private final int sectorNo;
    private final int antNo;
    private MoHandler theMoHandler = this.rbs.getMoHandler();
    private boolean isPsiCoverage = false;

    public TmfRI(Rbs rbs, String string, String string2, String string3, int n, int n2) {
        super(name, rbs, 25, piuTypeProductName, myInstallationPhases, string3);
        this.setSwLoadable(false);
        this.deviceGroupLdn = string;
        this.tmfDeviceSetLdn = string2;
        this.sectorNo = n;
        this.antNo = n2;
    }

    public boolean isInstalled() throws BemException {
        return super.isExisting(this.deviceGroupLdn);
    }

    public String getLdn() {
        return this.deviceGroupLdn;
    }

    public String getDisplayName() {
        return "TmfDeviceGroup: " + this.getLdn();
    }

    protected static String getSectorPrefix(int n) {
        String string = MessageFormat.format("S{0}_", new Integer(n));
        return string;
    }

    public void install(String string) throws BemException {
        if (super.containsPhase(this.getInstallationPhases(), string)) {
            if (this.isPsiCoverage) {
                super.setUniqueHwId("" + this.antNo);
            }
            super.install(string);
            if (super.isExisting(this.tmfDeviceSetLdn) && string.equals("TmfSettingPhase")) {
                String string2 = "S" + this.sectorNo + "_";
                CustomerParameter customerParameter = this.rbs.getCustomerParameterObject(BemUtil.getCustomerParameterName(string2, "tmaType", this.antNo));
                BooleanCustomerParameter booleanCustomerParameter = (BooleanCustomerParameter)this.rbs.getCustomerParameterObject(string2 + "ModifyTmFile");
                if (customerParameter.hasValueChanged() || booleanCustomerParameter.getBooleanValue()) {
                    BemMo bemMo = this.theMoHandler.getMo(this.tmfDeviceSetLdn);
                    NalNameValue[] nalNameValueArray = new NalNameValue[]{};
                    try {
                        this.theMoHandler.action(bemMo, "configureTmf", nalNameValueArray);
                    }
                    catch (MoHandlerException moHandlerException) {
                        throw new BemException(moHandlerException.getAction(), this.tmfDeviceSetLdn, (Throwable)moHandlerException);
                    }
                }
            }
        }
    }

    public void setPsiConfiguration(boolean bl) {
        this.isPsiCoverage = bl;
    }
}

