/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.wcdma.rbs.bem.common.config.configitem.commonalarm.resource;

import java.text.MessageFormat;
import java.util.Vector;
import se.ericsson.wcdma.rbs.bem.common.config.custparam.CustomerParameterServer;
import se.ericsson.wcdma.rbs.bem.common.config.rbs.Rbs;
import se.ericsson.wcdma.rbs.bem.common.config.resource.AbstractResourceItem;
import se.ericsson.wcdma.rbs.bem.common.exception.BemException;
import se.ericsson.wcdma.rbs.bem.common.nal.ifc.Nal;
import se.ericsson.wcdma.rbs.bem.common.nal.ifc.NalNameValue;
import se.ericsson.wcdma.rbs.bem.common.proxy.BemMo;
import se.ericsson.wcdma.rbs.bem.common.proxy.BemMoImpl;
import se.ericsson.wcdma.rbs.bem.common.service.PrefixUtil;

public class AlarmPortRI
extends AbstractResourceItem {
    public static final String name = "AlarmPort";
    private static final String[] myInstallationPhases = new String[]{"ExternalAlarmCreationPhase"};
    private static final String[] pseudos = new String[]{"alarmSlogan", "normallyOpen", "severity", "probableCause", "alarmInExternalMe"};
    private static final String[] attributeNames = new String[]{"alarmSlogan", "normallyOpen", "perceivedSeverity", "probableCause", "alarmInExternalMe"};
    private String ldn = null;
    private String prefix = null;
    private String type;
    private Vector savedAttributes = new Vector();
    private String alarmSlogan = null;
    private Boolean normallyOpen;
    private Integer severity;
    private Integer probableCause;
    private Boolean alarmInExternalMe;
    private String savedAlarmSlogan = null;
    private Boolean savedNormallyOpen;
    private Integer savedSeverity;
    private Integer savedProbableCause;
    private Boolean savedAlarmInExternalMe;

    public AlarmPortRI(Rbs rbs, String string, String string2, int n) {
        super(name, rbs, myInstallationPhases);
        this.ldn = string;
        this.type = string2;
        BemMo bemMo = this.getMo(string);
        String string3 = bemMo.getId();
        String string4 = PrefixUtil.getCabinetPrefix(String.valueOf(n)) + string2 + "ExternalAlarm" + "{0}_";
        this.prefix = MessageFormat.format(string4, string3);
    }

    public void setLoadedValues() throws BemException {
        Object object;
        BemMo bemMo = this.getMo(this.ldn);
        for (int i = 0; i < pseudos.length; ++i) {
            object = this.prefix + pseudos[i];
            CustomerParameterServer customerParameterServer = this.rbs.getCustomerParameterServerObject((String)object);
            Object object2 = this.getAttribute(bemMo, attributeNames[i]);
            customerParameterServer.setLoadedValue(object2);
        }
        String string = this.prefix + "externalAlarmUnit";
        object = this.rbs.getCustomerParameterServerObject(string);
        object.setLoadedValue(this.type);
    }

    public void install(String string) throws BemException {
        if (myInstallationPhases[0].equals(string)) {
            Object object;
            Vector vector = new Vector();
            if (this.savedAttributes.size() == 0) {
                object = this.rbs.getCustomerParameterServerObject(this.prefix + "alarmSlogan");
                this.alarmSlogan = (String)object.getValueMom();
                object = this.rbs.getCustomerParameterServerObject(this.prefix + "normallyOpen");
                this.normallyOpen = (Boolean)object.getValueMom();
                object = this.rbs.getCustomerParameterServerObject(this.prefix + "severity");
                this.severity = (Integer)object.getValueMom();
                object = this.rbs.getCustomerParameterServerObject(this.prefix + "probableCause");
                this.probableCause = Integer.valueOf((String)object.getValueMom());
                object = this.rbs.getCustomerParameterServerObject(this.prefix + "alarmInExternalMe");
                this.alarmInExternalMe = (Boolean)object.getValueMom();
                vector.add(Nal.getFactory().getNameValue("alarmSlogan", this.alarmSlogan));
                vector.add(Nal.getFactory().getNameValue("normallyOpen", this.normallyOpen));
                vector.add(Nal.getFactory().getNameValue("perceivedSeverity", this.severity));
                vector.add(Nal.getFactory().getNameValue("probableCause", this.probableCause));
                vector.add(Nal.getFactory().getNameValue("alarmInExternalMe", this.alarmInExternalMe));
            } else {
                vector = this.savedAttributes;
                this.alarmSlogan = this.savedAlarmSlogan;
                this.normallyOpen = this.savedNormallyOpen;
                this.severity = this.savedSeverity;
                this.probableCause = this.savedProbableCause;
                this.alarmInExternalMe = this.savedAlarmInExternalMe;
            }
            this.verifyAttributes();
            object = this.getMo(this.ldn);
            if (object.isExisting()) {
                Vector vector2 = this.getLoadedValues();
                if (vector2 != null) {
                    for (int i = 0; i < vector2.size(); ++i) {
                        if (vector2.elementAt(i).toString().endsWith(vector.elementAt(i).toString())) continue;
                        this.setAlarmPortAttributes((BemMo)object, vector);
                        break;
                    }
                }
            } else if (this.rbs.getRbsStep().equals("STEP_SITE")) {
                int n = this.prefix.indexOf("ExternalAlarm");
                String string2 = this.prefix.substring(0, n);
                throw new BemException("AlarmPortRI.install error, " + string2 + " does not exist.");
            }
        }
    }

    public boolean isInstalled(String string) throws BemException {
        boolean bl = true;
        BemMoImpl bemMoImpl = new BemMoImpl(string);
        if (this.isExisting(bemMoImpl)) {
            Integer n = (Integer)this.getAttribute(bemMoImpl, "administrativeState");
            if (n == 0) {
                bl = false;
            }
        } else {
            bl = false;
        }
        return bl;
    }

    public void saveAttributes() throws BemException {
        BemMo bemMo = this.getMo(this.ldn);
        String string = "alarmSlogan";
        String string2 = (String)this.getAttribute(bemMo, string);
        this.savedAttributes.add(Nal.getFactory().getNameValue(string, string2));
        string = "normallyOpen";
        Boolean bl = (Boolean)this.getAttribute(bemMo, string);
        this.savedAttributes.add(Nal.getFactory().getNameValue(string, bl));
        string = "perceivedSeverity";
        Integer n = (Integer)this.getAttribute(bemMo, string);
        this.savedAttributes.add(Nal.getFactory().getNameValue(string, n));
        string = "probableCause";
        Integer n2 = (Integer)this.getAttribute(bemMo, string);
        this.savedAttributes.add(Nal.getFactory().getNameValue(string, n2));
        string = "alarmInExternalMe";
        Boolean bl2 = (Boolean)this.getAttribute(bemMo, string);
        this.savedAttributes.add(Nal.getFactory().getNameValue(string, bl2));
        this.savedAlarmSlogan = string2;
        this.savedNormallyOpen = bl;
        this.savedSeverity = n;
        this.savedProbableCause = n2;
        this.savedAlarmInExternalMe = bl2;
    }

    private void setAlarmPortAttributes(BemMo bemMo, Vector vector) throws BemException {
        if (vector != null && !vector.isEmpty()) {
            this.lockPort(bemMo);
            this.setAttributes(bemMo, vector);
            this.unlockPort(bemMo);
        }
    }

    private void lockPort(BemMo bemMo) throws BemException {
        Integer n = (Integer)this.getAttribute(bemMo, "administrativeState");
        if (n == 1) {
            this.setAttribute(bemMo, "administrativeState", (Object)new Integer(0));
        }
    }

    private void unlockPort(BemMo bemMo) throws BemException {
        Integer n = (Integer)this.getAttribute(bemMo, "administrativeState");
        if (n == 0) {
            this.setAttribute(bemMo, "administrativeState", (Object)new Integer(1));
        }
    }

    private Vector getLoadedValues() throws BemException {
        Vector<NalNameValue> vector = new Vector<NalNameValue>();
        BemMo bemMo = this.getMo(this.ldn);
        Object object = this.getAttribute(bemMo, "alarmSlogan");
        vector.add(Nal.getFactory().getNameValue("alarmSlogan", object));
        object = this.getAttribute(bemMo, "normallyOpen");
        vector.add(Nal.getFactory().getNameValue("normallyOpen", object));
        object = this.getAttribute(bemMo, "perceivedSeverity");
        vector.add(Nal.getFactory().getNameValue("perceivedSeverity", object));
        object = this.getAttribute(bemMo, "probableCause");
        vector.add(Nal.getFactory().getNameValue("probableCause", object));
        object = this.getAttribute(bemMo, "alarmInExternalMe");
        vector.add(Nal.getFactory().getNameValue("alarmInExternalMe", object));
        return vector;
    }

    public String getLdn() {
        return this.ldn;
    }

    public String getDisplayName() {
        return "AlarmPort: " + this.getLdn();
    }

    private void verifyAttributes() throws BemException {
        if (this.alarmSlogan == null) {
            throw new BemException("AlarmPortRI.verifyAttributes() alarmSlogan is null for\n" + this.getDisplayName());
        }
        if (this.normallyOpen == null) {
            throw new BemException("AlarmPortRI.verifyAttributes() normallyOpen is null for\n" + this.getDisplayName());
        }
        if (!this.normallyOpen.toString().equalsIgnoreCase("true") && !this.normallyOpen.toString().equalsIgnoreCase("false")) {
            throw new BemException("AlarmPortRI.verifyAttributes() normallyOpen is not in range\n" + this.getDisplayName());
        }
        if (this.probableCause == null) {
            throw new BemException("AlarmPortRI.verifyAttributes() probableCause is null for\n" + this.getDisplayName());
        }
        try {
            Integer.getInteger(this.probableCause.toString());
        }
        catch (Exception exception) {
            throw new BemException("AlarmPortRI.verifyAttributes() probableCause can not be formatted to int.\nValue=" + this.probableCause + "\n" + this.getDisplayName());
        }
        if (this.severity.toString() == null) {
            throw new BemException("AlarmPortRI.verifyAttributes() severity is null for\n" + this.getDisplayName());
        }
        if (this.alarmInExternalMe == null) {
            throw new BemException("AlarmPortRI.verifyAttributes() alarmInExternalMe is null for\n" + this.getDisplayName());
        }
        if (!this.alarmInExternalMe.toString().equalsIgnoreCase("TRUE") && !this.alarmInExternalMe.toString().equalsIgnoreCase("FALSE")) {
            throw new BemException("AlarmPortRI.verifyAttributes() alarmInExternalMe is not in range\n" + this.getDisplayName());
        }
    }

    public String getType() {
        return this.type;
    }

    Vector getSavedAttributes() {
        return this.savedAttributes;
    }

    String getSavedAlarmSlogan() {
        return this.savedAlarmSlogan;
    }

    Boolean getSavedNormallyOpen() {
        return this.savedNormallyOpen;
    }

    Integer getSavedProbableCause() {
        return this.savedProbableCause;
    }

    Integer getSavedSeverity() {
        return this.savedSeverity;
    }

    public String getPrefix() {
        return this.prefix;
    }

    Boolean getSavedAlarmInExternalMe() {
        return this.savedAlarmInExternalMe;
    }
}

