/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.wcdma.rbs.bem.common.config.configitem.etmboard;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.StringTokenizer;
import se.ericsson.wcdma.rbs.bem.common.BemLog;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.AbstractConfigurationItem;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.etmboard.CbuBasedEtmRI;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.etmboard.Etm1RI;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.etmboard.Etm3RI;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.etmboard.Etm4RI;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.etmboard.EtmBoard;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.etmboard.Etmc1RI;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.etmboard.Etmc41RI;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.etmboard.SlotListBuilder;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.etmboard.SlotListParameter;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.etmboard.SlotListRange;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.etmboard.resource.DeleteEtmfx11RI;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.etmboard.resource.Etmfx11RI;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.etmboard.resource.Etmfx14RI;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.provider.EtmBoardListener;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.provider.EtmBoardProvider;
import se.ericsson.wcdma.rbs.bem.common.config.custparam.CustomerParameter;
import se.ericsson.wcdma.rbs.bem.common.config.custparam.CustomerParameterException;
import se.ericsson.wcdma.rbs.bem.common.config.custparam.CustomerParameterListener;
import se.ericsson.wcdma.rbs.bem.common.config.custparam.OutOfRangeException;
import se.ericsson.wcdma.rbs.bem.common.config.custparam.ParameterEvent;
import se.ericsson.wcdma.rbs.bem.common.config.custparam.ParameterRestriction;
import se.ericsson.wcdma.rbs.bem.common.config.rbs.Rbs;
import se.ericsson.wcdma.rbs.bem.common.config.resource.ResourceItem;
import se.ericsson.wcdma.rbs.bem.common.exception.BemException;
import se.ericsson.wcdma.rbs.bem.common.mim.MimCbu;
import se.ericsson.wcdma.rbs.bem.common.moi.LdnMoi;
import se.ericsson.wcdma.rbs.bem.common.moi.MoInstance;
import se.ericsson.wcdma.rbs.bem.common.service.ServiceValue;
import se.ericsson.wcdma.rbs.bem.common.util.BemUtil;

public abstract class AbstractEtmBoardCI
extends AbstractConfigurationItem
implements CustomerParameterListener,
EtmBoardProvider {
    public static final String name = "EtmBoardCI";
    static final String[] PSEUDO_SLOTS = new String[]{"slotsForETM1", "slotsForETMC1", "slotsForETM3", "slotsForETM4", "slotsForETMC41s", "slotsForETMFX11", "slotsForETMFX14"};
    private static final String[] SUPPORTED_ATM_ETM_BOARD_TYPES_FOR_RBS3_AND_RBS4 = new String[]{MimCbu.MOTYPENAME, "Etm1", "Etmc1", "Etm3", "Etm4", "Etmc41"};
    private static final String[] SUPPORTED_IP_ETM_BOARD_TYPES_FOR_RBS3_AND_RBS4 = new String[]{"Etmfx11", "Etmfx14"};
    private final HashMap allResourceItems = new HashMap();
    private final HashMap allSlotListParameters = new HashMap();
    private final List supportedEtmTypes = new ArrayList();
    private final HashMap etmExistingSlots = new HashMap();
    private final String[] supportedEtmBoardSlots;
    private boolean isOpen = false;
    private final ArrayList EtmBoardListenerList = new ArrayList();

    public AbstractEtmBoardCI(Rbs rbs, String[] stringArray) {
        super(rbs);
        this.supportedEtmBoardSlots = stringArray;
        this.supportedEtmTypes.add("slotsForETM1");
        this.supportedEtmTypes.add("slotsForETMC1");
        this.supportedEtmTypes.add("slotsForETM3");
        this.supportedEtmTypes.add("slotsForETM4");
        this.supportedEtmTypes.add("slotsForETMC41s");
        this.supportedEtmTypes.add("slotsForETMFX11");
        this.supportedEtmTypes.add("slotsForETMFX14");
    }

    protected void removeEtmType(String string) {
        this.supportedEtmTypes.remove(string);
    }

    private void setEtmExisting(String string, String string2, ResourceItem resourceItem) throws BemException {
        boolean bl = resourceItem.isInstalled();
        if (bl) {
            this.etmExistingSlots.put(string, string2);
            SlotListParameter slotListParameter = (SlotListParameter)this.allSlotListParameters.get(string2);
            String string3 = slotListParameter.getLoadedValue();
            List<String> list = new ArrayList<String>();
            if (!string3.equals("##UNDEFINED") && !string3.equals("0")) {
                list = slotListParameter.getValueArrayList(string3);
            }
            list.add(string);
            String[] stringArray = list.toArray(new String[0]);
            String string4 = BemUtil.getCommaSeparatedValueString(stringArray);
            slotListParameter.setLoadedValue(string4);
        }
    }

    public boolean open() throws BemException {
        if (this.isOpen) {
            throw new BemException("AbstractEtmBoardCI.open(): Already open");
        }
        this.initialiseCustomerParameters();
        this.createAllResourceItems();
        this.isOpen = true;
        return this.isOpen;
    }

    private void createAllResourceItems() throws BemException {
        this.createEtm1RIs();
        this.createEtmc1RIs();
        this.createEtm3RIs();
        this.createEtm4RIs();
        this.createEtmc41RIs();
        this.createEtmfx11RIs();
        this.createEtmfx14RIs();
    }

    private void createEtm1RIs() throws BemException {
        String string = "slotsForETM1";
        if (this.supportedEtmTypes.contains(string)) {
            HashMap<String, Etm1RI> hashMap = new HashMap<String, Etm1RI>();
            for (int i = 0; i < this.supportedEtmBoardSlots.length; ++i) {
                Etm1RI etm1RI = new Etm1RI(this.getRbs(), Integer.parseInt(this.supportedEtmBoardSlots[i]));
                hashMap.put(this.supportedEtmBoardSlots[i], etm1RI);
                this.setEtmExisting(this.supportedEtmBoardSlots[i], string, etm1RI);
            }
            this.allResourceItems.put(string, hashMap);
        }
    }

    private void createEtmc1RIs() throws BemException {
        String string = "slotsForETMC1";
        if (this.supportedEtmTypes.contains(string)) {
            HashMap<String, Etmc1RI> hashMap = new HashMap<String, Etmc1RI>();
            for (int i = 0; i < this.supportedEtmBoardSlots.length; ++i) {
                Etmc1RI etmc1RI = new Etmc1RI(this.getRbs(), Integer.parseInt(this.supportedEtmBoardSlots[i]));
                hashMap.put(this.supportedEtmBoardSlots[i], etmc1RI);
                this.setEtmExisting(this.supportedEtmBoardSlots[i], string, etmc1RI);
            }
            this.allResourceItems.put(string, hashMap);
        }
    }

    private void createEtmc41RIs() throws BemException {
        String string = "slotsForETMC41s";
        if (this.supportedEtmTypes.contains(string)) {
            HashMap<String, Etmc41RI> hashMap = new HashMap<String, Etmc41RI>();
            for (int i = 0; i < this.supportedEtmBoardSlots.length; ++i) {
                Etmc41RI etmc41RI = new Etmc41RI(this.getRbs(), Integer.parseInt(this.supportedEtmBoardSlots[i]));
                hashMap.put(this.supportedEtmBoardSlots[i], etmc41RI);
                this.setEtmExisting(this.supportedEtmBoardSlots[i], string, etmc41RI);
            }
            this.allResourceItems.put(string, hashMap);
        }
    }

    private void createEtm3RIs() throws BemException {
        String string = "slotsForETM3";
        if (this.supportedEtmTypes.contains(string)) {
            HashMap<String, Etm3RI> hashMap = new HashMap<String, Etm3RI>();
            for (int i = 0; i < this.supportedEtmBoardSlots.length; ++i) {
                Etm3RI etm3RI = new Etm3RI(this.getRbs(), Integer.parseInt(this.supportedEtmBoardSlots[i]));
                hashMap.put(this.supportedEtmBoardSlots[i], etm3RI);
                this.setEtmExisting(this.supportedEtmBoardSlots[i], string, etm3RI);
            }
            this.allResourceItems.put(string, hashMap);
        }
    }

    private void createEtm4RIs() throws BemException {
        String string = "slotsForETM4";
        if (this.supportedEtmTypes.contains(string)) {
            HashMap<String, Etm4RI> hashMap = new HashMap<String, Etm4RI>();
            for (int i = 0; i < this.supportedEtmBoardSlots.length; ++i) {
                Etm4RI etm4RI = new Etm4RI(this.getRbs(), Integer.parseInt(this.supportedEtmBoardSlots[i]));
                hashMap.put(this.supportedEtmBoardSlots[i], etm4RI);
                this.setEtmExisting(this.supportedEtmBoardSlots[i], string, etm4RI);
            }
            this.allResourceItems.put(string, hashMap);
        }
    }

    private void createEtmfx11RIs() throws BemException {
        String string = "slotsForETMFX11";
        if (this.supportedEtmTypes.contains(string)) {
            HashMap<String, Etmfx11RI> hashMap = new HashMap<String, Etmfx11RI>();
            for (int i = 0; i < this.supportedEtmBoardSlots.length; ++i) {
                Etmfx11RI etmfx11RI = new Etmfx11RI(this.getRbs(), Integer.parseInt(this.supportedEtmBoardSlots[i]));
                hashMap.put(this.supportedEtmBoardSlots[i], etmfx11RI);
                this.setEtmExisting(this.supportedEtmBoardSlots[i], string, etmfx11RI);
            }
            this.allResourceItems.put(string, hashMap);
        }
    }

    private void createEtmfx14RIs() throws BemException {
        String string = "slotsForETMFX14";
        if (this.supportedEtmTypes.contains(string)) {
            HashMap<String, Etmfx14RI> hashMap = new HashMap<String, Etmfx14RI>();
            for (int i = 0; i < this.supportedEtmBoardSlots.length; ++i) {
                Etmfx14RI etmfx14RI = new Etmfx14RI(this.getRbs(), Integer.parseInt(this.supportedEtmBoardSlots[i]));
                hashMap.put(this.supportedEtmBoardSlots[i], etmfx14RI);
                this.setEtmExisting(this.supportedEtmBoardSlots[i], string, etmfx14RI);
            }
            this.allResourceItems.put(string, hashMap);
        }
    }

    private void initialiseCustomerParameters() throws BemException {
        SlotListBuilder slotListBuilder = new SlotListBuilder();
        for (int i = 0; i < PSEUDO_SLOTS.length; ++i) {
            SlotListParameter slotListParameter;
            SlotListRange slotListRange;
            if (this.supportedEtmTypes.contains(PSEUDO_SLOTS[i])) {
                slotListRange = new SlotListRange(this.supportedEtmBoardSlots);
                slotListParameter = slotListBuilder.buildSlotListParameter(PSEUDO_SLOTS[i], slotListRange);
                slotListParameter.setDefaultValue("0");
                slotListParameter.setLoadedValue("0");
                slotListParameter.addCustomerParameterListener(this);
                this.addParameter(slotListParameter);
                this.allSlotListParameters.put(PSEUDO_SLOTS[i], slotListParameter);
                continue;
            }
            slotListRange = new SlotListRange(new String[]{"0"});
            slotListParameter = slotListBuilder.buildSlotListParameter(PSEUDO_SLOTS[i], slotListRange);
            ParameterRestriction parameterRestriction = new ParameterRestriction("Board type is not supported", slotListRange, true);
            slotListParameter.addRestriction(parameterRestriction);
            slotListParameter.setDefaultValue("0");
            slotListParameter.addCustomerParameterListener(this);
            this.addParameter(slotListParameter);
        }
        this.updateParameterProperties();
    }

    public void checkConsistency() throws BemException {
        String[] stringArray;
        HashMap hashMap;
        Object object;
        super.checkConsistency();
        if (this.isEtmBoardMandatory()) {
            boolean bl = false;
            for (int i = 0; i < PSEUDO_SLOTS.length; ++i) {
                object = (SlotListParameter)this.allSlotListParameters.get(PSEUDO_SLOTS[i]);
                if (object == null || (hashMap = (HashMap)this.allResourceItems.get(PSEUDO_SLOTS[i])) == null || (stringArray = ((SlotListParameter)object).getAllSlots()).length <= 0) continue;
                bl = true;
            }
            if (!bl) {
                throw new BemException("Missing ET board. At least one ET board must be defined.");
            }
        }
        SlotListParameter slotListParameter = (SlotListParameter)this.allSlotListParameters.get("slotsForETMFX11");
        SlotListParameter slotListParameter2 = (SlotListParameter)this.allSlotListParameters.get("slotsForETMFX14");
        if (slotListParameter != null && slotListParameter2 != null) {
            String[] stringArray2;
            object = (HashMap)this.allResourceItems.get("slotsForETMFX11");
            hashMap = (HashMap)this.allResourceItems.get("slotsForETMFX14");
            if (object != null && hashMap != null && (stringArray = slotListParameter.getAllSlots()).length + (stringArray2 = slotListParameter2.getAllSlots()).length > 1) {
                throw new BemException("Multiple ET-MFX boards not allowed");
            }
        }
    }

    protected boolean isEtmBoardMandatory() {
        return false;
    }

    public ArrayList getNeededRIs() throws BemException {
        ArrayList<DeleteEtmfx11RI> arrayList = new ArrayList<DeleteEtmfx11RI>();
        if (!this.isOpen) {
            throw new BemException("AbstractEtmBoardCI is not open");
        }
        arrayList.addAll(this.getNeededEtmRIs());
        if (this.getRbs().getRbsStep().equals("STEP_CABINET")) {
            BemLog.log(7, "EtmBoardCI creating DeleteEtmfx11RIs");
            DeleteEtmfx11RI deleteEtmfx11RI = new DeleteEtmfx11RI(this.getRbs(), 2);
            DeleteEtmfx11RI deleteEtmfx11RI2 = new DeleteEtmfx11RI(this.getRbs(), 3);
            arrayList.add(deleteEtmfx11RI);
            arrayList.add(deleteEtmfx11RI2);
        }
        return arrayList;
    }

    private List getNeededEtmRIs() throws BemException {
        ArrayList arrayList = new ArrayList();
        for (int i = 0; i < PSEUDO_SLOTS.length; ++i) {
            SlotListParameter slotListParameter = (SlotListParameter)this.allSlotListParameters.get(PSEUDO_SLOTS[i]);
            if (slotListParameter == null) continue;
            boolean bl = slotListParameter.isValidValue();
            if (!bl) {
                throw new BemException(PSEUDO_SLOTS[i] + " uses an occupied slot.");
            }
            HashMap hashMap = (HashMap)this.allResourceItems.get(PSEUDO_SLOTS[i]);
            if (hashMap == null) continue;
            String[] stringArray = slotListParameter.getAllSlots();
            ArrayList arrayList2 = new ArrayList();
            arrayList2 = this.getRIsForSlots(hashMap, stringArray);
            arrayList.addAll(arrayList2);
        }
        return arrayList;
    }

    private ArrayList getRIsForSlots(HashMap hashMap, String[] stringArray) {
        ArrayList arrayList = new ArrayList();
        for (int i = 0; i < stringArray.length; ++i) {
            arrayList.add(hashMap.get(stringArray[i]));
        }
        return arrayList;
    }

    public void parameterPropertiesChanged(CustomerParameter customerParameter, ParameterEvent parameterEvent) {
        this.updateParameterProperties();
        this.notifyAllEtmBoardListeners(customerParameter, parameterEvent);
    }

    public void notifyAllEtmBoardListeners(CustomerParameter customerParameter, ParameterEvent parameterEvent) {
        for (EtmBoardListener etmBoardListener : this.EtmBoardListenerList) {
            etmBoardListener.update();
        }
    }

    public void updateParameterProperties() {
    }

    public void setCustomerParameters(ServiceValue serviceValue) throws OutOfRangeException, CustomerParameterException, BemException {
        String[] stringArray = PSEUDO_SLOTS;
        super.setCustomerParametersFromSV(stringArray, serviceValue);
        String[] stringArray2 = serviceValue.getPseudoNames();
        for (int i = 0; i < stringArray2.length; ++i) {
            this.handleSpecialCases(stringArray2[i], serviceValue);
        }
        this.checkConsistency();
    }

    private void handleSpecialCases(String string, ServiceValue serviceValue) throws BemException {
        if (string.startsWith("AddEtBoard_Slot") && string.endsWith("boardType")) {
            String string2 = serviceValue.getValue(string);
            String string3 = "slotsFor" + string2;
            int n = "AddEtBoard_Slot".length();
            int n2 = string.indexOf("_", n);
            String string4 = string.substring(n, n2);
            SlotListParameter slotListParameter = (SlotListParameter)this.getRbs().getCustomerParameterObject(string3);
            String[] stringArray = slotListParameter.getAllListValues();
            String[] stringArray2 = new String[stringArray.length + 1];
            for (int i = 0; i < stringArray.length; ++i) {
                stringArray2[i] = stringArray[i];
            }
            stringArray2[stringArray.length] = string4;
            slotListParameter.setValue(stringArray2);
        } else if (string.startsWith("AddIpEtBoard_Slot") && string.endsWith("boardType")) {
            String string5 = serviceValue.getValue(string);
            if (string5.equals("ETMFX")) {
                string5 = "ETMFX11";
            }
            String string6 = "slotsFor" + string5;
            int n = "AddIpEtBoard_Slot".length();
            int n3 = string.indexOf("_", n);
            String string7 = string.substring(n, n3);
            SlotListParameter slotListParameter = (SlotListParameter)this.getRbs().getCustomerParameterObject(string6);
            String[] stringArray = slotListParameter.getAllListValues();
            String[] stringArray3 = new String[stringArray.length + 1];
            for (int i = 0; i < stringArray.length; ++i) {
                stringArray3[i] = stringArray[i];
            }
            stringArray3[stringArray.length] = string7;
            slotListParameter.setValue(stringArray3);
        }
    }

    public String getName() {
        return name;
    }

    public boolean isOpen() {
        return this.isOpen;
    }

    public String[] getAllSupportedSlots() {
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.addAll(Arrays.asList(this.supportedEtmBoardSlots));
        Rbs rbs = this.getRbs();
        String string = rbs.getSlotsForCbu();
        if (string != null && !string.equals("")) {
            StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
            while (stringTokenizer.hasMoreTokens()) {
                String string2 = stringTokenizer.nextToken().trim();
                arrayList.add(string2);
            }
        }
        Collections.sort(arrayList);
        return arrayList.toArray(new String[0]);
    }

    public String[] getAllPossibleEtmBoards() {
        return this.supportedEtmTypes.toArray(new String[0]);
    }

    public String[] getAllPossibleEtmBoardsForSlot(String string) {
        ArrayList<String> arrayList = new ArrayList<String>();
        boolean bl = this.etmExistingSlots.containsKey(string);
        if (bl) {
            String string2 = (String)this.etmExistingSlots.get(string);
            String string3 = EtmBoardProvider.ETM_TYPE_MAPING.pseudo2display(string2);
            arrayList.add(string3);
        } else {
            arrayList.add("");
            for (int i = 0; i < PSEUDO_SLOTS.length; ++i) {
                if (!this.supportedEtmTypes.contains(PSEUDO_SLOTS[i])) continue;
                String string4 = EtmBoardProvider.ETM_TYPE_MAPING.pseudo2display(PSEUDO_SLOTS[i]);
                arrayList.add(string4);
            }
        }
        return arrayList.toArray(new String[0]);
    }

    public List getEtmCapableBoards() {
        ArrayList<CbuBasedEtmRI> arrayList = new ArrayList<CbuBasedEtmRI>();
        try {
            List list = this.getNeededEtmRIs();
            arrayList.addAll(list);
            Rbs rbs = this.getRbs();
            String string = rbs.getSlotsForCbu();
            if (!string.equals("")) {
                StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
                while (stringTokenizer.hasMoreTokens()) {
                    int n = Integer.parseInt(stringTokenizer.nextToken().trim());
                    CbuBasedEtmRI cbuBasedEtmRI = new CbuBasedEtmRI(rbs, n);
                    if (!cbuBasedEtmRI.isInstalled()) continue;
                    arrayList.add(cbuBasedEtmRI);
                }
            }
        }
        catch (Exception exception) {
            BemLog.exceptionRaised("Unable to find ETM boards", exception);
        }
        return arrayList;
    }

    public String getTypeForExistingBoard(String string) throws BemException {
        Rbs rbs;
        String string2;
        String string3 = (String)this.etmExistingSlots.get(string);
        if (string3 == null && !(string2 = (rbs = this.getRbs()).getSlotsForCbu()).equals("")) {
            StringTokenizer stringTokenizer = new StringTokenizer(string2, ",");
            while (stringTokenizer.hasMoreTokens()) {
                String string4 = stringTokenizer.nextToken().trim();
                if (!string.equals(string4)) continue;
                CbuBasedEtmRI cbuBasedEtmRI = new CbuBasedEtmRI(rbs, Integer.parseInt(string4));
                if (!cbuBasedEtmRI.isInstalled()) break;
                string3 = CbuBasedEtmRI.CBU;
                break;
            }
        }
        return string3;
    }

    public void addEtmBoardListener(EtmBoardListener etmBoardListener) {
        this.EtmBoardListenerList.add(etmBoardListener);
    }

    public MoInstance getExchangeTerminalMoi(String string) throws BemException {
        Object object2;
        String string2 = "";
        List list = this.getEtmCapableBoards();
        for (Object object2 : list) {
            if (object2.getSlotNo() != Integer.valueOf(string).intValue()) continue;
            string2 = object2.getLdn();
        }
        if (string2.equals("")) {
            throw new BemException("EtmBoardCIgetExchangeTerminalMoi() could not find exchangeTerminalMoi for slot=" + string);
        }
        object2 = new LdnMoi(string2);
        return object2;
    }

    public String[] getSupportedEtmBoardTypesForAtm() {
        return SUPPORTED_ATM_ETM_BOARD_TYPES_FOR_RBS3_AND_RBS4;
    }

    public String[] getSupportedEtmBoardTypesForIp() {
        return SUPPORTED_IP_ETM_BOARD_TYPES_FOR_RBS3_AND_RBS4;
    }

    public MoInstance getExchangeTerminalIpMoi() {
        List list = this.getEtmCapableBoards();
        for (EtmBoard etmBoard : list) {
            String string = etmBoard.getTransportCapabilty();
            if (!string.equals("IPv4")) continue;
            return etmBoard.getBoardMoi();
        }
        return null;
    }
}

