/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.wcdma.rbs.bem.common.config.configitem.ipoveratm.custparam;

import java.util.ArrayList;
import java.util.List;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.ipoveratm.custparam.AtmIpAddressParameter;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.ipoveratm.custparam.AtmSubnetMaskParameter;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.ipoveratm.custparam.ServiceCategoryParameter;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.ipoveratm.custparam.VciParameter;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.ipoveratm.custparam.VpMcrParameter;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.ipoveratm.custparam.VpPcrParameter;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.ipoveratm.custparam.VpiParameter;
import se.ericsson.wcdma.rbs.bem.common.config.custparam.CustomerParameter;
import se.ericsson.wcdma.rbs.bem.common.config.custparam.CustomerParameterListener;
import se.ericsson.wcdma.rbs.bem.common.config.custparam.Enumeration;
import se.ericsson.wcdma.rbs.bem.common.config.custparam.ParameterEvent;
import se.ericsson.wcdma.rbs.bem.common.exception.BemException;

public class IpOverAtmParameterSet
extends Enumeration
implements CustomerParameterListener {
    private AtmIpAddressParameter atmIpAddrParam;
    private AtmSubnetMaskParameter atmSubnetMaskParam;
    private VciParameter vciParameter;
    private ServiceCategoryParameter vcServiceCategoryParameter;
    private VpiParameter vpiParameter;
    private VpPcrParameter vpPcrParameter;
    private ServiceCategoryParameter vpServiceCategoryParameter;
    private VpMcrParameter vpMcrParameter;

    public IpOverAtmParameterSet(String string, AtmIpAddressParameter atmIpAddressParameter, AtmSubnetMaskParameter atmSubnetMaskParameter, VciParameter vciParameter, ServiceCategoryParameter serviceCategoryParameter, VpiParameter vpiParameter, VpPcrParameter vpPcrParameter, VpMcrParameter vpMcrParameter, ServiceCategoryParameter serviceCategoryParameter2) throws BemException {
        super(string, new String[]{"OK", "NOT_OK"});
        this.setLoadedValue("OK");
        this.atmIpAddrParam = atmIpAddressParameter;
        atmIpAddressParameter.addCustomerParameterListener(this);
        this.atmSubnetMaskParam = atmSubnetMaskParameter;
        atmSubnetMaskParameter.addCustomerParameterListener(this);
        this.vciParameter = vciParameter;
        vciParameter.addCustomerParameterListener(this);
        this.vcServiceCategoryParameter = serviceCategoryParameter;
        serviceCategoryParameter.addCustomerParameterListener(this);
        this.vpiParameter = vpiParameter;
        vpiParameter.addCustomerParameterListener(this);
        this.vpPcrParameter = vpPcrParameter;
        vpPcrParameter.addCustomerParameterListener(this);
        this.vpMcrParameter = vpMcrParameter;
        vpMcrParameter.addCustomerParameterListener(this);
        this.vpServiceCategoryParameter = serviceCategoryParameter2;
        serviceCategoryParameter2.addCustomerParameterListener(this);
    }

    public AtmIpAddressParameter getAtmIpAddressParameter() {
        return this.atmIpAddrParam;
    }

    public AtmSubnetMaskParameter getAtmSubnetMaskParameter() {
        return this.atmSubnetMaskParam;
    }

    public VciParameter getVciParameter() {
        return this.vciParameter;
    }

    public ServiceCategoryParameter getVcServiceCategoryParameter() {
        return this.vcServiceCategoryParameter;
    }

    public VpiParameter getVpiParameter() {
        return this.vpiParameter;
    }

    public VpPcrParameter getVpPcrParameter() {
        return this.vpPcrParameter;
    }

    public ServiceCategoryParameter getVpServiceCategoryParameter() {
        return this.vpServiceCategoryParameter;
    }

    public VpMcrParameter getVpMcrParameter() {
        return this.vpMcrParameter;
    }

    public List getAllPseudos() {
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add(this.atmIpAddrParam.getName());
        arrayList.add(this.atmSubnetMaskParam.getName());
        arrayList.add(this.vciParameter.getName());
        arrayList.add(this.vcServiceCategoryParameter.getName());
        arrayList.add(this.vpiParameter.getName());
        arrayList.add(this.vpPcrParameter.getName());
        arrayList.add(this.vpMcrParameter.getName());
        arrayList.add(this.vpServiceCategoryParameter.getName());
        return arrayList;
    }

    public void setAsMandatoryCP() {
        this.atmIpAddrParam.getRestriction().setAccessLevel(3);
        this.atmSubnetMaskParam.getRestriction().setAccessLevel(3);
        this.vciParameter.getRestriction().setAccessLevel(3);
        this.vcServiceCategoryParameter.getRestriction().setAccessLevel(3);
        this.vpiParameter.getRestriction().setAccessLevel(3);
        Integer n = (Integer)this.vpServiceCategoryParameter.getValueMom();
        if (n == 3) {
            this.vpMcrParameter.getRestriction().setAccessLevel(3);
        } else {
            this.vpPcrParameter.getRestriction().setAccessLevel(3);
            this.vpMcrParameter.getRestriction().setAccessLevel(1);
        }
        this.vpServiceCategoryParameter.getRestriction().setAccessLevel(3);
    }

    public void setAsOptionalCP() {
        this.atmIpAddrParam.getRestriction().setAccessLevel(2);
        this.atmSubnetMaskParam.getRestriction().setAccessLevel(2);
        this.vciParameter.getRestriction().setAccessLevel(2);
        this.vpiParameter.getRestriction().setAccessLevel(2);
        this.vpPcrParameter.getRestriction().setAccessLevel(2);
    }

    public void setAsIgnoredCP() {
        this.atmIpAddrParam.getRestriction().setAccessLevel(1);
        this.atmSubnetMaskParam.getRestriction().setAccessLevel(1);
        this.vciParameter.getRestriction().setAccessLevel(1);
        this.vcServiceCategoryParameter.getRestriction().setAccessLevel(1);
        this.vpiParameter.getRestriction().setAccessLevel(1);
        this.vpPcrParameter.getRestriction().setAccessLevel(1);
        this.vpMcrParameter.getRestriction().setAccessLevel(1);
        this.vpServiceCategoryParameter.getRestriction().setAccessLevel(1);
    }

    public void setAsReadOnlyCP() {
        this.atmIpAddrParam.getRestriction().setAccessLevel(0);
        this.atmSubnetMaskParam.getRestriction().setAccessLevel(0);
        this.vciParameter.getRestriction().setAccessLevel(0);
        this.vcServiceCategoryParameter.getRestriction().setAccessLevel(0);
        this.vpiParameter.getRestriction().setAccessLevel(0);
        this.vpPcrParameter.getRestriction().setAccessLevel(0);
        this.vpMcrParameter.getRestriction().setAccessLevel(0);
        this.vpServiceCategoryParameter.getRestriction().setAccessLevel(0);
    }

    public void setVPIAndVCIAsReadOnlyCP() {
        this.atmIpAddrParam.getRestriction().setAccessLevel(3);
        this.atmSubnetMaskParam.getRestriction().setAccessLevel(3);
        this.vciParameter.getRestriction().setAccessLevel(0);
        this.vpiParameter.getRestriction().setAccessLevel(0);
        Integer n = (Integer)this.vpServiceCategoryParameter.getValueMom();
        if (n == 3) {
            this.vpMcrParameter.getRestriction().setAccessLevel(3);
        } else {
            this.vpPcrParameter.getRestriction().setAccessLevel(3);
            this.vpMcrParameter.getRestriction().setAccessLevel(1);
        }
    }

    public void setVPI_VCI_ReadOnly_PCR_Ignored() {
        this.atmIpAddrParam.getRestriction().setAccessLevel(3);
        this.atmSubnetMaskParam.getRestriction().setAccessLevel(3);
        this.vciParameter.getRestriction().setAccessLevel(0);
        this.vpiParameter.getRestriction().setAccessLevel(0);
        this.vpPcrParameter.getRestriction().setAccessLevel(1);
    }

    public void setAsIgnoredCP(boolean bl, boolean bl2, boolean bl3, boolean bl4, boolean bl5, boolean bl6, boolean bl7) {
        if (bl) {
            this.vpiParameter.getRestriction().setAccessLevel(1);
        } else {
            this.vpiParameter.getRestriction().setAccessLevel(3);
        }
        if (bl2) {
            this.vpPcrParameter.getRestriction().setAccessLevel(1);
        } else {
            this.vpPcrParameter.getRestriction().setAccessLevel(3);
        }
        if (bl3) {
            this.vpMcrParameter.getRestriction().setAccessLevel(1);
        } else {
            this.vpMcrParameter.getRestriction().setAccessLevel(3);
        }
        if (bl5) {
            this.vciParameter.getRestriction().setAccessLevel(1);
        } else {
            this.vciParameter.getRestriction().setAccessLevel(3);
        }
        if (bl6) {
            this.atmIpAddrParam.getRestriction().setAccessLevel(1);
        } else {
            this.atmIpAddrParam.getRestriction().setAccessLevel(3);
        }
        if (bl7) {
            this.atmSubnetMaskParam.getRestriction().setAccessLevel(1);
        } else {
            this.atmSubnetMaskParam.getRestriction().setAccessLevel(3);
        }
    }

    public boolean isValidValue() {
        if (this.atmIpAddrParam == null || this.atmSubnetMaskParam == null || this.vciParameter == null || this.vpiParameter == null || this.vpPcrParameter == null) {
            return true;
        }
        boolean bl = this.atmIpAddrParam.isValidValue();
        boolean bl2 = this.atmSubnetMaskParam.isValidValue();
        boolean bl3 = this.vciParameter.isValidValue();
        boolean bl4 = this.vpiParameter.isValidValue();
        boolean bl5 = this.vpPcrParameter.isValidValue();
        return bl && bl2 && bl3 && bl4 && bl5;
    }

    public void parameterPropertiesChanged(CustomerParameter customerParameter, ParameterEvent parameterEvent) {
        if (parameterEvent.isValueChanged() || parameterEvent.isRangeChanged()) {
            if (customerParameter instanceof ServiceCategoryParameter) {
                ServiceCategoryParameter serviceCategoryParameter = (ServiceCategoryParameter)customerParameter;
                this.handleVpServiceCategory(serviceCategoryParameter);
            }
            this.notifyAllListeners(parameterEvent);
        }
    }

    private void handleVpServiceCategory(ServiceCategoryParameter serviceCategoryParameter) {
        if (serviceCategoryParameter.getName().endsWith("vpServiceCategory")) {
            Integer n = (Integer)this.vpServiceCategoryParameter.getValueMom();
            if (n == 1) {
                this.setPCR_mandatory_MCR_ignored();
            } else if (n == 3) {
                this.setMCR_mandatory_PCR_optional();
            }
        }
    }

    private void setMCR_mandatory_PCR_optional() {
        this.vpMcrParameter.getRestriction().setAccessLevel(3);
        this.vpPcrParameter.getRestriction().setAccessLevel(2);
    }

    private void setPCR_mandatory_MCR_ignored() {
        this.vpPcrParameter.getRestriction().setAccessLevel(3);
        this.vpMcrParameter.getRestriction().setAccessLevel(1);
    }
}

