/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.wcdma.rbs.bem.common.config.configitem.ipoveratm.resource;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import java.util.Vector;
import se.ericsson.wcdma.rbs.bem.common.BemLog;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.ipoveratm.custparam.ServiceCategoryParameter;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.ipoveratm.custparam.VciParameter;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.ipoveratm.custparam.VpMcrParameter;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.ipoveratm.custparam.VpPcrParameter;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.ipoveratm.custparam.VpiParameter;
import se.ericsson.wcdma.rbs.bem.common.config.custparam.IntegerParameter;
import se.ericsson.wcdma.rbs.bem.common.config.rbs.Rbs;
import se.ericsson.wcdma.rbs.bem.common.config.resource.AbstractResourceItem;
import se.ericsson.wcdma.rbs.bem.common.exception.BemException;
import se.ericsson.wcdma.rbs.bem.common.mim.MimAtmTrafficDescriptor;
import se.ericsson.wcdma.rbs.bem.common.mim.MimTransportNetwork;
import se.ericsson.wcdma.rbs.bem.common.mim.MimVclTp;
import se.ericsson.wcdma.rbs.bem.common.mim.MimVpcTp;
import se.ericsson.wcdma.rbs.bem.common.mim.MimVplTp;
import se.ericsson.wcdma.rbs.bem.common.moi.FixedRdnMoi;
import se.ericsson.wcdma.rbs.bem.common.moi.MoInstance;
import se.ericsson.wcdma.rbs.bem.common.moi.RootMoi;
import se.ericsson.wcdma.rbs.bem.common.moi.SingleChildMoi;
import se.ericsson.wcdma.rbs.bem.common.nal.ifc.Nal;
import se.ericsson.wcdma.rbs.bem.common.nal.ifc.NalNameValue;
import se.ericsson.wcdma.rbs.bem.common.proxy.BemMo;

public class AtmStackRI
extends AbstractResourceItem {
    public static final String NAME = "AtmStack";
    private static final String[] myInstallationPhases = new String[]{"AtmStackCreationPhase"};
    public static final String VPLTP = "=vp";
    public static final String VPCTP = "=1";
    public static final String VCLTP = "=vc";
    private static final int DEFAULT = 0;
    private static final int REDUNDANT = 1;
    private MoInstance transportNetworkMoi;
    private VpPcrParameter vpPcrParam = null;
    private IntegerParameter vpMcrParam = null;
    private ServiceCategoryParameter vpServiceCategoryParameter = null;
    private ServiceCategoryParameter vcServiceCategoryParameter = null;
    private String vplTpLdn = null;
    private String vplAtmTrafficDescLdn = null;
    private VpiParameter vpiParameter = null;
    private String vclTpLdn = null;
    private String vclAtmTrafficDescrLdn = null;
    private VciParameter vciParameter = null;
    private String vpcTpLdn = null;
    private List listOfMOsToBeCreated = new ArrayList();

    public AtmStackRI(Rbs rbs, VciParameter vciParameter, ServiceCategoryParameter serviceCategoryParameter, VpiParameter vpiParameter, VpPcrParameter vpPcrParameter, VpMcrParameter vpMcrParameter, ServiceCategoryParameter serviceCategoryParameter2, int n) {
        super(NAME, rbs, myInstallationPhases);
        this.vciParameter = vciParameter;
        this.vcServiceCategoryParameter = serviceCategoryParameter;
        this.vpiParameter = vpiParameter;
        this.vpPcrParam = vpPcrParameter;
        this.vpMcrParam = vpMcrParameter;
        this.vpServiceCategoryParameter = serviceCategoryParameter2;
        if (n == 0) {
            this.vciParameter.setDefaultValue("32");
        } else if (n == 1) {
            this.vciParameter.setDefaultValue("33");
        }
        this.initializeMoi();
    }

    private void initializeMoi() {
        RootMoi rootMoi = new RootMoi();
        this.transportNetworkMoi = new SingleChildMoi(rootMoi, MimTransportNetwork.MOTYPENAME, "1");
    }

    private void loadAllAttributesFromNode() throws BemException {
        if (this.isExisting(this.vclTpLdn)) {
            this.vciParameter.setLoadedValue(this.getAttribute(this.getMo(this.vclTpLdn), "externalVci"));
            BemMo bemMo = (BemMo)this.getAttribute(this.getMo(this.vclTpLdn), "atmTrafficDescriptorId");
            this.vclAtmTrafficDescrLdn = bemMo.getDN();
            Integer n = (Integer)this.getAttribute(bemMo, "serviceCategory");
            this.vcServiceCategoryParameter.setLoadedValue(n);
            this.vpiParameter.setLoadedValue(this.getAttribute(this.getMo(this.vplTpLdn), "externalVpi"));
            BemMo bemMo2 = (BemMo)this.getAttribute(this.getMo(this.vplTpLdn), "atmTrafficDescriptor");
            this.vplAtmTrafficDescLdn = bemMo2.getDN();
            Integer n2 = (Integer)this.getAttribute(bemMo2, "serviceCategory");
            this.vpServiceCategoryParameter.setLoadedValue(n2);
            this.vpPcrParam.setLoadedValue(this.getAttribute(bemMo2, "egressAtmPcr"));
            this.vpMcrParam.setLoadedValue(this.getAttribute(bemMo2, "egressAtmMcr"));
        }
    }

    public String getVclTpLdn() {
        return this.vclTpLdn;
    }

    public void setLoadedVclTpMO(String string) throws BemException {
        if (string == null) {
            return;
        }
        if (this.isExisting(string)) {
            this.vclTpLdn = string;
            BemMo bemMo = this.getParent(this.getMo(string));
            this.vpcTpLdn = bemMo.getDN();
            BemMo bemMo2 = this.getParent(bemMo);
            this.vplTpLdn = bemMo2.getDN();
            this.loadAllAttributesFromNode();
        }
    }

    public void install(String string) throws BemException {
        if (string.equals("AtmStackCreationPhase")) {
            BemLog.log(3, this.getClass() + ": install(), entered, installation phase: " + string);
            this.createAtmStack();
        }
    }

    private void createAtmStack() throws BemException {
        for (MoData moData : this.listOfMOsToBeCreated) {
            String string = moData.getMoType();
            String string2 = moData.getLdn();
            Vector vector = moData.getAttributes();
            BemLog.log(3, this.getClass() + ": createAtmStack(), moType is " + string + ", aLdn is " + string2 + "!");
            if (!this.isExisting(string2)) {
                if (vector != null) {
                    this.createMoIfNotExisting(string2, vector);
                    continue;
                }
                this.createMoIfNotExisting(string2);
                continue;
            }
            if (!string.equals(MimVplTp.MOTYPENAME)) continue;
            this.changeAttrTrafficDescForVplTp(string2, vector);
        }
    }

    private String getLdnBasedOnAttribute(String string, int n, String string2, NalNameValue nalNameValue) throws BemException {
        BemMo bemMo = this.getMo(string);
        if (this.isExisting(bemMo)) {
            BemMo[] bemMoArray = this.getChildren(bemMo, n, string2, "");
            for (int i = 0; i < bemMoArray.length; ++i) {
                Object object = bemMoArray[i].getAttribute(nalNameValue.getName());
                if (object == null || !nalNameValue.getValue().toString().equals(object.toString())) continue;
                return bemMoArray[i].getDN();
            }
        }
        return null;
    }

    private String getXTpLdn(String string, NalNameValue nalNameValue, String string2, String string3, String string4) throws BemException {
        String string5 = this.getLdnBasedOnAttribute(string, 1, string2, nalNameValue);
        if (string5 == null) {
            return string + "," + string2 + string3 + string4;
        }
        return string5;
    }

    private void changeAttrTrafficDescForVplTp(String string, Vector vector) throws BemException {
        String string2 = this.vpPcrParam.getLoadedValue();
        String string3 = this.vpPcrParam.getValue();
        BemLog.log(3, this.getClass() + ": changeAttrTrafficDescForVplTp(), loadedPCR is " + string2 + ", configuredPCR is " + string3 + "!");
        if (string2.equals(string3)) {
            return;
        }
        Enumeration enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            NalNameValue nalNameValue = (NalNameValue)enumeration.nextElement();
            String string4 = nalNameValue.getName();
            BemLog.log(3, this.getClass() + ": changeAttrTrafficDescForVplTp(), name is " + string4 + ", value is " + nalNameValue.getValue() + "!");
            if (!string4.equals("atmTrafficDescriptor")) continue;
            BemMo bemMo = this.getMo(string);
            this.setAttribute(bemMo, string4, nalNameValue.getValue());
        }
    }

    public void uninstall(String string) throws BemException {
        if (string.equals("AtmStackDeletionPhase")) {
            BemLog.log(3, this.getClass() + ": uninstall(), entered, installation phase: " + string);
            this.deleteAtmStack();
        }
    }

    private void deleteAtmStack() throws BemException {
        Collections.reverse(this.listOfMOsToBeCreated);
        for (MoData moData : this.listOfMOsToBeCreated) {
            String string = moData.getLdn();
            BemLog.log(3, this.getClass() + ": deleteAtmStack() before check ldn, aLdn is " + string + "!");
            if (!this.isExisting(string)) continue;
            BemLog.log(3, this.getClass() + ": deleteAtmStack(), aLdn is " + string + "!");
            this.deleteMoIfNotExisting(string);
        }
    }

    public void addAtmStack(String string) throws BemException {
        this.addAtmStack(string, false);
    }

    public void addAtmStack(String string, boolean bl) throws BemException {
        Object object;
        this.listOfMOsToBeCreated = new ArrayList();
        MoData moData = this.createVplTrafficDescriptor(bl);
        this.listOfMOsToBeCreated.add(moData);
        this.vplAtmTrafficDescLdn = moData.getLdn();
        String string2 = VPLTP;
        String string3 = VPCTP;
        String string4 = VCLTP;
        String string5 = bl ? this.vpiParameter.getLoadedValue() : this.vpiParameter.getValue();
        NalNameValue nalNameValue = Nal.getFactory().getNameValue("externalVpi", Integer.valueOf(string5));
        this.vplTpLdn = this.getXTpLdn(string, nalNameValue, MimVplTp.MOTYPENAME, string2, string5);
        BemMo bemMo = this.getMo(this.vplAtmTrafficDescLdn);
        NalNameValue nalNameValue2 = Nal.getFactory().getNameValue("atmTrafficDescriptor", bemMo);
        Vector<NalNameValue> vector = new Vector<NalNameValue>(0, 1);
        vector.add(nalNameValue);
        vector.add(nalNameValue2);
        this.listOfMOsToBeCreated.add(new MoData(MimVplTp.MOTYPENAME, this.vplTpLdn, vector));
        this.vpcTpLdn = this.vplTpLdn + "," + MimVpcTp.MOTYPENAME + string3;
        this.listOfMOsToBeCreated.add(new MoData(MimVpcTp.MOTYPENAME, this.vpcTpLdn, null));
        String string6 = this.vciParameter.getValue();
        NalNameValue nalNameValue3 = Nal.getFactory().getNameValue("externalVci", Integer.valueOf(string6));
        this.vclTpLdn = this.getXTpLdn(this.vpcTpLdn, nalNameValue3, MimVclTp.MOTYPENAME, string4, string6);
        if (this.vclAtmTrafficDescrLdn == null || !bl) {
            object = this.createVclTrafficDescriptor(bl);
            this.listOfMOsToBeCreated.add(object);
            this.vclAtmTrafficDescrLdn = ((MoData)object).getLdn();
        } else if (bl) {
            object = new MoData(MimAtmTrafficDescriptor.MOTYPENAME, this.vclAtmTrafficDescrLdn, new Vector());
            this.listOfMOsToBeCreated.add(object);
        }
        object = this.getMo(this.vclAtmTrafficDescrLdn);
        NalNameValue nalNameValue4 = Nal.getFactory().getNameValue("atmTrafficDescriptorId", object);
        Vector<NalNameValue> vector2 = new Vector<NalNameValue>(0, 1);
        vector2.add(nalNameValue3);
        vector2.add(nalNameValue4);
        this.listOfMOsToBeCreated.add(new MoData(MimVclTp.MOTYPENAME, this.vclTpLdn, vector2));
    }

    private Vector getAtmTrafficDescriptorAttributes(int n, int n2, int n3, Boolean bl, int n4, int n5, int n6, int n7) {
        Vector<NalNameValue> vector = new Vector<NalNameValue>();
        vector.add(Nal.getFactory().getNameValue("egressAtmPcr", new Integer(n4)));
        vector.add(Nal.getFactory().getNameValue("ingressAtmPcr", new Integer(n5)));
        vector.add(Nal.getFactory().getNameValue("egressAtmMcr", new Integer(n6)));
        vector.add(Nal.getFactory().getNameValue("ingressAtmMcr", new Integer(n7)));
        vector.add(Nal.getFactory().getNameValue("egressAtmQos", new Integer(n3)));
        vector.add(Nal.getFactory().getNameValue("ingressAtmQos", new Integer(n2)));
        vector.add(Nal.getFactory().getNameValue("serviceCategory", new Integer(n)));
        if (bl != null) {
            vector.add(Nal.getFactory().getNameValue("packetDiscard", bl));
        }
        return vector;
    }

    private String getServiceCategoryLetter(int n) throws BemException {
        if (n == 1) {
            return "C";
        }
        if (n == 2 || n == 3) {
            return "U";
        }
        throw new BemException("Invalid service category.");
    }

    private String buildTrafficDescriptorName(int n, int n2, int n3, boolean bl, int n4, int n5, int n6, int n7) throws BemException {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.getServiceCategoryLetter(n));
        stringBuffer.append(n2);
        if (bl) {
            stringBuffer.append('2');
        }
        if (n4 != 0) {
            stringBuffer.append('P');
            stringBuffer.append(n4);
        }
        if (n6 != 0) {
            stringBuffer.append('M');
            stringBuffer.append(n6);
        }
        if (n2 != n3) {
            stringBuffer.append("in");
            stringBuffer.append(n3);
        }
        if (n4 != n5 && n5 != 0) {
            stringBuffer.append('P');
            stringBuffer.append(n5);
        }
        if (n6 != n7 && n7 != 0) {
            stringBuffer.append('M');
            stringBuffer.append(n7);
        }
        return stringBuffer.toString();
    }

    public void setVclAtmTrafficDescr(String string) {
        this.vclAtmTrafficDescrLdn = string;
    }

    public String getVclAtmTrafficDescr() {
        return this.vclAtmTrafficDescrLdn;
    }

    public String getDefaultVclAtmTrafficDescr() throws BemException {
        return this.createVclTrafficDescriptor().getLdn();
    }

    private int getCellRateValue(IntegerParameter integerParameter, boolean bl) {
        String string;
        String string2 = string = bl ? integerParameter.getLoadedValue() : integerParameter.getValue();
        if (string.length() == 0) {
            return 0;
        }
        return Integer.parseInt(string);
    }

    private MoData createVplTrafficDescriptor(boolean bl) throws BemException {
        BemLog.log(3, this.getClass() + ": createVplTrafficDescriptor() entered");
        Integer n = bl ? (Integer)this.vpServiceCategoryParameter.getLoadedValueMom() : (Integer)this.vpServiceCategoryParameter.getValueMom();
        int n2 = this.getCellRateValue(this.vpPcrParam, bl);
        int n3 = this.getCellRateValue(this.vpMcrParam, bl);
        BemLog.log(3, this.getClass() + ": createVplTrafficDescriptor(), pcr is " + n2 + ", mcr is " + n3 + "!");
        if (n == 1) {
            BemLog.log(3, this.getClass() + ": createVplTrafficDescriptor(), enter " + 1 + " branch!");
            return this.createAtmTrafficDescriptor(n, 1, n2, n3, null);
        }
        if (n == 3) {
            BemLog.log(3, this.getClass() + ": createVplTrafficDescriptor(), enter " + 3 + " branch!");
            return this.createAtmTrafficDescriptor(n, 3, n2, n3, null);
        }
        throw new BemException("Unexpected service category: " + this.vpServiceCategoryParameter.getValue());
    }

    private MoData createVclTrafficDescriptor() throws BemException {
        return this.createVclTrafficDescriptor(false);
    }

    private MoData createVclTrafficDescriptor(boolean bl) throws BemException {
        Integer n;
        BemLog.log(3, this.getClass() + ": createVclTrafficDescriptor() entered");
        Integer n2 = n = bl ? (Integer)this.vpServiceCategoryParameter.getLoadedValueMom() : (Integer)this.vcServiceCategoryParameter.getValueMom();
        if (n == 2) {
            BemLog.log(3, this.getClass() + ": createVclTrafficDescriptor(), enter " + 2 + " branch!");
            return this.createAtmTrafficDescriptor(n, 4, 0, 0, true);
        }
        if (n == 3) {
            BemLog.log(3, this.getClass() + ": createVclTrafficDescriptor(), enter " + 3 + " branch!");
            return this.createAtmTrafficDescriptor(n, 3, 0, 20, true);
        }
        throw new BemException("Unexpected service category: " + this.vcServiceCategoryParameter.getValue());
    }

    private MoData createAtmTrafficDescriptor(int n, int n2, int n3, int n4, Boolean bl) throws BemException {
        Vector vector = this.getAtmTrafficDescriptorAttributes(n, n2, n2, bl, n3, n3, n4, n4);
        String string = this.buildTrafficDescriptorName(n, n2, n2, false, n3, n3, n4, n4);
        FixedRdnMoi fixedRdnMoi = new FixedRdnMoi(this.transportNetworkMoi, MimAtmTrafficDescriptor.MOTYPENAME, string);
        return new MoData(MimAtmTrafficDescriptor.MOTYPENAME, fixedRdnMoi.getLdn(), vector);
    }

    public String getVplTpLdn() {
        return this.vplTpLdn;
    }

    public String getVplAtmTrafficDescLdn() {
        return this.vplAtmTrafficDescLdn;
    }

    public String getVpcTpLdn() {
        return this.vpcTpLdn;
    }

    public String getDisplayName() {
        return this.getName();
    }

    public String getLdn() {
        return "";
    }

    private static class MoData {
        private String moType = null;
        private String ldn = null;
        private Vector attributes = null;

        public MoData(String string, String string2, Vector vector) {
            this.moType = string;
            this.ldn = string2;
            this.attributes = vector;
        }

        public String getMoType() {
            return this.moType;
        }

        public String getLdn() {
            return this.ldn;
        }

        public Vector getAttributes() {
            return this.attributes;
        }
    }
}

