/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.wcdma.rbs.bem.common.config.configitem.ipovergigabitethernet.resource;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Vector;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.ipovergigabitethernet.provider.PacketFrequencySyncRef;
import se.ericsson.wcdma.rbs.bem.common.config.custparam.CustomerParameter;
import se.ericsson.wcdma.rbs.bem.common.config.custparam.CustomerParameterServer;
import se.ericsson.wcdma.rbs.bem.common.config.custparam.ParameterRestriction;
import se.ericsson.wcdma.rbs.bem.common.config.rbs.Rbs;
import se.ericsson.wcdma.rbs.bem.common.config.resource.AbstractResourceItem;
import se.ericsson.wcdma.rbs.bem.common.exception.BemException;
import se.ericsson.wcdma.rbs.bem.common.mim.MimIpAccessHostEt;
import se.ericsson.wcdma.rbs.bem.common.mim.MimIpSystem;
import se.ericsson.wcdma.rbs.bem.common.mim.MimPacketFrequencySyncRef;
import se.ericsson.wcdma.rbs.bem.common.moi.FixedRdnMoi;
import se.ericsson.wcdma.rbs.bem.common.moi.MoInstance;
import se.ericsson.wcdma.rbs.bem.common.moi.SingleChildMoi;
import se.ericsson.wcdma.rbs.bem.common.nal.ifc.Nal;
import se.ericsson.wcdma.rbs.bem.common.nal.ifc.NalNameValue;
import se.ericsson.wcdma.rbs.bem.common.proxy.BemMo;

public class PacketFrequencySyncRefRI
extends AbstractResourceItem
implements PacketFrequencySyncRef {
    public static final String name = "PacketFrequencySyncRefRI";
    private static String[] phases = new String[]{"PacketFrequencySyncRefCreationPhase"};
    private MoInstance synchronizationMoi;
    private MoInstance packetFrequencySyncRefMoi = null;
    private MoInstance ipAccessHostEtMoi;
    private int rdnId = -1;
    private final List pseudoList = new ArrayList();
    public static final ParameterRestriction restrictionOptional = new ParameterRestriction("Optional", 2);

    public PacketFrequencySyncRefRI(Rbs rbs, MoInstance moInstance, int n) throws BemException {
        super(name, rbs, phases);
        this.rdnId = n;
        List list = this.getCustomerParameters();
        for (CustomerParameter customerParameter : list) {
            this.pseudoList.add(customerParameter.getName());
        }
        if (moInstance != null) {
            this.synchronizationMoi = moInstance;
            this.initializeMois();
            this.initiateCPWithNodeValues();
        }
    }

    private void initializeMois() {
        MoInstance moInstance = this.rbs.getRootMoi();
        SingleChildMoi singleChildMoi = new SingleChildMoi(moInstance, MimIpSystem.MOTYPENAME, "1");
        this.ipAccessHostEtMoi = new SingleChildMoi(singleChildMoi, MimIpAccessHostEt.MOTYPENAME, "1");
        this.packetFrequencySyncRefMoi = new FixedRdnMoi(this.synchronizationMoi, MimPacketFrequencySyncRef.MOTYPENAME, String.valueOf(this.rdnId));
    }

    private void initiateCPWithNodeValues() throws BemException {
        String string = "";
        String string2 = this.packetFrequencySyncRefMoi.getLdn();
        boolean bl = this.isInstalled();
        BemMo bemMo = this.getMo(this.synchronizationMoi.getLdn());
        BemMo[] bemMoArray = (BemMo[])bemMo.getAttribute("syncReference");
        boolean bl2 = false;
        if (bemMoArray != null) {
            for (int i = 0; i < bemMoArray.length; ++i) {
                if (bemMoArray[i] == null || !this.packetFrequencySyncRefMoi.getLdn().equals(bemMoArray[i].getDN())) continue;
                bl2 = true;
                break;
            }
        }
        if (bl) {
            CustomerParameterServer customerParameterServer;
            String string32;
            BemMo bemMo2 = this.getMo(string2);
            for (String string32 : this.pseudoList) {
                customerParameterServer = this.rbs.getCustomerParameterServerObject(string32);
                string = customerParameterServer.getAttributeName();
                Object object = this.getAttribute(bemMo2, string);
                customerParameterServer.setLoadedValue(object);
            }
            string32 = MessageFormat.format("IPoverGigabitEthernet_{0}_syncServerType", new Integer(this.rdnId));
            customerParameterServer = this.rbs.getCustomerParameterServerObject(string32);
            if (bl2) {
                customerParameterServer.setLoadedValue("PTP");
            }
            customerParameterServer.addRestriction(restrictionOptional);
        }
    }

    public void install(String string) throws BemException {
        if (string.equals("PacketFrequencySyncRefCreationPhase")) {
            this.lockPacketFrequencySyncRef();
            this.installPacketFrequencySyncRef();
            this.unlockPacketFrequencySyncRef();
        }
    }

    private void lockPacketFrequencySyncRef() throws BemException {
        String string = this.packetFrequencySyncRefMoi.getLdn();
        BemMo bemMo = this.getMo(string);
        boolean bl = this.isExisting(bemMo);
        if (bl) {
            for (String string2 : this.pseudoList) {
                CustomerParameter customerParameter = this.rbs.getCustomerParameterObject(string2);
                if (!customerParameter.hasValueChanged()) continue;
                this.setAttribute(bemMo, "administrativeState", (Object)new Integer(0));
                break;
            }
        }
    }

    private void unlockPacketFrequencySyncRef() throws BemException {
        String string = this.packetFrequencySyncRefMoi.getLdn();
        BemMo bemMo = this.getMo(string);
        boolean bl = this.isExisting(bemMo);
        if (bl) {
            for (String string2 : this.pseudoList) {
                CustomerParameter customerParameter = this.rbs.getCustomerParameterObject(string2);
                boolean bl2 = customerParameter.hasValueChanged();
                if (!bl2) continue;
                this.setAttribute(bemMo, "administrativeState", (Object)new Integer(1));
                break;
            }
        }
    }

    private void installPacketFrequencySyncRef() throws BemException {
        String string = this.packetFrequencySyncRefMoi.getLdn();
        BemMo bemMo = this.getMo(string);
        boolean bl = this.isInstalled();
        if (!bl) {
            Object object3;
            Vector<NalNameValue> vector = new Vector<NalNameValue>();
            String string2 = "administrativeState";
            Object object2 = new Integer(1);
            vector.add(Nal.getFactory().getNameValue(string2, object2));
            for (Object object3 : this.pseudoList) {
                CustomerParameterServer customerParameterServer = this.rbs.getCustomerParameterServerObject((String)object3);
                string2 = customerParameterServer.getAttributeName();
                object2 = customerParameterServer.getValueMom();
                vector.add(Nal.getFactory().getNameValue(string2, object2));
            }
            object3 = this.getMo(this.ipAccessHostEtMoi.getLdn());
            vector.add(Nal.getFactory().getNameValue("ipAccessHostEtRef", object3));
            this.create(bemMo, vector);
        } else {
            Vector<NalNameValue> vector = new Vector<NalNameValue>();
            for (String string3 : this.pseudoList) {
                CustomerParameterServer customerParameterServer = this.rbs.getCustomerParameterServerObject(string3);
                boolean bl2 = customerParameterServer.hasValueChanged();
                if (!bl2) continue;
                String string4 = customerParameterServer.getAttributeName();
                Object object = customerParameterServer.getValueMom();
                vector.add(Nal.getFactory().getNameValue(string4, object));
            }
            if (vector.size() > 0) {
                this.setAttributes(bemMo, vector);
            }
        }
    }

    public boolean isInstalled() throws BemException {
        boolean bl = false;
        if (this.packetFrequencySyncRefMoi != null) {
            String string = this.packetFrequencySyncRefMoi.getLdn();
            BemMo bemMo = this.getMo(string);
            bl = this.isExisting(bemMo);
        }
        return bl;
    }

    private boolean isConfigured() throws BemException {
        boolean bl = false;
        for (String string : this.pseudoList) {
            CustomerParameter customerParameter = this.rbs.getCustomerParameterObject(string);
            String string2 = customerParameter.getValue();
            if ("##UNDEFINED".equals(string2) || "".equals(string2)) continue;
            bl = true;
            break;
        }
        return bl;
    }

    public boolean shouldRiBeInstalled() throws BemException {
        boolean bl = false;
        if (this.isInstalled()) {
            for (String string : this.pseudoList) {
                CustomerParameter customerParameter = this.rbs.getCustomerParameterObject(string);
                boolean bl2 = customerParameter.hasValueChanged();
                if (!bl2) continue;
                bl = bl2;
                break;
            }
        } else {
            bl = this.isConfigured();
        }
        return bl;
    }

    public String getPacketFrequencySyncRefId() {
        return String.valueOf(this.rdnId);
    }

    public String getPacketFrequencySyncRefLdn() throws BemException {
        String string = "";
        if (this.packetFrequencySyncRefMoi != null) {
            string = this.packetFrequencySyncRefMoi.getLdn();
        }
        return string;
    }

    public String getDisplayName() {
        return name;
    }

    public String getLdn() {
        return "";
    }

    private List getCustomerParameters() throws BemException {
        ArrayList<CustomerParameter> arrayList = new ArrayList<CustomerParameter>();
        String string = MessageFormat.format("IPoverGigabitEthernet_{0}_serverAddress", new Integer(this.rdnId));
        arrayList.add(this.rbs.getCustomerParameterObject(string));
        String string2 = MessageFormat.format("IPoverGigabitEthernet_{0}_ptpDomain", new Integer(this.rdnId));
        arrayList.add(this.rbs.getCustomerParameterObject(string2));
        return arrayList;
    }
}

