/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.wcdma.rbs.bem.common.config.configitem.ipovergigabitethernet.resource;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import se.ericsson.wcdma.rbs.bem.common.config.custparam.CustomerParameter;
import se.ericsson.wcdma.rbs.bem.common.config.custparam.CustomerParameterServer;
import se.ericsson.wcdma.rbs.bem.common.config.rbs.Rbs;
import se.ericsson.wcdma.rbs.bem.common.config.resource.AbstractResourceItem;
import se.ericsson.wcdma.rbs.bem.common.exception.BemException;
import se.ericsson.wcdma.rbs.bem.common.mim.MimIpSystem;
import se.ericsson.wcdma.rbs.bem.common.mim.MimVpnInterface;
import se.ericsson.wcdma.rbs.bem.common.moi.FixedRdnMoi;
import se.ericsson.wcdma.rbs.bem.common.moi.MoInstance;
import se.ericsson.wcdma.rbs.bem.common.moi.SingleChildMoi;
import se.ericsson.wcdma.rbs.bem.common.nal.ifc.Nal;
import se.ericsson.wcdma.rbs.bem.common.nal.ifc.NalNameValue;
import se.ericsson.wcdma.rbs.bem.common.proxy.BemMo;

public class VpnInterfaceRI
extends AbstractResourceItem {
    public static final String name = "VpnInterfaceRI";
    private static String[] phases = new String[]{"VpnInterfaceCreationPhase"};
    private final List pseudoList = new ArrayList();
    private MoInstance ipAccessHostEtMoi;
    private MoInstance vpnInterfaceMoi;
    private boolean usedOnlyByIpHostLink = false;

    public VpnInterfaceRI(Rbs rbs, MoInstance moInstance, boolean bl) throws BemException {
        super(name, rbs, phases);
        this.usedOnlyByIpHostLink = bl;
        List list = this.getCustomerParameters();
        for (CustomerParameter customerParameter : list) {
            this.pseudoList.add(customerParameter.getName());
        }
        if (moInstance != null) {
            this.ipAccessHostEtMoi = moInstance;
        }
        this.initializeMois();
        this.initiateCPWithNodeValues();
    }

    public void setIpAccessHostEtMoi(MoInstance moInstance) throws BemException {
        this.ipAccessHostEtMoi = moInstance;
    }

    private void initializeMois() throws BemException {
        if (!this.usedOnlyByIpHostLink) {
            MoInstance moInstance = this.rbs.getRootMoi();
            SingleChildMoi singleChildMoi = new SingleChildMoi(moInstance, MimIpSystem.MOTYPENAME, "1");
            this.vpnInterfaceMoi = new FixedRdnMoi(singleChildMoi, MimVpnInterface.MOTYPENAME, "1");
        } else if (this.usedOnlyByIpHostLink) {
            MoInstance moInstance = this.rbs.getRootMoi();
            SingleChildMoi singleChildMoi = new SingleChildMoi(moInstance, MimIpSystem.MOTYPENAME, "1");
            this.vpnInterfaceMoi = new FixedRdnMoi(singleChildMoi, MimVpnInterface.MOTYPENAME, "2");
        }
    }

    private void initiateCPWithNodeValues() throws BemException {
        String string = this.vpnInterfaceMoi.getLdn();
        BemMo bemMo = this.getMo(string);
        String string2 = "";
        boolean bl = this.isInstalled();
        if (bl) {
            Iterator iterator = this.getCustomerParameters().iterator();
            while (iterator.hasNext()) {
                String string3 = ((CustomerParameter)iterator.next()).getName();
                CustomerParameterServer customerParameterServer = this.rbs.getCustomerParameterServerObject(string3);
                string2 = customerParameterServer.getAttributeName();
                Object object = this.getAttribute(bemMo, string2);
                customerParameterServer.setLoadedValue(object);
            }
        }
    }

    private List getCustomerParameters() throws BemException {
        ArrayList arrayList = new ArrayList();
        return arrayList;
    }

    public boolean isInstalled() throws BemException {
        boolean bl = false;
        String string = this.vpnInterfaceMoi.getLdn();
        bl = this.isExisting(string);
        return bl;
    }

    public boolean shouldRiBeInstalled() throws BemException {
        boolean bl = false;
        if (this.isInstalled()) {
            for (String string : this.pseudoList) {
                CustomerParameter customerParameter = this.rbs.getCustomerParameterObject(string);
                boolean bl2 = customerParameter.hasValueChanged();
                if (!bl2) continue;
                bl = bl2;
                break;
            }
        } else {
            bl = true;
        }
        return bl;
    }

    public void install(String string) throws BemException {
        if (string.equals("VpnInterfaceCreationPhase")) {
            this.installVpnInterFace();
        }
    }

    private void installVpnInterFace() throws BemException {
        String string = this.vpnInterfaceMoi.getLdn();
        BemMo bemMo = this.getMo(string);
        Vector<NalNameValue> vector = new Vector<NalNameValue>();
        boolean bl = this.isInstalled();
        if (!bl) {
            String string2;
            if (this.ipAccessHostEtMoi != null) {
                BemMo bemMo2 = this.getMo(this.ipAccessHostEtMoi.getLdn());
                string2 = "ipAccessHostEtRef";
                vector.add(Nal.getFactory().getNameValue(string2, bemMo2));
            }
            for (String string3 : this.pseudoList) {
                CustomerParameterServer customerParameterServer = this.rbs.getCustomerParameterServerObject(string3);
                string2 = customerParameterServer.getAttributeName();
                Object object = customerParameterServer.getValueMom();
                vector.add(Nal.getFactory().getNameValue(string2, object));
            }
            this.create(bemMo, vector);
        } else {
            for (String string4 : this.pseudoList) {
                CustomerParameterServer customerParameterServer = this.rbs.getCustomerParameterServerObject(string4);
                boolean bl2 = customerParameterServer.hasValueChanged();
                if (!bl2) continue;
                String string5 = customerParameterServer.getAttributeName();
                Object object = customerParameterServer.getValueMom();
                vector.add(Nal.getFactory().getNameValue(string5, object));
            }
            if (vector.size() > 0) {
                this.setAttributes(bemMo, vector);
            }
        }
    }

    public String getLdn() {
        return "";
    }

    public String getDisplayName() {
        return name;
    }

    public MoInstance getMoi() {
        return this.vpnInterfaceMoi;
    }
}

