/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.wcdma.rbs.bem.common.config.configitem.ipovergigabitethernet.util;

import java.text.MessageFormat;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.util.DuwUtil;
import se.ericsson.wcdma.rbs.bem.common.config.custparam.CustomerParameter;
import se.ericsson.wcdma.rbs.bem.common.config.rbs.Rbs;
import se.ericsson.wcdma.rbs.bem.common.exception.BemException;

public class IpSecUtil {
    private static void checkIpsecTunnel(Rbs rbs, String string) throws BemException {
        boolean bl = DuwUtil.hasDuw() && DuwUtil.isPrimaryDuwV1();
        for (int i = 0; i < 11; ++i) {
            String string2;
            String string3 = MessageFormat.format(string + "IpSecTunnel_ChildSaTf_{0}_integrityAlgorithm", new Integer(i + 1));
            String string4 = MessageFormat.format(string + "IpSecTunnel_ChildSaTf_{0}_encryptionAlgorithm", new Integer(i + 1));
            CustomerParameter customerParameter = rbs.getCustomerParameterObject(string3);
            CustomerParameter customerParameter2 = rbs.getCustomerParameterObject(string4);
            boolean bl2 = false;
            boolean bl3 = false;
            boolean bl4 = false;
            if (customerParameter != null) {
                string2 = customerParameter.getValue();
                bl2 = string2.equals("AES_GCM");
                bl4 = string2.equals("HMAC_SHA2_256_128");
            }
            if (customerParameter2 != null) {
                string2 = customerParameter2.getValue();
                boolean bl5 = bl3 = string2.equals("AES_128_GCM_128") || string2.equals("AES_256_GCM_128");
            }
            if (bl && (bl2 || bl3 || bl4)) {
                string2 = "For DUWV1,IpSec tunnel SHA-2 and AES_GCM algorithm is not supported:\nElement index = " + i + "\n" + "Integrity = " + customerParameter.getValue() + "\n" + "Encrypt = " + customerParameter2.getValue() + "\n";
                throw new BemException(string2);
            }
            if (bl2 == bl3) continue;
            string2 = "Integrity and Encryption algorithm for IPsec tunnel must be set to AES_GCM at the same time or neither of them are AES_GCM:\nElement index = " + i + "\n" + "Integrity = " + customerParameter.getValue() + "\n" + "Encrypt = " + customerParameter2.getValue() + "\n";
            throw new BemException(string2);
        }
    }

    private static void checkIkePeer(Rbs rbs, String string) throws BemException {
        for (int i = 0; i < 6; ++i) {
            String string2;
            String string3 = MessageFormat.format(string + "IkePeer_IkeSaTf_{0}_integrityAlgorithm", new Integer(i + 1));
            String string4 = MessageFormat.format(string + "IkePeer_IkeSaTf_{0}_encryptionAlgorithm", new Integer(i + 1));
            CustomerParameter customerParameter = rbs.getCustomerParameterObject(string3);
            CustomerParameter customerParameter2 = rbs.getCustomerParameterObject(string4);
            boolean bl = false;
            boolean bl2 = false;
            if (customerParameter != null) {
                string2 = customerParameter.getValue();
                bl = string2.equals("AES_GCM");
            }
            if (customerParameter2 != null) {
                string2 = customerParameter2.getValue();
                boolean bl3 = bl2 = string2.equals("AES_128_GCM_128") || string2.equals("AES_256_GCM_128");
            }
            if (bl == bl2) continue;
            string2 = "Integrity and Encryption algorithm for IPsec tunnel must be set to AES_GCM at the same time or neither of them are AES_GCM:\nElement index = " + i + "\n" + "Integrity = " + customerParameter.getValue() + "\n" + "Encrypt = " + customerParameter2.getValue() + "\n";
            throw new BemException(string2);
        }
    }

    public static void checkIpsec(Rbs rbs, String string) throws BemException {
        IpSecUtil.checkIpsecTunnel(rbs, string);
        IpSecUtil.checkIkePeer(rbs, string);
    }
}

