/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.wcdma.rbs.bem.common.config.configitem.powersupply.rbs3;

import se.ericsson.wcdma.rbs.bem.common.config.rbs.Rbs;
import se.ericsson.wcdma.rbs.bem.common.config.resource.AbstractRbsSubrackRI;
import se.ericsson.wcdma.rbs.bem.common.exception.BemException;
import se.ericsson.wcdma.rbs.bem.common.mim.MimPowerSupplySubrack;
import se.ericsson.wcdma.rbs.bem.common.mim.MimRbsSlot;
import se.ericsson.wcdma.rbs.bem.common.moi.FixedRdnMoi;
import se.ericsson.wcdma.rbs.bem.common.moi.MoInstance;
import se.ericsson.wcdma.rbs.bem.common.moi.SingleChildMoi;

public class PowerSupplySubrackRI
extends AbstractRbsSubrackRI {
    public static final String NAME = "PowerSupplySubrackRI";
    public String ldn;
    private int noOfSlots = 0;
    private MoInstance powerSupplySubrackMoi;
    private MoInstance[] rbsSlotMoi;
    private static final String AUTO_CREATED_RDNID_1 = "1";
    private static final String[] AUTO_CREATED_SLOT_RDNID = new String[]{"1", "2", "3", "4", "5", "6", "7"};

    public PowerSupplySubrackRI(Rbs rbs, int n, String string, String string2, MoInstance moInstance) throws BemException {
        super(NAME, rbs, n, string, string2);
        this.noOfSlots = n;
        this.setupMoi(moInstance);
    }

    public void setupMoi(MoInstance moInstance) throws BemException {
        this.powerSupplySubrackMoi = new SingleChildMoi(moInstance, MimPowerSupplySubrack.MOTYPENAME, AUTO_CREATED_RDNID_1);
        this.rbsSlotMoi = new MoInstance[this.noOfSlots];
        for (int i = 0; i < this.noOfSlots; ++i) {
            this.rbsSlotMoi[i] = new FixedRdnMoi(this.powerSupplySubrackMoi, MimRbsSlot.MOTYPENAME, AUTO_CREATED_SLOT_RDNID[i]);
        }
        this.ldn = this.powerSupplySubrackMoi.getLdn();
    }

    public MoInstance getMoiPowerSupplySubrack() {
        return this.powerSupplySubrackMoi;
    }

    public MoInstance getMoiSlot(int n) {
        return this.rbsSlotMoi[n - 1];
    }

    public String getLdn() {
        return this.ldn;
    }

    public String getDisplayName() {
        return "PowerSupplySubrackRI: " + this.getLdn();
    }

    public int getNoOfSlots() {
        return this.noOfSlots;
    }
}

