/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.wcdma.rbs.bem.common.config.configitem.powersupply.rbs4;

import se.ericsson.wcdma.rbs.bem.common.config.rbs.Rbs;
import se.ericsson.wcdma.rbs.bem.common.config.resource.AbstractRbsSubrackRI;
import se.ericsson.wcdma.rbs.bem.common.exception.BemException;
import se.ericsson.wcdma.rbs.bem.common.mim.MimRbsSlot;
import se.ericsson.wcdma.rbs.bem.common.mim.MimRbsSubrack;
import se.ericsson.wcdma.rbs.bem.common.moi.FixedRdnMoi;
import se.ericsson.wcdma.rbs.bem.common.moi.MoInstance;

public class BfSubrackRI
extends AbstractRbsSubrackRI {
    public static final String NAME = "BF-SUBRACK";
    private static int NUMBER_OF_SLOTS = 1;
    private String ldn;
    private MoInstance bfSubrackMoi;
    private MoInstance[] rbsSlotMoi;
    private static final String AUTO_CREATED_RDNID_1 = "BF";
    private static final String[] AUTO_CREATED_SLOT_RDNID = new String[]{"1", "2", "3", "4", "5", "6", "7", "8"};

    public BfSubrackRI(Rbs rbs, MoInstance moInstance, String string, String string2) throws BemException {
        super(NAME, rbs, NUMBER_OF_SLOTS, string, string2);
        this.setupMoi(moInstance);
    }

    public BfSubrackRI(Rbs rbs, MoInstance moInstance, String string, String string2, int n) throws BemException {
        super(NAME, rbs, n, string, string2);
        this.setupMoi(moInstance);
    }

    public void setupMoi(MoInstance moInstance) throws BemException {
        this.bfSubrackMoi = new FixedRdnMoi(moInstance, MimRbsSubrack.MOTYPENAME, AUTO_CREATED_RDNID_1);
        this.rbsSlotMoi = new MoInstance[NUMBER_OF_SLOTS];
        for (int i = 0; i < NUMBER_OF_SLOTS; ++i) {
            this.rbsSlotMoi[i] = new FixedRdnMoi(this.bfSubrackMoi, MimRbsSlot.MOTYPENAME, AUTO_CREATED_SLOT_RDNID[i]);
        }
        this.ldn = this.bfSubrackMoi.getLdn();
    }

    public MoInstance getMoiBfSubrack() {
        return this.bfSubrackMoi;
    }

    public MoInstance getMoiSlot(int n) {
        return this.rbsSlotMoi[n - 1];
    }

    public boolean isInstalled() throws BemException {
        return super.isExisting(this.getLdn());
    }

    public String getLdn() {
        return this.ldn;
    }

    public String getDisplayName() {
        return "BF-SUBRACK:" + this.ldn;
    }
}

