/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.wcdma.rbs.bem.common.config.configitem.radioequipment.rbs4.configurations;

import java.util.ArrayList;
import java.util.List;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.radioequipment.DigitalCableRI;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.radioequipment.FreeConnectorRI;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.radioequipment.RadioInterfaceBoard;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.radioequipment.ReservedConnectorRI;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.radioequipment.RuwRI;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.radioequipment.cableutil.AbstractCableSet;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.radioequipment.rbs4.configurations.AbstractRadioBuildingBlock;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.radioequipment.rbs4.configurations.RadioBuildingBlock;
import se.ericsson.wcdma.rbs.bem.common.config.rbs.Rbs;
import se.ericsson.wcdma.rbs.bem.common.config.resource.AbstractResourceItem;
import se.ericsson.wcdma.rbs.bem.common.exception.BemException;
import se.ericsson.wcdma.rbs.bem.common.mim.MimRfCable;
import se.ericsson.wcdma.rbs.bem.common.nal.ifc.NalNameValue;

public class RB4B
extends AbstractRadioBuildingBlock {
    public static final String name = "RB4B";
    private static final int NO_OF_CARRIERS = 2;
    private static final int NO_OF_RUS = 0;
    private static final int NO_OF_TX_BRANCHES = 1;
    private Rbs rbs;
    private List ris = new ArrayList();
    private DigitalCableRI digitalCable1 = null;
    private DigitalCableRI digitalCable2 = null;
    private RuwRI ruw = null;
    private int dcElectricalDelay;
    List freeConnectors;
    ReservedConnectorRI[][] reservedConnectors;

    public RB4B(Rbs rbs, int n, RuwRI ruwRI, RadioInterfaceBoard radioInterfaceBoard, int n2) throws BemException {
        super(name, n, 2, 0, 1, new RadioInterfaceBoard[]{radioInterfaceBoard});
        this.rbs = rbs;
        this.ruw = ruwRI;
        this.dcElectricalDelay = n2;
        this.createResourceItems(radioInterfaceBoard);
    }

    public void setRadioIfConnectors(ReservedConnectorRI reservedConnectorRI, ReservedConnectorRI reservedConnectorRI2, ReservedConnectorRI reservedConnectorRI3, ReservedConnectorRI reservedConnectorRI4, ReservedConnectorRI reservedConnectorRI5, ReservedConnectorRI reservedConnectorRI6) {
        ReservedConnectorRI[][] reservedConnectorRIArrayArray = new ReservedConnectorRI[][]{{reservedConnectorRI6, reservedConnectorRI5}, {reservedConnectorRI4, reservedConnectorRI3}, {reservedConnectorRI2, reservedConnectorRI}, {reservedConnectorRI6, reservedConnectorRI5}, {reservedConnectorRI4, reservedConnectorRI3}, {reservedConnectorRI2, reservedConnectorRI}};
        this.reservedConnectors = reservedConnectorRIArrayArray;
    }

    private void createResourceItems(RadioInterfaceBoard radioInterfaceBoard) throws BemException {
        this.ris.add(this.ruw);
        this.freeConnectors = new ArrayList();
        String string = this.ruw.getAuxPiuLdn();
        this.freeConnectors.add(new FreeConnectorRI(this.rbs, string, 22, MimRfCable.MOTYPENAME, "objectBConnector"));
        this.digitalCable1 = new DigitalCableRI(this.rbs, radioInterfaceBoard.getLdn(), this.getDigitalCableConnectorA(1), this.ruw.getLdn(), 1, this.dcElectricalDelay);
        this.ris.add(this.digitalCable1);
        this.digitalCable2 = new DigitalCableRI(this.rbs, radioInterfaceBoard.getLdn(), this.getDigitalCableConnectorA(2), this.ruw.getLdn(), 2, this.dcElectricalDelay);
        this.ris.add(this.digitalCable2);
    }

    public List getResourceItems() throws BemException {
        this.ruw.setSecondAiLocked(false);
        return this.ris;
    }

    public List getAllocatedResources() {
        ArrayList<AbstractResourceItem> arrayList = new ArrayList<AbstractResourceItem>();
        arrayList.add(this.ruw);
        arrayList.add(this.reservedConnectors[this.getSectorNo() - 1][0]);
        arrayList.add(this.reservedConnectors[this.getSectorNo() - 1][1]);
        return arrayList;
    }

    private int getDigitalCableConnectorA(int n) throws BemException {
        int n2 = 0;
        int n3 = this.getSectorNo();
        int[][] nArrayArray = new int[][]{{6, 5}, {4, 3}, {2, 1}, {6, 5}, {4, 3}, {2, 1}};
        n2 = nArrayArray[n3 - 1][n - 1];
        return n2;
    }

    public Integer getTerminationConnector(String string) throws BemException {
        Integer n = null;
        if (string.equalsIgnoreCase("A")) {
            n = new Integer(1);
        } else if (string.equalsIgnoreCase("B")) {
            n = new Integer(2);
        } else {
            throw new BemException(this.getClass().getName() + " getAntFeederCableConnectorA(): Antenna branch " + string + " not supported");
        }
        return n;
    }

    public String getTerminationObject(String string) throws BemException {
        return this.ruw.getAuxPiuLdn();
    }

    protected List getFreeConnectors() {
        return this.freeConnectors;
    }

    public void updateCableCharacteristics(AbstractCableSet abstractCableSet, int n) throws BemException {
        NalNameValue[] nalNameValueArray = null;
        nalNameValueArray = abstractCableSet.getData1CableAttributes(n);
        this.digitalCable1.setAttributes(nalNameValueArray);
        nalNameValueArray = abstractCableSet.getData2CableAttributes(n);
        this.digitalCable2.setAttributes(nalNameValueArray);
    }

    public int minNumberOfCarriers() {
        return 1;
    }

    public int getNoOfRuws() {
        return 1;
    }

    public List getAtfRoleMapping() {
        ArrayList<RadioBuildingBlock.SlotToBBPools> arrayList = new ArrayList<RadioBuildingBlock.SlotToBBPools>();
        arrayList.add(new RadioBuildingBlock.SlotToBBPools(this.ruw.getSlotNumber(), new int[]{0}));
        return arrayList;
    }

    public int[] getSupportedTxDivRange() {
        return new int[]{1};
    }
}

