/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.wcdma.rbs.bem.common.config.configitem.radioequipment.rbs4.configurations;

import java.util.ArrayList;
import java.util.List;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.antennasystem.OilRI;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.antennasystem.RruwRI;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.radioequipment.RadioInterfaceBoard;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.radioequipment.ReservedConnectorRI;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.radioequipment.RfCableRI;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.radioequipment.cableutil.AbstractCableSet;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.radioequipment.rbs4.configurations.AbstractRadioBuildingBlock;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.radioequipment.resource.ObifRI;
import se.ericsson.wcdma.rbs.bem.common.config.rbs.Rbs;
import se.ericsson.wcdma.rbs.bem.common.config.resource.AbstractResourceItem;
import se.ericsson.wcdma.rbs.bem.common.exception.BemException;
import se.ericsson.wcdma.rbs.bem.common.mim.MimAuxPlugInUnit;
import se.ericsson.wcdma.rbs.bem.common.mim.MimOpticalInterfaceLink;
import se.ericsson.wcdma.rbs.bem.common.mim.MimRruDeviceGroup;
import se.ericsson.wcdma.rbs.bem.common.mim.MimSector;
import se.ericsson.wcdma.rbs.bem.common.mohandler.MoHandler;
import se.ericsson.wcdma.rbs.bem.common.moi.CableMoi;
import se.ericsson.wcdma.rbs.bem.common.moi.ChildWithAttributeValues;
import se.ericsson.wcdma.rbs.bem.common.moi.FixedRdnMoi;
import se.ericsson.wcdma.rbs.bem.common.moi.MoInstance;
import se.ericsson.wcdma.rbs.bem.common.moi.SectorAntennaMoi;
import se.ericsson.wcdma.rbs.bem.common.moi.SingleChildMoi;
import se.ericsson.wcdma.rbs.bem.common.nal.ifc.NalNameValue;
import se.ericsson.wcdma.rbs.bem.common.proxy.BemMo;

public class RRB05
extends AbstractRadioBuildingBlock {
    public static final String name = "RRB05";
    private static final int NOT_USED = -1;
    private static final String AUTO_CREATED_RDNID_1 = "1";
    private static final String AUTO_CREATED_RDNID_2 = "1";
    private static final String OIL_DL_DEFAULT_RDNID_1 = "-1-DL";
    private static final String OIL_UL_DEFAULT_RDNID_1 = "-1-UL";
    private static final String OIL_DL_DEFAULT_RDNID_2 = "-2-DL";
    private static final String OIL_UL_DEFAULT_RDNID_2 = "-2-UL";
    public static final int NAMING_CONVENTION_RRU_RRUW = 2;
    private static final int NO_OF_CARRIERS = 2;
    private static final int NO_OF_RUS = 0;
    private static final int NO_OF_TX_BRANCHES = 2;
    MoHandler moHandler;
    private Rbs rbs;
    private List ris = new ArrayList();
    private Integer dlConnector1;
    private Integer ulConnector1;
    private Integer dlConnector2;
    private Integer ulConnector2;
    private Integer[] dlConnectors;
    private Integer[] ulConnectors;
    private RadioInterfaceBoard radioIfBoard;
    private OilRI oil1Dl = null;
    private OilRI oil1Ul = null;
    private RruwRI rruw1 = null;
    private OilRI oil2Dl = null;
    private OilRI oil2Ul = null;
    private RruwRI rruw2 = null;
    private RfCableRI rxARfCable = null;
    private RfCableRI rxBRfCable = null;
    Integer object1ACon;
    Integer object1BCon;
    Integer object2ACon;
    Integer object2BCon;
    String conUlRefParam;
    String conDlRefParam;
    BemMo objectARef;
    BemMo objectBRef;
    String objARefParam;
    String objBRefParam;
    List freeConnectors = new ArrayList();
    ReservedConnectorRI[][] reservedConnectors;
    private ReservedConnectorRI a;
    private ReservedConnectorRI b;
    private ReservedConnectorRI c;
    private ReservedConnectorRI d;
    private ReservedConnectorRI e;
    private ReservedConnectorRI f;
    public MoInstance managedElementMoi;
    public MoInstance equipmentMoi;
    public MoInstance nodeBFunctionMoi;
    public MoInstance sectorMoi;
    public MoInstance sectorAntennaMoi;
    public MoInstance rruw1Moi;
    public MoInstance rruw1AuxPiuMoi;
    public MoInstance rruw2Moi;
    public MoInstance rruw2AuxPiuMoi;
    public MoInstance optLinkDl1Moi;
    public MoInstance optLinkUl1Moi;
    public MoInstance optLinkDl2Moi;
    public MoInstance optLinkUl2Moi;
    public String[] sectorRdn = new String[]{"1", "2", "3", "4", "5", "6"};
    private ObifRI obif;
    private String radioIfType;
    private int rfElectricalUlDelay;
    private int rfUlAttenuation;

    public RRB05(Rbs rbs, int n, RadioInterfaceBoard radioInterfaceBoard, RruwRI rruwRI, RruwRI rruwRI2, int n2, int n3, int n4, int n5) throws BemException {
        super(name, n, 2, 0, 2, new RadioInterfaceBoard[]{radioInterfaceBoard});
        this.rbs = rbs;
        this.moHandler = rbs.getMoHandler();
        this.radioIfBoard = radioInterfaceBoard;
        this.obif = (ObifRI)radioInterfaceBoard;
        this.radioIfType = radioInterfaceBoard.getType();
        this.rruw1 = rruwRI;
        this.rruw2 = rruwRI2;
        this.rfElectricalUlDelay = n2;
        this.rfUlAttenuation = n4;
        this.createTerminationConnector(n);
        this.createResourceItems(n);
    }

    public void setRadioIfConnectors(ReservedConnectorRI reservedConnectorRI, ReservedConnectorRI reservedConnectorRI2, ReservedConnectorRI reservedConnectorRI3, ReservedConnectorRI reservedConnectorRI4, ReservedConnectorRI reservedConnectorRI5, ReservedConnectorRI reservedConnectorRI6) {
        ReservedConnectorRI[][] reservedConnectorRIArrayArray = new ReservedConnectorRI[][]{{reservedConnectorRI, reservedConnectorRI2}, {reservedConnectorRI3, reservedConnectorRI4}, {reservedConnectorRI5, reservedConnectorRI6}};
        this.reservedConnectors = reservedConnectorRIArrayArray;
    }

    public void setRadioIfConnectors(int n, ReservedConnectorRI[] reservedConnectorRIArray) {
        for (int i = 0; i < reservedConnectorRIArray.length; ++i) {
            ReservedConnectorRI reservedConnectorRI;
            if (reservedConnectorRIArray[i] == null) continue;
            this.reservedConnectors[n - 1][0] = reservedConnectorRIArray[i];
            int n2 = reservedConnectorRIArray[i].getConnector();
            int n3 = this.getObject2Con(new Integer(n2));
            this.reservedConnectors[n - 1][1] = reservedConnectorRI = new ReservedConnectorRI(this.rbs, this.obif.getPiuLdn(), n3, MimOpticalInterfaceLink.MOTYPENAME, "objectAConnector");
        }
    }

    public void createTerminationConnector(int n) throws BemException {
        this.dlConnectors = new Integer[]{new Integer(1), new Integer(2), new Integer(3), new Integer(5), new Integer(6), new Integer(7)};
        this.ulConnectors = new Integer[]{new Integer(1), new Integer(2), new Integer(3), new Integer(5), new Integer(6), new Integer(7)};
        int n2 = n - 1;
        this.dlConnector1 = this.dlConnectors[n2 * 2];
        this.ulConnector1 = this.ulConnectors[n2 * 2];
        this.dlConnector2 = this.dlConnectors[n2 * 2 + 1];
        this.ulConnector2 = this.ulConnectors[n2 * 2 + 1];
    }

    private Integer getObject2Con(Integer n) {
        Integer n2 = n;
        for (int i = 0; i < this.dlConnectors.length; ++i) {
            if (n.intValue() != this.dlConnectors[i].intValue()) continue;
            n2 = this.dlConnectors[i + 1];
        }
        return n2;
    }

    private void createResourceItems(int n) throws BemException {
        this.createReservedConnectors();
        this.ris.add(this.rruw1);
        String string = this.rruw1.getAuxPiuLdn();
        String string2 = this.radioIfBoard.getPiuLdn();
        this.object1ACon = this.ulConnector1;
        this.object1BCon = new Integer(4);
        this.objARefParam = string2;
        this.objBRefParam = string;
        this.oil1Dl = new OilRI(this.rbs, n - 1, "Dl", this.object1ACon, this.object1BCon, this.objARefParam, this.objBRefParam);
        this.ris.add(this.oil1Dl);
        this.object1ACon = new Integer(4);
        this.object1BCon = this.dlConnector1;
        this.objARefParam = string;
        this.objBRefParam = string2;
        this.oil1Ul = new OilRI(this.rbs, n - 1, "Ul", this.object1ACon, this.object1BCon, this.objARefParam, this.objBRefParam);
        this.ris.add(this.oil1Ul);
        String string3 = this.rruw2.getAuxPiuLdn();
        this.ris.add(this.rruw2);
        this.object2ACon = this.ulConnector2;
        this.object2BCon = new Integer(4);
        this.objARefParam = string2;
        this.objBRefParam = string3;
        this.oil2Dl = new OilRI(this.rbs, n - 1, "Dl", this.object2ACon, this.object2BCon, this.objARefParam, this.objBRefParam);
        this.ris.add(this.oil2Dl);
        this.object2ACon = new Integer(4);
        this.object2BCon = this.dlConnector2;
        this.objARefParam = string3;
        this.objBRefParam = string2;
        this.oil2Ul = new OilRI(this.rbs, n - 1, "Ul", this.object2ACon, this.object2BCon, this.objARefParam, this.objBRefParam);
        this.ris.add(this.oil2Ul);
        this.rxARfCable = new RfCableRI(this.rbs, this.rruw1.getLdn(), 12, this.rruw2.getLdn(), 22, this.rfElectricalUlDelay, -1, this.rfUlAttenuation, -1, n, "A", 2);
        this.ris.add(this.rxARfCable);
        this.rxBRfCable = new RfCableRI(this.rbs, this.rruw2.getLdn(), 12, this.rruw1.getLdn(), 22, this.rfElectricalUlDelay, -1, this.rfUlAttenuation, -1, n, "B", 2);
        this.ris.add(this.rxBRfCable);
    }

    public void updateOil(int n, String string, String string2, Integer n2, Integer n3) throws BemException {
        this.object1BCon = new Integer(4);
        this.object1ACon = new Integer(4);
        this.oil1Dl.updateMoiResources(n, string, this.rruw1.getAuxPiuLdn(), n2, this.object1BCon, "Dl");
        this.oil1Ul.updateMoiResources(n, this.rruw1.getAuxPiuLdn(), string, this.object1ACon, n3, "Ul");
        this.object2BCon = new Integer(4);
        this.object2ACon = new Integer(4);
        this.oil2Dl.updateMoiResources(n, string2, this.rruw2.getAuxPiuLdn(), n2, this.object2BCon, "Dl");
        this.oil2Ul.updateMoiResources(n, this.rruw2.getAuxPiuLdn(), string2, this.object2ACon, n3, "Ul");
    }

    public void updatePrimaryConnector(int n, Integer n2) throws BemException {
        this.object1BCon = new Integer(4);
        this.object1ACon = new Integer(4);
        this.oil1Dl.updateMoiResources(n, this.radioIfBoard.getPiuLdn(), this.rruw1.getAuxPiuLdn(), n2, this.object1BCon, "Dl");
        this.oil1Ul.updateMoiResources(n, this.rruw1.getAuxPiuLdn(), this.radioIfBoard.getPiuLdn(), this.object1ACon, n2, "Ul");
        Integer n3 = this.getObject2Con(n2);
        this.object2BCon = new Integer(4);
        this.object2ACon = new Integer(4);
        this.oil2Dl.updateMoiResources(n, this.radioIfBoard.getPiuLdn(), this.rruw2.getAuxPiuLdn(), n3, this.object2BCon, "Dl");
        this.oil2Ul.updateMoiResources(n, this.rruw2.getAuxPiuLdn(), this.radioIfBoard.getPiuLdn(), this.object2ACon, n3, "Ul");
    }

    public List getResourceItems() throws BemException {
        return this.ris;
    }

    public List getAllocatedResources() {
        ArrayList<AbstractResourceItem> arrayList = new ArrayList<AbstractResourceItem>();
        arrayList.add(this.rruw1);
        arrayList.add(this.oil1Dl);
        arrayList.add(this.oil1Ul);
        arrayList.add(this.rxARfCable);
        arrayList.add(this.rruw2);
        arrayList.add(this.oil2Dl);
        arrayList.add(this.oil2Ul);
        arrayList.add(this.rxBRfCable);
        arrayList.add(this.reservedConnectors[this.getSectorNo() - 1][0]);
        arrayList.add(this.reservedConnectors[this.getSectorNo() - 1][1]);
        return arrayList;
    }

    public int getReservedConnector() {
        return this.reservedConnectors[this.getSectorNo() - 1][0].getConnector();
    }

    public Integer getTerminationConnector(String string) throws BemException {
        Integer n = null;
        if (!string.equalsIgnoreCase("A") && !string.equalsIgnoreCase("B")) {
            throw new BemException(this.getClass().getName() + " getAntFeederCableConnectorA(): Antenna branch " + string + " not supported");
        }
        n = new Integer(1);
        return n;
    }

    public String getTerminationObject(String string) throws BemException {
        if (string.equalsIgnoreCase("A")) {
            return this.rruw1.getAuxPiuLdn();
        }
        if (string.equalsIgnoreCase("B")) {
            return this.rruw2.getAuxPiuLdn();
        }
        if (string.equalsIgnoreCase("UL") || string.equalsIgnoreCase("DL")) {
            return this.obif.getPiuLdn();
        }
        throw new BemException(this.getClass().getName() + " getTerminationObject(): Type " + string + " not supported");
    }

    public String getRadioInterfaceType() throws BemException {
        return this.radioIfType;
    }

    public String getPrevious() throws BemException {
        String string = "";
        String string2 = this.oil1Dl.getLdn();
        MoHandler moHandler = this.rbs.getMoHandler();
        try {
            BemMo bemMo = moHandler.getMo(string2);
            BemMo bemMo2 = (BemMo)moHandler.getAttribute(bemMo, "connectedToObjectARef");
            string = bemMo2.getDN();
        }
        catch (Exception exception) {
            throw new BemException(this.getClass().getName(), "updateLoadedValues()", null, "Get configurationGroup attribute", exception);
        }
        return string;
    }

    public Integer getPrimaryPortId() throws BemException {
        Integer n;
        String string = this.oil1Dl.getLdn();
        MoHandler moHandler = this.rbs.getMoHandler();
        try {
            BemMo bemMo = moHandler.getMo(string);
            n = (Integer)moHandler.getAttribute(bemMo, "objectAConnector");
        }
        catch (Exception exception) {
            throw new BemException(this.getClass().getName(), "updateLoadedValues()", null, "Get configurationGroup attribute", exception);
        }
        return n;
    }

    public String getObjARefForCascade() {
        return this.rruw1.getAuxPiuLdn();
    }

    public String getObjBRefForCascade() {
        return this.rruw2.getAuxPiuLdn();
    }

    protected List getFreeConnectors() {
        return this.freeConnectors;
    }

    public void updateCableCharacteristics(AbstractCableSet abstractCableSet, int n) throws BemException {
        NalNameValue[] nalNameValueArray = null;
        nalNameValueArray = abstractCableSet.getRxACableAttributes(n);
        this.rxARfCable.setAttributes(nalNameValueArray);
        nalNameValueArray = abstractCableSet.getRxBCableAttributes(n);
        this.rxBRfCable.setAttributes(nalNameValueArray);
    }

    public int minNumberOfCarriers() {
        return 2;
    }

    protected void initialiseMoiResources(int n) throws BemException {
        this.equipmentMoi = this.rbs.getEquipmentMoi();
        this.nodeBFunctionMoi = this.rbs.getNodeBFunctionMoi();
        this.sectorMoi = new FixedRdnMoi(this.nodeBFunctionMoi, MimSector.MOTYPENAME, this.sectorRdn[n - 1]);
        this.sectorAntennaMoi = new SectorAntennaMoi(this.equipmentMoi, this.sectorMoi, "" + n);
        this.rruw1AuxPiuMoi = new ChildWithAttributeValues(this.sectorAntennaMoi, MimAuxPlugInUnit.MOTYPENAME, "auType", new Integer(20), "RRUW-1");
        this.rruw1Moi = new SingleChildMoi(this.rruw1AuxPiuMoi, MimRruDeviceGroup.MOTYPENAME, "1");
        this.rruw2AuxPiuMoi = new ChildWithAttributeValues(this.sectorAntennaMoi, MimAuxPlugInUnit.MOTYPENAME, "auType", new Integer(20), "RRUW-2");
        this.rruw2Moi = new SingleChildMoi(this.rruw2AuxPiuMoi, MimRruDeviceGroup.MOTYPENAME, "1");
        this.object1ACon = this.ulConnector1;
        this.object1BCon = this.dlConnector1;
        this.object2ACon = this.ulConnector2;
        this.object2BCon = this.dlConnector2;
        this.conUlRefParam = this.radioIfBoard.getPiuLdn();
        this.objectARef = this.moHandler.getMo(this.conUlRefParam);
        this.conDlRefParam = this.radioIfBoard.getPiuLdn();
        this.objectBRef = this.moHandler.getMo(this.conDlRefParam);
        this.optLinkUl1Moi = new CableMoi(MimOpticalInterfaceLink.MOTYPENAME, "B", null, null, null, null, "connectedToObjectBRef", this.objectBRef, "objectBConnector", this.object1BCon, Integer.toString(n) + OIL_UL_DEFAULT_RDNID_1);
        this.optLinkDl1Moi = new CableMoi(MimOpticalInterfaceLink.MOTYPENAME, "A", "connectedToObjectARef", this.objectARef, "objectAConnector", this.object1ACon, null, null, null, null, Integer.toString(n) + OIL_DL_DEFAULT_RDNID_1);
        this.optLinkUl2Moi = new CableMoi(MimOpticalInterfaceLink.MOTYPENAME, "B", null, null, null, null, "connectedToObjectBRef", this.objectBRef, "objectBConnector", this.object2BCon, Integer.toString(n) + OIL_UL_DEFAULT_RDNID_2);
        this.optLinkDl2Moi = new CableMoi(MimOpticalInterfaceLink.MOTYPENAME, "A", "connectedToObjectARef", this.objectARef, "objectAConnector", this.object2ACon, null, null, null, null, Integer.toString(n) + OIL_DL_DEFAULT_RDNID_2);
    }

    private void createReservedConnectors() {
        String string = MimOpticalInterfaceLink.MOTYPENAME;
        String string2 = "objectAConnector";
        this.a = new ReservedConnectorRI(this.rbs, this.obif.getPiuLdn(), 1, string, string2);
        this.b = new ReservedConnectorRI(this.rbs, this.obif.getPiuLdn(), 2, string, string2);
        this.c = new ReservedConnectorRI(this.rbs, this.obif.getPiuLdn(), 3, string, string2);
        this.d = new ReservedConnectorRI(this.rbs, this.obif.getPiuLdn(), 5, string, string2);
        this.e = new ReservedConnectorRI(this.rbs, this.obif.getPiuLdn(), 6, string, string2);
        this.f = new ReservedConnectorRI(this.rbs, this.obif.getPiuLdn(), 7, string, string2);
        this.setRadioIfConnectors(this.a, this.b, this.c, this.d, this.e, this.f);
    }

    public int getNoOfRruAndRruwPerPort() {
        return 1;
    }

    public int getNoOfRrusAndRruws() {
        return 2;
    }

    public boolean isInstalled() throws BemException {
        boolean bl = super.isInstalled();
        if (bl) {
            BemMo bemMo = this.moHandler.getMo(this.oil2Dl.getLdn());
            BemMo bemMo2 = (BemMo)bemMo.getAttribute("connectedToObjectARef");
            if (bemMo2.getDN().equals(this.rruw1.getAuxPiuLdn())) {
                return false;
            }
            bemMo2 = (BemMo)bemMo.getAttribute("connectedToObjectBRef");
            if (bemMo2.getDN().equals(this.rruw1.getAuxPiuLdn())) {
                return false;
            }
        }
        return bl;
    }

    public MoInstance[] getRruwMois() {
        MoInstance[] moInstanceArray = new MoInstance[]{this.rruw1.boardMoi, this.rruw2.boardMoi};
        return moInstanceArray;
    }

    public int[] getSupportedTxDivRange() {
        return new int[]{1};
    }
}

