/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.wcdma.rbs.bem.common.config.resource;

import java.util.HashMap;
import java.util.Vector;
import se.ericsson.wcdma.rbs.bem.common.BemLog;
import se.ericsson.wcdma.rbs.bem.common.config.custparam.CustomerParameter;
import se.ericsson.wcdma.rbs.bem.common.config.custparam.CustomerParameterServer;
import se.ericsson.wcdma.rbs.bem.common.config.rbs.Rbs;
import se.ericsson.wcdma.rbs.bem.common.config.resource.ResourceItem;
import se.ericsson.wcdma.rbs.bem.common.exception.BemException;
import se.ericsson.wcdma.rbs.bem.common.exception.ExceptionConstants;
import se.ericsson.wcdma.rbs.bem.common.mohandler.MoHandler;
import se.ericsson.wcdma.rbs.bem.common.mohandler.MoHandlerException;
import se.ericsson.wcdma.rbs.bem.common.nal.ifc.Nal;
import se.ericsson.wcdma.rbs.bem.common.nal.ifc.NalFactory;
import se.ericsson.wcdma.rbs.bem.common.nal.ifc.NalNameValue;
import se.ericsson.wcdma.rbs.bem.common.nal.ifc.NalStruct;
import se.ericsson.wcdma.rbs.bem.common.proxy.BemMo;

public abstract class AbstractResourceItem
implements ResourceItem,
ExceptionConstants {
    private final HashMap customerParameters = new HashMap();
    private final String name;
    protected final Rbs rbs;
    private final String[] installationPhases;
    private final MoHandler moHandler;
    private int duwSlotNumber;

    public AbstractResourceItem(String string, Rbs rbs, String[] stringArray) {
        this.name = string;
        this.rbs = rbs;
        this.installationPhases = stringArray;
        this.moHandler = this.rbs.getMoHandler();
        this.duwSlotNumber = 0;
    }

    public String getName() {
        return this.name;
    }

    public void setDuwSlot(int n) {
        this.duwSlotNumber = n;
    }

    public int getDuwSlot() {
        return this.duwSlotNumber;
    }

    public String[] getInstallationPhases() {
        return this.installationPhases;
    }

    public void registerCustomerParameter(CustomerParameter customerParameter) throws BemException {
        if (!(customerParameter instanceof CustomerParameterServer)) {
            BemException bemException = new BemException();
            bemException.setProperty("Problem, Low Level", "PROGRAMMING ERROR. The registered CustomerParameter does not implement interface CustomerParameterServer!");
            bemException.setProperty("ResourceItem  (RI)", this.getDisplayName());
            bemException.setProperty("ConfigParameter (CP)", customerParameter);
            bemException.setProperty("Failing Method", "registerCustomerParameter()");
            throw bemException;
        }
        this.customerParameters.put(customerParameter.getName(), customerParameter);
    }

    public CustomerParameter getCustomerParameter(String string) throws BemException {
        CustomerParameter customerParameter = (CustomerParameter)this.customerParameters.get(string);
        if (customerParameter == null) {
            BemException bemException = new BemException();
            bemException.setProperty("Problem, Low Level", "The requested CustomerParameter is not registered.");
            bemException.setProperty("ResourceItem  (RI)", this.getDisplayName());
            bemException.setProperty("ConfigParameter (CP)", string);
            bemException.setProperty("Failing Method", "getCustomerParameter()");
            throw bemException;
        }
        return customerParameter;
    }

    public CustomerParameterServer getCustomerParameterServer(String string) throws BemException {
        CustomerParameterServer customerParameterServer = (CustomerParameterServer)this.customerParameters.get(string);
        if (customerParameterServer == null) {
            BemException bemException = new BemException();
            bemException.setProperty("Problem, Low Level", "The requested CustomerParameterServer is not registered.");
            bemException.setProperty("ResourceItem  (RI)", this.getDisplayName());
            bemException.setProperty("ConfigParameter (CP)", string);
            bemException.setProperty("Failing Method", "getCustomerParameterServer()");
            throw bemException;
        }
        return customerParameterServer;
    }

    public Object getAttributeValue(String string) throws BemException {
        BemException bemException = new BemException();
        bemException.setProperty("Problem, Low Level", "getAttributeValue() is not supported by this resource");
        bemException.setProperty("ResourceItem  (RI)", this.getDisplayName());
        bemException.setProperty("Failing Method", "getAttributeValue()");
        throw bemException;
    }

    public boolean isExisting(String string) throws BemException {
        BemMo bemMo = this.getMo(string);
        try {
            BemLog.log(7, this.name + " isExisting()");
            return this.moHandler.isExisting(bemMo);
        }
        catch (MoHandlerException moHandlerException) {
            BemException bemException = new BemException(moHandlerException);
            bemException.setProperty("ManagedObject", string);
            bemException.setProperty("ResourceItem  (RI)", this.getDisplayName());
            bemException.setProperty("Failing Method", "isExisting()");
            throw bemException;
        }
    }

    public abstract void install(String var1) throws BemException;

    public void uninstall(String string) throws BemException {
    }

    protected Rbs getRbs() {
        return this.rbs;
    }

    protected final void createMoIfNotExisting(String string) throws BemException {
        try {
            BemLog.log(7, this.name + " createMoIfNotExisting(), ldn: " + string);
            this.moHandler.createMoIfNotExisting(string);
        }
        catch (MoHandlerException moHandlerException) {
            BemException bemException = new BemException(moHandlerException);
            bemException.setProperty("ManagedObject", string);
            bemException.setProperty("ResourceItem  (RI)", this.getDisplayName());
            bemException.setProperty("Failing Method", "createMoIfNotExisting()");
            throw bemException;
        }
    }

    protected final void createMoIfNotExisting(String string, Vector vector) throws BemException {
        try {
            BemLog.log(7, this.name + " createMoIfNotExisting(), ldn: " + string);
            this.moHandler.createMoIfNotExisting(string, vector);
        }
        catch (MoHandlerException moHandlerException) {
            BemException bemException = new BemException(moHandlerException);
            bemException.setProperty("ManagedObject", string);
            bemException.setProperty("ResourceItem  (RI)", this.getDisplayName());
            bemException.setProperty("Failing Method", "createMoIfNotExisting()");
            throw bemException;
        }
    }

    protected final void createMoIfNotExisting(String string, NalNameValue[] nalNameValueArray) throws BemException {
        try {
            BemLog.log(7, this.name + " createMoIfNotExisting(), ldn: " + string);
            this.moHandler.createMoIfNotExisting(string, nalNameValueArray);
        }
        catch (MoHandlerException moHandlerException) {
            BemException bemException = new BemException(moHandlerException);
            bemException.setProperty("ManagedObject", string);
            bemException.setProperty("ResourceItem  (RI)", this.getDisplayName());
            bemException.setProperty("Failing Method", "createMoIfNotExisting()");
            throw bemException;
        }
    }

    protected final void deleteMoIfNotExisting(String string) throws BemException {
        try {
            BemLog.log(7, this.name + " deleteMoIfNotExisting(), ldn: " + string);
            this.moHandler.deleteMoIfExisting(string);
        }
        catch (MoHandlerException moHandlerException) {
            BemException bemException = new BemException(moHandlerException);
            bemException.setProperty("ManagedObject", string);
            bemException.setProperty("ResourceItem  (RI)", this.getDisplayName());
            bemException.setProperty("Failing Method", "deleteMoIfNotExisting()");
            throw bemException;
        }
    }

    protected boolean containsPhase(String[] stringArray, String string) {
        boolean bl = false;
        for (int i = 0; i < stringArray.length; ++i) {
            if (!string.equalsIgnoreCase(stringArray[i])) continue;
            bl = true;
            break;
        }
        return bl;
    }

    public String getLoadedValue(String string) throws BemException {
        BemException bemException = new BemException();
        bemException.setProperty("Problem", "INTERNAL ERROR. If the problem persists, please report.");
        bemException.setProperty("Problem, Low Level", "getLoadedValue() is not supported by this resource");
        bemException.setProperty("ResourceItem  (RI)", this.getDisplayName());
        bemException.setProperty("PseudoName", string);
        bemException.setProperty("Failing Method", "getLoadedValue()");
        throw bemException;
    }

    public boolean isInstalled() throws BemException {
        return this.isExisting(this.getLdn());
    }

    public StringBuffer getInstallReport() {
        return null;
    }

    protected void unlock(String string) throws BemException {
        String string2 = null;
        try {
            Integer n;
            string2 = this.getLdn();
            BemMo bemMo = this.getMo(string2);
            BemMo bemMo2 = this.getParent(bemMo);
            if (this.isExisting(bemMo2) && (n = (Integer)this.moHandler.getAttribute(bemMo2, string)) != null && n == 0) {
                BemLog.log(7, this.name + " unlock()");
                this.moHandler.setAttribute(bemMo2, string, new Integer(1));
            }
        }
        catch (Exception exception) {
            BemException bemException = new BemException(exception);
            bemException.setProperty("Problem, Low Level", "Failed unlocking MO parent using adminStateAttrName=" + string);
            bemException.setProperty("ResourceItem  (RI)", this.getDisplayName());
            bemException.setProperty("ManagedObject", this.getLdn());
            bemException.setProperty("Failing Method", "unlock()");
            throw bemException;
        }
    }

    protected void unlockThisMo(String string) throws BemException {
        String string2 = null;
        try {
            Integer n;
            string2 = this.getLdn();
            BemMo bemMo = this.getMo(string2);
            if (this.isExisting(bemMo) && (n = (Integer)this.moHandler.getAttribute(bemMo, string)) != null && n == 0) {
                BemLog.log(7, this.name + " unlock()");
                this.moHandler.setAttribute(bemMo, string, new Integer(1));
            }
        }
        catch (Exception exception) {
            BemException bemException = new BemException(exception);
            bemException.setProperty("Problem, Low Level", "Failed unlocking MO using adminStateAttrName=" + string);
            bemException.setProperty("ResourceItem  (RI)", this.getDisplayName());
            bemException.setProperty("ManagedObject", this.getLdn());
            bemException.setProperty("Failing Method", "unlockThisMo()");
            throw bemException;
        }
    }

    protected void unlockMO(BemMo bemMo, String string) throws BemException {
        if (bemMo == null || string == null) {
            return;
        }
        try {
            if (this.moHandler.isExisting(bemMo)) {
                Integer n = new Integer(1);
                this.moHandler.setAttribute(bemMo, string, n);
            }
        }
        catch (Exception exception) {
            BemException bemException = new BemException(exception);
            bemException.setProperty("Problem, Low Level", "Failed unlocking MO using adminStateAttrName=" + string);
            bemException.setProperty("ResourceItem  (RI)", this.getDisplayName());
            bemException.setProperty("ManagedObject", bemMo);
            bemException.setProperty("Failing Method", "unlockMO()");
            throw bemException;
        }
    }

    protected void lock(String string) throws BemException {
        String string2 = null;
        string2 = this.getLdn();
        BemMo bemMo = this.getMo(string2);
        BemMo bemMo2 = this.getParent(bemMo);
        try {
            if (this.isExisting(bemMo2)) {
                BemLog.log(7, this.name + " lock()");
                this.moHandler.setAttribute(bemMo2, string, new Integer(0));
            }
        }
        catch (MoHandlerException moHandlerException) {
            BemException bemException = new BemException(moHandlerException);
            bemException.setProperty("Problem, Low Level", "Failed locking MO parent using adminStateAttrName=" + string);
            bemException.setProperty("ResourceItem  (RI)", this.getDisplayName());
            bemException.setProperty("ManagedObject", string2);
            bemException.setProperty("Failing Method", "lock()");
            throw bemException;
        }
    }

    protected void lockMO(BemMo bemMo, String string) throws BemException {
        if (bemMo == null || string == null) {
            return;
        }
        try {
            if (this.moHandler.isExisting(bemMo)) {
                Integer n = new Integer(0);
                this.moHandler.setAttribute(bemMo, string, n);
            }
        }
        catch (Exception exception) {
            BemException bemException = new BemException(exception);
            bemException.setProperty("Problem, Low Level", "Failed locking MO using adminStateAttrName=" + string);
            bemException.setProperty("ResourceItem  (RI)", this.getDisplayName());
            bemException.setProperty("ManagedObject", bemMo);
            bemException.setProperty("Failing Method", "lockMO()");
            throw bemException;
        }
    }

    protected final void setAttribute(String string, String string2, Object object) throws BemException {
        try {
            BemLog.log(7, this.name + " setAttribute()");
            BemMo bemMo = this.moHandler.getMo(string);
            this.moHandler.setAttribute(bemMo, string2, object);
        }
        catch (MoHandlerException moHandlerException) {
            BemException bemException = new BemException(moHandlerException);
            bemException.setProperty("Problem, Low Level", "Failed settingAttribute " + string2);
            bemException.setProperty("ResourceItem  (RI)", this.getDisplayName());
            bemException.setProperty("ManagedObject", string);
            bemException.setProperty("Failing Method", "setAttribute()");
            throw bemException;
        }
    }

    protected Object getValeOfStructMember(NalStruct nalStruct, String string) throws BemException {
        Object object = null;
        try {
            object = nalStruct.getMemberValue(string);
        }
        catch (NoSuchFieldException noSuchFieldException) {
            BemException bemException = new BemException(noSuchFieldException);
            bemException.setProperty("Problem, Low Level", "Failed retreiving missing member '" + string + "' from Struct.");
            bemException.setProperty("ResourceItem  (RI)", this.getDisplayName());
            bemException.setProperty("Failing Method", "getValeOfStructMember()");
            throw bemException;
        }
        return object;
    }

    protected final BemMo getMo(String string) {
        BemMo bemMo = null;
        BemLog.log(7, this.name + " getMo()");
        bemMo = this.moHandler.getMo(string);
        return bemMo;
    }

    protected final BemMo[] getChildren(BemMo bemMo, int n, String string, String string2) throws BemException {
        BemMo[] bemMoArray = null;
        try {
            BemLog.log(7, this.name + " getChildren()");
            bemMoArray = this.moHandler.getChildren(bemMo, n, string, string2);
        }
        catch (MoHandlerException moHandlerException) {
            BemException bemException = new BemException(moHandlerException);
            bemException.setProperty("ResourceItem  (RI)", this.getDisplayName());
            bemException.setProperty("ManagedObject", bemMo);
            bemException.setProperty("Failing Method", "getChildren()");
            throw bemException;
        }
        return bemMoArray;
    }

    protected final Object getAttribute(BemMo bemMo, String string) throws BemException {
        Object object = null;
        try {
            BemLog.log(7, this.name + " getAttribute()");
            object = this.moHandler.getAttribute(bemMo, string);
        }
        catch (MoHandlerException moHandlerException) {
            BemException bemException = new BemException(moHandlerException);
            bemException.setProperty("ResourceItem  (RI)", this.getDisplayName());
            bemException.setProperty("ManagedObject", bemMo);
            bemException.setProperty("Failing Method", "getAttribute()");
            throw bemException;
        }
        return object;
    }

    protected final String genLDN(String string, String string2) throws BemException {
        String string3 = null;
        try {
            BemLog.log(7, this.name + " getAttribute()");
            string3 = this.moHandler.genLDN(string, string2);
        }
        catch (MoHandlerException moHandlerException) {
            BemException bemException = new BemException(moHandlerException);
            bemException.setProperty("ResourceItem  (RI)", this.getDisplayName());
            bemException.setProperty("Failing Method", "getAttributes()");
            throw bemException;
        }
        return string3;
    }

    protected final Object[] getAttributes(BemMo bemMo, String[] stringArray) throws BemException {
        Object[] objectArray = null;
        try {
            BemLog.log(7, this.name + " getAttribute()");
            objectArray = this.moHandler.getAttributes(bemMo, stringArray);
        }
        catch (MoHandlerException moHandlerException) {
            BemException bemException = new BemException(moHandlerException);
            bemException.setProperty("ResourceItem  (RI)", this.getDisplayName());
            bemException.setProperty("ManagedObject", bemMo);
            bemException.setProperty("Failing Method", "getAttributes()");
            throw bemException;
        }
        return objectArray;
    }

    protected final BemMo getRoot() throws BemException {
        BemMo bemMo = null;
        try {
            BemLog.log(7, this.name + " getRoot()");
            bemMo = this.moHandler.getRoot();
        }
        catch (MoHandlerException moHandlerException) {
            BemException bemException = new BemException(moHandlerException);
            bemException.setProperty("ResourceItem  (RI)", this.getDisplayName());
            bemException.setProperty("Failing Method", "getRoot()");
            throw bemException;
        }
        return bemMo;
    }

    protected final boolean isExisting(BemMo bemMo) throws BemException {
        boolean bl = true;
        try {
            BemLog.log(7, this.name + " isExisting()");
            bl = this.moHandler.isExisting(bemMo);
        }
        catch (MoHandlerException moHandlerException) {
            BemException bemException = new BemException(moHandlerException);
            bemException.setProperty("ResourceItem  (RI)", this.getDisplayName());
            bemException.setProperty("ManagedObject", bemMo);
            bemException.setProperty("Failing Method", "isExisting()");
            throw bemException;
        }
        return bl;
    }

    protected final void setAttribute(BemMo bemMo, String string, Object object) throws BemException {
        try {
            BemLog.log(7, this.name + " setAttribute()");
            this.moHandler.setAttribute(bemMo, string, object);
        }
        catch (MoHandlerException moHandlerException) {
            BemException bemException = new BemException(moHandlerException);
            bemException.setProperty("ResourceItem  (RI)", this.getDisplayName());
            bemException.setProperty("ManagedObject", bemMo);
            bemException.setProperty("Failing Method", "setAttribute()");
            throw bemException;
        }
    }

    protected final void create(BemMo bemMo, Vector vector) throws BemException {
        try {
            BemLog.log(7, this.name + " create()");
            this.moHandler.create(bemMo, vector);
        }
        catch (MoHandlerException moHandlerException) {
            BemException bemException = new BemException(moHandlerException);
            bemException.setProperty("ResourceItem  (RI)", this.getDisplayName());
            bemException.setProperty("ManagedObject", bemMo);
            bemException.setProperty("Failing Method", "create()");
            throw bemException;
        }
    }

    protected Object action(BemMo bemMo, String string, NalNameValue[] nalNameValueArray) throws BemException {
        Object object = null;
        try {
            BemLog.log(7, this.name + " action() " + string);
            object = this.moHandler.action(bemMo, string, nalNameValueArray);
        }
        catch (MoHandlerException moHandlerException) {
            BemException bemException = new BemException(moHandlerException);
            bemException.setProperty("ResourceItem  (RI)", this.getDisplayName());
            bemException.setProperty("ManagedObject", bemMo);
            bemException.setProperty("Failing Method", "action( anAction=" + string + ")");
            throw bemException;
        }
        return object;
    }

    protected Object action(BemMo bemMo, String string, NalNameValue[] nalNameValueArray, boolean bl) throws BemException {
        Object object = null;
        try {
            BemLog.log(7, this.name + " action() " + string);
            object = this.moHandler.action(bemMo, string, nalNameValueArray, bl);
        }
        catch (MoHandlerException moHandlerException) {
            BemException bemException = new BemException(moHandlerException);
            bemException.setProperty("ResourceItem  (RI)", this.getDisplayName());
            bemException.setProperty("ManagedObject", bemMo);
            bemException.setProperty("Failing Method", "action( anAction=" + string + ")");
            throw bemException;
        }
        return object;
    }

    protected void deleteMoIfExisting(String string) throws BemException {
        try {
            BemLog.log(7, this.name + " deleteMoIfExisting()");
            this.moHandler.deleteMoIfExisting(string);
        }
        catch (MoHandlerException moHandlerException) {
            BemException bemException = new BemException(moHandlerException);
            bemException.setProperty("ResourceItem  (RI)", this.getDisplayName());
            bemException.setProperty("ManagedObject", string);
            bemException.setProperty("Failing Method", "deleteMoIfExisting()");
            throw bemException;
        }
    }

    protected final void delete(BemMo bemMo) throws BemException {
        try {
            BemLog.log(7, this.name + " delete()");
            this.moHandler.delete(bemMo);
        }
        catch (MoHandlerException moHandlerException) {
            BemException bemException = new BemException(moHandlerException);
            bemException.setProperty("ResourceItem  (RI)", this.getDisplayName());
            bemException.setProperty("ManagedObject", bemMo);
            bemException.setProperty("Failing Method", "delete()");
            throw bemException;
        }
    }

    protected final BemMo getParent(BemMo bemMo) throws BemException {
        BemMo bemMo2 = null;
        try {
            BemLog.log(7, this.name + " getParent()");
            bemMo2 = this.moHandler.getParent(bemMo);
        }
        catch (MoHandlerException moHandlerException) {
            BemException bemException = new BemException(moHandlerException);
            bemException.setProperty("ResourceItem  (RI)", this.getDisplayName());
            bemException.setProperty("ManagedObject", bemMo);
            bemException.setProperty("Failing Method", "getParent()");
            throw bemException;
        }
        return bemMo2;
    }

    public void setAttributes(BemMo bemMo, Vector vector) throws BemException {
        try {
            BemLog.log(7, this.name + " setAttributes()");
            this.moHandler.setAttributes(bemMo, vector);
        }
        catch (MoHandlerException moHandlerException) {
            BemException bemException = new BemException(moHandlerException);
            bemException.setProperty("ResourceItem  (RI)", this.getDisplayName());
            bemException.setProperty("ManagedObject", bemMo);
            bemException.setProperty("Failing Method", "setAttributes()");
            throw bemException;
        }
    }

    protected boolean isInterrupted() {
        if (Thread.currentThread().isInterrupted()) {
            Nal.getLog().nalTrace(6, this.getClass(), "interupted by user");
            return true;
        }
        return false;
    }

    protected void delay_ms(int n) {
        if (this.isInterrupted()) {
            return;
        }
        try {
            NalFactory nalFactory = Nal.getFactory();
            nalFactory.sleep(n);
        }
        catch (InterruptedException interruptedException) {
            return;
        }
    }

    public String toString() {
        return this.getName();
    }
}

