/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.wcdma.rbs.bem.common.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.Serializable;
import java.util.StringTokenizer;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.UIManager;
import javax.swing.border.EmptyBorder;
import javax.swing.text.JTextComponent;

public class ErrorDialog
extends JDialog
implements ActionListener {
    private JButton detailsButton;
    private JButton closeButton;
    private JScrollPane detailsScrollP;
    private static final int TEXT_WIDTH = 480;
    private static final int TEXT_HEIGHT = 300;
    private String closeStr = "Close";
    private String moreStr = "More >>";
    private String lessStr = "<< Less";

    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() == this.closeButton) {
            this.closeButton.removeActionListener(this);
            this.detailsButton.removeActionListener(this);
            this.dispose();
        } else if (actionEvent.getSource() == this.detailsButton) {
            if (this.detailsButton.getText().equals(this.moreStr)) {
                this.detailsScrollP.setPreferredSize(new Dimension(480, 300));
                this.detailsScrollP.setVisible(true);
                this.pack();
                this.detailsScrollP.getVerticalScrollBar().setValue(0);
                this.detailsScrollP.getHorizontalScrollBar().setValue(0);
                this.detailsButton.setText(this.lessStr);
            } else {
                this.detailsScrollP.setPreferredSize(new Dimension(0, 0));
                this.detailsScrollP.setVisible(false);
                this.pack();
                this.detailsButton.setText(this.moreStr);
            }
            this.setDetailsBtnMnemonic();
        }
    }

    public static ErrorDialog create(Component component, String string, String string2) {
        return ErrorDialog.create(component, string, string2, null, null, null, null);
    }

    public static ErrorDialog create(Component component, String string, String string2, String string3, String string4, String string5, String string6) {
        Frame frame = null;
        if (component != null) {
            frame = JOptionPane.getFrameForComponent(component);
        }
        return new ErrorDialog(frame, string, string2, string3, string4, string5, string6);
    }

    private ErrorDialog(Frame frame, String string, String string2, String string3, String string4, String string5, String string6) {
        super(frame, "Error", true);
        this.initStrings(string3, string4, string5, string6);
        this.init(frame, string, string2);
    }

    private void initStrings(String string, String string2, String string3, String string4) {
        if (null != string) {
            this.closeStr = string;
        }
        if (null != string2) {
            this.moreStr = string2;
        }
        if (null != string3) {
            this.lessStr = string3;
        }
        if (null != string4) {
            this.setTitle(string4);
        }
    }

    private void init(Frame frame, String string, String string2) {
        JTextComponent jTextComponent = this.toJTextComponent(frame, string);
        this.init(frame, jTextComponent, string2);
    }

    private void setDetailsBtnMnemonic() {
        if (this.detailsButton.getText().indexOf("Less") > -1) {
            this.detailsButton.setMnemonic('L');
        } else if (this.detailsButton.getText().indexOf("More") > -1) {
            this.detailsButton.setMnemonic('M');
        }
    }

    private JTextComponent toJTextComponent(Frame frame, String string) {
        Object object;
        int n = 2;
        StringTokenizer stringTokenizer = new StringTokenizer(string, "\n", true);
        while (stringTokenizer.hasMoreTokens()) {
            object = stringTokenizer.nextToken();
            if (((String)object).equals("\n")) {
                ++n;
                continue;
            }
            if (((String)object).length() <= 80) continue;
            n += ((String)object).length() / 80;
        }
        object = frame == null ? null : frame.getFont();
        JTextArea jTextArea = new JTextArea(string, n, 80);
        jTextArea.setBorder(new EmptyBorder(0, 0, 0, 0));
        jTextArea.setEditable(false);
        jTextArea.setOpaque(false);
        jTextArea.setFont((Font)object);
        jTextArea.setLineWrap(true);
        jTextArea.setWrapStyleWord(true);
        jTextArea.setCaretPosition(0);
        jTextArea.setRequestFocusEnabled(true);
        return jTextArea;
    }

    private void init(Frame frame, JTextComponent jTextComponent, String string) {
        int n;
        Serializable serializable;
        Font font;
        JScrollPane jScrollPane = new JScrollPane(jTextComponent);
        jScrollPane.setBorder(new EmptyBorder(6, 10, 0, 0));
        JPanel jPanel = new JPanel(new BorderLayout());
        JPanel jPanel2 = new JPanel(new FlowLayout(2));
        JLabel jLabel = new JLabel();
        jLabel.setIcon(UIManager.getIcon("OptionPane.errorIcon"));
        JPanel jPanel3 = new JPanel();
        jPanel3.add(jLabel);
        jPanel.add((Component)jScrollPane, "Center");
        jPanel.add((Component)jPanel3, "West");
        this.detailsButton = new JButton(this.moreStr);
        this.closeButton = new JButton(this.closeStr);
        if (this.closeStr.indexOf("Close") > -1) {
            this.closeButton.setMnemonic('C');
        }
        this.closeButton.requestFocus();
        Font font2 = font = frame == null ? null : frame.getFont();
        if (null != string && !string.trim().equals("")) {
            jPanel2.add(this.detailsButton);
            this.detailsButton.addActionListener(this);
            this.setDetailsBtnMnemonic();
            serializable = new JTextArea(string);
            ((JComponent)serializable).setRequestFocusEnabled(true);
            ((JTextComponent)serializable).setEditable(false);
            ((JTextArea)serializable).setFont(font);
            ((JTextArea)serializable).setLineWrap(false);
            ((JTextArea)serializable).setWrapStyleWord(false);
            ((JComponent)serializable).setOpaque(false);
            ((JComponent)serializable).setBorder(new EmptyBorder(0, 10, 0, 10));
            this.detailsScrollP = new JScrollPane((Component)serializable);
            this.detailsScrollP.setBorder(BorderFactory.createLoweredBevelBorder());
            this.detailsScrollP.setPreferredSize(new Dimension(0, 0));
            this.getContentPane().add((Component)this.detailsScrollP, "Center");
        }
        jPanel2.add(this.closeButton);
        this.closeButton.addActionListener(this);
        jPanel.add((Component)jPanel2, "South");
        this.getContentPane().add((Component)jPanel, "North");
        this.pack();
        serializable = Toolkit.getDefaultToolkit().getScreenSize();
        int n2 = this.getWidth();
        for (n = this.getHeight(); n >= ((Dimension)serializable).height; n /= 2) {
        }
        while (n2 >= ((Dimension)serializable).width) {
            n2 /= 2;
        }
        this.setSize(n2, n);
        int n3 = (((Dimension)serializable).width - n2) / 2;
        int n4 = (((Dimension)serializable).height - n) / 2;
        this.setLocation(n3, n4);
        this.setDefaultCloseOperation(2);
        this.setResizable(true);
    }
}

