/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.wcdma.rbs.bem.common.gui;

import java.awt.Color;
import java.awt.Component;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import javax.swing.text.Caret;
import se.ericsson.wcdma.rbs.bem.common.config.custparam.CustomerParameter;
import se.ericsson.wcdma.rbs.bem.common.gui.EditorRendererBase;
import se.ericsson.wcdma.rbs.bem.common.gui.TextFieldEditor;
import se.ericsson.wcdma.rbs.bem.common.gui.TooltipFactory;

public class TextFieldEditorRenderer
extends EditorRendererBase
implements TableCellEditor,
TableCellRenderer {
    protected TextFieldEditor editor = null;
    protected JTextField renderer = null;

    public TextFieldEditorRenderer(CustomerParameter customerParameter) {
        super(customerParameter);
    }

    public boolean stopCellEditing() {
        super.stopCellEditing();
        String string = this.editor.getText();
        try {
            this.customerParameter.setValue(string);
            if (this.customerParameter.isValidValue()) {
                this.renderer.setForeground(Color.black);
            } else {
                this.renderer.setForeground(Color.red);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return true;
    }

    public Component getTableCellEditorComponent(JTable jTable, Object object, boolean bl, int n, int n2) {
        if (object != null && object instanceof CustomerParameter) {
            CustomerParameter customerParameter = (CustomerParameter)object;
            TextFieldEditor textFieldEditor = new TextFieldEditor(customerParameter);
            String string = TooltipFactory.generateTooltip(customerParameter);
            textFieldEditor.setToolTipText(string);
            String string2 = this.customerParameter.getValue();
            if (string2.equals("##UNDEFINED") || string2.equals("*")) {
                textFieldEditor.setText("");
            } else {
                textFieldEditor.setText(string2);
            }
            Caret caret = textFieldEditor.getCaret();
            if (caret != null) {
                caret.setVisible(true);
            }
            textFieldEditor.keyReleased(null);
            this.editor = textFieldEditor;
        }
        return this.editor;
    }

    public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
        if (object != null && object instanceof CustomerParameter) {
            CustomerParameter customerParameter = (CustomerParameter)object;
            TextFieldEditor textFieldEditor = new TextFieldEditor(customerParameter);
            String string = TooltipFactory.generateTooltip(customerParameter);
            textFieldEditor.setToolTipText(string);
            String string2 = this.customerParameter.getValue();
            if (string2.equals("##UNDEFINED")) {
                textFieldEditor.setText("*");
            } else {
                textFieldEditor.setText(string2);
            }
            textFieldEditor.keyReleased(null);
            if (bl2) {
                textFieldEditor.setForeground(jTable.getSelectionForeground());
                textFieldEditor.setBackground(jTable.getSelectionBackground());
            } else {
                textFieldEditor.setForeground(jTable.getForeground());
                textFieldEditor.setBackground(jTable.getBackground());
            }
            this.renderer = textFieldEditor;
        }
        return this.renderer;
    }
}

