/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.wcdma.rbs.bem.common.proxy.pmpi;

import se.ericsson.cello.neal.Node;
import se.ericsson.cello.neal.NodeAccess;
import se.ericsson.cello.neal.pm.Pm;
import se.ericsson.cello.neal.pm.PmException;
import se.ericsson.cello.neal.pm.PmInfo;
import se.ericsson.cello.neal.pm.PmService;
import se.ericsson.wcdma.rbs.bem.common.BemLog;
import se.ericsson.wcdma.rbs.bem.common.nal.ifc.NalCmException;
import se.ericsson.wcdma.rbs.bem.common.proxy.pmpi.BemPmciException;
import se.ericsson.wcdma.rbs.bem.common.proxy.pmpi.ScannerProxy;

public class PerformanceScannerFacade {
    private static PerformanceScannerFacade myRef = null;
    private String hostname = null;
    private Node node = null;

    private PerformanceScannerFacade() throws BemPmciException {
        BemLog.trace("Entering the constructor of PerformanceScannerFacade");
    }

    public static PerformanceScannerFacade getFacade() throws BemPmciException {
        BemLog.trace("getPerformanceScannerFacade()");
        if (myRef == null) {
            myRef = new PerformanceScannerFacade();
        }
        return myRef;
    }

    public void destroyFacade() {
        BemLog.trace("destroyFacade()");
        myRef = null;
    }

    public void setHostname(String string) {
        this.hostname = string;
    }

    public synchronized void connectToMib() {
        try {
            this.node = NodeAccess.getNode((String)this.hostname);
        }
        catch (Exception exception) {
            throw new NalCmException("Unable to connect to RBS: " + this.hostname, exception);
        }
    }

    public ScannerProxy[] listScanners() {
        BemLog.log(7, "Entering method listScanners() in PerformanceScannerFacade");
        ScannerProxy[] scannerProxyArray = new ScannerProxy[]{};
        if (this.node == null) {
            return scannerProxyArray;
        }
        PmService pmService = this.node.getPmService();
        if (pmService == null) {
            return scannerProxyArray;
        }
        Pm[] pmArray = pmService.lookupAll();
        if (pmArray != null) {
            scannerProxyArray = new ScannerProxy[pmArray.length];
            for (int i = 0; i < pmArray.length; ++i) {
                int n = pmArray[i].getId();
                PmInfo pmInfo = pmArray[i].getPmInfo();
                String string = pmInfo.getName();
                boolean bl = pmInfo.isActive();
                scannerProxyArray[i] = new ScannerProxy(n, string, bl);
            }
        }
        BemLog.log(7, "Exiting method listScanners() in PerformanceScannerFacade");
        return scannerProxyArray;
    }

    public boolean suspendPm(int n) {
        PmService pmService = this.node.getPmService();
        Pm pm = pmService.lookup(n);
        try {
            pm.suspend();
        }
        catch (PmException pmException) {
            BemLog.logError("Suspension of PM with id: " + n + " failed! ", pmException);
            return false;
        }
        return true;
    }

    public boolean resumePm(int n) {
        PmService pmService = this.node.getPmService();
        Pm pm = pmService.lookup(n);
        try {
            pm.resume();
        }
        catch (PmException pmException) {
            BemLog.logError("Activation of PM with id: " + n + " failed! ", pmException);
            return false;
        }
        return true;
    }
}

