/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.wcdma.rbs.bem.common.proxy.pmpi;

import se.ericsson.wcdma.rbs.bem.common.BemLog;
import se.ericsson.wcdma.rbs.bem.common.proxy.pmpi.BemPmciException;
import se.ericsson.wcdma.rbs.bem.common.proxy.pmpi.PerformanceScannerFacade;

public class ScannerProxy {
    public static final boolean ACTIVE = true;
    public static final boolean INACTIVE = false;
    private int performanceId;
    private String measurementName;
    private boolean state;

    public ScannerProxy(int n, String string, boolean bl) {
        this.performanceId = n;
        this.measurementName = string;
        this.state = bl;
    }

    public static ScannerProxy[] listScanners(String string) throws BemPmciException {
        BemLog.log(7, "Entering method listScanners(String hostname) in ScannerProxy");
        PerformanceScannerFacade performanceScannerFacade = PerformanceScannerFacade.getFacade();
        performanceScannerFacade.setHostname(string);
        performanceScannerFacade.connectToMib();
        ScannerProxy[] scannerProxyArray = performanceScannerFacade.listScanners();
        BemLog.log(7, "Exiting method listScanners(String hostname) in ScannerProxy");
        return scannerProxyArray;
    }

    public boolean suspendScanner() throws BemPmciException {
        PerformanceScannerFacade performanceScannerFacade;
        boolean bl = true;
        if (this.state && (bl = (performanceScannerFacade = PerformanceScannerFacade.getFacade()).suspendPm(this.performanceId))) {
            this.state = false;
            BemLog.log(7, " Successful suspension of performance monitoring with id: " + this.performanceId + ", and measurementName: " + this.measurementName);
        }
        return bl;
    }

    public boolean resumeScanner() throws BemPmciException {
        PerformanceScannerFacade performanceScannerFacade;
        boolean bl = true;
        if (!this.state && (bl = (performanceScannerFacade = PerformanceScannerFacade.getFacade()).resumePm(this.performanceId))) {
            this.state = true;
            BemLog.log(7, " Successful activation of performance monitoring with id: " + this.performanceId + ", and measurementName: " + this.measurementName);
        }
        return bl;
    }

    public boolean getState() {
        return this.state;
    }

    public String getStateString() {
        String string = "Unknown State";
        if (this.state) {
            string = "active";
        } else if (!this.state) {
            string = "inactive";
        }
        return string;
    }

    public int getPerformanceId() {
        return this.performanceId;
    }

    public String getMeasurmentName() {
        return this.measurementName;
    }
}

