/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.wcdma.rbs.bem.common.service;

import se.ericsson.wcdma.rbs.bem.common.nal.ifc.Nal;
import se.ericsson.wcdma.rbs.bem.common.nal.ifc.NalNameValue;
import se.ericsson.wcdma.rbs.bem.common.service.Source;

public class ServiceNameValue
implements NalNameValue {
    private final NalNameValue delegate;
    private String serviceName;
    private String prefix;
    private Source inputSource;
    private String simpleName;

    public ServiceNameValue(String string, String string2, String string3, String string4, Source source) {
        this.delegate = Nal.getFactory().getNameValue(ServiceNameValue.toPseudoName(string2, string3), string4);
        this.serviceName = string;
        this.prefix = string2;
        this.simpleName = string3;
        this.inputSource = source;
    }

    public ServiceNameValue(String string, String string2, String string3, String string4) {
        this(string, string2, string3, string4, new Source("Unspecified source"));
    }

    public ServiceNameValue(String string, String string2) {
        this.delegate = Nal.getFactory().getNameValue(string, string2);
        this.serviceName = null;
        this.inputSource = new Source("unspecified source");
        this.prefix = "";
        this.simpleName = "";
        boolean bl = false;
        for (int i = string.length() - 1; i >= 0; --i) {
            char c = string.charAt(i);
            if (c == '_') {
                bl = true;
            }
            if (bl) {
                this.prefix = c + this.prefix;
                continue;
            }
            this.simpleName = c + this.simpleName;
        }
    }

    void setServiceName(String string) {
        this.serviceName = string;
    }

    private static String toPseudoName(String string, String string2) {
        String string3 = string + string2;
        return string3;
    }

    public String getServiceName() {
        return this.serviceName;
    }

    public String getPrefix() {
        return this.prefix;
    }

    public String getPseudoName() {
        return this.delegate.getName();
    }

    public String getSimpleName() {
        return this.simpleName;
    }

    public String getValueAsString() {
        return this.getValue().toString();
    }

    public Source getInputSource() {
        return this.inputSource;
    }

    public String toString() {
        return this.getPseudoName() + "=" + this.getValue();
    }

    public Object getNative() {
        return this.delegate.getNative();
    }

    public String getName() {
        return this.delegate.getName();
    }

    public Object getValue() {
        return this.delegate.getValue();
    }
}

