/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.wcdma.rbs.bem.view.actions;

import java.util.Properties;
import javax.swing.JOptionPane;
import se.ericsson.security.launcher.Launchable;
import se.ericsson.security.launcher.LauncherInterface;
import se.ericsson.wcdma.rbs.bem.common.BemLog;
import se.ericsson.wcdma.rbs.bem.common.mim.MimAuxPlugInUnit;
import se.ericsson.wcdma.rbs.bem.common.mim.MimDpProgram;
import se.ericsson.wcdma.rbs.bem.common.mim.MimPlugInUnit;
import se.ericsson.wcdma.rbs.bem.common.mim.MimProgram;
import se.ericsson.wcdma.rbs.bem.common.mim.MimRaxDeviceGroup;
import se.ericsson.wcdma.rbs.bem.common.mim.MimRbsSlot;
import se.ericsson.wcdma.rbs.bem.common.mim.MimSlot;
import se.ericsson.wcdma.rbs.bem.common.mim.MimSwAllocation;
import se.ericsson.wcdma.rbs.bem.common.mim.MimXpProgram;
import se.ericsson.wcdma.rbs.bem.common.mohandler.MoHandler;
import se.ericsson.wcdma.rbs.bem.common.mohandler.MoHandlerException;
import se.ericsson.wcdma.rbs.bem.common.mohandler.MoHandlerImpl;
import se.ericsson.wcdma.rbs.bem.common.nal.ifc.Nal;
import se.ericsson.wcdma.rbs.bem.common.nal.ifc.NalCmException;
import se.ericsson.wcdma.rbs.bem.common.nal.ifc.NalNameValue;
import se.ericsson.wcdma.rbs.bem.common.nal.ifc.NalTransaction;
import se.ericsson.wcdma.rbs.bem.common.proxy.BemMo;
import se.ericsson.wcdma.rbs.bem.view.util.BemViewCommon;

public class DeleteAction
implements Launchable {
    private static final String NAME = "Delete";
    private static final String WARNING_TITLE = "Warning";
    private static final String ERROR_TITLE = "Error";
    private static final String emString = " - RBS Element Manager - ";
    private BemMo mo;
    private String ldn;
    private String hostname;
    private boolean lockedByDeleteAppl = false;
    private StringBuffer title = new StringBuffer();
    MoHandler moHandler = new MoHandlerImpl();
    private LauncherInterface launcher;

    public void run(String string, Properties properties, LauncherInterface launcherInterface, Launchable launchable) {
        this.hostname = string;
        this.launcher = launcherInterface;
        this.ldn = properties.getProperty("LDNs");
        this.mo = this.moHandler.getMo(this.ldn);
        this.delete();
        this.exit();
    }

    public boolean reconnect(String string, Properties properties) {
        return false;
    }

    public void exit() {
        this.launcher.onExit((Launchable)this);
    }

    public boolean forcePerformAction() {
        return this.delete(true, true);
    }

    public void delete() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("You intend to delete \"" + this.mo.getType() + "\"");
        stringBuffer.append("\n(" + this.mo.getDN() + ")\n");
        stringBuffer.append("Please be aware that this operation might disturb the ongoing traffic.");
        this.title.append(this.hostname);
        this.title.append(emString);
        this.title.append(NAME);
        int n = JOptionPane.showConfirmDialog(null, stringBuffer.toString(), this.title.toString(), 0, 3);
        if (n == 0) {
            if (this.mo.getType().equals(MimRaxDeviceGroup.MOTYPENAME)) {
                this.delete(false, false);
            } else {
                this.delete(false, true);
            }
        }
    }

    protected boolean delete(boolean bl, boolean bl2) {
        try {
            this.lockBoard();
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("Removing " + this.mo.getType() + ":" + "\n");
            stringBuffer.append("Please remove board concerned from the subrack and then click on \"OK\" to continue deletion.");
            int n = JOptionPane.showConfirmDialog(null, stringBuffer.toString(), WARNING_TITLE, 2, 2);
            if (n == 0) {
                if (this.boardIsRemoved()) {
                    if (bl2) {
                        BemMo bemMo = this.getMoForSwAllocation();
                        this.removeFromSwAllocationIfConfigured(bemMo, false, this.moHandler);
                    }
                    this.deleteRbsBoard();
                } else {
                    JOptionPane.showMessageDialog(null, "Board is not removed from the subrack!", WARNING_TITLE, 2);
                    this.unlockboardIflocked();
                }
            } else if (n == 2) {
                this.unlockboardIflocked();
            }
        }
        catch (Exception exception) {
            BemLog.exceptionRaised("Failed to delete MO.", exception);
            if (!bl) {
                JOptionPane.showMessageDialog(null, "Delete failed.", ERROR_TITLE, 0);
            }
            return false;
        }
        return true;
    }

    private void unlockboardIflocked() throws Exception {
        BemMo bemMo = this.getParent(this.mo, MimPlugInUnit.MOTYPENAME);
        if (bemMo == null) {
            bemMo = this.getParent(this.mo, MimAuxPlugInUnit.MOTYPENAME);
        }
        if (bemMo == null) {
            throw new Error("Unable to unlock board. PIU not found");
        }
        Integer n = (Integer)this.moHandler.getAttribute(bemMo, "administrativeState");
        if (n != 1 && this.lockedByDeleteAppl) {
            this.moHandler.setAttribute(bemMo, "administrativeState", 1);
        }
    }

    private boolean boardIsRemoved() {
        return (Integer)this.mo.getParent().getParent().getAttribute("slotState") != 1;
    }

    protected void removeFromSwAllocationIfConfigured(BemMo bemMo, boolean bl, MoHandler moHandler) throws NalCmException {
        BemMo bemMo2 = moHandler.getMo(BemViewCommon.VIEW_LDN_MANAGEDELEMENT);
        BemMo[] bemMoArray = bemMo2.getChildren(2, MimSwAllocation.MOTYPENAME, "");
        if (bemMoArray != null && bemMoArray.length > 1) {
            for (int i = 0; i < bemMoArray.length; ++i) {
                BemMo bemMo3 = bemMoArray[i];
                boolean bl2 = this.isSlotConfigured(bemMo, bemMo3);
                if (!bl2) continue;
                NalNameValue[] nalNameValueArray = new NalNameValue[]{Nal.getFactory().getNameValue("aSlot", bemMo)};
                if (bl) {
                    moHandler.orderMoOperation("deleteSlot", bemMo3, nalNameValueArray);
                    continue;
                }
                try {
                    moHandler.action(bemMo3, "deleteSlot", nalNameValueArray);
                    continue;
                }
                catch (Exception exception) {
                    BemLog.exceptionRaised("Failed action: deleteSlot", exception);
                }
            }
        }
    }

    private boolean isSlotConfigured(BemMo bemMo, BemMo bemMo2) throws NalCmException {
        BemMo[] bemMoArray = null;
        boolean bl = false;
        if (bemMo2.isExisting() && (bemMoArray = (BemMo[])bemMo2.getAttribute("slotList")) != null && bemMoArray.length != 0) {
            for (int i = 0; i < bemMoArray.length; ++i) {
                String string;
                BemMo bemMo3 = bemMoArray[i];
                String string2 = bemMo3.getDN();
                if (!string2.equals(string = bemMo.getDN())) continue;
                bl = true;
                break;
            }
        }
        return bl;
    }

    private BemMo getMoForSwAllocation() throws Exception {
        BemMo bemMo = null;
        BemMo bemMo2 = this.getParent(this.mo, MimSlot.MOTYPENAME);
        if (bemMo2 == null) {
            bemMo2 = this.mo.getParent().getParent();
        }
        if (bemMo2 == null) {
            bemMo = this.mo.getParent();
        }
        if (bemMo2 != null) {
            BemMo[] bemMoArray = bemMo2.getChildren(1, MimPlugInUnit.MOTYPENAME, "");
            if (bemMoArray != null && bemMoArray.length != 0) {
                bemMo = bemMo2;
            } else {
                bemMoArray = bemMo2.getChildren(1, MimAuxPlugInUnit.MOTYPENAME, "");
                if (bemMoArray != null && bemMoArray.length != 0) {
                    bemMo = bemMoArray[0];
                }
            }
        }
        return bemMo;
    }

    protected BemMo getParent(BemMo bemMo, String string) {
        String string2 = null;
        BemMo bemMo2 = null;
        if (bemMo != null) {
            bemMo2 = bemMo.getParent();
            if (bemMo2 != null) {
                string2 = bemMo2.getType();
                if (string2.equals(string)) {
                    return bemMo2;
                }
                return this.getParent(bemMo2, string);
            }
            return bemMo2;
        }
        return bemMo2;
    }

    private void deleteRbsBoard() throws NalCmException {
        BemMo bemMo = this.getParent(this.mo, MimSlot.MOTYPENAME);
        if (bemMo == null) {
            bemMo = this.getParent(this.mo, MimRbsSlot.MOTYPENAME);
        }
        if (bemMo == null) {
            bemMo = this.getParent(this.mo, MimAuxPlugInUnit.MOTYPENAME);
        }
        if (bemMo != null) {
            BemMo[] bemMoArray = bemMo.getChildren(20, "", "");
            NalTransaction nalTransaction = Nal.getFactory().createTransaction();
            try {
                String string;
                Object object;
                if (bemMoArray != null) {
                    BemMo bemMo2;
                    int n;
                    for (n = 0; n < bemMoArray.length; ++n) {
                        bemMo2 = bemMoArray[n];
                        object = bemMo2.getType();
                        if (!((String)object).equals(MimDpProgram.MOTYPENAME) && !((String)object).equals(MimXpProgram.MOTYPENAME) && !((String)object).equals(MimProgram.MOTYPENAME)) continue;
                        bemMo2.delete(nalTransaction);
                    }
                    for (n = 0; n < bemMoArray.length; ++n) {
                        bemMo2 = bemMoArray[n];
                        object = bemMo2.getType();
                        if (!((String)object).endsWith("DeviceGroup")) continue;
                        bemMo2.delete(nalTransaction);
                    }
                }
                if (MimAuxPlugInUnit.MOTYPENAME.equals(string = bemMo.getType())) {
                    bemMo.delete(nalTransaction);
                } else {
                    for (int i = 0; i < bemMoArray.length; ++i) {
                        object = bemMoArray[i];
                        String string2 = object.getType();
                        if (!MimAuxPlugInUnit.MOTYPENAME.equals(string2) && !MimPlugInUnit.MOTYPENAME.equals(string2)) continue;
                        object.delete(nalTransaction);
                    }
                }
                nalTransaction.commit();
            }
            catch (Exception exception) {
                String string = "Failed to delete RbsBoard!";
                nalTransaction.rollback(string, exception);
            }
        } else {
            Exception exception = new Exception(this.getClass().getName() + " " + this.mo.getDN() + " View Element Faulty implemented.");
            BemLog.exceptionRaised("Failed to delete MO.", exception);
        }
    }

    private void lockBoard() throws Exception {
        BemMo bemMo = this.getParent(this.mo, MimPlugInUnit.MOTYPENAME);
        if (bemMo == null) {
            bemMo = this.getParent(this.mo, MimAuxPlugInUnit.MOTYPENAME);
        }
        if (bemMo == null) {
            throw new Error("Unable to lock board. PIU not found.");
        }
        Integer n = (Integer)this.moHandler.getAttribute(bemMo, "administrativeState");
        if (n != 0) {
            this.moHandler.setAttribute(bemMo, "administrativeState", 0);
            this.lockedByDeleteAppl = true;
        }
    }

    protected void deleteDeviceGroup(MoHandler moHandler, BemMo bemMo) throws MoHandlerException {
        BemMo bemMo2 = bemMo;
        BemMo[] bemMoArray = null;
        BemMo bemMo3 = null;
        String string = null;
        boolean bl = moHandler.isExisting(bemMo2);
        if (bl) {
            bemMoArray = moHandler.getChildren(bemMo2, 1, MimXpProgram.MOTYPENAME, "");
            if (bemMoArray != null && bemMoArray.length != 0) {
                for (int i = 0; i < bemMoArray.length; ++i) {
                    bemMo3 = bemMoArray[i];
                    string = bemMo3.getType();
                    if (!string.equals(MimXpProgram.MOTYPENAME)) continue;
                    moHandler.orderMoOperation("delete", bemMo3, null);
                }
            }
            moHandler.orderMoOperation("delete", bemMo2, null);
        }
    }

    protected void lockMoIfNotLocked(MoHandler moHandler, BemMo bemMo) throws MoHandlerException {
        Integer n;
        boolean bl = moHandler.isExisting(bemMo);
        if (bl && 1 == (n = (Integer)moHandler.getAttribute(bemMo, "administrativeState"))) {
            moHandler.orderMoOperation("Lock", bemMo, null);
        }
    }

    protected void unlockMoIfLocked(MoHandler moHandler, BemMo bemMo) throws MoHandlerException {
        Integer n;
        boolean bl = moHandler.isExisting(bemMo);
        if (bl && 0 == (n = (Integer)moHandler.getAttribute(bemMo, "administrativeState"))) {
            moHandler.setAttribute(bemMo, "administrativeState", 1);
        }
    }
}

