/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.wcdma.rbs.bem.view.actions;

import java.util.Properties;
import javax.swing.JOptionPane;
import se.ericsson.security.launcher.Launchable;
import se.ericsson.security.launcher.LauncherInterface;
import se.ericsson.wcdma.rbs.bem.common.BemLog;
import se.ericsson.wcdma.rbs.bem.common.mim.MimPowerSupplySystem;
import se.ericsson.wcdma.rbs.bem.common.mohandler.MoHandler;
import se.ericsson.wcdma.rbs.bem.common.mohandler.MoHandlerException;
import se.ericsson.wcdma.rbs.bem.common.mohandler.MoHandlerImpl;
import se.ericsson.wcdma.rbs.bem.common.nal.ifc.NalNameValue;
import se.ericsson.wcdma.rbs.bem.common.proxy.BemMo;
import se.ericsson.wcdma.rbs.bem.view.util.BemViewCommon;

public class StartStopBatteryTestAction
implements Launchable {
    private static final String IN_TEST = "1";
    private static final String EMSTRING = "- RBS Element Manager -";
    private BemMo mo;
    private String ldn;
    private String hostname;
    MoHandler moHandler = new MoHandlerImpl();
    private StringBuffer title = new StringBuffer();
    private LauncherInterface launcher;
    String start_txt = "Start battery test";
    String stop_txt = "Stop battery test";
    String additional_txt = "Manual battery test will be stopped. Cyclic or initial test will continue.";
    String start_failed = "Start battery test failed!";
    String stop_failed = "Stop battery test failed!";
    String error_title = "BEM Error";

    public void run(String string, Properties properties, LauncherInterface launcherInterface, Launchable launchable) {
        this.hostname = string;
        this.launcher = launcherInterface;
        this.ldn = properties.getProperty("LDNs");
        this.mo = this.moHandler.getMo(this.ldn);
        try {
            this.startStopBatteryTest();
        }
        catch (Exception exception) {
            BemLog.exceptionRaised(this.stop_failed, exception);
            JOptionPane.showMessageDialog(null, this.stop_failed + "\n" + exception.toString(), this.error_title, 0);
        }
        this.exit();
    }

    public boolean reconnect(String string, Properties properties) {
        return false;
    }

    public void exit() {
        this.launcher.onExit((Launchable)this);
    }

    public void startStopBatteryTest() {
        BemMo bemMo = this.mo.getParent();
        BemMo[] bemMoArray = bemMo.getChildren();
        BemMo bemMo2 = this.getNeededMoFromArray(MimPowerSupplySystem.MOTYPENAME, bemMoArray);
        if (bemMo2 != null) {
            String string = null;
            string = bemMo2.getAttribute("availabilityStatus").toString();
            if (string.equals(IN_TEST)) {
                this.stopBatteryTest();
            } else {
                this.startBatteryTest();
            }
        }
    }

    private void startBatteryTest() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.start_txt);
        stringBuffer.append("?");
        stringBuffer.append("\n");
        StringBuffer stringBuffer2 = new StringBuffer();
        stringBuffer2.append(this.hostname);
        stringBuffer2.append(EMSTRING);
        stringBuffer2.append(this.start_txt);
        int n = JOptionPane.showConfirmDialog(null, stringBuffer.toString(), stringBuffer2.toString(), 0, 3);
        if (n == 0) {
            try {
                BemMo[] bemMoArray;
                BemMo bemMo = this.moHandler.getMo(BemViewCommon.VIEW_LDN_MANAGEDELEMENT);
                if (bemMo != null && (bemMoArray = this.moHandler.getChildren(bemMo, 2, MimPowerSupplySystem.MOTYPENAME, "")).length != 0) {
                    BemMo bemMo2 = bemMoArray[0];
                    NalNameValue[] nalNameValueArray = new NalNameValue[]{};
                    this.moHandler.action(bemMo2, "startBatteryTest", nalNameValueArray);
                }
            }
            catch (MoHandlerException moHandlerException) {
                BemLog.exceptionRaised(this.start_failed, moHandlerException);
                JOptionPane.showMessageDialog(null, this.start_failed + "\n" + moHandlerException.toString(), this.error_title, 0);
            }
        }
    }

    private void stopBatteryTest() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.stop_txt);
        stringBuffer.append("?");
        stringBuffer.append("\n");
        stringBuffer.append(this.additional_txt);
        this.title.append(this.hostname);
        this.title.append(EMSTRING);
        this.title.append(this.stop_txt);
        int n = JOptionPane.showConfirmDialog(null, stringBuffer.toString(), this.title.toString(), 0, 3);
        if (n == 0) {
            try {
                BemMo[] bemMoArray;
                BemMo bemMo = this.moHandler.getMo(BemViewCommon.VIEW_LDN_MANAGEDELEMENT);
                if (bemMo != null && (bemMoArray = this.moHandler.getChildren(bemMo, 2, MimPowerSupplySystem.MOTYPENAME, "")).length != 0) {
                    BemMo bemMo2 = bemMoArray[0];
                    NalNameValue[] nalNameValueArray = new NalNameValue[]{};
                    this.moHandler.action(bemMo2, "stopBatteryTest", nalNameValueArray);
                }
            }
            catch (MoHandlerException moHandlerException) {
                BemLog.exceptionRaised(this.stop_failed, moHandlerException);
                JOptionPane.showMessageDialog(null, this.stop_failed + "\n" + moHandlerException.toString(), this.error_title, 0);
            }
        }
    }

    protected BemMo getNeededMoFromArray(String string, BemMo[] bemMoArray) {
        for (int i = 0; i <= bemMoArray.length; ++i) {
            if (!bemMoArray[i].getType().equals(string)) continue;
            return bemMoArray[i];
        }
        return null;
    }
}

