/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.wcdma.rbs.bem.wizard.control;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import se.ericsson.security.launcher.Launchable;
import se.ericsson.wcdma.rbs.bem.common.BemLog;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.provider.ReconnectDialogProvider;
import se.ericsson.wcdma.rbs.bem.common.config.rbs.Rbs;
import se.ericsson.wcdma.rbs.bem.common.gui.app.BemLaunchable;
import se.ericsson.wcdma.rbs.bem.common.mim.MimSecurity;
import se.ericsson.wcdma.rbs.bem.common.nal.ifc.Nal;
import se.ericsson.wcdma.rbs.bem.common.nal.ifc.NalMo;
import se.ericsson.wcdma.rbs.bem.common.nal.ifc.NalNameValue;
import se.ericsson.wcdma.rbs.bem.common.util.BemLdn;
import se.ericsson.wcdma.rbs.bem.wizard.control.ProgressDialogController;
import se.ericsson.wcdma.rbs.bem.wizard.model.AbstractWizardCIModel;
import se.ericsson.wcdma.rbs.bem.wizard.util.InstallController;
import se.ericsson.wcdma.rbs.bem.wizard.util.WizardHelper;
import se.ericsson.wcdma.rbs.bem.wizard.view.ProgressDialogView;

public class ReconnectingPostProgressDlgController
extends ProgressDialogController
implements ReconnectDialogProvider {
    private final AbstractWizardCIModel model;
    private final Rbs rbs;
    private final WizardHelper wizardHelp;
    private ProgressDialogView view;
    private InstallController installController = null;
    private boolean shallKillNexOnCancel = false;
    private boolean isReconnectModeOn = false;
    private boolean isReconnected = false;
    private static final String RECONNECT_MODE_CANCEL_WARNING = "Press Cancel to abort reconnect and terminate BEM";
    private String originalCancelWarning;
    private final ActionListener cancelButtonKiller = new ActionListener(){

        public void actionPerformed(ActionEvent actionEvent) {
            if (ReconnectingPostProgressDlgController.this.isReconnectModeOn || ReconnectingPostProgressDlgController.this.isReconnected) {
                Nal.getLog().nalTrace(3, this.getClass(), "User aborted attempt to reconnect to node after change of IP address. About to call System.exit(0).");
                System.exit(0);
            } else if (ReconnectingPostProgressDlgController.this.shallKillNexOnCancel) {
                BemLaunchable bemLaunchable;
                String string = "button";
                if (ReconnectingPostProgressDlgController.this.view != null && ((ReconnectingPostProgressDlgController)ReconnectingPostProgressDlgController.this).view.cancelButton != null) {
                    string = ((ReconnectingPostProgressDlgController)ReconnectingPostProgressDlgController.this).view.cancelButton.getText();
                }
                Launchable launchable = (bemLaunchable = ReconnectingPostProgressDlgController.this.getApplication().getBemLaunchable()) == null ? null : bemLaunchable.getParentLaunchable();
                Nal.getLog().nalTrace(3, this.getClass(), "User clicked [" + string + "] " + "after change of IP address. About to close all of NEX with " + (launchable != null ? "parent.exit()." : "System.exit(0)."));
                if (launchable != null) {
                    launchable.exit();
                    bemLaunchable.exit();
                    System.exit(0);
                } else {
                    System.exit(0);
                }
            }
        }
    };
    private String reconnectMessage = null;
    private final StringBuffer progressLogBuffer = new StringBuffer();
    private static Boolean isCorbaSecurityActive = null;

    protected ReconnectingPostProgressDlgController(AbstractWizardCIModel abstractWizardCIModel, WizardHelper wizardHelper) {
        this.model = abstractWizardCIModel;
        this.rbs = this.model.getRbs();
        this.wizardHelp = wizardHelper;
    }

    public InstallController createInstallController() {
        this.view = (ProgressDialogView)this.getView();
        this.rbs.setReconnectDialogProvider(this);
        this.view.cancelButton.addActionListener(this.cancelButtonKiller);
        Class[] classArray = this.wizardHelp.getAllPostControllerClasses();
        this.installController = new InstallController(this, classArray);
        return this.installController;
    }

    public void stopDialog() {
        this.rbs.setReconnectDialogProvider(null);
        super.stopDialog();
    }

    public void launchReconnectProgressDialog() {
        this.reconnectMessage = " The RBS Element Manager has now disconnected from the old RBS IP address\n and is attempting to reconnect on the new RBS IP address.";
        if (ReconnectingPostProgressDlgController.isCorbaSecurityActive()) {
            this.reconnectMessage = this.reconnectMessage + "\n\n Since the RBS has CORBA security activated, the re-connect will fail.";
        }
        this.reconnectMessage = this.reconnectMessage + "\n\n Click [Cancel] to terminate the Element Manager.\n Then be prepared to do the following:" + this.model.getHowToReconnectText() + "\n\n\n" + "\n Reconnect progress (reversed chronological order):" + "\n -------------------------------------------------\n";
        if (ReconnectingPostProgressDlgController.isCorbaSecurityActive()) {
            this.view.resultArea.setText(this.reconnectMessage);
            this.view.resultArea.setCaretPosition(0);
            this.view.resultArea.repaint();
            this.view.setVisible(true);
        }
        this.setButtonReconnectModeOn(true);
        this.shallKillNexOnCancel = true;
    }

    public void reportReconnectProgress(String string) {
        this.progressLogBuffer.insert(0, '\n');
        this.progressLogBuffer.insert(0, " " + string);
        this.view.resultArea.setText(this.reconnectMessage + this.progressLogBuffer.toString());
        this.view.resultArea.setCaretPosition(0);
        this.view.resultArea.repaint();
        this.view.setVisible(true);
        this.setButtonReconnectModeOn(true);
    }

    public void closeReconnectProgressDialog(String string) {
        this.view.resultArea.setText(string + "\n\n");
        this.view.resultArea.setCaretPosition(0);
        this.view.resultArea.repaint();
        this.setButtonReconnectModeOn(false);
        this.view.setVisible(true);
        this.isReconnected = true;
        this.setButtonReconnectModeOn(false);
    }

    private void setButtonReconnectModeOn(boolean bl) {
        if (this.isReconnectModeOn == bl) {
            return;
        }
        if (bl) {
            this.originalCancelWarning = this.view.cancelWarning.getText();
            this.view.cancelWarning.setText(RECONNECT_MODE_CANCEL_WARNING);
        } else {
            this.view.cancelWarning.setText(this.originalCancelWarning);
        }
        this.isReconnectModeOn = bl;
    }

    public static boolean isCorbaSecurityActive() {
        if (isCorbaSecurityActive == null) {
            final NalMo nalMo = Nal.getFactory().getMo(BemLdn.LDN_SECURITY);
            if (nalMo.exists(null)) {
                Thread thread = new Thread("securityMoAttributeReader"){

                    public void run() {
                        try {
                            NalNameValue nalNameValue = nalMo.getAttribute("corbaSecurityActive", null);
                            isCorbaSecurityActive = (Boolean)nalNameValue.getValue();
                            BemLog.log(6, "successfully read attribute corbaSecurityActive, value=" + isCorbaSecurityActive);
                        }
                        catch (Throwable throwable) {
                            BemLog.log(2, "failed reading attribute corbaSecurityActive on MO " + MimSecurity.MOTYPENAME);
                            isCorbaSecurityActive = Boolean.FALSE;
                        }
                    }
                };
                thread.start();
                try {
                    long l = 15000L;
                    thread.join(l);
                    if (thread.isAlive()) {
                        thread.interrupt();
                        BemLog.log(2, "timed out while reading attribute corbaSecurityActive on MO " + MimSecurity.MOTYPENAME);
                        isCorbaSecurityActive = Boolean.FALSE;
                    }
                }
                catch (InterruptedException interruptedException) {
                    if (thread.isAlive()) {
                        thread.interrupt();
                    }
                    BemLog.log(2, "interupted by user!");
                    isCorbaSecurityActive = Boolean.FALSE;
                }
            } else {
                BemLog.log(3, "MO " + BemLdn.LDN_SECURITY + " does not exist on RBS. Setting security to FALSE.");
                isCorbaSecurityActive = Boolean.FALSE;
            }
        }
        return isCorbaSecurityActive;
    }

    public boolean isReconnected() {
        return this.isReconnected;
    }
}

