/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.wcdma.rbs.bem.wizard.precontrol;

import se.ericsson.wcdma.rbs.bem.wizard.exception.WizardException;
import se.ericsson.wcdma.rbs.bem.wizard.util.Installer;
import se.ericsson.wcdma.rbs.bem.wizard.util.Preconditions;
import se.ericsson.wcdma.rbs.bem.wizard.util.PreconditionsCheck;
import se.ericsson.wcdma.rbs.bem.wizard.util.SubInstaller;

public class PreconditionsPreController
implements SubInstaller {
    protected String theName;
    private final Preconditions preconditions;
    private final Installer theInstaller;
    protected String theDescription = "Evaluating preconditions";
    private final int totalReports = 1;
    private int myProgressReports = 0;

    protected PreconditionsPreController(Installer installer, Preconditions preconditions) {
        this.theInstaller = installer;
        this.preconditions = preconditions;
        this.myProgressReports = this.totalReports;
    }

    public int getTotalNoOfProgressReports() {
        return this.totalReports;
    }

    public boolean install() throws WizardException {
        boolean bl = false;
        if (this.theInstaller.isInterrupted()) {
            return false;
        }
        bl = this.checkPreconditions();
        this.theInstaller.reportProgress(this.theName, this.theDescription);
        --this.myProgressReports;
        if (this.theInstaller.isInterrupted()) {
            return false;
        }
        while (this.myProgressReports > 0) {
            this.theInstaller.reportProgress(this.theName, this.theDescription);
            --this.myProgressReports;
        }
        return bl;
    }

    private boolean checkPreconditions() throws WizardException {
        boolean bl;
        block7: {
            bl = false;
            Preconditions preconditions = null;
            try {
                preconditions = new PreconditionsCheck().checkPreconditions(this.preconditions);
                if (preconditions.getPreconditionsFullfilled()) {
                    bl = true;
                    break block7;
                }
                String string = preconditions.getResultMessage();
                throw new WizardException(string);
            }
            catch (WizardException wizardException) {
                throw wizardException;
            }
            catch (Exception exception) {
                throw new WizardException("checkPreconditions()", null, null, this.theDescription, exception);
            }
            finally {
                preconditions = null;
            }
        }
        return bl;
    }

    public String getTheName() {
        return this.theName;
    }

    public String getTheDescription() {
        return this.theDescription;
    }
}

