/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.wcdma.rbs.bem.wizard.wizards.cabinet.flex.precontrol;

import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import se.ericsson.wcdma.rbs.bem.common.BemLog;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.util.DuwUtil;
import se.ericsson.wcdma.rbs.bem.common.exception.BemException;
import se.ericsson.wcdma.rbs.bem.common.mim.MimCbu;
import se.ericsson.wcdma.rbs.bem.common.mim.MimEquipment;
import se.ericsson.wcdma.rbs.bem.common.mim.MimExchangeTerminal;
import se.ericsson.wcdma.rbs.bem.common.mim.MimManagedElementData;
import se.ericsson.wcdma.rbs.bem.common.mim.MimPiuDevice;
import se.ericsson.wcdma.rbs.bem.common.moi.HubSubrackMoi;
import se.ericsson.wcdma.rbs.bem.common.moi.RootMoi;
import se.ericsson.wcdma.rbs.bem.common.moi.SingleChildMoi;
import se.ericsson.wcdma.rbs.bem.common.nal.ifc.Nal;
import se.ericsson.wcdma.rbs.bem.common.nal.ifc.NalNodeConnectionListener;
import se.ericsson.wcdma.rbs.bem.common.proxy.BemMo;
import se.ericsson.wcdma.rbs.bem.common.util.BemLanguageHelp;
import se.ericsson.wcdma.rbs.bem.wizard.exception.WizardException;
import se.ericsson.wcdma.rbs.bem.wizard.precontrol.AbstractDuwPlugAndPlayPreController;
import se.ericsson.wcdma.rbs.bem.wizard.util.Installer;

public class HandlePlugAndPlayPreController
extends AbstractDuwPlugAndPlayPreController
implements NalNodeConnectionListener {
    private final CountDownLatch myNodeConnLostSignal = new CountDownLatch(1);
    private final CountDownLatch myNodeConnRestoredSignal = new CountDownLatch(1);
    private static final int timeoutInSeconds = 600;
    private boolean connectionLost = false;
    private boolean nodeHasDuw = false;
    private boolean nodeHasCbu = false;
    private String hubSubrackFirstCbuLdn = "not defined";
    private boolean isPrimaryDuwPnPAlreadyPerformed = false;
    private boolean isSecondaryDuwPnPAlreadyPerformed = false;
    private static final int ATTEMP_TIMES = 30;
    private static final int RETRY_INTERVAL_MS = 60000;
    private static final String faultTolerantCoreStatesAttribute = "faultTolerantCoreStates";

    public HandlePlugAndPlayPreController(Installer installer) {
        super(installer);
        this.description = "Handle Plug and Play";
        this.name = this.getClass().getName();
        this.totalReports = 7;
    }

    public synchronized boolean install() throws BemException {
        this.installer.reportProgress(this.name, this.description);
        --this.totalReports;
        try {
            DuwUtil.setup();
            this.nodeHasDuw = DuwUtil.hasDuw();
            if (!this.nodeHasDuw) {
                this.nodeHasCbu = this.theNodeHasCbu();
            }
        }
        catch (Exception exception) {
            throw new WizardException(exception.toString());
        }
        if (this.nodeHasDuw && !DuwUtil.isMicroRbsDuw()) {
            super.setParameters(DuwUtil.getSecondaryDuwSlotLdn());
        }
        if (this.nodeHasDuw || this.nodeHasCbu) {
            try {
                if (!this.isPlugAndPlayAlreadyPerformed()) {
                    BemMo[] bemMoArray = super.getChildren(super.getRoot(), 1, MimManagedElementData.MOTYPENAME, "");
                    BemMo bemMo = bemMoArray[0];
                    Nal.getFactory().addConnectionListener(this);
                    Boolean bl = (Boolean)super.getAttribute(bemMo, "autoConfigurationAllowed");
                    boolean bl2 = false;
                    if (this.nodeHasDuw) {
                        bl2 = this.checkIfRedRepertoireIsAlreadyConnected();
                        if (!DuwUtil.isMicroRbsDuw()) {
                            this.prepareSecondaryDuwForPlugAndPlay();
                        }
                        if (bl.booleanValue()) {
                            BemMo bemMo2 = super.getMo(DuwUtil.getPrimaryDuwSlotLdn());
                            this.performPlugAndPlayForSlot1(bemMo2);
                            if (!DuwUtil.isMicroRbsDuw()) {
                                BemMo bemMo3 = super.getMo(DuwUtil.getSecondaryDuwSlotLdn());
                                this.performPlugAndPlayForSlot2(bemMo3);
                            }
                        }
                    }
                    if (!bl.booleanValue()) {
                        super.setAttribute(bemMo, "autoConfigurationAllowed", Boolean.TRUE);
                        if (BemLanguageHelp.getEnvironment() != 1) {
                            this.installer.reportProgress(this.name, "Waiting for the RBS to restart due to plug and play configuration.");
                            --this.totalReports;
                            Nal.getLog().nalTrace(3, this.getClass(), "Waiting for the RBS to restart due to plug and play configuration.");
                            if (this.isPrimaryDuwPnPAlreadyPerformed && !this.isSecondaryDuwPnPAlreadyPerformed && bl2) {
                                this.myNodeConnLostSignal.await(15L, TimeUnit.SECONDS);
                            } else {
                                this.myNodeConnLostSignal.await();
                            }
                            this.installer.reportProgress(this.name, "Waiting for the RBS to restore connection, after plug and play configuration.");
                            --this.totalReports;
                            Nal.getLog().nalTrace(3, this.getClass(), "Waiting for the RBS to restore connection, after plug and play configuration.");
                            if (this.isPrimaryDuwPnPAlreadyPerformed && !this.isSecondaryDuwPnPAlreadyPerformed && bl2) {
                                this.myNodeConnRestoredSignal.await(15L, TimeUnit.SECONDS);
                            } else {
                                this.myNodeConnRestoredSignal.await();
                            }
                        }
                    }
                    Nal.getFactory().removeConnectionListener(this);
                    DuwUtil.setup();
                    this.installer.reportProgress(this.name, "The RBS node connection is restored, after plug and play configuration.");
                    --this.totalReports;
                    Nal.getLog().nalTrace(3, this.getClass(), "The RBS node connection is restored, after plug and play configuration.");
                }
            }
            catch (InterruptedException interruptedException) {
            }
            catch (Exception exception) {
                throw new BemException(this.description, (Throwable)exception);
            }
        }
        while (this.totalReports > 0) {
            this.installer.reportProgress(this.name, this.description);
            --this.totalReports;
        }
        return true;
    }

    public void connectionLost() {
        BemLog.log(7, "HandlePlugAndPlayPreController.connectionLost()");
        this.myNodeConnLostSignal.countDown();
        this.connectionLost = true;
    }

    public void connectionRestored() {
        BemLog.log(7, "HandlePlugAndPlayPreController.connectionRestored()");
        this.myNodeConnRestoredSignal.countDown();
        this.connectionLost = false;
    }

    public void waitForConnectionLost() throws InterruptedException, BemException {
        int n = 0;
        this.installer.reportProgress(this.name, "Waiting for the RBS to restart due to plug and play configuration on slot1.");
        --this.totalReports;
        while (!this.connectionLost && BemLanguageHelp.getEnvironment() != 1) {
            if (n >= 600) {
                throw new BemException("Timeout waiting for connectionLost after 600 seconds.");
            }
            if (n % 60 == 0) {
                Nal.getLog().nalTrace(6, this.getClass(), " Waited for connectionLost for " + n + " seconds.");
            }
            Nal.getFactory().sleep(1000L);
            ++n;
        }
    }

    public void waitForConnectionRestored() throws InterruptedException, BemException {
        int n = 0;
        this.installer.reportProgress(this.name, "Waiting for the RBS to restore connection, after plug and play configuration on slot1.");
        --this.totalReports;
        while (this.connectionLost && BemLanguageHelp.getEnvironment() != 1) {
            if (n >= 600) {
                throw new BemException("Timeout waiting for connectionRestored after 600 seconds.");
            }
            if (n % 60 == 0) {
                Nal.getLog().nalTrace(6, this.getClass(), " Waited for connectionRestore for " + n + " seconds.");
            }
            Nal.getFactory().sleep(1000L);
            ++n;
        }
    }

    private boolean theNodeHasCbu() throws BemException {
        RootMoi rootMoi = new RootMoi();
        SingleChildMoi singleChildMoi = new SingleChildMoi(rootMoi, MimEquipment.MOTYPENAME, "1");
        HubSubrackMoi hubSubrackMoi = new HubSubrackMoi(singleChildMoi);
        BemMo bemMo = super.getMo(hubSubrackMoi.getLdn());
        BemMo[] bemMoArray = super.getChildren(bemMo, 4, MimCbu.MOTYPENAME, "");
        if (bemMoArray.length > 0) {
            this.hubSubrackFirstCbuLdn = bemMoArray[0].getDN();
            return true;
        }
        return false;
    }

    private boolean isPlugAndPlayAlreadyPerformed() throws BemException {
        if (this.nodeHasDuw) {
            String string = DuwUtil.getPrimaryDuwPiuLdn();
            String string2 = string + "," + MimPiuDevice.MOTYPENAME + "=1";
            BemMo bemMo = this.getMo(string2);
            this.isPrimaryDuwPnPAlreadyPerformed = bemMo.isExisting();
            BemLog.log(6, this.name + " PnP on pDUW=" + this.isPrimaryDuwPnPAlreadyPerformed);
            String string3 = DuwUtil.getSecondaryDuwPiuLdn();
            String string4 = string3 + "," + MimPiuDevice.MOTYPENAME + "=1";
            BemMo bemMo2 = super.getMo(string4);
            this.isSecondaryDuwPnPAlreadyPerformed = bemMo2.isExisting();
            BemLog.log(6, this.name + " PnP on sDUW=" + this.isSecondaryDuwPnPAlreadyPerformed);
            return this.isPrimaryDuwPnPAlreadyPerformed && this.isSecondaryDuwPnPAlreadyPerformed;
        }
        if (this.nodeHasCbu) {
            BemMo bemMo = super.getMo(this.hubSubrackFirstCbuLdn);
            BemMo[] bemMoArray = this.getChildren(bemMo, 1, MimExchangeTerminal.MOTYPENAME, "");
            return bemMoArray.length > 0;
        }
        return true;
    }

    private void prepareSecondaryDuwForPlugAndPlay() throws BemException {
        this.installer.reportProgress(this.name, "Preparing sDUW for plug and play.");
        --this.totalReports;
        Nal.getLog().nalTrace(3, this.getClass(), "Preparing sDUW for plug and play.");
        super.addRedundancyRepToSwAllocationIfExisting();
        super.addSecondDuwSlotToSwAllocation();
        super.createInterPiuLinkCable();
        super.unlockInterPiuLinkCable();
    }

    private void performPlugAndPlayForSlot1(BemMo bemMo) throws BemException {
        this.installer.reportProgress(this.name, "Perform Plug and play on slot1.");
        --this.totalReports;
        BemLog.log(7, "HandlePlugAndPlayPreController.performPlugAndPlayForSlot1()");
        super.action(bemMo, "updateConfiguration");
        try {
            BemLog.log(6, "isPrimaryDuwPnPAlreadyPerformed = " + this.isPrimaryDuwPnPAlreadyPerformed);
            if (this.isPrimaryDuwPnPAlreadyPerformed) {
                return;
            }
            this.waitForConnectionLost();
            this.waitForConnectionRestored();
        }
        catch (InterruptedException interruptedException) {
            throw new BemException("Waiting for connection lost or restore failure =>" + interruptedException.toString());
        }
    }

    private void performPlugAndPlayForSlot2(BemMo bemMo) throws BemException {
        BemLog.log(6, "HandlePlugAndPlayPreController.performPlugAndPlayForSlot2() -->");
        BemMo bemMo2 = this.getRoot();
        int n = 0;
        this.installer.reportProgress(this.name, "Perform Plug and play on slot 2.");
        --this.totalReports;
        String[] stringArray = (String[])bemMo2.getAttribute(faultTolerantCoreStatesAttribute);
        if (BemLanguageHelp.getEnvironment() == 1) {
            super.action(bemMo, "updateConfiguration");
        } else if (stringArray.length > 0) {
            while (n < 30) {
                if (!DuwUtil.hasDualDuws() || DuwUtil.hasDualDuws() && (stringArray[0].indexOf("PassiveReady") != -1 || stringArray[1].indexOf("PassiveReady") != -1)) {
                    BemLog.log(6, "HandlePlugAndPlayPreController.performPlugAndPlayForSlot2()");
                    super.action(bemMo, "updateConfiguration");
                    try {
                        this.installer.reportProgress(this.name, "Waiting for 60000 ms for Plug and play on slot 2.");
                        --this.totalReports;
                        BemLog.log(6, "Waiting for60000ms for slot=2 updateConfiguration");
                        Nal.getFactory().sleep(60000L);
                        break;
                    }
                    catch (InterruptedException interruptedException) {
                        throw new BemException("Sleep interrupted when waiting for reconnection.");
                    }
                }
                try {
                    Nal.getFactory().sleep(60000L);
                    BemLog.log(6, "Already been waiting for60000ms");
                }
                catch (InterruptedException interruptedException) {
                    throw new BemException("Sleep interrupted when waiting for reconnection.");
                }
                stringArray = (String[])bemMo2.getAttribute(faultTolerantCoreStatesAttribute);
                if (n == 30) {
                    throw new BemException("Wait for slot=1 to be PassiveReady. Time out for 30 miuntes!");
                }
                BemLog.log(6, "attemptime =>" + ++n);
            }
        }
    }
}

