/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.wcdma.rbs.bem.wizard.wizards.modify.postcontrol;

import java.util.List;
import java.util.Observable;
import java.util.Observer;
import se.ericsson.wcdma.rbs.bem.common.BemLog;
import se.ericsson.wcdma.rbs.bem.common.config.phase.Phase;
import se.ericsson.wcdma.rbs.bem.common.config.rbs.Rbs;
import se.ericsson.wcdma.rbs.bem.common.config.resource.ResourceItem;
import se.ericsson.wcdma.rbs.bem.common.exception.BemException;
import se.ericsson.wcdma.rbs.bem.common.mohandler.MoHandler;
import se.ericsson.wcdma.rbs.bem.common.mohandler.TransactionHelper;
import se.ericsson.wcdma.rbs.bem.wizard.exception.WizardException;
import se.ericsson.wcdma.rbs.bem.wizard.util.Installer;
import se.ericsson.wcdma.rbs.bem.wizard.util.SubInstaller;
import se.ericsson.wcdma.rbs.bem.wizard.wizards.modify.model.ModifyModel;

public class UnInstallationPostController
implements SubInstaller,
Observer {
    private int totalNumberOfProgressReports = 50;
    private Installer theInstaller = null;
    private String theName = null;
    private int myProgressReports = 0;
    private String theDescription = "Uninstall according to choises";
    private static final String UNINSTALLING_RBS = "Uninstall - Updating RBS with chosen configuration data";
    private static final String PREFIX_DESCRIPTION = "Currently handling ";
    private ModifyModel model = null;
    private Rbs rbs = null;
    private Phase[] unInstallationPhases = null;
    private static final int totalExpectedProgressReports = 0;
    private int progressReportsReceived = 0;

    public UnInstallationPostController(Installer installer) {
        this.theInstaller = installer;
        this.theName = this.getClass().getName();
        this.model = ModifyModel.getInstance();
        this.rbs = this.model.getRbs();
        this.unInstallationPhases = this.rbs.getUninstallationPhases();
        int n = this.unInstallationPhases.length;
        int n2 = this.rbs.getAllConfigItems().keySet().size();
        this.myProgressReports = this.totalNumberOfProgressReports = n + n2 + 6 + 15;
    }

    public boolean install() throws WizardException {
        block13: {
            this.theInstaller.reportProgress(this.theName, this.theDescription);
            --this.myProgressReports;
            if (this.theInstaller.isInterrupted()) {
                return false;
            }
            MoHandler moHandler = this.rbs.getMoHandler();
            TransactionHelper transactionHelper = TransactionHelper.getInstance(moHandler);
            moHandler.setUseLargeTransactions(true);
            transactionHelper.addObserver(this);
            this.rbs.addObserver(this);
            try {
                this.theDescription = "Reading resources to uninstall";
                this.theInstaller.reportProgress(this.theName, this.theDescription);
                --this.myProgressReports;
                List list = this.rbs.getRIsToUninstall();
                this.theDescription = "Starting uninstallation";
                this.theInstaller.reportProgress(this.theName, this.theDescription);
                --this.myProgressReports;
                if (list.size() <= 0) break block13;
                for (Phase object : this.unInstallationPhases) {
                    String string = object.getName();
                    boolean bl = transactionHelper.setPhase(string);
                    if (!bl) {
                        String string2 = this.removePhaseFromName(string);
                        this.theDescription = PREFIX_DESCRIPTION + string2;
                        this.theInstaller.reportProgress(this.theName, this.theDescription);
                        --this.myProgressReports;
                        String string3 = this.theDescription;
                        for (ResourceItem resourceItem : list) {
                            this.theDescription = string3 + " " + resourceItem.getDisplayName();
                            resourceItem.uninstall(string);
                            if (!this.theInstaller.isInterrupted()) continue;
                            boolean bl2 = false;
                            return bl2;
                        }
                    }
                    this.theDescription = UNINSTALLING_RBS;
                    this.theInstaller.reportProgress(this.theName, this.theDescription);
                    --this.myProgressReports;
                }
            }
            catch (Exception exception) {
                String string;
                Phase[] phaseArray;
                block14: {
                    phaseArray = "commit failed, rollback to previous configuration.";
                    string = "Operation failed";
                    try {
                        transactionHelper.rollbackAlloperations(exception);
                    }
                    catch (Exception exception2) {
                        BemException bemException;
                        if (!(exception2 instanceof BemException) || !"ROLLBACK_TRANSACTION".equals((bemException = (BemException)exception2).getAction())) break block14;
                        string = bemException.getAction();
                    }
                }
                BemLog.exceptionRaised((String)phaseArray, exception);
                WizardException wizardException = new WizardException("Installing data on node" + (String)phaseArray, string, "", "", exception);
                throw wizardException;
            }
            finally {
                moHandler.setUseLargeTransactions(false);
            }
        }
        while (this.myProgressReports > 0) {
            this.theInstaller.reportProgress(this.theName, this.theDescription);
            --this.myProgressReports;
        }
        return true;
    }

    public int getTotalNoOfProgressReports() {
        return this.totalNumberOfProgressReports;
    }

    public String getTheName() {
        return this.theName;
    }

    public String getTheDescription() {
        return this.theDescription;
    }

    private String removePhaseFromName(String string) {
        String string2 = string;
        if (string.endsWith("Phase")) {
            int n = string.lastIndexOf("Phase");
            string2 = string.substring(0, n);
        }
        return string2;
    }

    public void update(Observable observable, Object object) {
        String string = (String)object;
        ++this.progressReportsReceived;
        --this.myProgressReports;
        this.theInstaller.reportProgress(this.theName, string);
        BemLog.log(7, "Progress: " + this.progressReportsReceived + " (" + 0 + ") : " + string);
    }
}

