/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.wcdma.rbs.bem.wizard.wizards.oam.control;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import se.ericsson.wcdma.rbs.bem.common.BemLog;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.provider.EthernetProvider;
import se.ericsson.wcdma.rbs.bem.common.config.custparam.CustomerParameter;
import se.ericsson.wcdma.rbs.bem.common.config.custparam.CustomerParameterException;
import se.ericsson.wcdma.rbs.bem.common.config.rbs.Rbs;
import se.ericsson.wcdma.rbs.bem.common.exception.BemException;
import se.ericsson.wcdma.rbs.bem.wizard.control.BemWizardGuiController;
import se.ericsson.wcdma.rbs.bem.wizard.exception.WizardException;
import se.ericsson.wcdma.rbs.bem.wizard.model.WizardCIModel;
import se.ericsson.wcdma.rbs.bem.wizard.wizards.oam.model.OamCIModel;
import se.ericsson.wcdma.rbs.bem.wizard.wizards.oam.util.WizardHelp;
import se.ericsson.wcdma.rbs.bem.wizard.wizards.oam.view.IpHostLinkConfigurationViewer;

public class IpHostLinkConfigurationController
extends BemWizardGuiController {
    private static final String NCONF_OAM_PAGE_HEADER = "O&M Access Configuration page {0}({1})";
    private WizardCIModel wizardCiModel;
    private Rbs rbs = null;
    private IpHostLinkConfigurationViewer myView = null;
    private CustomerParameter ipsecEnable = null;
    private final List<CustomerParameter> cpsToValidateOnNext = new ArrayList<CustomerParameter>();
    private static final String CONFIGURATION_MODE_DHCP = "DHCP";

    protected void init() {
        this.myView = (IpHostLinkConfigurationViewer)((Object)this.getView());
        this.wizardHelp = WizardHelp.getTheInstance();
        this.wizardCiModel = OamCIModel.getInstance();
        this.rbs = this.wizardCiModel.getRbs();
        this.setWindowTitle();
    }

    protected void beforeVisible() {
        EthernetProvider ethernetProvider = (EthernetProvider)this.rbs.getProvider(EthernetProvider.class);
        if (ethernetProvider != null) {
            try {
                boolean bl = ethernetProvider.hasEthernetSwitch();
                if (!bl) {
                    super.setPreviousEnabled(false);
                    super.setPreviousVisible(false);
                }
            }
            catch (BemException bemException) {
                BemLog.log(2, this.getClass() + " beforeVisible()");
            }
        }
    }

    protected void afterVisible() {
        try {
            String[] stringArray;
            this.cpsToValidateOnNext.clear();
            this.ipsecEnable = this.rbs.getCustomerParameterObject("IpSec_configType");
            for (String string : stringArray = new String[]{"OamIpHost_configurationMode", "OamIpHost_oamIpAddress", "OamIpHost_oamSubnetMask", "OamIpHost_oamDefaultRouter0", "OamIpHost_oamVid"}) {
                CustomerParameter customerParameter = this.rbs.getCustomerParameterObject(string);
                this.cpsToValidateOnNext.add(customerParameter);
            }
            if (!this.ipsecEnable.getValue().equals("NON_IPSEC")) {
                CustomerParameter wizardException = this.rbs.getCustomerParameterObject("OamIpHost_outerOamIpAddressHostEt");
                this.cpsToValidateOnNext.add(wizardException);
            }
            CustomerParameter[] customerParameterArray2 = new CustomerParameter[this.cpsToValidateOnNext.size()];
            customerParameterArray2 = this.cpsToValidateOnNext.toArray(customerParameterArray2);
            if (this.ipsecEnable.getValue().equals("NON_IPSEC")) {
                this.myView.setCustomerParameters(customerParameterArray2, false, this.isDHCP());
            } else {
                this.myView.setCustomerParameters(customerParameterArray2, true, false);
            }
        }
        catch (Exception exception) {
            WizardException wizardException = new WizardException(this.getClass().getName(), "afterVisible()", null, "Setting up window for input", exception);
            wizardException.setProperty("Problem, Low Level", "An error has occurred while reading from the model");
            super.displayError(wizardException);
        }
    }

    private void setWindowTitle() {
        String string = this.getClass().getName();
        String string2 = String.valueOf(this.wizardHelp.getPageNumber(string));
        String string3 = String.valueOf(this.wizardHelp.getTotalPageNumbers());
        this.myView.setHeaderText(MessageFormat.format(NCONF_OAM_PAGE_HEADER, string2, string3));
    }

    protected boolean previous() {
        return true;
    }

    public boolean isDHCP() {
        try {
            CustomerParameter customerParameter = this.rbs.getCustomerParameterObject("OamIpHost_configurationMode");
            return customerParameter.getValue().equals(CONFIGURATION_MODE_DHCP);
        }
        catch (Exception exception) {
            WizardException wizardException = new WizardException(this.getClass().getName(), "afterVisible()", null, "Setting up window for input", exception);
            wizardException.setProperty("Problem, Low Level", "An error has occurred while reading from the model");
            super.displayError(wizardException);
            return false;
        }
    }

    protected boolean next() {
        boolean bl = true;
        if (this.isDHCP()) {
            return bl;
        }
        try {
            for (CustomerParameter customerParameter : this.cpsToValidateOnNext) {
                if (customerParameter.getName().equals("OamIpHost_configurationMode") || customerParameter.isValidValue()) continue;
                this.displayNextError(this.myView, new CustomerParameterException(customerParameter));
                return false;
            }
        }
        catch (Exception exception) {
            this.displayNextError(this.myView, exception);
            bl = false;
        }
        return bl;
    }
}

