/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.wcdma.rbs.bem.wizard.wizards.oam.control;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import se.ericsson.wcdma.rbs.bem.common.BemLog;
import se.ericsson.wcdma.rbs.bem.common.config.custparam.CustomerParameter;
import se.ericsson.wcdma.rbs.bem.common.config.custparam.StringParameter;
import se.ericsson.wcdma.rbs.bem.common.config.custparam.StringRange;
import se.ericsson.wcdma.rbs.bem.common.exception.BemException;
import se.ericsson.wcdma.rbs.bem.common.gui.CustomerParameterTable;
import se.ericsson.wcdma.rbs.bem.common.gui.CustomerParameterTableModel;
import se.ericsson.wcdma.rbs.bem.common.gui.CustomerParameterTextField;
import se.ericsson.wcdma.rbs.bem.wizard.wizards.oam.control.LagManager;

public class LagDialog
extends JDialog {
    public static final String[] COLUMN_NAMES = new String[]{"Link Aggregation Groups"};
    JButton addButton;
    private final JButton deleteButton;
    private final JButton closeButton;
    private final CustomerParameter lagIdCP;
    private final CustomerParameterTextField newLagField;
    private final JPanel mainPanel;
    private final JPanel lagPanel;
    private final JPanel buttonAddDeletePanel;
    private final JPanel buttonClosePanel;
    private JTable lagTable;
    private final LagManager lagManager;

    public LagDialog(CustomerParameter customerParameter) {
        this.lagManager = (LagManager)customerParameter;
        this.getContentPane().setLayout(new GridBagLayout());
        this.mainPanel = new JPanel();
        this.mainPanel.setLayout(new GridBagLayout());
        this.lagPanel = new JPanel();
        this.lagPanel.setLayout(new GridBagLayout());
        this.buttonAddDeletePanel = new JPanel();
        this.buttonClosePanel = new JPanel();
        this.addButton = new JButton("Add");
        this.deleteButton = new JButton("Delete");
        this.closeButton = new JButton("Ok");
        this.lagIdCP = new StringParameter("LAG Id", new StringRange(0, 10));
        this.newLagField = new CustomerParameterTextField(this.lagIdCP);
        this.addButton.addActionListener(new AddButtonActionListener());
        this.deleteButton.addActionListener(new DeleteButtonActionListener());
        this.closeButton.addActionListener(new CloseButtonActionListener());
        this.createLagTable();
        this.enableDisableButtons();
        this.buttonClosePanel.add(this.closeButton);
        this.mainPanel.add((Component)this.buttonClosePanel, new GridBagConstraints(0, 2, 1, 1, 1.0, 1.0, 14, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.newLagField.setColumns(5);
        this.buttonAddDeletePanel.add(this.addButton);
        this.buttonAddDeletePanel.add(this.newLagField);
        this.buttonAddDeletePanel.add(this.deleteButton);
        this.lagPanel.add((Component)this.buttonAddDeletePanel, new GridBagConstraints(1, 1, 1, 1, 1.0, 1.0, 18, 0, new Insets(0, 0, 0, 0), 1, 1));
        this.mainPanel.add((Component)this.lagPanel, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 11, 2, new Insets(0, 0, 0, 0), 0, 0));
        JScrollPane jScrollPane = new JScrollPane(this.mainPanel);
        this.getContentPane().add((Component)jScrollPane, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(5, 10, 5, 0), 0, 0));
        this.pack();
    }

    public CustomerParameterTableModel createTableModel() {
        List<CustomerParameter> list = this.lagManager.getCustomerParameterObjects();
        Collections.sort(list);
        Object[][] objectArray = new Object[list.size()][1];
        Iterator<CustomerParameter> iterator = list.iterator();
        int n = 0;
        while (iterator.hasNext()) {
            objectArray[n][0] = iterator.next();
            ++n;
        }
        CustomerParameterTableModel customerParameterTableModel = new CustomerParameterTableModel(objectArray, COLUMN_NAMES);
        if (list.size() > 0) {
            customerParameterTableModel.setEditableColumn(0, false);
        }
        return customerParameterTableModel;
    }

    private void createLagTable() {
        CustomerParameterTableModel customerParameterTableModel = this.createTableModel();
        this.lagTable = new CustomerParameterTable(customerParameterTableModel);
        this.lagTable.setRowSelectionAllowed(true);
        this.lagTable.setSelectionMode(0);
        this.lagTable.putClientProperty("LANGUAGE_CONTROLLED", "NT");
        this.lagTable.setPreferredScrollableViewportSize(this.calculatePreferredScrollableViewportSize(10));
        this.lagTable.getTableHeader().setReorderingAllowed(false);
        this.lagTable.setRowSelectionAllowed(true);
        this.lagTable.setColumnSelectionAllowed(false);
        JScrollPane jScrollPane = new JScrollPane(this.lagTable);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.ipadx = 1;
        gridBagConstraints.ipady = 1;
        gridBagConstraints.insets = new Insets(0, 0, 0, 0);
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.lagPanel.add((Component)jScrollPane, gridBagConstraints);
    }

    public Dimension calculatePreferredScrollableViewportSize(int n) {
        int n2 = this.lagTable.getRowHeight();
        int n3 = this.lagTable.getColumnCount();
        int n4 = n2 * n;
        int n5 = 0;
        for (int i = 0; i < n3; ++i) {
            n5 += this.lagTable.getColumn(this.lagTable.getColumnName(0)).getWidth() + 7;
        }
        return new Dimension(n5, n4);
    }

    private void enableDisableButtons() {
        if (this.lagManager.counterReachedLimit()) {
            this.addButton.setEnabled(false);
        } else {
            this.addButton.setEnabled(true);
        }
        this.deleteButton.setEnabled(true);
        this.getContentPane().repaint();
    }

    class CloseButtonActionListener
    implements ActionListener {
        CloseButtonActionListener() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            try {
                LagDialog.this.lagManager.buildGuiCustomerParameter();
                LagDialog.this.setVisible(false);
                LagDialog.this.dispose();
            }
            catch (BemException bemException) {
                BemLog.log(6, this.getClass().toString(), bemException);
            }
        }
    }

    class DeleteButtonActionListener
    implements ActionListener {
        DeleteButtonActionListener() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            try {
                int n = LagDialog.this.lagTable.getSelectedRow();
                if (n != -1) {
                    CustomerParameterTableModel customerParameterTableModel = (CustomerParameterTableModel)LagDialog.this.lagTable.getModel();
                    CustomerParameter customerParameter = (CustomerParameter)customerParameterTableModel.getValueAt(n, 0);
                    String string = customerParameter.getValue();
                    LagDialog.this.lagManager.createCICustomerParamater(string, "DELETE");
                    CustomerParameterTableModel customerParameterTableModel2 = LagDialog.this.createTableModel();
                    LagDialog.this.lagTable.setModel(customerParameterTableModel2);
                    LagDialog.this.enableDisableButtons();
                }
            }
            catch (BemException bemException) {
                BemLog.log(6, this.getClass().toString(), bemException);
            }
        }
    }

    class AddButtonActionListener
    implements ActionListener {
        AddButtonActionListener() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            try {
                String string = LagDialog.this.newLagField.getText();
                if (!string.equals("") && LagDialog.this.lagIdCP.isValidValue()) {
                    LagDialog.this.lagManager.createCICustomerParamater(string, "ADD_MODIFY");
                    CustomerParameterTableModel customerParameterTableModel = LagDialog.this.createTableModel();
                    LagDialog.this.lagTable.setModel(customerParameterTableModel);
                    LagDialog.this.enableDisableButtons();
                }
            }
            catch (BemException bemException) {
                BemLog.log(6, this.getClass().toString(), bemException);
            }
        }
    }
}

