/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.wcdma.rbs.bem.wizard.wizards.site.view;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.border.TitledBorder;
import se.ericsson.wcdma.rbs.bem.common.config.custparam.TrueFalseCustomerParameter;
import se.ericsson.wcdma.rbs.bem.common.gui.CustomerParameterCheckbox;
import se.ericsson.wcdma.rbs.bem.common.gui.CustomerParameterTable;
import se.ericsson.wcdma.rbs.bem.wizard.util.WizardLanguageHelp;
import se.ericsson.wcdma.rbs.bem.wizard.view.BemWizardGuiView;
import se.ericsson.wcdma.rbs.bem.wizard.wizards.site.view.HsdpaAndEulViewer;

public class HsdpaAndEulView
extends BemWizardGuiView
implements HsdpaAndEulViewer {
    private static final String STEERED_HS_ALLOCATION = "Steered HS Allocation:";
    private JPanel hsdpaAndEulMainPanel = null;
    private JPanel hsdpaPanel = null;
    private JPanel[] hsdpaDuwSlotPanels;
    private CustomerParameterCheckbox steeredHsAllocationComponent;
    private JLabel noSlotsForHsdpaLabel;
    private JLabel staticLoadingLabel;
    private CustomerParameterTable[] numHsCodeResourceTable;
    private CustomerParameterTable[] hsCodeResourceIdTable;

    protected void init() {
        try {
            super.init();
            this.initView();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private void initView() throws Exception {
        this.initiateMainPanel();
    }

    public void initiateMainPanel() {
        String string = this.hsdpaPanel != null ? ((TitledBorder)this.hsdpaPanel.getBorder()).getTitle() : "NCONF_SITE_HSDPA_SUB_TITLE";
        this.hsdpaAndEulMainPanel = new JPanel();
        this.hsdpaAndEulMainPanel.setLayout(new GridBagLayout());
        this.hsdpaPanel = new JPanel();
        this.hsdpaDuwSlotPanels = new JPanel[2];
        this.numHsCodeResourceTable = new CustomerParameterTable[2];
        this.hsCodeResourceIdTable = new CustomerParameterTable[2];
        this.steeredHsAllocationComponent = null;
        this.addMainPanel(this.hsdpaAndEulMainPanel);
        this.hsdpaPanel.setLayout(new GridBagLayout());
        this.hsdpaPanel.setBorder(new TitledBorder(BorderFactory.createEtchedBorder(), string));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridheight = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(0, 10, 0, 10);
        this.hsdpaAndEulMainPanel.add((Component)this.hsdpaPanel, gridBagConstraints);
        for (int i = 0; i <= 1; ++i) {
            this.hsdpaDuwSlotPanels[i] = new JPanel(new GridBagLayout());
            this.hsdpaDuwSlotPanels[i].setBorder(new TitledBorder(BorderFactory.createEtchedBorder(), "DUW board " + (i + 1)));
            this.hsdpaDuwSlotPanels[i].putClientProperty("LANGUAGE_CONTROLLED", "NT");
            if (i != 0) continue;
            this.hsdpaPanel.add((Component)this.hsdpaDuwSlotPanels[i], new GridBagConstraints(0, i + 1, 1, 1, 0.2, 0.2, 18, 2, new Insets(5, 5, 5, 5), 0, 0));
        }
    }

    public void setNumHsCodeAndNumEulResourceTableParameters(int n, Object[][] objectArray, String[] stringArray, String[] stringArray2) {
        if (this.numHsCodeResourceTable[n] == null) {
            this.numHsCodeResourceTable[n] = new CustomerParameterTable(objectArray, stringArray, stringArray2);
            this.numHsCodeResourceTable[n].putClientProperty("LANGUAGE_CONTROLLED", "NT");
            JScrollPane jScrollPane = new JScrollPane(this.numHsCodeResourceTable[n]);
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = 0;
            gridBagConstraints.weightx = 0.2;
            gridBagConstraints.weighty = 0.2;
            gridBagConstraints.anchor = 18;
            gridBagConstraints.fill = 2;
            gridBagConstraints.insets = new Insets(5, 5, 5, 5);
            this.hsdpaDuwSlotPanels[n].add((Component)jScrollPane, gridBagConstraints);
        }
    }

    public void setHsCodeResourceIdTableParameters(int n, Object[][] objectArray, String[] stringArray, String[] stringArray2) {
        if (this.hsCodeResourceIdTable[n] == null) {
            this.hsCodeResourceIdTable[n] = new CustomerParameterTable(objectArray, stringArray, stringArray2);
            this.hsCodeResourceIdTable[n].putClientProperty("LANGUAGE_CONTROLLED", "NT");
            JScrollPane jScrollPane = new JScrollPane(this.hsCodeResourceIdTable[n]);
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = 2;
            gridBagConstraints.weightx = 1.2;
            gridBagConstraints.weighty = 1.2;
            gridBagConstraints.anchor = 18;
            gridBagConstraints.fill = 2;
            gridBagConstraints.insets = new Insets(5, 5, 5, 5);
            this.hsdpaDuwSlotPanels[n].add((Component)jScrollPane, gridBagConstraints);
        }
    }

    protected String getSubHeading() {
        return WizardLanguageHelp.getTranslation("NCONF_SITE_HSDPA_EUL_SUB_TITLE");
    }

    public void setSteeredHSAllocation(TrueFalseCustomerParameter trueFalseCustomerParameter) {
        if (this.steeredHsAllocationComponent == null) {
            this.steeredHsAllocationComponent = new CustomerParameterCheckbox(STEERED_HS_ALLOCATION, trueFalseCustomerParameter);
            JPanel jPanel = new JPanel(new GridBagLayout());
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = 0;
            gridBagConstraints.weighty = 0.1;
            gridBagConstraints.anchor = 17;
            jPanel.add((Component)this.steeredHsAllocationComponent, gridBagConstraints);
            GridBagConstraints gridBagConstraints2 = new GridBagConstraints();
            gridBagConstraints2.gridx = 0;
            gridBagConstraints2.gridy = 0;
            gridBagConstraints2.anchor = 17;
            gridBagConstraints2.insets = new Insets(5, 5, 5, 5);
            this.hsdpaPanel.add((Component)jPanel, gridBagConstraints2);
        }
    }

    public void displayNoSlotsForHsdpa(int n) {
        this.noSlotsForHsdpaLabel = new JLabel("No TX boards available for configuration of HSDPA or EUL.");
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.gridheight = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(4, 10, 10, 10);
        this.hsdpaDuwSlotPanels[n].add((Component)this.noSlotsForHsdpaLabel, gridBagConstraints);
    }

    public void displayStaticLoading(int n) {
        this.staticLoadingLabel = new JLabel("This base band pool uses static allocation, hence the fields above are read only.");
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(4, 10, 10, 10);
        this.hsdpaDuwSlotPanels[n].add((Component)this.staticLoadingLabel, gridBagConstraints);
    }

    public void setNumberOfDuwSlots(int n) {
        int n2 = n - 1;
        if (n > 1) {
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = n2 + 1;
            gridBagConstraints.weightx = 0.2;
            gridBagConstraints.weighty = 0.2;
            gridBagConstraints.anchor = 18;
            gridBagConstraints.fill = 2;
            gridBagConstraints.insets = new Insets(5, 5, 5, 5);
            this.hsdpaPanel.add((Component)this.hsdpaDuwSlotPanels[n2], gridBagConstraints);
        }
    }

    public void setFocusOnCustomerParameterComponent(String string) {
        for (int i = 0; i <= 1; ++i) {
            if (this.numHsCodeResourceTable[i] != null && this.numHsCodeResourceTable[i].isParameterInTable(string)) {
                this.numHsCodeResourceTable[i].setFocusOnCell(string);
                break;
            }
            if (this.hsCodeResourceIdTable[i] != null && this.hsCodeResourceIdTable[i].isParameterInTable(string)) {
                this.hsCodeResourceIdTable[i].setFocusOnCell(string);
                break;
            }
            if (!this.steeredHsAllocationComponent.getCustomerParameter().getName().equals(string)) continue;
            this.steeredHsAllocationComponent.requestFocus();
            break;
        }
    }

    public String getGuiNameForCustomerParameter(String string) {
        String string2 = string;
        for (int i = 0; i <= 1; ++i) {
            if (this.numHsCodeResourceTable[i] != null && this.numHsCodeResourceTable[i].isParameterInTable(string)) {
                string2 = this.numHsCodeResourceTable[i].getRowAndColumnName(string);
                break;
            }
            if (this.hsCodeResourceIdTable[i] == null || !this.hsCodeResourceIdTable[i].isParameterInTable(string)) continue;
            string2 = this.hsCodeResourceIdTable[i].getRowAndColumnName(string);
            break;
        }
        return string2;
    }

    public void setFocusFixListeners(int n) {
        if (this.numHsCodeResourceTable[n] != null) {
            this.numHsCodeResourceTable[n].addFocusLostListener(this.hsCodeResourceIdTable[n]);
        }
        if (this.steeredHsAllocationComponent != null) {
            this.hsCodeResourceIdTable[n].addStopEditingListener(this.steeredHsAllocationComponent);
        }
        if (this.numHsCodeResourceTable[n] != null) {
            this.hsCodeResourceIdTable[n].addFocusLostListener(this.numHsCodeResourceTable[n]);
        }
    }

    public void editingStopped() {
        for (int i = 0; i <= 1; ++i) {
            if (this.numHsCodeResourceTable[i] != null) {
                this.numHsCodeResourceTable[i].focusLost(null);
            }
            if (this.hsCodeResourceIdTable[i] != null) {
                this.hsCodeResourceIdTable[i].focusLost(null);
            }
            if (this.numHsCodeResourceTable[i] != null) {
                this.numHsCodeResourceTable[i].editingStopped(null);
            }
            if (this.hsCodeResourceIdTable[i] == null) continue;
            this.hsCodeResourceIdTable[i].editingStopped(null);
        }
    }
}

