/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.wcdma.support.gui.guilib.infra;

import java.awt.Component;
import java.awt.Container;
import java.util.Locale;
import java.util.Vector;
import javax.swing.JComponent;
import javax.swing.JMenu;
import javax.swing.JPopupMenu;
import javax.swing.MenuElement;
import se.ericsson.wcdma.support.gui.guilib.comp.Log;
import se.ericsson.wcdma.support.gui.guilib.infra.AbstractComponent;
import se.ericsson.wcdma.support.gui.guilib.infra.AbstractHandler;
import se.ericsson.wcdma.support.gui.guilib.infra.AbstractPresenter;
import se.ericsson.wcdma.support.gui.guilib.infra.AbstractView;
import se.ericsson.wcdma.support.gui.guilib.infra.ApplicationMenuBar;
import se.ericsson.wcdma.support.gui.guilib.infra.ApplicationPresenter;
import se.ericsson.wcdma.support.gui.guilib.infra.ApplicationToolBar;
import se.ericsson.wcdma.support.gui.guilib.infra.WizardSlidePresenter;

class ComponentSniffer {
    private AbstractPresenter presenter;
    private JPopupMenu popupMenu;
    private Vector componentHandlers = new Vector();

    ComponentSniffer(AbstractPresenter abstractPresenter) {
        this.presenter = abstractPresenter;
    }

    ComponentSniffer(JPopupMenu jPopupMenu) {
        this.popupMenu = jPopupMenu;
    }

    void addComponentHandler(AbstractHandler abstractHandler) {
        for (int i = 0; i < this.componentHandlers.size(); ++i) {
            if (abstractHandler != this.componentHandlers.elementAt(i)) continue;
            return;
        }
        this.componentHandlers.addElement(abstractHandler);
    }

    protected void dispose() {
        for (int i = 0; i < this.componentHandlers.size(); ++i) {
            ((AbstractHandler)this.componentHandlers.elementAt(i)).dispose();
        }
        this.componentHandlers.clear();
    }

    private void iterate(Component component, AbstractHandler[] abstractHandlerArray) {
        AbstractHandler[] abstractHandlerArray2 = new AbstractHandler[abstractHandlerArray.length];
        for (int i = 0; i < abstractHandlerArray.length; ++i) {
            AbstractHandler abstractHandler = abstractHandlerArray[i];
            if (abstractHandler == null) continue;
            if (component instanceof AbstractComponent) {
                ((AbstractComponent)component).init();
                return;
            }
            if (component instanceof JComponent) {
                if (!abstractHandler.handleComponent((JComponent)component)) continue;
                abstractHandlerArray2[i] = abstractHandler;
                continue;
            }
            abstractHandlerArray2[i] = abstractHandler;
        }
        if (component instanceof Container && abstractHandlerArray2.length > 0) {
            Component[] componentArray = null;
            componentArray = component instanceof JMenu ? ((JMenu)component).getMenuComponents() : ((Container)component).getComponents();
            for (int i = 0; i < componentArray.length; ++i) {
                this.iterate(componentArray[i], abstractHandlerArray2);
            }
        }
    }

    private void iteratePopup(JPopupMenu jPopupMenu, AbstractHandler[] abstractHandlerArray) {
        MenuElement[] menuElementArray = jPopupMenu.getSubElements();
        for (int i = 0; i < menuElementArray.length; ++i) {
            if (menuElementArray[i] instanceof JMenu) {
                this.iterate((JMenu)menuElementArray[i], abstractHandlerArray);
                continue;
            }
            if (menuElementArray[i] instanceof JComponent) {
                for (int j = 0; j < abstractHandlerArray.length; ++j) {
                    AbstractHandler abstractHandler = abstractHandlerArray[j];
                    if (abstractHandler == null) continue;
                    abstractHandler.handleComponent((JComponent)((Object)menuElementArray[i]));
                }
                continue;
            }
            Log.logWarning("Unknown component in iteratePopup");
        }
    }

    void removeComponentHandler(AbstractHandler abstractHandler) {
        for (int i = 0; i < this.componentHandlers.size(); ++i) {
            if (abstractHandler != this.componentHandlers.elementAt(i)) continue;
            this.componentHandlers.remove(i);
            return;
        }
    }

    void sniff() {
        Log.measure("sniff", true, "ComponentSniffer.sniff");
        Object[] objectArray = new AbstractHandler[this.componentHandlers.size()];
        this.componentHandlers.copyInto(objectArray);
        if (this.popupMenu != null) {
            this.iteratePopup(this.popupMenu, (AbstractHandler[])objectArray);
        } else {
            AbstractView abstractView = this.presenter.getView();
            this.iterate(abstractView, (AbstractHandler[])objectArray);
            if (this.presenter instanceof ApplicationPresenter) {
                ApplicationToolBar applicationToolBar;
                ApplicationPresenter applicationPresenter = (ApplicationPresenter)this.presenter;
                ApplicationMenuBar applicationMenuBar = applicationPresenter.getApplicationMenuBar();
                if (applicationMenuBar != null) {
                    this.iterate(applicationMenuBar, (AbstractHandler[])objectArray);
                }
                if ((applicationToolBar = applicationPresenter.getApplicationToolBar()) != null) {
                    this.iterate(applicationToolBar, (AbstractHandler[])objectArray);
                }
            } else if (this.presenter instanceof WizardSlidePresenter) {
                WizardSlidePresenter wizardSlidePresenter = (WizardSlidePresenter)this.presenter;
                this.iterate(wizardSlidePresenter.getWizardDefaultView(), (AbstractHandler[])objectArray);
            }
        }
        Log.measure("sniff", false);
    }

    void sniff(Component component) {
        Object[] objectArray = new AbstractHandler[this.componentHandlers.size()];
        this.componentHandlers.copyInto(objectArray);
        this.iterate(component, (AbstractHandler[])objectArray);
    }

    void updateLocale(Locale locale) {
        for (int i = 0; i < this.componentHandlers.size(); ++i) {
            ((AbstractHandler)this.componentHandlers.elementAt(i)).updateLocale(locale);
        }
    }
}

