/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.wcdma.support.gui.guilib.infra;

import java.util.Locale;
import javax.swing.JComponent;
import se.ericsson.wcdma.support.gui.guilib.comp.Log;
import se.ericsson.wcdma.support.gui.guilib.infra.AbstractHandler;
import se.ericsson.wcdma.support.gui.guilib.infra.AbstractHelp;
import se.ericsson.wcdma.support.gui.guilib.infra.Resources;

class HelpManager
extends AbstractHandler {
    static final String DEFAULT_HELP_BUNDLE_NAME_KEY = "gsl.help.default.bundle.name";
    public static final String HELP_TRACKING = "HELP_TRACKING";
    static final String HELP_HANDLER_CLASS_KEY = "gsl.help.helphandler.class";
    private AbstractHelp helpHandler;

    HelpManager() {
    }

    AbstractHelp getHelpHandler() {
        return this.helpHandler;
    }

    public void dispose() {
        if (this.helpHandler != null) {
            this.helpHandler.dispose();
        }
    }

    public boolean handleComponent(JComponent jComponent) {
        Log.trace("HelpManager.handleComponent(" + jComponent.getClass().getName() + ")");
        if (this.helpHandler != null) {
            Object object = jComponent.getClientProperty("HELP_KEY");
            if (object != null) {
                if (object.equals("NA")) {
                    return false;
                }
                if (!object.equals("NT")) {
                    this.helpHandler.handleComponent(jComponent);
                }
            }
            return true;
        }
        Log.logNotify("No further sub-component help-handling for component: " + jComponent.getClass().getName());
        return false;
    }

    public void init() {
        Resources resources = this.getResources();
        String string = null;
        try {
            string = resources.getEnvironment().getProperty(HELP_HANDLER_CLASS_KEY);
            if (string == null) {
                string = this.getApplication().getApplicationManager().getFirstInitialApplication().getEnvironment().getProperty(HELP_HANDLER_CLASS_KEY);
            }
            Log.log(4, "helphandler className = " + string);
            if (string != null && !"null".equalsIgnoreCase(string)) {
                this.helpHandler = (AbstractHelp)Class.forName(string).newInstance();
                this.helpHandler.init(this.presenter);
            }
        }
        catch (Exception exception) {
            String string2 = "Could not create help handler class: " + string;
            Log.logError(string2, exception);
            Log.assertion(false, string2);
        }
    }

    public void updateLocale(Locale locale) {
        if (this.helpHandler != null) {
            this.helpHandler.updateHelp(locale);
        }
    }
}

