/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.wcdma.support.gui.guilib.infra;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Image;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.ImageIcon;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.border.BevelBorder;
import se.ericsson.wcdma.support.gui.guilib.infra.AbstractApplication;
import se.ericsson.wcdma.support.gui.guilib.infra.AbstractPresenter;
import se.ericsson.wcdma.support.gui.guilib.infra.AbstractView;
import se.ericsson.wcdma.support.gui.guilib.infra.ApplicationMenuBar;
import se.ericsson.wcdma.support.gui.guilib.infra.ApplicationToolBar;
import se.ericsson.wcdma.support.gui.guilib.infra.ViewContainer;
import se.ericsson.wcdma.support.gui.resources.ImageConstant;

class SDIViewContainer
extends JFrame
implements ViewContainer {
    private AbstractPresenter presenter;
    private JPanel viewPanel;
    private JPanel contentPanel;
    private JPanel statusBar;
    private JLabel statusLabel;
    private JLabel iconLabel;
    private WinAdapter winAdapter;
    private ApplicationToolBar applicationToolBar = null;
    private ImageIcon ericsson_icon = new ImageIcon();
    private JLabel myUtcClock;

    public void init(AbstractPresenter abstractPresenter) {
        this.presenter = abstractPresenter;
        AbstractApplication abstractApplication = abstractPresenter.getApplication();
        Image image = abstractApplication.getMinimizeIconImage();
        super.setIconImage(image);
        this.ericsson_icon = ImageConstant.ERICSSON_ICON_KEY.getImageIcon();
        this.getContentPane().setLayout(new BorderLayout());
        this.contentPanel = new JPanel();
        this.contentPanel.setLayout(new BorderLayout());
        this.getContentPane().add((Component)this.contentPanel, "Center");
        this.viewPanel = new JPanel();
        this.viewPanel.setLayout(new BoxLayout(this.viewPanel, 1));
        this.contentPanel.add((Component)this.viewPanel, "Center");
        this.createStatusBar();
        if (abstractPresenter.getApplication().isLaunchedStandAlone()) {
            this.addStatusBar();
        }
        this.setDefaultCloseOperation(0);
        this.winAdapter = new WinAdapter();
        this.addWindowListener(this.winAdapter);
    }

    public void dispose() {
        this.presenter = null;
        this.removeComponents(this);
        this.viewPanel = null;
        this.statusBar = null;
        this.statusLabel = null;
        this.myUtcClock = null;
        this.setJMenuBar(null);
        this.applicationToolBar = null;
        this.ericsson_icon = null;
        this.removeWindowListener(this.winAdapter);
        this.winAdapter = null;
        super.dispose();
    }

    private void removeComponents(Component component) {
        if (component instanceof Container) {
            Container container = (Container)component;
            if (component instanceof JMenu) {
                this.removeComponents(container, ((JMenu)component).getMenuComponents());
            }
            this.removeComponents(container, container.getComponents());
        }
    }

    private void removeComponents(Container container, Component[] componentArray) {
        for (int i = 0; i < componentArray.length; ++i) {
            Component component = componentArray[i];
            container.remove(component);
            this.removeComponents(component);
        }
    }

    private void createStatusBar() {
        this.statusLabel = new JLabel("");
        this.iconLabel = new JLabel(this.ericsson_icon);
        this.statusBar = new JPanel();
        this.statusBar.setLayout(new BorderLayout());
        this.statusLabel.setBorder(BorderFactory.createCompoundBorder(new BevelBorder(1), BorderFactory.createEmptyBorder(0, 5, 0, 0)));
        this.statusBar.add((Component)this.statusLabel, "Center");
        this.myUtcClock = new JLabel();
        if (this.presenter.getApplication().isLaunchedStandAlone()) {
            this.iconLabel = new JLabel(this.ericsson_icon);
            this.statusBar.add((Component)this.iconLabel, "East");
        }
    }

    public void setMenuBar(ApplicationMenuBar applicationMenuBar) {
        if (applicationMenuBar != null) {
            this.setJMenuBar(applicationMenuBar);
        }
    }

    public void setToolBar(ApplicationToolBar applicationToolBar) {
        if (this.applicationToolBar != null) {
            this.getContentPane().remove(this.applicationToolBar);
        }
        if (applicationToolBar != null) {
            this.getContentPane().add((Component)applicationToolBar, "North");
        }
        this.applicationToolBar = applicationToolBar;
    }

    public void setView(AbstractView abstractView) {
        this.viewPanel.removeAll();
        this.viewPanel.add(abstractView);
        this.setResizable(abstractView.isResizable());
    }

    public void setViewResizable(boolean bl) {
        this.setResizable(bl);
    }

    public Window getWindow() {
        return this;
    }

    public Component getComponent() {
        return this;
    }

    public void setStatus(String string) {
        if (string == null || string.equals("")) {
            string = " ";
        }
        if (string.startsWith("CLOCK")) {
            this.myUtcClock.setText(string.substring(5));
        } else {
            this.statusLabel.setText(string);
        }
    }

    public void setVisible(boolean bl) {
        if (bl) {
            this.pack();
            this.centerOnScreen();
        }
        super.setVisible(bl);
    }

    public void setEnabled(boolean bl) {
        if (this.presenter.isDefaultEnabling()) {
            super.setEnabled(bl);
        }
    }

    public void bringToFront() {
        if (this.getState() == 1) {
            this.setState(0);
            Dimension dimension = this.getSize();
            this.setSize(dimension.width + 1, dimension.height + 1);
            this.setSize(dimension);
        }
        this.toFront();
        this.requestFocus();
    }

    public void setLocation(int n, int n2) {
        super.setLocation(n, n2);
    }

    public void setMaximized() {
        this.setState(0);
    }

    public void setMinimized() {
        this.setState(1);
    }

    public void setRestored() {
        this.setState(0);
    }

    public void doValidate() {
        this.validate();
        this.repaint();
    }

    private void centerOnScreen() {
        Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
        this.setLocation((dimension.width - this.getSize().width) / 2, (dimension.height - this.getSize().height) / 2);
    }

    public void addStatusBar() {
        this.contentPanel.add((Component)this.statusBar, "South");
    }

    public void setHorizontalScrollBarPolicy(int n) {
    }

    public void setVerticalScrollBarPolicy(int n) {
    }

    private class WinAdapter
    extends WindowAdapter {
        private WinAdapter() {
        }

        public void windowClosing(WindowEvent windowEvent) {
            if (SDIViewContainer.this.presenter.isEnabled()) {
                SDIViewContainer.this.presenter.getController().viewClosing();
            }
        }

        public void windowOpened(WindowEvent windowEvent) {
            super.windowOpened(windowEvent);
            BringToFrontThread bringToFrontThread = new BringToFrontThread();
            bringToFrontThread.start();
        }
    }

    private class BringToFrontThread
    extends Thread {
        private BringToFrontThread() {
        }

        public void run() {
            try {
                Thread.sleep(100L);
            }
            catch (Exception exception) {
                // empty catch block
            }
            Runnable runnable = new Runnable(){

                public void run() {
                    SDIViewContainer.this.bringToFront();
                }
            };
            SwingUtilities.invokeLater(runnable);
        }
    }
}

