/*
 * Decompiled with CFR 0.152.
 */
package com.maverick.crypto.asn1;

import com.maverick.crypto.asn1.ASN1InputStream;
import com.maverick.crypto.asn1.DEREncodable;
import com.maverick.crypto.asn1.DERObject;
import com.maverick.crypto.asn1.DEROutputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;

public class DERApplicationSpecific
extends DERObject {
    private int tb;
    private byte[] ub;

    public DERApplicationSpecific(int n, byte[] byArray) {
        this.tb = n;
        this.ub = byArray;
    }

    public DERApplicationSpecific(int n, DEREncodable dEREncodable) throws IOException {
        this.tb = n | 0x20;
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        DEROutputStream dEROutputStream = new DEROutputStream(byteArrayOutputStream);
        dEROutputStream.writeObject(dEREncodable);
        this.ub = byteArrayOutputStream.toByteArray();
    }

    public boolean isConstructed() {
        return (this.tb & 0x20) != 0;
    }

    public byte[] getContents() {
        return this.ub;
    }

    public int getApplicationTag() {
        return this.tb & 0x1F;
    }

    public DERObject getObject() throws IOException {
        return new ASN1InputStream(new ByteArrayInputStream(this.getContents())).readObject();
    }

    void encode(DEROutputStream dEROutputStream) throws IOException {
        dEROutputStream.b(0x40 | this.tb, this.ub);
    }
}

