/*
 * Decompiled with CFR 0.152.
 */
package com.maverick.crypto.asn1;

import com.maverick.crypto.asn1.ASN1OctetString;
import com.maverick.crypto.asn1.ASN1OutputStream;
import com.maverick.crypto.asn1.ASN1TaggedObject;
import com.maverick.crypto.asn1.DERObject;
import com.maverick.crypto.asn1.DEROutputStream;
import com.maverick.crypto.asn1.DERString;
import java.io.ByteArrayOutputStream;
import java.io.IOException;

public class DERUniversalString
extends DERObject
implements DERString {
    private static final char[] lb = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};
    private byte[] kb;

    public static DERUniversalString getInstance(Object object) {
        if (object == null || object instanceof DERUniversalString) {
            return (DERUniversalString)object;
        }
        if (object instanceof ASN1OctetString) {
            return new DERUniversalString(((ASN1OctetString)object).getOctets());
        }
        throw new IllegalArgumentException("illegal object in getInstance: " + object.getClass().getName());
    }

    public static DERUniversalString getInstance(ASN1TaggedObject aSN1TaggedObject, boolean bl) {
        return DERUniversalString.getInstance(aSN1TaggedObject.getObject());
    }

    public DERUniversalString(byte[] byArray) {
        this.kb = byArray;
    }

    public String getString() {
        StringBuffer stringBuffer = new StringBuffer("#");
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        ASN1OutputStream aSN1OutputStream = new ASN1OutputStream(byteArrayOutputStream);
        try {
            aSN1OutputStream.writeObject(this);
        }
        catch (IOException iOException) {
            throw new RuntimeException("internal error encoding BitString");
        }
        byte[] byArray = byteArrayOutputStream.toByteArray();
        for (int k = 0; k != byArray.length; ++k) {
            stringBuffer.append(lb[(byArray[k] >>> 4) % 15]);
            stringBuffer.append(lb[byArray[k] & 0xF]);
        }
        return stringBuffer.toString();
    }

    public byte[] getOctets() {
        return this.kb;
    }

    void encode(DEROutputStream dEROutputStream) throws IOException {
        dEROutputStream.b(28, this.getOctets());
    }

    public boolean equals(Object object) {
        if (object == null || !(object instanceof DERUniversalString)) {
            return false;
        }
        return this.getString().equals(((DERUniversalString)object).getString());
    }
}

