/*
 * Decompiled with CFR 0.152.
 */
package com.maverick.sftp;

import com.maverick.sftp.ACL;
import com.maverick.sftp.SftpSubsystemChannel;
import com.maverick.util.ByteArrayReader;
import com.maverick.util.ByteArrayWriter;
import com.maverick.util.UnsignedInteger32;
import com.maverick.util.UnsignedInteger64;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.Date;
import java.util.Hashtable;
import java.util.Vector;

public class SftpFileAttributes {
    public static final int SSH_FILEXFER_TYPE_REGULAR = 1;
    public static final int SSH_FILEXFER_TYPE_DIRECTORY = 2;
    public static final int SSH_FILEXFER_TYPE_SYMLINK = 3;
    public static final int SSH_FILEXFER_TYPE_SPECIAL = 4;
    public static final int SSH_FILEXFER_TYPE_UNKNOWN = 5;
    private Vector q = new Vector();
    private Hashtable m = new Hashtable();
    public static final int S_IFMT = 61440;
    public static final int S_IFSOCK = 49152;
    public static final int S_IFLNK = 40960;
    public static final int S_IFREG = 32768;
    public static final int S_IFBLK = 24576;
    public static final int S_IFDIR = 16384;
    public static final int S_IFCHR = 8192;
    public static final int S_IFIFO = 4096;
    public static final int S_ISUID = 2048;
    public static final int S_ISGID = 1024;
    public static final int S_IRUSR = 256;
    public static final int S_IWUSR = 128;
    public static final int S_IXUSR = 64;
    public static final int S_IRGRP = 32;
    public static final int S_IWGRP = 16;
    public static final int S_IXGRP = 8;
    public static final int S_IROTH = 4;
    public static final int S_IWOTH = 2;
    public static final int S_IXOTH = 1;
    int r = 3;
    long j = 0L;
    int t;
    UnsignedInteger64 d = null;
    String c = null;
    String o = null;
    UnsignedInteger32 e = null;
    UnsignedInteger64 f = null;
    UnsignedInteger32 b = null;
    UnsignedInteger64 h = null;
    UnsignedInteger32 g = null;
    UnsignedInteger64 s = null;
    UnsignedInteger32 l = null;
    String n;
    String k;
    char[] p = new char[]{'p', 'c', 'd', 'b', '-', 'l', 's'};
    SftpSubsystemChannel i;

    public SftpFileAttributes(SftpSubsystemChannel sftpSubsystemChannel, int n) {
        this.i = sftpSubsystemChannel;
        this.r = sftpSubsystemChannel.getVersion();
        this.t = n;
    }

    public int getType() {
        return this.t;
    }

    public SftpFileAttributes(SftpSubsystemChannel sftpSubsystemChannel, ByteArrayReader byteArrayReader) throws IOException {
        int n;
        this.i = sftpSubsystemChannel;
        this.r = sftpSubsystemChannel.getVersion();
        if (byteArrayReader.available() >= 4) {
            this.j = byteArrayReader.readInt();
        }
        if (this.r > 3 && byteArrayReader.available() > 0) {
            this.t = byteArrayReader.read();
        }
        if (this.isFlagSet(1L) && byteArrayReader.available() >= 8) {
            byte[] byArray = new byte[8];
            byteArrayReader.read(byArray);
            this.d = new UnsignedInteger64(byArray);
        }
        if (this.r <= 3 && this.isFlagSet(2L) && byteArrayReader.available() >= 8) {
            this.c = String.valueOf(byteArrayReader.readInt());
            this.o = String.valueOf(byteArrayReader.readInt());
        } else if (this.r > 3 && this.isFlagSet(128L) && byteArrayReader.available() > 0) {
            this.c = byteArrayReader.readString(sftpSubsystemChannel.getCharsetEncoding());
            this.o = byteArrayReader.readString(sftpSubsystemChannel.getCharsetEncoding());
        }
        if (this.isFlagSet(4L) && byteArrayReader.available() >= 4) {
            this.e = new UnsignedInteger32(byteArrayReader.readInt());
        }
        if (this.r <= 3 && this.isFlagSet(8L) && byteArrayReader.available() >= 8) {
            this.f = new UnsignedInteger64(byteArrayReader.readInt());
            this.s = new UnsignedInteger64(byteArrayReader.readInt());
        } else if (this.r > 3 && byteArrayReader.available() > 0) {
            if (this.isFlagSet(8L) && byteArrayReader.available() >= 8) {
                this.f = byteArrayReader.readUINT64();
            }
            if (this.isFlagSet(256L) && byteArrayReader.available() >= 4) {
                this.b = byteArrayReader.readUINT32();
            }
        }
        if (this.r > 3 && byteArrayReader.available() > 0) {
            if (this.isFlagSet(16L) && byteArrayReader.available() >= 8) {
                this.h = byteArrayReader.readUINT64();
            }
            if (this.isFlagSet(256L) && byteArrayReader.available() >= 4) {
                this.g = byteArrayReader.readUINT32();
            }
        }
        if (this.r > 3 && byteArrayReader.available() > 0) {
            if (this.isFlagSet(32L) && byteArrayReader.available() >= 8) {
                this.s = byteArrayReader.readUINT64();
            }
            if (this.isFlagSet(256L) && byteArrayReader.available() >= 4) {
                this.l = byteArrayReader.readUINT32();
            }
        }
        if (this.r > 3 && this.isFlagSet(64L) && byteArrayReader.available() > 0) {
            int n2 = (int)byteArrayReader.readInt();
            n = (int)byteArrayReader.readInt();
            for (int k = 0; k < n; ++k) {
                this.q.addElement(new ACL((int)byteArrayReader.readInt(), (int)byteArrayReader.readInt(), (int)byteArrayReader.readInt(), byteArrayReader.readString()));
            }
        }
        if (this.r >= 3 && this.isFlagSet(Integer.MIN_VALUE) && byteArrayReader.available() > 0) {
            int n3 = (int)byteArrayReader.readInt();
            for (n = 0; n < n3; ++n) {
                this.m.put(byteArrayReader.readString(), byteArrayReader.readBinaryString());
            }
        }
    }

    public String getUID() {
        if (this.n != null) {
            return this.n;
        }
        if (this.c != null) {
            return this.c;
        }
        return "";
    }

    public void setUID(String string) {
        this.j = this.r > 3 ? (this.j |= 0x80L) : (this.j |= 2L);
        this.c = string;
    }

    public void setGID(String string) {
        this.j = this.r > 3 ? (this.j |= 0x80L) : (this.j |= 2L);
        this.o = string;
    }

    public String getGID() {
        if (this.k != null) {
            return this.k;
        }
        if (this.o != null) {
            return this.o;
        }
        return "";
    }

    public boolean hasUID() {
        return this.c != null;
    }

    public boolean hasGID() {
        return this.o != null;
    }

    public void setSize(UnsignedInteger64 unsignedInteger64) {
        this.d = unsignedInteger64;
        this.j = unsignedInteger64 != null ? (this.j |= 1L) : (this.j ^= 1L);
    }

    public UnsignedInteger64 getSize() {
        if (this.d != null) {
            return this.d;
        }
        return new UnsignedInteger64("0");
    }

    public boolean hasSize() {
        return this.d != null;
    }

    public void setPermissions(UnsignedInteger32 unsignedInteger32) {
        this.e = unsignedInteger32;
        this.j = unsignedInteger32 != null ? (this.j |= 4L) : (this.j ^= 4L);
    }

    public void setPermissionsFromMaskString(String string) {
        if (string.length() != 4) {
            throw new IllegalArgumentException("Mask length must be 4");
        }
        try {
            this.setPermissions(new UnsignedInteger32(String.valueOf(Integer.parseInt(string, 8))));
        }
        catch (NumberFormatException numberFormatException) {
            throw new IllegalArgumentException("Mask must be 4 digit octal number.");
        }
    }

    public void setPermissionsFromUmaskString(String string) {
        if (string.length() != 4) {
            throw new IllegalArgumentException("umask length must be 4");
        }
        try {
            this.setPermissions(new UnsignedInteger32(String.valueOf(Integer.parseInt(string, 8) ^ 0x1FF)));
        }
        catch (NumberFormatException numberFormatException) {
            throw new IllegalArgumentException("umask must be 4 digit octal number");
        }
    }

    public void setPermissions(String string) {
        int n;
        int n2 = 0;
        if (this.e != null) {
            n2 |= (this.e.longValue() & 0xF000L) == 61440L ? 61440 : 0;
            n2 |= (this.e.longValue() & 0xC000L) == 49152L ? 49152 : 0;
            n2 |= (this.e.longValue() & 0xA000L) == 40960L ? 40960 : 0;
            n2 |= (this.e.longValue() & 0x8000L) == 32768L ? 32768 : 0;
            n2 |= (this.e.longValue() & 0x6000L) == 24576L ? 24576 : 0;
            n2 |= (this.e.longValue() & 0x4000L) == 16384L ? 16384 : 0;
            n2 |= (this.e.longValue() & 0x2000L) == 8192L ? 8192 : 0;
            n2 |= (this.e.longValue() & 0x1000L) == 4096L ? 4096 : 0;
            n2 |= (this.e.longValue() & 0x800L) == 2048L ? 2048 : 0;
            n2 |= (this.e.longValue() & 0x400L) == 1024L ? 1024 : 0;
        }
        if ((n = string.length()) >= 1) {
            n2 |= string.charAt(0) == 'r' ? 256 : 0;
        }
        if (n >= 2) {
            n2 |= string.charAt(1) == 'w' ? 128 : 0;
        }
        if (n >= 3) {
            n2 |= string.charAt(2) == 'x' ? 64 : 0;
        }
        if (n >= 4) {
            n2 |= string.charAt(3) == 'r' ? 32 : 0;
        }
        if (n >= 5) {
            n2 |= string.charAt(4) == 'w' ? 16 : 0;
        }
        if (n >= 6) {
            n2 |= string.charAt(5) == 'x' ? 8 : 0;
        }
        if (n >= 7) {
            n2 |= string.charAt(6) == 'r' ? 4 : 0;
        }
        if (n >= 8) {
            n2 |= string.charAt(7) == 'w' ? 2 : 0;
        }
        if (n >= 9) {
            n2 |= string.charAt(8) == 'x' ? 1 : 0;
        }
        this.setPermissions(new UnsignedInteger32(n2));
    }

    public UnsignedInteger32 getPermissions() {
        if (this.e != null) {
            return this.e;
        }
        return new UnsignedInteger32(0L);
    }

    public void setTimes(UnsignedInteger64 unsignedInteger64, UnsignedInteger64 unsignedInteger642) {
        this.f = unsignedInteger64;
        this.s = unsignedInteger642;
        this.j = unsignedInteger64 != null ? (this.j |= 8L) : (this.j ^= 8L);
    }

    public UnsignedInteger64 getAccessedTime() {
        return this.f;
    }

    public UnsignedInteger64 getModifiedTime() {
        if (this.s != null) {
            return this.s;
        }
        return new UnsignedInteger64(0L);
    }

    public Date getModifiedDateTime() {
        long l = 0L;
        if (this.s != null) {
            l = this.s.longValue() * 1000L;
        }
        if (this.l != null) {
            l += this.l.longValue() / 1000000L;
        }
        return new Date(l);
    }

    public Date getCreationDateTime() {
        long l = 0L;
        if (this.h != null) {
            l = this.h.longValue() * 1000L;
        }
        if (this.g != null) {
            l += this.g.longValue() / 1000000L;
        }
        return new Date(l);
    }

    public Date getAccessedDateTime() {
        long l = 0L;
        if (this.f != null) {
            l = this.f.longValue() * 1000L;
        }
        if (this.f != null) {
            l += this.b.longValue() / 1000000L;
        }
        return new Date(l);
    }

    public UnsignedInteger64 getCreationTime() {
        if (this.h != null) {
            return this.h;
        }
        return new UnsignedInteger64(0L);
    }

    public boolean isFlagSet(long l) {
        return (this.j & (l & 0xFFFFFFFFL)) == (l & 0xFFFFFFFFL);
    }

    public byte[] toByteArray() throws IOException {
        Object object;
        Object object2;
        ByteArrayWriter byteArrayWriter = new ByteArrayWriter();
        byteArrayWriter.writeInt(this.j);
        if (this.r > 3) {
            byteArrayWriter.write(this.t);
        }
        if (this.isFlagSet(1L)) {
            byteArrayWriter.write(this.d.toByteArray());
        }
        if (this.r <= 3 && this.isFlagSet(2L)) {
            if (this.c != null) {
                try {
                    byteArrayWriter.writeInt(Long.parseLong(this.c));
                }
                catch (NumberFormatException numberFormatException) {
                    byteArrayWriter.writeInt(0);
                }
            } else {
                byteArrayWriter.writeInt(0);
            }
            if (this.o != null) {
                try {
                    byteArrayWriter.writeInt(Long.parseLong(this.o));
                }
                catch (NumberFormatException numberFormatException) {
                    byteArrayWriter.writeInt(0);
                }
            } else {
                byteArrayWriter.writeInt(0);
            }
        } else if (this.r > 3 && this.isFlagSet(128L)) {
            if (this.c != null) {
                byteArrayWriter.writeString(this.c, this.i.getCharsetEncoding());
            } else {
                byteArrayWriter.writeString("");
            }
            if (this.o != null) {
                byteArrayWriter.writeString(this.o, this.i.getCharsetEncoding());
            } else {
                byteArrayWriter.writeString("");
            }
        }
        if (this.isFlagSet(4L)) {
            byteArrayWriter.writeInt(this.e.longValue());
        }
        if (this.r <= 3 && this.isFlagSet(8L)) {
            byteArrayWriter.writeInt(this.f.longValue());
            byteArrayWriter.writeInt(this.s.longValue());
        } else if (this.r > 3) {
            if (this.isFlagSet(8L)) {
                byteArrayWriter.writeUINT64(this.f);
            }
            if (this.isFlagSet(256L)) {
                byteArrayWriter.writeUINT32(this.b);
            }
            if (this.isFlagSet(16L)) {
                byteArrayWriter.writeUINT64(this.h);
            }
            if (this.isFlagSet(256L)) {
                byteArrayWriter.writeUINT32(this.g);
            }
            if (this.isFlagSet(32L)) {
                byteArrayWriter.writeUINT64(this.s);
            }
            if (this.isFlagSet(256L)) {
                byteArrayWriter.writeUINT32(this.l);
            }
        }
        if (this.isFlagSet(64L)) {
            object2 = new ByteArrayWriter();
            object = this.q.elements();
            ((ByteArrayWriter)object2).writeInt(this.q.size());
            while (object.hasMoreElements()) {
                ACL aCL = (ACL)object.nextElement();
                ((ByteArrayWriter)object2).writeInt(aCL.getType());
                ((ByteArrayWriter)object2).writeInt(aCL.getFlags());
                ((ByteArrayWriter)object2).writeInt(aCL.getMask());
                ((ByteArrayWriter)object2).writeString(aCL.getWho());
            }
            byteArrayWriter.writeBinaryString(((ByteArrayOutputStream)object2).toByteArray());
        }
        if (this.isFlagSet(Integer.MIN_VALUE)) {
            byteArrayWriter.writeInt(this.m.size());
            object2 = this.m.keys();
            while (object2.hasMoreElements()) {
                object = (String)object2.nextElement();
                byteArrayWriter.writeString((String)object);
                byteArrayWriter.writeBinaryString((byte[])this.m.get(object));
            }
        }
        return byteArrayWriter.toByteArray();
    }

    private int c(int n, int n2) {
        return (((n >>>= n2) & 4) != 0 ? 4 : 0) + ((n & 2) != 0 ? 2 : 0) + ((n & 1) != 0 ? 1 : 0);
    }

    private String b(int n, int n2) {
        String string = (((n >>>= n2) & 4) != 0 ? "r" : "-") + ((n & 2) != 0 ? "w" : "-");
        string = n2 == 6 && (this.e.longValue() & 0x800L) == 2048L || n2 == 3 && (this.e.longValue() & 0x400L) == 1024L ? string + ((n & 1) != 0 ? "s" : "S") : string + ((n & 1) != 0 ? "x" : "-");
        return string;
    }

    public String getPermissionsString() {
        if (this.e != null) {
            boolean bl;
            StringBuffer stringBuffer = new StringBuffer();
            boolean bl2 = bl = ((int)this.e.longValue() & 0xF000) > 0;
            if (bl) {
                stringBuffer.append(this.p[(int)(this.e.longValue() & 0xF000L) >>> 13]);
            } else {
                stringBuffer.append('-');
            }
            stringBuffer.append(this.b((int)this.e.longValue(), 6));
            stringBuffer.append(this.b((int)this.e.longValue(), 3));
            stringBuffer.append(this.b((int)this.e.longValue(), 0));
            return stringBuffer.toString();
        }
        return "";
    }

    public String getMaskString() {
        StringBuffer stringBuffer = new StringBuffer();
        if (this.e != null) {
            int n = (int)this.e.longValue();
            stringBuffer.append('0');
            stringBuffer.append(this.c(n, 6));
            stringBuffer.append(this.c(n, 3));
            stringBuffer.append(this.c(n, 0));
        } else {
            stringBuffer.append("----");
        }
        return stringBuffer.toString();
    }

    public boolean isDirectory() {
        if (this.i.getVersion() > 3) {
            return this.t == 2;
        }
        return this.e != null && (this.e.longValue() & 0x4000L) == 16384L;
    }

    public boolean isFile() {
        if (this.i.getVersion() > 3) {
            return this.t == 1;
        }
        return this.e != null && (this.e.longValue() & 0x8000L) == 32768L;
    }

    public boolean isLink() {
        if (this.i.getVersion() > 3) {
            return this.t == 3;
        }
        return this.e != null && (this.e.longValue() & 0xA000L) == 40960L;
    }

    public boolean isFifo() {
        return this.e != null && (this.e.longValue() & 0x1000L) == 4096L;
    }

    public boolean isBlock() {
        return this.e != null && (this.e.longValue() & 0x6000L) == 24576L;
    }

    public boolean isCharacter() {
        return this.e != null && (this.e.longValue() & 0x2000L) == 8192L;
    }

    public boolean isSocket() {
        return this.e != null && (this.e.longValue() & 0xC000L) == 49152L;
    }

    void b(String string) {
        this.n = string;
    }

    void c(String string) {
        this.k = string;
    }
}

