/*
 * Decompiled with CFR 0.152.
 */
package com.sshtools.publickey;

import com.maverick.ssh.SshException;
import com.maverick.ssh.components.SshPublicKey;
import com.sshtools.publickey.Base64EncodedFileFormat;
import com.sshtools.publickey.SshPublicKeyFile;
import com.sshtools.publickey.SshPublicKeyFileFactory;
import java.io.IOException;

public class SECSHPublicKeyFile
extends Base64EncodedFileFormat
implements SshPublicKeyFile {
    private static String q = "---- BEGIN SSH2 PUBLIC KEY ----";
    private static String s = "---- END SSH2 PUBLIC KEY ----";
    String p;
    byte[] r;

    SECSHPublicKeyFile(byte[] byArray) throws IOException {
        super(q, s);
        this.r = this.getKeyBlob(byArray);
        this.toPublicKey();
    }

    SECSHPublicKeyFile(SshPublicKey sshPublicKey, String string) throws IOException {
        super(q, s);
        try {
            this.p = sshPublicKey.getAlgorithm();
            this.r = sshPublicKey.getEncoded();
            this.setComment(string);
            this.toPublicKey();
        }
        catch (SshException sshException) {
            throw new IOException("Failed to encode public key");
        }
    }

    public String getComment() {
        return this.getHeaderValue("Comment");
    }

    public SshPublicKey toPublicKey() throws IOException {
        return SshPublicKeyFileFactory.decodeSSH2PublicKey(this.r);
    }

    public byte[] getFormattedKey() throws IOException {
        return this.formatKey(this.r);
    }

    public void setComment(String string) {
        this.setHeaderValue("Comment", (string.trim().startsWith("\"") ? "" : "\"") + string.trim() + (string.trim().endsWith("\"") ? "" : "\""));
    }

    public String toString() {
        try {
            return new String(this.getFormattedKey());
        }
        catch (IOException iOException) {
            return "Invalid encoding!";
        }
    }
}

