/*
 * Decompiled with CFR 0.152.
 */
package com.sshtools.publickey;

import com.maverick.ssh.SshException;
import com.maverick.ssh.SshIOException;
import com.maverick.ssh.components.ComponentManager;
import com.maverick.ssh.components.Digest;
import com.maverick.ssh.components.SshCipher;
import com.maverick.ssh.components.SshDsaPublicKey;
import com.maverick.ssh.components.SshKeyPair;
import com.maverick.util.ByteArrayReader;
import com.maverick.util.ByteArrayWriter;
import com.sshtools.publickey.Base64EncodedFileFormat;
import com.sshtools.publickey.InvalidPassphraseException;
import com.sshtools.publickey.SshPrivateKeyFile;
import java.io.IOException;
import java.math.BigInteger;

class h
extends Base64EncodedFileFormat
implements SshPrivateKeyFile {
    static String m = "---- BEGIN SSH2 ENCRYPTED PRIVATE KEY ----";
    static String o = "---- END SSH2 ENCRYPTED PRIVATE KEY ----";
    byte[] n;

    h(byte[] byArray) throws IOException {
        super(m, o);
        if (!h.e(byArray)) {
            throw new IOException("Key is not formatted in the ssh.com format");
        }
        this.n = byArray;
    }

    public String getType() {
        return "SSH Communications Security";
    }

    public static boolean e(byte[] byArray) {
        return Base64EncodedFileFormat.isFormatted(byArray, m, o);
    }

    public boolean supportsPassphraseChange() {
        return false;
    }

    public boolean isPassphraseProtected() {
        try {
            byte[] byArray = this.getKeyBlob(this.n);
            ByteArrayReader byteArrayReader = new ByteArrayReader(byArray);
            long l = byteArrayReader.readInt();
            if (l != 1064303083L) {
                throw new IOException("Invalid ssh.com key! Magic number not found");
            }
            byteArrayReader.readInt();
            byteArrayReader.readString();
            String string = byteArrayReader.readString();
            return string.equals("3des-cbc");
        }
        catch (IOException iOException) {
            return false;
        }
    }

    public SshKeyPair toKeyPair(String string) throws IOException, InvalidPassphraseException {
        Object object;
        Object object2;
        Object object3;
        byte[] byArray = this.getKeyBlob(this.n);
        boolean bl = false;
        ByteArrayReader byteArrayReader = new ByteArrayReader(byArray);
        long l = byteArrayReader.readInt();
        if (l != 1064303083L) {
            throw new IOException("Invalid ssh.com key! Magic number not found");
        }
        byteArrayReader.readInt();
        String string2 = byteArrayReader.readString();
        String string3 = byteArrayReader.readString();
        byte[] byArray2 = byteArrayReader.readBinaryString();
        try {
            if (!string3.equals("none")) {
                if (!string3.equals("3des-cbc")) {
                    throw new IOException("Unsupported cipher type " + string3 + " in ssh.com private key");
                }
                object3 = (SshCipher)ComponentManager.getInstance().supportedSsh2CiphersCS().getInstance("3des-cbc");
                object2 = new byte[32];
                object = this.e(string);
                ((SshCipher)object3).init(1, (byte[])object2, (byte[])object);
                ((SshCipher)object3).transform(byArray2);
                bl = true;
            }
        }
        catch (SshException sshException) {
            throw new SshIOException(sshException);
        }
        try {
            object3 = new ByteArrayReader(byArray2, 4, byArray2.length - 4);
            if (string2.startsWith("if-modn{sign{rsa")) {
                object2 = ((ByteArrayReader)object3).readMPINT32();
                object = ((ByteArrayReader)object3).readMPINT32();
                BigInteger bigInteger = ((ByteArrayReader)object3).readMPINT32();
                BigInteger bigInteger2 = ((ByteArrayReader)object3).readMPINT32();
                BigInteger bigInteger3 = ((ByteArrayReader)object3).readMPINT32();
                BigInteger bigInteger4 = ((ByteArrayReader)object3).readMPINT32();
                SshKeyPair sshKeyPair = new SshKeyPair();
                sshKeyPair.setPublicKey(ComponentManager.getInstance().createRsaPublicKey(bigInteger, (BigInteger)object2, 2));
                sshKeyPair.setPrivateKey(ComponentManager.getInstance().createRsaPrivateCrtKey(bigInteger, (BigInteger)object2, (BigInteger)object, bigInteger3, bigInteger4, bigInteger2));
                return sshKeyPair;
            }
            if (string2.startsWith("dl-modp{sign{dsa")) {
                long l2 = ((ByteArrayReader)object3).readInt();
                if (l2 != 0L) {
                    throw new IOException("Unexpected value in DSA key; this is an unsupported feature of ssh.com private keys");
                }
                BigInteger bigInteger = ((ByteArrayReader)object3).readMPINT32();
                BigInteger bigInteger5 = ((ByteArrayReader)object3).readMPINT32();
                BigInteger bigInteger6 = ((ByteArrayReader)object3).readMPINT32();
                BigInteger bigInteger7 = ((ByteArrayReader)object3).readMPINT32();
                BigInteger bigInteger8 = ((ByteArrayReader)object3).readMPINT32();
                SshKeyPair sshKeyPair = new SshKeyPair();
                SshDsaPublicKey sshDsaPublicKey = ComponentManager.getInstance().createDsaPublicKey(bigInteger, bigInteger6, bigInteger5, bigInteger7);
                sshKeyPair.setPublicKey(sshDsaPublicKey);
                sshKeyPair.setPrivateKey(ComponentManager.getInstance().createDsaPrivateKey(bigInteger, bigInteger6, bigInteger5, bigInteger8, sshDsaPublicKey.getY()));
                return sshKeyPair;
            }
            throw new IOException("Unsupported ssh.com key type " + string2);
        }
        catch (Throwable throwable) {
            if (bl) {
                throw new InvalidPassphraseException();
            }
            throw new IOException("Bad SSH.com private key format!");
        }
    }

    private byte[] e(String string) throws IOException {
        try {
            Digest digest = (Digest)ComponentManager.getInstance().supportedDigests().getInstance("MD5");
            ByteArrayWriter byteArrayWriter = new ByteArrayWriter();
            digest.putBytes(string.getBytes());
            byte[] byArray = digest.doFinal();
            digest.reset();
            digest.putBytes(string.getBytes());
            digest.putBytes(byArray);
            byteArrayWriter.write(byArray);
            byteArrayWriter.write(digest.doFinal());
            return byteArrayWriter.toByteArray();
        }
        catch (SshException sshException) {
            throw new SshIOException(sshException);
        }
    }

    public void changePassphrase(String string, String string2) throws IOException {
        throw new IOException("Changing passphrase is not supported by the ssh.com key format engine");
    }

    public byte[] getFormattedKey() throws IOException {
        return this.n;
    }
}

