/*
 * Decompiled with CFR 0.152.
 */
package com.sshtools.scp;

import com.maverick.scp.ScpClientIO;
import com.maverick.sftp.FileTransferProgress;
import com.maverick.sftp.SftpStatusException;
import com.maverick.ssh.ChannelOpenException;
import com.maverick.ssh.Client;
import com.maverick.ssh.ShellTimeoutException;
import com.maverick.ssh.SshClient;
import com.maverick.ssh.SshException;
import com.maverick.ssh.SshIOException;
import com.maverick.ssh.SshSession;
import com.sshtools.sftp.GlobRegExpMatching;
import java.io.EOFException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;

public class ScpClient
extends ScpClientIO
implements Client {
    File l;

    public ScpClient(SshClient sshClient) {
        this(null, sshClient);
    }

    public ScpClient(File file, SshClient sshClient) {
        super(sshClient);
        String string = "";
        if (file == null) {
            try {
                string = System.getProperty("user.home");
            }
            catch (SecurityException securityException) {
                // empty catch block
            }
            file = new File(string);
        }
        this.l = file;
    }

    public void put(String string, String string2, boolean bl) throws SshException, ChannelOpenException, SftpStatusException {
        this.put(string, string2, bl, null);
    }

    public void putFile(String string, String string2, boolean bl, FileTransferProgress fileTransferProgress, boolean bl2) throws SshException, ChannelOpenException {
        File file = new File(string);
        if (!file.isAbsolute()) {
            file = new File(this.l, string);
        }
        if (!file.exists()) {
            throw new SshException(string + " does not exist", 6);
        }
        if (!file.isFile() && !file.isDirectory()) {
            throw new SshException(string + " is not a regular file or directory", 6);
        }
        if (file.isDirectory() && !bl) {
            throw new SshException(string + " is a directory, use recursive mode", 6);
        }
        if (string2 == null || string2.equals("")) {
            string2 = ".";
        }
        ScpEngine scpEngine = new ScpEngine("scp " + (file.isDirectory() | bl2 ? "-d " : "") + "-t " + (bl ? "-r " : "") + string2, this.ssh.openSessionChannel());
        try {
            scpEngine.waitForResponse();
            scpEngine.b(file, bl, fileTransferProgress);
        }
        catch (SshIOException sshIOException) {
            throw sshIOException.getRealException();
        }
        catch (IOException iOException) {
            throw new SshException("localfile=" + string + " remotefile=" + string2, 6, iOException);
        }
        finally {
            try {
                scpEngine.close();
            }
            catch (Throwable throwable) {}
        }
    }

    public void put(String string, String string2, boolean bl, FileTransferProgress fileTransferProgress) throws SshException, ChannelOpenException {
        File file;
        GlobRegExpMatching globRegExpMatching = new GlobRegExpMatching();
        String string3 = this.l.getAbsolutePath();
        String string4 = "";
        int n = string.lastIndexOf(System.getProperty("file.separator"));
        if (n > -1 || (n = string.lastIndexOf(47)) > -1) {
            string4 = string.substring(0, n + 1);
            file = new File(string4);
            string3 = file.isAbsolute() ? string4 : string3 + System.getProperty("file.separator") + string4;
        }
        file = new File(string3);
        String[] stringArray = file.list();
        File[] fileArray = new File[stringArray.length];
        for (int k = 0; k < stringArray.length; ++k) {
            fileArray[k] = new File(string3 + File.separator + stringArray[k]);
        }
        String[] stringArray2 = globRegExpMatching.matchFileNamesWithPattern(fileArray, string.substring(n + 1));
        if (stringArray2.length == 0) {
            throw new SshException(string + "No file matches/File does not exist", 6);
        }
        if (stringArray2.length > 1) {
            this.put(stringArray2, string2, bl, fileTransferProgress);
        } else {
            this.putFile(stringArray2[0], string2, bl, fileTransferProgress, false);
        }
    }

    public void put(String[] stringArray, String string, boolean bl) throws SshException, ChannelOpenException {
        this.put(stringArray, string, bl, null);
    }

    public void put(String[] stringArray, String string, boolean bl, FileTransferProgress fileTransferProgress) throws SshException, ChannelOpenException {
        for (int k = 0; k < stringArray.length; ++k) {
            this.putFile(stringArray[k], string, bl, fileTransferProgress, true);
        }
    }

    public void get(String string, String[] stringArray, boolean bl) throws SshException, ChannelOpenException {
        this.get(string, stringArray, bl, null);
    }

    public void get(String string, String[] stringArray, boolean bl, FileTransferProgress fileTransferProgress) throws SshException, ChannelOpenException {
        StringBuffer stringBuffer = new StringBuffer();
        for (int k = 0; k < stringArray.length; ++k) {
            stringBuffer.append("\"");
            stringBuffer.append(stringArray[k]);
            stringBuffer.append("\" ");
        }
        String string2 = stringBuffer.toString();
        string2 = string2.trim();
        this.get(string, string2, bl, fileTransferProgress);
    }

    public void get(String string, String string2, boolean bl) throws SshException, ChannelOpenException {
        this.get(string, string2, bl, null);
    }

    public void get(String string, String string2, boolean bl, FileTransferProgress fileTransferProgress) throws SshException, ChannelOpenException {
        File file;
        if (string == null || string.equals("")) {
            string = ".";
        }
        if (!(file = new File(string)).isAbsolute()) {
            file = new File(this.l, string);
        }
        if (file.exists() && !file.isFile() && !file.isDirectory()) {
            throw new SshException(string + " is not a regular file or directory", 6);
        }
        ScpEngine scpEngine = new ScpEngine("scp -f " + (bl ? "-r " : "") + string2, this.ssh.openSessionChannel());
        scpEngine.b(file, fileTransferProgress, false);
        try {
            scpEngine.close();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public void exit() throws SshException, ShellTimeoutException, IOException {
    }

    protected class ScpEngine
    extends ScpClientIO.ScpEngineIO {
        protected ScpEngine(String string, SshSession sshSession) throws SshException {
            super(string, sshSession);
        }

        private boolean c(File file, boolean bl, FileTransferProgress fileTransferProgress) throws SshException {
            try {
                if (!bl) {
                    this.writeError("File " + file.getName() + " is a directory, use recursive mode");
                    return false;
                }
                String string = "D0755 0 " + file.getName() + "\n";
                this.out.write(string.getBytes());
                this.waitForResponse();
                String[] stringArray = file.list();
                for (int k = 0; k < stringArray.length; ++k) {
                    File file2 = new File(file, stringArray[k]);
                    this.b(file2, bl, fileTransferProgress);
                }
                this.out.write("E\n".getBytes());
                return true;
            }
            catch (IOException iOException) {
                this.close();
                throw new SshException(iOException, 6);
            }
        }

        private void b(File file, boolean bl, FileTransferProgress fileTransferProgress) throws SshException {
            try {
                if (file.isDirectory()) {
                    if (!this.c(file, bl, fileTransferProgress)) {
                        return;
                    }
                } else if (file.isFile()) {
                    String string = "C0644 " + file.length() + " " + file.getName() + "\n";
                    this.out.write(string.getBytes());
                    if (fileTransferProgress != null) {
                        fileTransferProgress.started(file.length(), file.getName());
                    }
                    this.waitForResponse();
                    FileInputStream fileInputStream = new FileInputStream(file);
                    this.writeCompleteFile(fileInputStream, file.length(), fileTransferProgress);
                    if (fileTransferProgress != null) {
                        fileTransferProgress.completed();
                    }
                    this.writeOk();
                } else {
                    throw new SshException(file.getName() + " not valid for SCP", 6);
                }
                this.waitForResponse();
            }
            catch (SshIOException sshIOException) {
                throw sshIOException.getRealException();
            }
            catch (IOException iOException) {
                this.close();
                throw new SshException(iOException, 6);
            }
        }

        private void b(File file, FileTransferProgress fileTransferProgress, boolean bl) throws SshException {
            try {
                String string;
                String[] stringArray = new String[3];
                this.writeOk();
                block13: while (true) {
                    try {
                        string = this.readString();
                    }
                    catch (EOFException eOFException) {
                        return;
                    }
                    catch (SshIOException sshIOException) {
                        return;
                    }
                    char c2 = string.charAt(0);
                    switch (c2) {
                        case 'E': {
                            this.writeOk();
                            return;
                        }
                        case 'T': {
                            continue block13;
                        }
                        case 'C': 
                        case 'D': {
                            Object object;
                            String string2 = file.getAbsolutePath();
                            this.parseCommand(string, stringArray);
                            if (file.isDirectory()) {
                                string2 = string2 + File.separator + stringArray[2];
                            }
                            File file2 = new File(string2);
                            if (c2 == 'D') {
                                if (file2.exists()) {
                                    if (!file2.isDirectory()) {
                                        object = "Invalid target " + file2.getName() + ", must be a directory";
                                        this.writeError((String)object);
                                        throw new IOException((String)object);
                                    }
                                } else if (!file2.mkdir()) {
                                    object = "Could not create directory: " + file2.getName();
                                    this.writeError((String)object);
                                    throw new IOException((String)object);
                                }
                                this.b(file2, fileTransferProgress, true);
                                continue block13;
                            }
                            object = new FileOutputStream(file2);
                            this.writeOk();
                            long l = Long.parseLong(stringArray[1]);
                            if (fileTransferProgress != null) {
                                fileTransferProgress.started(l, string2);
                            }
                            this.readCompleteFile((OutputStream)object, l, fileTransferProgress);
                            if (fileTransferProgress != null) {
                                fileTransferProgress.completed();
                            }
                            try {
                                this.waitForResponse();
                                this.writeOk();
                            }
                            catch (SshIOException sshIOException) {
                                if (sshIOException.getRealException().getReason() == 1 && !bl) {
                                    return;
                                }
                                throw sshIOException;
                            }
                        }
                        continue block13;
                    }
                    break;
                }
                this.writeError("Unexpected cmd: " + string);
                throw new IOException("SCP unexpected cmd: " + string);
            }
            catch (SshIOException sshIOException) {
                throw sshIOException.getRealException();
            }
            catch (IOException iOException) {
                this.close();
                throw new SshException(iOException, 6);
            }
        }
    }
}

