/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.crbs.omf.mao.indications.avc;

import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import se.ericsson.cello.moframework.csnotifications.CSNotificationSubscriber;
import se.ericsson.cello.moframework.csnotifications.CSNotificationSubscriberMgr;
import se.ericsson.cello.moframework.csnotifications.CSNotificationSubscriberMgrFactory;
import se.ericsson.cello.moframework.csnotifications.NameValue;
import se.ericsson.cello.moframework.csnotifications.SubscriptionFilter;
import se.ericsson.cello.moframework.csnotifications.TopologyAndAVCSubscriber;
import se.ericsson.crbs.logging.AbstractLogger;
import se.ericsson.crbs.logging.LoggingService;
import se.ericsson.crbs.omf.mao.indications.avc.AvcConnector;
import se.ericsson.crbs.omf.mao.indications.avc.AvcException;
import se.ericsson.crbs.omf.mao.indications.avc.AvcRegistrator;
import se.ericsson.crbs.omf.mao.indications.avc.TopologyRegistrator;

public class AvcConnectorImpl
implements AvcConnector,
TopologyAndAVCSubscriber {
    private static final Class THIS_CLASS = AvcConnectorImpl.class;
    private static final AbstractLogger logger = LoggingService.getLogger(THIS_CLASS.getName());
    private final Set oldMoTypes = new HashSet();
    private final Set latestMoTypes = new HashSet();
    private final Object attributeValueChangedLock = new Object();
    private final LinkedList attributeValueChangedQueue = new LinkedList();
    private final AvcRegistrator avcRegistrator;
    protected CSNotificationSubscriberMgr subMgr;
    protected SubscriptionFilter subFilter = new SubscriptionFilter();
    private boolean avcThreadDone = false;

    public AvcConnectorImpl(AvcRegistrator avc_registrator) {
        this(avc_registrator, CSNotificationSubscriberMgrFactory.createCSNotificationSubscriberMgr());
    }

    public AvcConnectorImpl(AvcRegistrator avc_registrator, CSNotificationSubscriberMgr subMgr) {
        this.avcRegistrator = avc_registrator;
        this.subMgr = subMgr;
        subMgr.register((TopologyAndAVCSubscriber)this, this.subFilter);
        GoamLmAttributeValueChangedThread thread = new GoamLmAttributeValueChangedThread(avc_registrator);
        thread.start();
    }

    public void registerAvcSubscriber(String moType) throws AvcException {
        logger.traceEnter(THIS_CLASS, "registerAvcSubscriber(ldn = " + moType + ")");
        boolean newMoType = this.addMoTypeToRegistratedMoTypes(moType);
        if (newMoType) {
            this.updateRegistrationToAVC();
        }
        logger.traceReturn(THIS_CLASS, "registerAvcSubscriber()");
    }

    public void unregisterAvcSubscriber(String moType) throws AvcException {
        logger.traceEnter(THIS_CLASS, "unregisterAvcSubscriber(ldn = " + moType + ")");
        boolean moTypeRemoved = this.removeMoTypeToRegistratedMoTypes(moType);
        if (moTypeRemoved) {
            this.updateRegistrationToAVC();
        }
        logger.traceReturn(THIS_CLASS, "unregisterAvcSubscriber()");
    }

    public void stopSubscriptions() throws AvcException {
        logger.traceEnter(THIS_CLASS, "stopSubscriptions()");
        if (this.subMgr != null) {
            this.subMgr.deregister((CSNotificationSubscriber)this);
        }
        logger.traceReturn(THIS_CLASS, "stopSubscriptions()");
    }

    private boolean addMoTypeToRegistratedMoTypes(String moType) {
        logger.traceEnter(THIS_CLASS, "addMoTypeToRegistratedMoTypes(MO type=" + moType + ")");
        this.oldMoTypes.clear();
        this.oldMoTypes.addAll(this.latestMoTypes);
        logger.traceReturn(THIS_CLASS, "addMoTypeToRegistratedMoTypes()");
        return this.latestMoTypes.add(moType);
    }

    private boolean removeMoTypeToRegistratedMoTypes(String moType) {
        logger.traceEnter(THIS_CLASS, "removeMoTypeToRegistratedMoTypes(MO type=" + moType + ")");
        this.oldMoTypes.clear();
        this.oldMoTypes.addAll(this.latestMoTypes);
        logger.traceReturn(THIS_CLASS, "removeMoTypeToRegistratedMoTypes()");
        return this.latestMoTypes.remove(moType);
    }

    private void updateRegistrationToAVC() throws AvcException {
        logger.traceEnter(THIS_CLASS, "updateRegistrationToAVC()");
        this.setUpNewRegistration();
        logger.traceReturn(THIS_CLASS, "updateRegistrationToAVC()");
    }

    private void setUpNewRegistration() throws AvcException {
        logger.traceEnter(THIS_CLASS, "setUpNewRegistration()");
        this.subFilter.setMoTypes(this.getActiveSubscribedMoTypes());
        logger.traceReturn(THIS_CLASS, "setUpNewRegistration()");
    }

    public String[] getActiveSubscribedMoTypes() {
        return this.latestMoTypes.toArray(new String[this.latestMoTypes.size()]);
    }

    private void updateRegistrationToAvcAndReportSubscriptionProblem() {
        try {
            this.updateRegistrationToAVC();
            this.avcRegistrator.reportSubscriptionProblem();
        }
        catch (AvcException e) {
            logger.traceGeneral(THIS_CLASS, "Got exception when trying to reconnect to AVC: " + e.toString());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void moChanged(String ldn, List nameValueList) {
        logger.traceEnter(THIS_CLASS, "moChanged() - ldn = " + ldn + ", AttributeNameValueList size = " + nameValueList.size());
        Object object = this.attributeValueChangedLock;
        synchronized (object) {
            try {
                NameValue[] nameValueArray = nameValueList.toArray(new NameValue[nameValueList.size()]);
                for (int i = 0; i < nameValueArray.length; ++i) {
                    NameValue nameValue = nameValueArray[i];
                    logger.traceDebug(THIS_CLASS, "Send update for ldn=" + ldn + ", attributename=" + nameValue.getName() + ", value=" + nameValue.getValue());
                    this.attributeValueChangedQueue.addLast(new Object[]{ldn, nameValue});
                }
            }
            catch (Exception anyException) {
                logger.traceError(THIS_CLASS, "Catch any exception", anyException);
            }
            this.attributeValueChangedLock.notifyAll();
        }
        logger.traceReturn(THIS_CLASS, "moChanged()");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void moCreated(String ldn) {
        logger.traceEnter(THIS_CLASS, "moCreated() - " + ldn);
        NameValue nameValue = new NameValue();
        Object object = this.attributeValueChangedLock;
        synchronized (object) {
            try {
                nameValue.setName("moCreated");
                nameValue.setValue(this.attributeValueChangedLock);
                logger.traceDebug(THIS_CLASS, "Send update for ldn=" + ldn + ", attributename=" + nameValue.getName());
                this.attributeValueChangedQueue.addLast(new Object[]{ldn, nameValue});
            }
            catch (Exception anyException) {
                logger.traceError(THIS_CLASS, "Catch any exception", anyException);
            }
            this.attributeValueChangedLock.notifyAll();
        }
        logger.traceReturn(THIS_CLASS, "moCreated()");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void moDeleted(String ldn) {
        logger.traceEnter(THIS_CLASS, "moDeleted() - " + ldn);
        NameValue nameValue = new NameValue();
        Object object = this.attributeValueChangedLock;
        synchronized (object) {
            try {
                nameValue.setName("moDeleted");
                nameValue.setValue(this.attributeValueChangedLock);
                logger.traceDebug(THIS_CLASS, "Send update for ldn=" + ldn + ", attributename=" + nameValue.getName());
                this.attributeValueChangedQueue.addLast(new Object[]{ldn, nameValue});
            }
            catch (Exception anyException) {
                logger.traceError(THIS_CLASS, "Catch any exception", anyException);
            }
            this.attributeValueChangedLock.notifyAll();
        }
        logger.traceReturn(THIS_CLASS, "moDeleted()");
    }

    public void queueOverflow() {
        logger.traceEnter(THIS_CLASS, "queueOverflow() - Not used");
        this.updateRegistrationToAvcAndReportSubscriptionProblem();
        logger.traceReturn(THIS_CLASS, "queueOverflow() - Not used");
    }

    public void queueOverflow(String message) {
        logger.traceEnter(THIS_CLASS, "queueOverflow(traceMessage) - Not used");
        logger.traceError(THIS_CLASS, message);
        this.queueOverflow();
        logger.traceReturn(THIS_CLASS, "queueOverflow(traceMessage) - Not used");
    }

    public void setAvcThreadDone(boolean avcThreadDone) {
        this.avcThreadDone = avcThreadDone;
    }

    private class GoamLmAttributeValueChangedThread
    extends Thread {
        private final AvcRegistrator avcRegistrator;
        private final TopologyRegistrator topologyRegistrator;

        public GoamLmAttributeValueChangedThread(AvcRegistrator avc_registrator) {
            super("crbs_AttributeValueChanged_Thread");
            this.avcRegistrator = avc_registrator;
            this.topologyRegistrator = (TopologyRegistrator)((Object)avc_registrator);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private Object[] getAction() {
            Object[] returnObj = null;
            Object object = AvcConnectorImpl.this.attributeValueChangedLock;
            synchronized (object) {
                if (!AvcConnectorImpl.this.attributeValueChangedQueue.isEmpty()) {
                    returnObj = (Object[])AvcConnectorImpl.this.attributeValueChangedQueue.removeFirst();
                }
            }
            return returnObj;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            AvcConnectorImpl.this.avcThreadDone = false;
            while (!AvcConnectorImpl.this.avcThreadDone) {
                Object ldn;
                Object[] nextAction = this.getAction();
                while (nextAction != null) {
                    ldn = (String)nextAction[0];
                    NameValue nameValue = (NameValue)nextAction[1];
                    if (nameValue.getName().equals("moCreated")) {
                        logger.traceDebug(THIS_CLASS, "For ldn=" + (String)ldn + " MO created");
                        this.topologyRegistrator.reportMoCreated((String)ldn);
                    } else if (nameValue.getName().equals("moDeleted")) {
                        logger.traceDebug(THIS_CLASS, "For ldn=" + (String)ldn + " MO deleted");
                        this.topologyRegistrator.reportMoDeleted((String)ldn);
                    } else {
                        logger.traceDebug(THIS_CLASS, "For ldn " + (String)ldn + ". Send update on attribute: name=" + nameValue.getName() + ", value=" + nameValue.getValue() + ")");
                        this.avcRegistrator.reportAvc((String)ldn, nameValue.getName(), nameValue.getValue());
                    }
                    nextAction = this.getAction();
                }
                try {
                    logger.traceDebug(THIS_CLASS, "Notification queue is processed, will wait for new notifications");
                    ldn = AvcConnectorImpl.this.attributeValueChangedLock;
                    synchronized (ldn) {
                        AvcConnectorImpl.this.attributeValueChangedLock.wait();
                    }
                    logger.traceDebug(THIS_CLASS, "Notification queue updated, will process " + AvcConnectorImpl.this.attributeValueChangedQueue.size() + " new notifications");
                }
                catch (InterruptedException interruptedException) {}
            }
        }
    }
}

