/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.mimparser.state;

import org.xml.sax.Attributes;
import se.ericsson.cello.mimparser.model.DomainExtensionImpl;
import se.ericsson.cello.mimparser.model.MomBiDirectionalAssociationImpl;
import se.ericsson.cello.mimparser.model.MomContainmentImpl;
import se.ericsson.cello.mimparser.model.MomRelationshipImpl;
import se.ericsson.cello.mimparser.model.MomSoftLinkImpl;
import se.ericsson.cello.mimparser.model.MomSupportImpl;
import se.ericsson.cello.mimparser.model.MomUniDirectionalAssociationImpl;
import se.ericsson.cello.mimparser.state.BiDirectionalAssociationState;
import se.ericsson.cello.mimparser.state.ContainmentState;
import se.ericsson.cello.mimparser.state.DomainExtensionState;
import se.ericsson.cello.mimparser.state.MomBaseState;
import se.ericsson.cello.mimparser.state.SoftLinkState;
import se.ericsson.cello.mimparser.state.SupportState;
import se.ericsson.cello.mimparser.state.UniDirectionalAssociationState;
import se.ericsson.cello.mimparser.statemachine.StateMachine;

class RelationshipState
extends MomBaseState {
    private MomRelationshipImpl momRelationship;
    public static final String RELATIONSHIP_TAG = "relationship";
    private String[] allPossibleAssociationTypes = new String[]{"biDirectionalAssociation", "uniDirectionalAssociation", "containment", "softLink", "support"};

    public RelationshipState(MomRelationshipImpl moRelationship) {
        super(RELATIONSHIP_TAG);
        this.momRelationship = moRelationship;
    }

    public void startElement(StateMachine stateMachine, String name, Attributes attributes) {
        super.startElement(stateMachine, name, this.momRelationship);
        if (this.isAssociationType(name)) {
            this.momRelationship.setAssociationType(name);
        }
        if (name.equals("containment")) {
            MomContainmentImpl momContainmentImpl = new MomContainmentImpl(name, attributes, stateMachine.getParseInfo().getMimModel(), stateMachine.getParseInfo().getNextId());
            momContainmentImpl.setName(this.momRelationship.getName());
            stateMachine.getParseInfo().getMimModel().addRelationshipToBeResolved(momContainmentImpl);
            stateMachine.getParseInfo().getMimModel().addContainmentRelationshipToBeResolved(momContainmentImpl);
            stateMachine.pushState(new ContainmentState(momContainmentImpl, this.momRelationship));
        } else if (name.equals("uniDirectionalAssociation")) {
            MomUniDirectionalAssociationImpl momUnidirectionalAssociationImpl = new MomUniDirectionalAssociationImpl(name, attributes, stateMachine.getParseInfo().getMimModel(), stateMachine.getParseInfo().getNextId());
            momUnidirectionalAssociationImpl.setName(this.momRelationship.getName());
            stateMachine.getParseInfo().getMimModel().addRelationshipToBeResolved(momUnidirectionalAssociationImpl);
            stateMachine.getParseInfo().getMimModel().addUniDirectionalRelationShipToBeResolved(momUnidirectionalAssociationImpl);
            stateMachine.pushState(new UniDirectionalAssociationState(momUnidirectionalAssociationImpl, this.momRelationship));
        } else if (name.equals("biDirectionalAssociation")) {
            MomBiDirectionalAssociationImpl momBiDirectionalAssociationImpl = new MomBiDirectionalAssociationImpl(name, attributes, stateMachine.getParseInfo().getMimModel(), stateMachine.getParseInfo().getNextId());
            momBiDirectionalAssociationImpl.setName(this.momRelationship.getName());
            stateMachine.getParseInfo().getMimModel().addRelationshipToBeResolved(momBiDirectionalAssociationImpl);
            stateMachine.getParseInfo().getMimModel().addBiDirectionalAssociationToBeResolved(momBiDirectionalAssociationImpl);
            stateMachine.pushState(new BiDirectionalAssociationState(momBiDirectionalAssociationImpl, this.momRelationship));
        } else if (name.equals("softLink")) {
            MomSoftLinkImpl momSoftLinkImpl = new MomSoftLinkImpl(name, attributes, stateMachine.getParseInfo().getMimModel(), stateMachine.getParseInfo().getNextId());
            momSoftLinkImpl.setName(this.momRelationship.getName());
            stateMachine.getParseInfo().getMimModel().addRelationshipToBeResolved(momSoftLinkImpl);
            stateMachine.getParseInfo().getMimModel().addSoftLinkRelationShipToBeResolved(momSoftLinkImpl);
            stateMachine.pushState(new SoftLinkState(momSoftLinkImpl, this.momRelationship));
        } else if (name.equals("support")) {
            MomSupportImpl momSupportImpl = new MomSupportImpl(name, attributes, stateMachine.getParseInfo().getMimModel(), stateMachine.getParseInfo().getNextId());
            momSupportImpl.setName(this.momRelationship.getName());
            stateMachine.getParseInfo().getMimModel().addRelationshipToBeResolved(momSupportImpl);
            stateMachine.getParseInfo().getMimModel().addSupportRelationShipToBeResolved(momSupportImpl);
            stateMachine.pushState(new SupportState(momSupportImpl, this.momRelationship));
        } else if (name.equals("domainExtension")) {
            DomainExtensionImpl domainObject = new DomainExtensionImpl(name, attributes, stateMachine.getParseInfo().getMimModel(), stateMachine.getParseInfo().getNextId());
            this.momRelationship.setDomain(domainObject);
            stateMachine.pushState(new DomainExtensionState(domainObject));
        }
    }

    private boolean isAssociationType(String elementName) {
        boolean isType = false;
        for (int i = 0; i < this.allPossibleAssociationTypes.length; ++i) {
            if (!elementName.equals(this.allPossibleAssociationTypes[i])) continue;
            isType = true;
            break;
        }
        return isType;
    }

    public void endElement(StateMachine stateMachine, String name) {
        if (name.equals(this.getReturnTag())) {
            this.momRelationship.synchronizeAssociationClassAttributes();
            stateMachine.popState();
        }
    }
}

