/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.mimparser.state;

import org.xml.sax.Attributes;
import se.ericsson.cello.mimparser.model.MomSequenceImpl;
import se.ericsson.cello.mimparser.state.LengthState;
import se.ericsson.cello.mimparser.state.MaxLengthState;
import se.ericsson.cello.mimparser.state.MinLengthState;
import se.ericsson.cello.mimparser.state.MomBaseState;
import se.ericsson.cello.mimparser.state.SeqDefaultValueState;
import se.ericsson.cello.mimparser.statemachine.StateMachine;

class SequenceState
extends MomBaseState {
    private MomSequenceImpl sequenceImpl;
    public static final String SEQUENCE_TAG = "sequence";

    public SequenceState(MomSequenceImpl sequenceImpl) {
        super(SEQUENCE_TAG);
        this.sequenceImpl = sequenceImpl;
    }

    public void startElement(StateMachine stateMachine, String name, Attributes attributes) {
        stateMachine.getDataTypeManager().handleDataTypes(this.sequenceImpl, name, attributes);
        if (name.equals("nonUnique")) {
            this.sequenceImpl.setAreElementsUnique(false);
        } else if (name.equals("ordered")) {
            this.sequenceImpl.setIsOrdered();
        } else if (name.equals("length")) {
            stateMachine.pushState(new LengthState(this.sequenceImpl));
        } else if (name.equals("maxLength")) {
            stateMachine.pushState(new MaxLengthState(this.sequenceImpl));
        } else if (name.equals("minLength")) {
            stateMachine.pushState(new MinLengthState(this.sequenceImpl));
        } else if (name.equals("seqDefaultValue")) {
            stateMachine.pushState(new SeqDefaultValueState(this.sequenceImpl));
        }
    }
}

