/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.cmaaue.precheck;

import se.ericsson.cello.ipoam.EthernetLinkMo;
import se.ericsson.cello.ipoam.IpAtmLinkMo;
import se.ericsson.cello.ipoam.IpHostLinkMo;
import se.ericsson.cello.ipoam.IpInterfaceBuildIF;
import se.ericsson.cello.ipoam.NetworkMask;
import se.ericsson.cello.iptransport.VpnInterfaceBuildIF;
import se.ericsson.cello.mao.IpAddress;
import se.ericsson.cello.mao.OperationNotAllowedException;
import se.ericsson.cello.moframework.ManagedObject;
import se.ericsson.cello.moframework.MoAccessException;
import se.ericsson.cello.moframework.MoIterator;
import se.ericsson.cello.moframework.Struct;
import se.ericsson.cello.transaction.Coordinator;

public class OamConfigValidationUtil {
    private static int selfPrefix;
    private static int linkPrefixLength;
    private static final int MAPPED_PREFIXLENGTH = 8;
    private static final int IP_ADDR = 0;
    private static final int SUBNET_ADDR = 1;

    public static void checkIpAdressUniqueness(ManagedObject managedObject, String string, int n, ManagedObject managedObject2, String string2, Coordinator coordinator) throws MoAccessException {
        MoIterator moIterator = managedObject.getChildren();
        ManagedObject managedObject3 = null;
        String string3 = null;
        selfPrefix = n;
        String[] stringArray = OamConfigValidationUtil.calculateSubnetandIpAddresses(string, n, coordinator);
        if (stringArray != null && !stringArray[1].equals("0.0.0.0")) {
            while (moIterator.hasMoreElements()) {
                String[] stringArray2;
                Object object;
                managedObject3 = moIterator.nextMo();
                if (managedObject2 != null && managedObject3 == managedObject2) continue;
                if (managedObject3.getType().equals("EthernetLink")) {
                    object = ((EthernetLinkMo)managedObject3).getIpv4Addresses(coordinator);
                    if (object == null || ((Struct[])object).length <= 0) continue;
                    string3 = (String)object[0].getValue("ipAddress");
                    linkPrefixLength = (Integer)object[0].getValue("prefixLength");
                    stringArray2 = OamConfigValidationUtil.calculateSubnetandIpAddresses(string3, linkPrefixLength, coordinator);
                    OamConfigValidationUtil.compareIpandSubnetAddresses(stringArray, stringArray2, managedObject3, managedObject2, string2);
                    continue;
                }
                if (managedObject3.getType().equals("IpHostLink")) {
                    string3 = ((IpHostLinkMo)managedObject3).getIpAddress(coordinator);
                    object = ((IpHostLinkMo)managedObject3).getIpInterfaceMoRef(coordinator);
                    linkPrefixLength = OamConfigValidationUtil.getNetworkPrefixLength(object, coordinator);
                    stringArray2 = OamConfigValidationUtil.calculateSubnetandIpAddresses(string3, linkPrefixLength, coordinator);
                    OamConfigValidationUtil.compareIpandSubnetAddresses(stringArray, stringArray2, managedObject3, managedObject2, string2);
                    continue;
                }
                if (!managedObject3.getType().equals("IpAtmLink")) continue;
                string3 = ((IpAtmLinkMo)managedObject3).getIpAddress(coordinator);
                object = ((IpAtmLinkMo)managedObject3).getSubnetMask(coordinator);
                linkPrefixLength = NetworkMask.calculateIpV4Prefix((String)object);
                stringArray2 = OamConfigValidationUtil.calculateSubnetandIpAddresses(string3, linkPrefixLength, coordinator);
                OamConfigValidationUtil.compareIpandSubnetAddresses(stringArray, stringArray2, managedObject3, managedObject2, string2);
            }
        }
    }

    private static String[] calculateSubnetandIpAddresses(String string, int n, Coordinator coordinator) throws MoAccessException {
        if (!string.equals("") && !string.equals("0.0.0.0")) {
            String[] stringArray = new String[2];
            IpAddress ipAddress = new IpAddress(string);
            IpAddress ipAddress2 = null;
            if (n == 0) {
                n = 8;
            }
            ipAddress2 = ipAddress.getSubnetAddress(n);
            stringArray[0] = string;
            stringArray[1] = ipAddress2.toString();
            return stringArray;
        }
        return null;
    }

    private static void compareIpandSubnetAddresses(String[] stringArray, String[] stringArray2, ManagedObject managedObject, ManagedObject managedObject2, String string) throws MoAccessException, OperationNotAllowedException {
        String string2 = "";
        if (stringArray2 != null) {
            long[] lArray = new long[3];
            long[] lArray2 = new long[3];
            IpAddress ipAddress = new IpAddress(stringArray[0]);
            IpAddress ipAddress2 = new IpAddress(stringArray2[0]);
            IpAddress ipAddress3 = new IpAddress(stringArray2[1]);
            IpAddress ipAddress4 = new IpAddress(stringArray[1]);
            IpAddress ipAddress5 = new IpAddress((long)IpAddress.getSubnetMask((int)linkPrefixLength));
            IpAddress ipAddress6 = new IpAddress((long)IpAddress.getSubnetMask((int)selfPrefix));
            lArray[0] = ipAddress.toLong();
            lArray[1] = ipAddress5.toLong();
            lArray[2] = ipAddress3.toLong();
            lArray2[0] = ipAddress2.toLong();
            lArray2[1] = ipAddress6.toLong();
            lArray2[2] = ipAddress4.toLong();
            if ((lArray[0] & lArray[1]) == lArray[2]) {
                if (managedObject2 != null) {
                    string2 = managedObject2.getRelativeDistinguishedName();
                }
                throw new OperationNotAllowedException(string + "Mo " + "(" + string2 + ") " + " ipAddress must not belong to the subnetwork of: " + managedObject.getLocalDistinguishedName(), managedObject.getType());
            }
            if ((lArray2[0] & lArray2[1]) == lArray2[2]) {
                if (managedObject2 != null) {
                    string2 = managedObject2.getLocalDistinguishedName();
                }
                throw new OperationNotAllowedException(managedObject.getType() + "Mo " + "(" + managedObject.getRelativeDistinguishedName() + ") " + "ipAddress must not belong to the subnetwork of: " + string2, string);
            }
        }
    }

    public static void checkIpAdressUniqueness(ManagedObject managedObject, String string, ManagedObject managedObject2, Coordinator coordinator, ManagedObject managedObject3, String string2) throws MoAccessException, OperationNotAllowedException {
        OamConfigValidationUtil.checkIpAdressUniqueness(managedObject, string, OamConfigValidationUtil.getNetworkPrefixLength(managedObject2, coordinator), managedObject3, string2, coordinator);
    }

    private static int getNetworkPrefixLength(ManagedObject managedObject, Coordinator coordinator) throws MoAccessException {
        int n = 8;
        if (managedObject instanceof IpInterfaceBuildIF) {
            n = ((IpInterfaceBuildIF)managedObject).getNetworkPrefixLength(coordinator);
        } else if (managedObject instanceof VpnInterfaceBuildIF) {
            n = ((VpnInterfaceBuildIF)managedObject).getNetworkPrefixLength(coordinator);
        }
        return n;
    }
}

