/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.equipment;

import se.ericsson.cello.equipment.CaxFanUnitMo;
import se.ericsson.cello.equipment.CaxFanUnitMoGen;
import se.ericsson.cello.equipment.SlotMo;
import se.ericsson.cello.equipment.SubrackMoImpl;
import se.ericsson.cello.indications.fropxy.MaoFroIndicationHandler;
import se.ericsson.cello.mao.AttrListImpl;
import se.ericsson.cello.mao.IllegalAttributeValueException;
import se.ericsson.cello.mao.Reservable;
import se.ericsson.cello.mao.SetRequestContext;
import se.ericsson.cello.maofro.framework.FroProxy;
import se.ericsson.cello.maofro.framework.Parameter;
import se.ericsson.cello.maofro.framework.SignedIntParameter;
import se.ericsson.cello.maofro.framework.StringParameter;
import se.ericsson.cello.moframework.AttrList;
import se.ericsson.cello.moframework.InitialMaoContext;
import se.ericsson.cello.moframework.ManagedObject;
import se.ericsson.cello.moframework.MoAccessException;
import se.ericsson.cello.moframework.MoData;
import se.ericsson.cello.moframework.MoIterator;
import se.ericsson.cello.moframework.MoNameAlreadyTakenException;
import se.ericsson.cello.moframework.MoNotFoundException;
import se.ericsson.cello.moframework.UndeletableMoException;
import se.ericsson.cello.transaction.Coordinator;

public class CaxFanUnitMoImpl
extends CaxFanUnitMoGen {
    private int subrackNr;
    private String position;
    private int connectedToBoard;

    public CaxFanUnitMoImpl(ManagedObject managedObject, AttrList attrList, String string, Coordinator coordinator, InitialMaoContext initialMaoContext, FroProxy froProxy, MaoFroIndicationHandler maoFroIndicationHandler) throws MoAccessException {
        super(coordinator, managedObject, string, froProxy, initialMaoContext, attrList, maoFroIndicationHandler);
    }

    public CaxFanUnitMoImpl(MoData moData, InitialMaoContext initialMaoContext, FroProxy froProxy, MaoFroIndicationHandler maoFroIndicationHandler) throws MoNameAlreadyTakenException {
        super(moData, initialMaoContext, froProxy, maoFroIndicationHandler);
    }

    public CaxFanUnitMoImpl(ManagedObject managedObject, AttrListImpl attrListImpl, String string, Coordinator coordinator, FroProxy froProxy, InitialMaoContext initialMaoContext, MaoFroIndicationHandler maoFroIndicationHandler) throws MoAccessException {
        super(coordinator, managedObject, string, froProxy, initialMaoContext, (AttrList)attrListImpl, maoFroIndicationHandler);
    }

    public void onCreate(SetRequestContext setRequestContext) throws MoAccessException {
        if (this.isLeftCax()) {
            this.position = "Left";
            this.connectedToBoard = 1;
        } else {
            this.position = "Right";
            this.connectedToBoard = 4;
        }
        this.subrackNr = ((SubrackMoImpl)this.getParent()).getSubrackNumber(setRequestContext.getCoordinator());
        setRequestContext.addParameter(this.froProxy, (Parameter)new SignedIntParameter("subrackNumber", this.subrackNr));
        setRequestContext.addParameter(this.froProxy, (Parameter)new StringParameter("position", this.position));
        setRequestContext.addParameter(this.froProxy, (Parameter)new SignedIntParameter("connectedToBoard", this.connectedToBoard));
        ManagedObject managedObject = CaxFanUnitMoImpl.findSlot(this.getParent(), this.connectedToBoard, setRequestContext.getCoordinator());
        ((Reservable)managedObject).reserve((ManagedObject)this, setRequestContext.getCoordinator());
    }

    private boolean isLeftCax() {
        MoIterator moIterator = this.getParent().getChildren();
        ManagedObject managedObject = null;
        int n = 0;
        while (moIterator != null && moIterator.hasMoreElements()) {
            managedObject = moIterator.nextMo();
            if (!(managedObject instanceof CaxFanUnitMo)) continue;
            ++n;
        }
        return n <= true;
    }

    public ManagedObject fetchConnectedToBoard(SignedIntParameter signedIntParameter, Coordinator coordinator) throws MoAccessException {
        String string = this.getPosition(coordinator);
        int n = 0;
        if (string.equalsIgnoreCase("Right")) {
            n = 4;
        } else if (string.equalsIgnoreCase("Left")) {
            n = 1;
        } else {
            throw new IllegalAttributeValueException("position is neither 'Left' nor 'Right'.", "CaxFanUnit");
        }
        return CaxFanUnitMoImpl.findSlot(this.getParent(), n, coordinator);
    }

    private static ManagedObject findSlot(ManagedObject managedObject, int n, Coordinator coordinator) throws MoAccessException {
        MoIterator moIterator = managedObject.getChildren();
        ManagedObject managedObject2 = null;
        while (moIterator != null && moIterator.hasMoreElements()) {
            managedObject2 = moIterator.nextMo();
            if (!(managedObject2 instanceof SlotMo) || ((SlotMo)managedObject2).getSlotPosition(coordinator) != n) continue;
            return managedObject2;
        }
        throw new MoNotFoundException("No Slot MO defined for Cax! ");
    }

    public void delete(Coordinator coordinator) throws MoAccessException {
        throw new UndeletableMoException((ManagedObject)this);
    }

    public void deleteMo(Coordinator coordinator) throws MoAccessException {
        this.data.handleTransaction(coordinator, MoData.WRITE_ACCESS);
        ((Reservable)this.getConnectedToBoard(coordinator)).release((ManagedObject)this, coordinator);
        super.delete(coordinator);
    }
}

