/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.equipment;

import enea.ose.system.Signal;
import enea.ose.system.UnlinkedSignal;
import java.util.ArrayList;
import java.util.TreeSet;
import se.ericsson.cello.common.fropxy.FroLockInd;
import se.ericsson.cello.common.fropxy.MoEventable;
import se.ericsson.cello.common.fropxy.MoNotifiable;
import se.ericsson.cello.equipment.AutoConfigurationAlarm;
import se.ericsson.cello.equipment.AutoCreateFanMoAccess;
import se.ericsson.cello.equipment.EquipException;
import se.ericsson.cello.equipment.EquipmentMoImpl;
import se.ericsson.cello.equipment.FanMo;
import se.ericsson.cello.equipment.FanMoInternal;
import se.ericsson.cello.equipment.PiuMoExtendImpl;
import se.ericsson.cello.equipment.PlugInUnitMo;
import se.ericsson.cello.equipment.PlugInUnitMoImpl;
import se.ericsson.cello.equipment.PlugNPlayListener;
import se.ericsson.cello.equipment.SlotMo;
import se.ericsson.cello.equipment.SubrackMo;
import se.ericsson.cello.equipment.SubrackMoImpl;
import se.ericsson.cello.equipment.SubrackProdTypeBuildIF;
import se.ericsson.cello.equipment.SubrackProdTypeMo;
import se.ericsson.cello.equipment.SwAllocationMarker;
import se.ericsson.cello.equipment.SwitchCoreUnitMarker;
import se.ericsson.cello.equipment.UpgradeRegistryBase;
import se.ericsson.cello.equipment.eqaccess.ProgramHandlerAccess;
import se.ericsson.cello.equipment.eqaccess.ProgramHandlerFactoryAccess;
import se.ericsson.cello.equipment.fropxy.OsaXpAutoLockInd;
import se.ericsson.cello.equipment.fropxy.OsaXpCreateCfm;
import se.ericsson.cello.equipment.fropxy.OsaXpDeleteCfm;
import se.ericsson.cello.equipment.fropxy.OsaXpGetAttributesRsp;
import se.ericsson.cello.equipment.fropxy.OsaXpMgmntProxy;
import se.ericsson.cello.equipment.fropxy.OsaXpNotifyInd;
import se.ericsson.cello.equipment.fropxy.OsaXpSetAdmStateCfm;
import se.ericsson.cello.equipment.fropxy.OsaXpSetAttributesCfm;
import se.ericsson.cello.equipment.intma.PiuTypeAccess;
import se.ericsson.cello.equipment.suaccess.FanMoAttributesInformation;
import se.ericsson.cello.equipment.suaccess.FanMoSU_Access;
import se.ericsson.cello.faultmanagement.AdditionalInfo;
import se.ericsson.cello.faultmanagement.AlarmManager;
import se.ericsson.cello.managedelement.ManagedElementDataMo;
import se.ericsson.cello.managedelement.MoDataRecoveryHelper;
import se.ericsson.cello.managedelement.suaccess.FroRequestFailedInformationException;
import se.ericsson.cello.managedelement.suaccess.SU_ConditionalException;
import se.ericsson.cello.mao.CelloMao;
import se.ericsson.cello.mao.ConvertWeekOfYearToDate;
import se.ericsson.cello.mao.IllegalAttributeValueException;
import se.ericsson.cello.mao.MoAttributeValidator;
import se.ericsson.cello.mao.MoReservedNotDeletableException;
import se.ericsson.cello.mao.ReservableImpl;
import se.ericsson.cello.mao.SingletonMoFactory;
import se.ericsson.cello.mao.UpgradeTrace;
import se.ericsson.cello.moframework.AttrList;
import se.ericsson.cello.moframework.Attribute;
import se.ericsson.cello.moframework.FroNotAccessibleException;
import se.ericsson.cello.moframework.FroRequestFailedException;
import se.ericsson.cello.moframework.IntegerAttribute;
import se.ericsson.cello.moframework.ManagedObject;
import se.ericsson.cello.moframework.MoAccessException;
import se.ericsson.cello.moframework.MoCanNotBeCreatedException;
import se.ericsson.cello.moframework.MoData;
import se.ericsson.cello.moframework.MoFactory;
import se.ericsson.cello.moframework.MoFactoryMgr;
import se.ericsson.cello.moframework.MoIterator;
import se.ericsson.cello.moframework.MoNameAlreadyTakenException;
import se.ericsson.cello.moframework.NotificationSender;
import se.ericsson.cello.moframework.ReferenceAttribute;
import se.ericsson.cello.moframework.SequenceAttribute;
import se.ericsson.cello.moframework.StringAttribute;
import se.ericsson.cello.moframework.Struct;
import se.ericsson.cello.moframework.StructImpl;
import se.ericsson.cello.moframework.ValueOutOfRangeException;
import se.ericsson.cello.moframework.WrongAttributeTypeException;
import se.ericsson.cello.productinventory.HardwareProductData;
import se.ericsson.cello.productinventory.ProductRepository;
import se.ericsson.cello.support.debug.MessageLog;
import se.ericsson.cello.support.servloc.ServiceLocatorFacade;
import se.ericsson.cello.support.servloc.ServiceRepository;
import se.ericsson.cello.transaction.Coordinator;
import se.ericsson.cello.transaction.InactiveTransactionException;
import se.ericsson.cello.transaction.Resource;
import se.ericsson.cello.util.library.Lib;

public class FanMoImpl
extends CelloMao
implements MoEventable,
MoNotifiable,
HardwareProductData,
FanMoInternal,
FanMoSU_Access,
FanMo,
PlugNPlayListener {
    private AutoConfigurationAlarm anAutoConfigurationAlarm = new AutoConfigurationAlarm();
    private static final String ATF_PRODUCT_NUMBER = "CXC1322166";
    private static final String DTF_PRODUCT_NUMBER = "CXC1724609";
    private MoData data;
    private StringAttribute userLabel;
    private SequenceAttribute connectedToScu;
    private ReferenceAttribute piuType;
    private IntegerAttribute hdlcAddress;
    private IntegerAttribute resourceId;
    private ReferenceAttribute firstScu;
    private ReferenceAttribute secondScu;
    private SequenceAttribute reservedBy;
    private String previousSerialNo = "";
    private String serialNo = "";
    private static final int RESTART_CAUSE_PIU_RESTART_UPGRADE = 2;
    private static final int RESTART_CAUSE_PIU_RESTART_ERROR = 1;
    private static final int CELLO_XP_OLD_FAN_MANAGEMENT = 1;
    private static final int CELLO_XP_NEW_FAN_MANAGEMENT = 2;
    private static final String RESOURCE_ID = "resourceId";
    private static final String PIU_RESTART_CAUSE_VALUE = "Restart cause value";
    private static final String[] PIU_TYPE_CLASSNAME = new String[]{"PiuType"};
    private static OsaXpMgmntProxy xpProxy = OsaXpMgmntProxy.instance();
    private PiuMoExtendImpl piuExtend = new PiuMoExtendImpl();
    private static NotificationSender myNotifSender = NotificationSender.instance();
    private Coordinator coordinator = null;
    private static final String[] SUPPORTED_VERSIONS = new String[]{"SU_1"};
    private static final int MO_DATA_REVISION_31 = 3000;
    private static final int MO_DATA_REVISION_311 = 3001;
    private static final int MO_DATA_REVISION_312 = 3002;
    private static final int MO_DATA_REVISION_7 = 7000;
    private static final int MO_DATA_REVISION_LATEST = 7000;

    public static synchronized ManagedObject create(ManagedObject managedObject, AttrList attrList, String string, ManagedObject managedObject2, Coordinator coordinator) throws MoAccessException {
        UpgradeTrace.debug((Class)FanMoImpl.class, (int)70, (String)"create( ManagedObject parent, AttrList attributes, String identity, ManagedObject source, Coordinator context )", (String)("parent: " + managedObject.getType() + "\n\tattributes: " + Lib.toString((AttrList)attrList) + "\n\tidentity: " + string + "\n\tsource: " + managedObject2 + "\n\tcontext: " + Lib.toString((Coordinator)coordinator)));
        MoAttributeValidator.checkTransaction((Coordinator)coordinator);
        MoAttributeValidator.checkIdentity((String)"Fan", (String)string);
        MoAttributeValidator.checkParent((ManagedObject)managedObject, (String)"Subrack");
        if (((SubrackMoImpl)managedObject).isEvoSubrack(coordinator)) {
            UpgradeTrace.debug((Class)FanMoImpl.class, (int)70, (String)"Trying to create a FanMO on an EVO subrack, not allowed\n\tEVO subrack uses PfmUnitMOs which are system created");
            throw new MoCanNotBeCreatedException("Fan Mo cannot be created because Fan confguration is EGEM2");
        }
        String string2 = MoAttributeValidator.checkAndGetStringAttributeWithLength((String)"userLabel", (AttrList)attrList, (boolean)false, (String)"", (String)"Fan", (int)128, (int)0);
        int n = MoAttributeValidator.checkAndGetIntegerAttribute((String)"administrativeState", (AttrList)attrList, (boolean)false, (int)0, (int)0, (int)2, (String)"Fan");
        ManagedObject managedObject3 = MoAttributeValidator.checkAndGetReferenceAttribute2((String)"piuType", (AttrList)attrList, (boolean)true, (String[])PIU_TYPE_CLASSNAME, (String)"Fan");
        int n2 = MoAttributeValidator.checkAndGetIntegerAttribute((String)"hdlcAddress", (AttrList)attrList, (boolean)false, (int)7, (int)1, (int)255, (String)"Fan");
        int n3 = MoAttributeValidator.checkAndGetIntegerAttribute((String)"fanNumber", (AttrList)attrList, (boolean)false, (int)FanMoImpl.calculateDefaultFanNumber(managedObject, coordinator), (int)1, (int)10, (String)"Fan");
        int n4 = MoAttributeValidator.checkAndGetIntegerAttribute((String)"highAirTempAlarmLimit", (AttrList)attrList, (boolean)false, (int)47, (int)25, (int)55, (String)"Fan");
        int n5 = MoAttributeValidator.checkAndGetIntegerAttribute((String)"criticalAirTempAlarmLimit", (AttrList)attrList, (boolean)false, (int)57, (int)35, (int)65, (String)"Fan");
        if (n5 <= n4 + 3) {
            throw new IllegalAttributeValueException("criticalAirTempAlarmLimit must be greater than highAirTempAlarmLimit + 3", "Fan");
        }
        FanMoImpl.checkCardinality(coordinator, (SubrackMo)managedObject);
        FanMoImpl.checkFanNumber(coordinator, managedObject, n3);
        MoAttributeValidator.checkOtherAttributes((AttrList)attrList, (String)"Fan");
        return new FanMoImpl(managedObject, string, n3, string2, n, managedObject3, n2, n4, n5, coordinator);
    }

    private FanMoImpl(ManagedObject managedObject, String string, int n, String string2, int n2, ManagedObject managedObject2, int n3, int n4, int n5, Coordinator coordinator) throws MoAccessException {
        super(managedObject, "Fan", string, coordinator);
        UpgradeTrace.debug(this.getClass(), (int)70, (String)"FanMoImpl( ManagedObject parent,String identity, int checkedfanNumber, String checkedUserLabel, int checkedAdministrativeState, ManagedObjectcheckedPiuType, int checkedHdlcAddress, int checkedHighTempLimit, int checkedCriticalTempLimit, Coordinator context )", (String)("parent: " + managedObject.getType() + "\n\tidentity: " + string + "\n\tfanNr: " + n + "\n\tuserL: " + string2 + "\n\tadmState: " + n2 + "\n\tpiuType: " + managedObject2 + "\n\thdlcAddr: " + n3 + "\n\tcheckedHighTempLimit: " + n4 + "\n\tcheckedCriticalTempLimit: " + n5 + "\n\tcontext: " + Lib.toString((Coordinator)coordinator)));
        ManagedObject managedObject3 = this.findScu(managedObject, 1, DTF_PRODUCT_NUMBER, coordinator);
        ManagedObject managedObject4 = this.findScu(managedObject, 28, DTF_PRODUCT_NUMBER, coordinator);
        if (managedObject3 == null && managedObject4 == null) {
            managedObject3 = this.findScu(managedObject, 1, ATF_PRODUCT_NUMBER, coordinator);
            managedObject4 = this.findScu(managedObject, 28, ATF_PRODUCT_NUMBER, coordinator);
        }
        if (managedObject3 == null && managedObject4 == null) {
            throw new EquipException("No SCU with ATF or DTF found");
        }
        long l = 0L;
        long l2 = 0L;
        this.firstScu = new ReferenceAttribute("", false, managedObject3);
        this.secondScu = new ReferenceAttribute("", false, managedObject4);
        if (managedObject3 == null && managedObject4 != null) {
            managedObject3 = managedObject4;
            managedObject4 = null;
            l = ((PlugInUnitMoImpl)managedObject3.getParent()).getResourceId(coordinator);
        } else if (managedObject3 != null) {
            l = ((PlugInUnitMoImpl)managedObject3.getParent()).getResourceId(coordinator);
            if (managedObject4 != null) {
                l2 = ((PlugInUnitMoImpl)managedObject4.getParent()).getResourceId(coordinator);
            }
        }
        if (l2 == 0L) {
            l2 = l;
        }
        if (!this.getAlarmLimitsSupported(coordinator)) {
            n4 = 47;
            n5 = 57;
        }
        this.data = new MoData(this.getLocalDistinguishedName(), this.getType(), true, coordinator);
        this.userLabel = new StringAttribute("userLabel", true, string2);
        this.data.registerPersistentAttr((Attribute)this.userLabel);
        this.reservedBy = new SequenceAttribute("reservedBy", false);
        this.data.registerPersistentAttr((Attribute)this.reservedBy);
        this.piuType = new ReferenceAttribute("piuType", true, managedObject2);
        this.data.registerPersistentAttr((Attribute)this.piuType);
        ((PiuTypeAccess)managedObject2).reserve(this, coordinator);
        this.hdlcAddress = new IntegerAttribute("hdlcAddress", false, n3);
        this.data.registerPersistentAttr((Attribute)this.hdlcAddress);
        this.connectedToScu = new SequenceAttribute("connectedToScu", false);
        this.connectedToScu.addElement((Attribute)this.firstScu);
        this.connectedToScu.addElement((Attribute)this.secondScu);
        this.data.registerPersistentAttr((Attribute)this.connectedToScu);
        OsaXpCreateCfm osaXpCreateCfm = xpProxy.sendOsaXpCreateReq(coordinator.getTransactionID(), n, l, l2, ((PiuTypeAccess)managedObject2).getProductNumber(coordinator), ((PiuTypeAccess)managedObject2).getProductRevision(coordinator), ((PiuTypeAccess)managedObject2).getProductName(coordinator), ((PiuTypeAccess)managedObject2).getProductionDate(coordinator), "", n3, n2, n4, n5);
        this.checkSignal((Signal)osaXpCreateCfm);
        if (osaXpCreateCfm.getResult() != 1) {
            String string3 = xpProxy.getResultMsg(osaXpCreateCfm.getResult());
            throw new FroRequestFailedException("Fan", " XP fRO ", "Create " + string3, osaXpCreateCfm.getResult());
        }
        int n6 = osaXpCreateCfm.getFroId();
        this.resourceId = new IntegerAttribute(RESOURCE_ID, false, n6);
        this.data.registerPersistentAttr((Attribute)this.resourceId);
        xpProxy.registerForNotifications(coordinator, this, n6);
        if (l == l2) {
            ((SwitchCoreUnitMarker)managedObject3).reserve(this, coordinator);
        } else {
            ((SwitchCoreUnitMarker)managedObject3).reserve(this, coordinator);
            ((SwitchCoreUnitMarker)managedObject4).reserve(this, coordinator);
        }
        ProductRepository.instance().registerHw((HardwareProductData)this, coordinator);
        EquipmentMoImpl.instance().actionTriggerLastHwPiChange(coordinator);
        this.data.setRevision(7000);
        ServiceRepository serviceRepository = ServiceLocatorFacade.getRepository();
        UpgradeRegistryBase upgradeRegistryBase = (UpgradeRegistryBase)serviceRepository.getService(UpgradeRegistryBase.class);
        upgradeRegistryBase.addPlugInUnitMoTypeName("Fan");
        this.data.handleTransaction(coordinator, MoData.WRITE_ACCESS);
    }

    public FanMoImpl(MoData moData) throws MoNameAlreadyTakenException {
        super(moData.getLocalDistinguishedName());
        UpgradeTrace.debug(this.getClass(), (int)70, (String)"FanMoImpl(MoData recoveredData)", (String)("recoveredData: " + moData));
        this.data = moData;
        MoDataRecoveryHelper moDataRecoveryHelper = new MoDataRecoveryHelper(this.data, (ManagedObject)this);
        moDataRecoveryHelper.assertMoDataRevision(7000);
        moDataRecoveryHelper.assertAttribute("userLabel");
        moDataRecoveryHelper.assertAttribute("connectedToScu");
        moDataRecoveryHelper.assertAttribute("piuType");
        moDataRecoveryHelper.assertAttribute("hdlcAddress");
        moDataRecoveryHelper.assertAttribute(RESOURCE_ID);
        moDataRecoveryHelper.assertAttribute("reservedBy");
        this.userLabel = (StringAttribute)moData.getAttribute("userLabel");
        this.connectedToScu = (SequenceAttribute)moData.getAttribute("connectedToScu");
        this.piuType = (ReferenceAttribute)moData.getAttribute("piuType");
        this.hdlcAddress = (IntegerAttribute)moData.getAttribute("hdlcAddress");
        this.resourceId = (IntegerAttribute)moData.getAttribute(RESOURCE_ID);
        this.reservedBy = (SequenceAttribute)moData.getAttribute("reservedBy");
        xpProxy.registerForNotifications(null, this, this.resourceId.getValue(null));
        ProductRepository.instance().registerHw((HardwareProductData)this);
        ServiceRepository serviceRepository = ServiceLocatorFacade.getRepository();
        UpgradeRegistryBase upgradeRegistryBase = (UpgradeRegistryBase)serviceRepository.getService(UpgradeRegistryBase.class);
        upgradeRegistryBase.addPlugInUnitMoTypeName("Fan");
    }

    public void delete(Coordinator coordinator) throws MoAccessException {
        UpgradeTrace.debug(this.getClass(), (int)70, (String)"delete(Coordinator context)", (String)("context: " + Lib.toString((Coordinator)coordinator)));
        this.data.handleTransaction(coordinator, MoData.WRITE_ACCESS);
        this.deleteChildren(coordinator);
        ManagedObject[] managedObjectArray = ReservableImpl.retrieveRefArrayFromSequence((SequenceAttribute)this.connectedToScu, (Coordinator)coordinator);
        for (int i = 0; i < managedObjectArray.length; ++i) {
            if (managedObjectArray[i] == null) continue;
            ((SwitchCoreUnitMarker)managedObjectArray[i]).release(this, coordinator);
        }
        if (this.getReservedBy(coordinator).length > 0) {
            throw new MoReservedNotDeletableException((ManagedObject)this);
        }
        OsaXpDeleteCfm osaXpDeleteCfm = xpProxy.sendOsaXpDeleteReq(coordinator.getTransactionID(), this.resourceId.getValue(coordinator));
        this.checkSignal((Signal)osaXpDeleteCfm);
        if (osaXpDeleteCfm.getResult() != 1) {
            String string = xpProxy.getResultMsg(osaXpDeleteCfm.getResult());
            throw new FroRequestFailedException("Fan", " XP fRO ", " Delete " + string, osaXpDeleteCfm.getResult());
        }
        PiuTypeAccess piuTypeAccess = (PiuTypeAccess)this.piuType.getValue(coordinator);
        if (piuTypeAccess != null) {
            piuTypeAccess.release(this, coordinator);
        }
        ProductRepository.instance().deregisterHw((HardwareProductData)this, coordinator);
        EquipmentMoImpl.instance().actionTriggerLastHwPiChange(coordinator);
        xpProxy.deregisterForNotifications(coordinator, this.resourceId.getValue(coordinator));
        this.data.delete(coordinator);
        super.delete(coordinator);
    }

    public String getUserLabel(Coordinator coordinator) throws MoAccessException {
        UpgradeTrace.debug(this.getClass(), (int)70, (String)"getUserLabel(Coordinator c)", (String)("c: " + Lib.toString((Coordinator)coordinator)));
        this.data.handleTransaction(coordinator, MoData.READ_ACCESS);
        return this.userLabel.getValue(coordinator);
    }

    public void setUserLabel(String string, Coordinator coordinator) throws MoAccessException {
        UpgradeTrace.debug(this.getClass(), (int)70, (String)"setUserLabel(String value, Coordinator c)", (String)("value: " + string + "\n\tc: " + Lib.toString((Coordinator)coordinator)));
        MoAttributeValidator.checkStringWithLength((String)string, (String)"userLabel", (String)"Fan", (int)128, (int)0);
        this.data.handleTransaction(coordinator, MoData.WRITE_ACCESS);
        this.userLabel.setValue(string);
    }

    public int getAdministrativeState(Coordinator coordinator) throws MoAccessException {
        UpgradeTrace.debug(this.getClass(), (int)70, (String)"getAdministrativeState(Coordinator c)", (String)("context: " + Lib.toString((Coordinator)coordinator)));
        this.data.handleTransaction(coordinator, MoData.READ_ACCESS);
        return this.getFroAttributes(coordinator).getAdministrativeState();
    }

    public void setAdministrativeState(int n, Coordinator coordinator) throws MoAccessException {
        UpgradeTrace.debug(this.getClass(), (int)70, (String)"setAdministrativeState(int value, Coordinator c)", (String)("admState: " + n + "\n\tcontext: " + Lib.toString((Coordinator)coordinator)));
        MoAttributeValidator.checkTransaction((Coordinator)coordinator);
        this.data.handleTransaction(coordinator, MoData.READ_ACCESS);
        if (n != 0 && n != 1 && n != 2) {
            throw new ValueOutOfRangeException("administrativeState", "Fan");
        }
        OsaXpSetAdmStateCfm osaXpSetAdmStateCfm = xpProxy.sendOsaXpSetAdmStateReq(coordinator.getTransactionID(), this.resourceId.getValue(coordinator), n);
        this.checkSignal((Signal)osaXpSetAdmStateCfm);
        if (osaXpSetAdmStateCfm.getResult() != 1) {
            String string = xpProxy.getResultMsg(osaXpSetAdmStateCfm.getResult());
            throw new FroRequestFailedInformationException("Fan", "XP fro", "setAdministrativeState " + string, osaXpSetAdmStateCfm.getResult());
        }
        String[] stringArray = new String[]{"administrativeState"};
        Object[] objectArray = new Object[]{new Integer(n)};
        NotificationSender.instance().pushAVC((ManagedObject)this, stringArray, objectArray, coordinator);
    }

    public ManagedObject[] getConnectedToScu(Coordinator coordinator) throws MoAccessException {
        UpgradeTrace.debug(this.getClass(), (int)70, (String)"getConnectedToScu(Coordinator c)", (String)("context: " + Lib.toString((Coordinator)coordinator)));
        this.data.handleTransaction(coordinator, MoData.READ_ACCESS);
        Attribute[] attributeArray = this.connectedToScu.getValue(coordinator);
        ManagedObject[] managedObjectArray = new ManagedObject[attributeArray.length];
        for (int i = 0; i < attributeArray.length; ++i) {
            managedObjectArray[i] = ((ReferenceAttribute)attributeArray[i]).getValue(coordinator);
        }
        return managedObjectArray;
    }

    public int getOperationalState(Coordinator coordinator) throws MoAccessException {
        UpgradeTrace.debug(this.getClass(), (int)70, (String)"getOperationalState(Coordinator c)", (String)("context: " + Lib.toString((Coordinator)coordinator)));
        this.data.handleTransaction(coordinator, MoData.READ_ACCESS);
        return this.getFroAttributes(coordinator).getOperationalState();
    }

    public int getAvailabilityStatus(Coordinator coordinator) throws MoAccessException {
        UpgradeTrace.debug(this.getClass(), (int)70, (String)"getAvailabilityStatus(Coordinator c)", (String)("context: " + Lib.toString((Coordinator)coordinator)));
        this.data.handleTransaction(coordinator, MoData.READ_ACCESS);
        return this.getFroAttributes(coordinator).getAvailStatus();
    }

    public ManagedObject getPiuType(Coordinator coordinator) throws MoAccessException {
        UpgradeTrace.debug(this.getClass(), (int)70, (String)"getPiuType(Coordinator c)", (String)("context: " + Lib.toString((Coordinator)coordinator)));
        this.data.handleTransaction(coordinator, MoData.READ_ACCESS);
        return this.piuType.getValue(coordinator);
    }

    public String getFanPosition(Coordinator coordinator) throws MoAccessException {
        this.data.handleTransaction(coordinator, MoData.READ_ACCESS);
        return this.getFroAttributes(coordinator).getFanPosition();
    }

    public int getYellowLed(Coordinator coordinator) throws MoAccessException {
        this.data.handleTransaction(coordinator, MoData.READ_ACCESS);
        return this.getFroAttributes(coordinator).getYellowLed();
    }

    public int getHighAirTempAlarmLimit(Coordinator coordinator) throws MoAccessException {
        this.data.handleTransaction(coordinator, MoData.READ_ACCESS);
        if (!this.getAlarmLimitsSupported(coordinator)) {
            return 47;
        }
        return this.getFroAttributes(coordinator).getHighAirTempAlarmLimit();
    }

    public void setHighAirTempAlarmLimit(int n, Coordinator coordinator) throws MoAccessException {
        MoAttributeValidator.checkTransaction((Coordinator)coordinator);
        this.data.handleTransaction(coordinator, MoData.READ_ACCESS);
        if (!this.getAlarmLimitsSupported(coordinator)) {
            return;
        }
        MoAttributeValidator.checkIntegerAttribute((String)"highAirTempAlarmLimit", (int)n, (int)25, (int)55, (String)"Fan");
        if (this.getCriticalAirTempAlarmLimit(coordinator) <= n + 3) {
            throw new IllegalAttributeValueException("criticalAirTempAlarmLimit must be greater than highAirTempAlarmLimit + 3", "Fan");
        }
        OsaXpGetAttributesRsp osaXpGetAttributesRsp = this.getFroAttributes(coordinator);
        this.setFanAttributes(coordinator, osaXpGetAttributesRsp.getAdministrativeState(), osaXpGetAttributesRsp.getAdmProductNumber(), osaXpGetAttributesRsp.getAdmProductRevision(), osaXpGetAttributesRsp.getAdmProductName(), osaXpGetAttributesRsp.getAdmProductDate(), osaXpGetAttributesRsp.getHdlcAddress(), n, osaXpGetAttributesRsp.getCriticalAirTempAlarmLimit());
        String[] stringArray = new String[]{"highAirTempAlarmLimit"};
        Object[] objectArray = new Object[]{new Integer(n)};
        NotificationSender.instance().pushAVC((ManagedObject)this, stringArray, objectArray, coordinator);
    }

    public int getCriticalAirTempAlarmLimit(Coordinator coordinator) throws MoAccessException {
        this.data.handleTransaction(coordinator, MoData.READ_ACCESS);
        if (!this.getAlarmLimitsSupported(coordinator)) {
            return 57;
        }
        return this.getFroAttributes(coordinator).getCriticalAirTempAlarmLimit();
    }

    public void setCriticalAirTempAlarmLimit(int n, Coordinator coordinator) throws MoAccessException {
        MoAttributeValidator.checkTransaction((Coordinator)coordinator);
        this.data.handleTransaction(coordinator, MoData.READ_ACCESS);
        if (!this.getAlarmLimitsSupported(coordinator)) {
            return;
        }
        MoAttributeValidator.checkIntegerAttribute((String)"criticalAirTempAlarmLimit", (int)n, (int)35, (int)65, (String)"Fan");
        if (n <= this.getHighAirTempAlarmLimit(coordinator) + 3) {
            throw new IllegalAttributeValueException("criticalAirTempAlarmLimit must be greater than highAirTempAlarmLimit + 3", "Fan");
        }
        OsaXpGetAttributesRsp osaXpGetAttributesRsp = this.getFroAttributes(coordinator);
        this.setFanAttributes(coordinator, osaXpGetAttributesRsp.getAdministrativeState(), osaXpGetAttributesRsp.getAdmProductNumber(), osaXpGetAttributesRsp.getAdmProductRevision(), osaXpGetAttributesRsp.getAdmProductName(), osaXpGetAttributesRsp.getAdmProductDate(), osaXpGetAttributesRsp.getHdlcAddress(), osaXpGetAttributesRsp.getHighAirTempAlarmLimit(), n);
        String[] stringArray = new String[]{"criticalAirTempAlarmLimit"};
        Object[] objectArray = new Object[]{new Integer(n)};
        NotificationSender.instance().pushAVC((ManagedObject)this, stringArray, objectArray, coordinator);
    }

    public int getFanNumber(Coordinator coordinator) throws MoAccessException {
        this.data.handleTransaction(coordinator, MoData.READ_ACCESS);
        return this.getFroAttributes(coordinator).getFanNumber();
    }

    public void setPiuType(ManagedObject managedObject, Coordinator coordinator) throws MoAccessException {
        UpgradeTrace.debug(this.getClass(), (int)70, (String)"setPiuType(ManagedObject value, Coordinator c)", (String)("piuType: " + managedObject + "\n\tcontext: " + Lib.toString((Coordinator)coordinator)));
        this.data.handleTransaction(coordinator, MoData.WRITE_ACCESS);
        if (managedObject == null || !(managedObject instanceof PiuTypeAccess)) {
            throw new WrongAttributeTypeException("piuType", "Fan");
        }
        if (managedObject.equals(this.piuType.getValue(coordinator))) {
            return;
        }
        PiuTypeAccess piuTypeAccess = (PiuTypeAccess)this.piuType.getValue(coordinator);
        this.piuType.setValue(managedObject);
        piuTypeAccess.release(this, coordinator);
        ((PiuTypeAccess)managedObject).reserve(this, coordinator);
        this.piuExtend.updateXpType(coordinator, managedObject, this);
    }

    public int getHdlcAddress(Coordinator coordinator) throws MoAccessException {
        UpgradeTrace.debug(this.getClass(), (int)70, (String)"getHdlcAddress(Coordinator c)", (String)("context: " + Lib.toString((Coordinator)coordinator)));
        this.data.handleTransaction(coordinator, MoData.READ_ACCESS);
        return this.hdlcAddress.getValue(coordinator);
    }

    public ManagedObject[] getReservedBy(Coordinator coordinator) throws MoAccessException {
        UpgradeTrace.debug(this.getClass(), (int)70, (String)"getReservedBy(Coordinator c)", (String)("context: " + Lib.toString((Coordinator)coordinator)));
        this.data.handleTransaction(coordinator, MoData.READ_ACCESS);
        ManagedObject[] managedObjectArray = ReservableImpl.retrieveRefArrayFromSequence((SequenceAttribute)this.reservedBy, (Coordinator)coordinator);
        return managedObjectArray;
    }

    public ManagedObject getActiveSwAllocation(Coordinator coordinator) throws MoAccessException {
        this.data.handleTransaction(coordinator, MoData.READ_ACCESS);
        ManagedObject managedObject = null;
        ManagedObject managedObject2 = this.getPiuType(coordinator);
        ManagedObject[] managedObjectArray = this.getSwAllocations(coordinator);
        if (managedObjectArray.length > 0 && managedObject2 != null) {
            AutoCreateFanMoAccess autoCreateFanMoAccess = (AutoCreateFanMoAccess)ServiceLocatorFacade.getRepository().getService(AutoCreateFanMoAccess.class);
            managedObject = autoCreateFanMoAccess.findSwAllocationWithPiuType(managedObject2, managedObjectArray, coordinator);
        }
        return managedObject;
    }

    public void reserve(ManagedObject managedObject, Coordinator coordinator) throws MoAccessException {
        MoFactory moFactory;
        ManagedElementDataMo managedElementDataMo;
        UpgradeTrace.debug(this.getClass(), (int)70, (String)"reserve( ManagedObject mo, Coordinator context )", (String)("userId: " + managedObject + "\n\tcontext: " + Lib.toString((Coordinator)coordinator)));
        this.reservedBy = ReservableImpl.reserve((ManagedObject)managedObject, (Coordinator)coordinator, (String)"Fan", (MoData)this.data, (SequenceAttribute)this.reservedBy);
        if (managedObject instanceof SwAllocationMarker && (managedElementDataMo = (ManagedElementDataMo)((SingletonMoFactory)(moFactory = MoFactoryMgr.instance().lookup("ManagedElementData"))).getMo()).getAutoConfigurationAllowed(coordinator)) {
            this.createChildren(coordinator);
            this.registerResource(coordinator);
        }
    }

    private synchronized void registerResource(Coordinator coordinator) {
        if (this.coordinator == null || !this.coordinator.isSameTransaction(coordinator)) {
            this.coordinator = coordinator;
            try {
                this.coordinator.registerResource((Resource)new ResourceAutoConfigFan());
            }
            catch (InactiveTransactionException inactiveTransactionException) {
                MessageLog.traceError(this.getClass(), (String)"registerResource failed due to an exception:", (Throwable)inactiveTransactionException);
            }
        }
    }

    public void release(ManagedObject managedObject, Coordinator coordinator) throws MoAccessException {
        UpgradeTrace.debug(this.getClass(), (int)70, (String)"release( ManagedObject mo, Coordinator context )", (String)("userId: " + managedObject + "\n\tcontext: " + Lib.toString((Coordinator)coordinator)));
        this.reservedBy = ReservableImpl.release((ManagedObject)managedObject, (Coordinator)coordinator, (String)"Fan", (MoData)this.data, (SequenceAttribute)this.reservedBy);
    }

    public void actionRestartFan(int n, Coordinator coordinator) throws MoAccessException {
        UpgradeTrace.debug(this.getClass(), (int)70, (String)"actionRestartFan(int restartCause, Coordinator c)", (String)("restartCause: " + n + "\n\tcontext: " + Lib.toString((Coordinator)coordinator)));
        MoAttributeValidator.checkTransaction((Coordinator)coordinator);
        this.data.handleTransaction(coordinator, MoData.WRITE_ACCESS);
        if (n != 2 && n != 1) {
            throw new ValueOutOfRangeException(PIU_RESTART_CAUSE_VALUE, "Fan");
        }
        this.sendRestartRequest(n, coordinator);
    }

    public void actionRestart(int n, int n2, Coordinator coordinator) throws MoAccessException {
        UpgradeTrace.debug(this.getClass(), (int)70, (String)"actionRestart(int restartRank, int restartCause, Coordinator c)", (String)("restartRank: " + n + "\n\trestartCause: " + n2 + "\n\tcontext: " + Lib.toString((Coordinator)coordinator)));
        this.actionRestartFan(n2, coordinator);
    }

    private void sendRestartRequest(int n, Coordinator coordinator) throws MoAccessException {
        UpgradeTrace.debug(this.getClass(), (int)70, (String)"sendRestartRequest(int restartCause, Coordinator c)", (String)("send restart request, resourceId: " + this.resourceId.getValue(coordinator) + ", restartCause: " + n));
        if (xpProxy.sendOsaXpRestartReq(this.resourceId.getValue(coordinator), n) == -1) {
            throw new FroNotAccessibleException("Fan", "XP resource not available");
        }
    }

    public void actionReconfigureProgramPrepare(Coordinator coordinator) throws MoAccessException {
        UpgradeTrace.debug(this.getClass(), (int)70, (String)"actionReconfigureProgramPrepare(Coordinator c)", (String)("context: " + Lib.toString((Coordinator)coordinator)));
        this.data.handleTransaction(coordinator, MoData.READ_ACCESS);
        ProgramHandlerFactoryAccess programHandlerFactoryAccess = (ProgramHandlerFactoryAccess)ServiceLocatorFacade.getRepository().getService(ProgramHandlerFactoryAccess.class);
        ProgramHandlerAccess programHandlerAccess = programHandlerFactoryAccess.getProgramHandlerAccess(this);
        programHandlerAccess.reconfigurePrograms(coordinator);
    }

    public void actionRemoveDisabledPrograms(Coordinator coordinator) throws MoAccessException {
        UpgradeTrace.debug(this.getClass(), (int)70, (String)"actionRemoveDisabledPrograms(Coordinator c)", (String)("context: " + Lib.toString((Coordinator)coordinator)));
        this.data.handleTransaction(coordinator, MoData.READ_ACCESS);
        ProgramHandlerFactoryAccess programHandlerFactoryAccess = (ProgramHandlerFactoryAccess)ServiceLocatorFacade.getRepository().getService(ProgramHandlerFactoryAccess.class);
        ProgramHandlerAccess programHandlerAccess = programHandlerFactoryAccess.getProgramHandlerAccess(this);
        programHandlerAccess.removeDisabledPrograms(coordinator);
    }

    public String getType() {
        return "Fan";
    }

    public Struct getOperationalProductData(Coordinator coordinator) throws MoAccessException {
        this.data.handleTransaction(coordinator, MoData.READ_ACCESS);
        Object[] objectArray = new Object[5];
        String[] stringArray = new String[5];
        objectArray[0] = this.getFroAttributes(coordinator).getOpProductDate();
        stringArray[0] = "productionDate";
        objectArray[1] = this.getFroAttributes(coordinator).getOpProductName();
        stringArray[1] = "productName";
        objectArray[2] = this.getFroAttributes(coordinator).getOpProductNumber();
        stringArray[2] = "productNumber";
        objectArray[3] = this.getFroAttributes(coordinator).getOpProductRevision();
        stringArray[3] = "productRevision";
        objectArray[4] = this.getFroAttributes(coordinator).getOpSerialNumber();
        stringArray[4] = "serialNumber";
        return new StructImpl(stringArray, objectArray);
    }

    public void setPiuTypeForSwUpgrade(ManagedObject managedObject, Coordinator coordinator) throws MoAccessException {
        UpgradeTrace.debug(this.getClass(), (int)70, (String)"setPiuTypeForSwUpgrade( ManagedObject value, Coordinator c )", (String)("value: " + managedObject + "\n\tcontext: " + Lib.toString((Coordinator)coordinator)));
        this.data.handleTransaction(coordinator, MoData.WRITE_ACCESS);
        PiuTypeAccess piuTypeAccess = (PiuTypeAccess)this.piuType.getValue(coordinator);
        this.piuType.setValue(managedObject);
        if (piuTypeAccess != null) {
            piuTypeAccess.release(this, coordinator);
        }
        if (managedObject != null) {
            ((PiuTypeAccess)managedObject).reserve(this, coordinator);
        }
    }

    private void createChildren(Coordinator coordinator) throws MoAccessException {
        this.piuExtend.createSubordinates(coordinator, this, null);
    }

    private void deleteChildren(Coordinator coordinator) throws MoAccessException {
        this.piuExtend.deleteSubordinates(coordinator, this);
    }

    public void setAdministrativeStateSwitch(int n, int n2, Coordinator coordinator) throws MoAccessException {
        UpgradeTrace.debug(this.getClass(), (int)70, (String)"setAdministrativeStateSwitch( int admState,int switchAtLock, Coordinator context ) ", (String)("admState: " + n + "\n\tswitchAtLock: " + n2 + "\n\tcontext: " + Lib.toString((Coordinator)coordinator)));
        this.setAdministrativeState(n, coordinator);
    }

    public int getResourceId(Coordinator coordinator) throws MoAccessException {
        UpgradeTrace.debug(this.getClass(), (int)70, (String)"getResourceId(Coordinator c)", (String)("context: " + Lib.toString((Coordinator)coordinator)));
        this.data.handleTransaction(coordinator, MoData.READ_ACCESS);
        return this.resourceId.getValue(coordinator);
    }

    public ManagedObject getSwAllocation(Coordinator coordinator) throws MoAccessException {
        UpgradeTrace.debug(this.getClass(), (int)70, (String)"getSwAllocation(Coordinator c)", (String)("context: " + Lib.toString((Coordinator)coordinator)));
        return this.getActiveSwAllocation(coordinator);
    }

    public ManagedObject[] getSwAllocations(Coordinator coordinator) throws MoAccessException {
        UpgradeTrace.debug(this.getClass(), (int)70, (String)"getSwAllocations(Coordinator context)", (String)("context: " + Lib.toString((Coordinator)coordinator)));
        ArrayList<ManagedObject> arrayList = new ArrayList<ManagedObject>();
        ManagedObject[] managedObjectArray = this.getReservedBy(coordinator);
        if (managedObjectArray != null) {
            for (int i = 0; i < managedObjectArray.length; ++i) {
                if (!(managedObjectArray[i] instanceof SwAllocationMarker)) continue;
                arrayList.add(managedObjectArray[i]);
            }
        }
        return arrayList.toArray(new ManagedObject[0]);
    }

    public boolean getAlarmLimitsSupported(Coordinator coordinator) throws MoAccessException {
        SubrackMo subrackMo = (SubrackMo)this.getParent();
        SubrackProdTypeBuildIF subrackProdTypeBuildIF = (SubrackProdTypeBuildIF)subrackMo.getSubrackProdTypeRef(coordinator);
        if (subrackProdTypeBuildIF == null) {
            return false;
        }
        int n = subrackProdTypeBuildIF.getFanConfiguration(coordinator);
        return n == 2 || n == 3;
    }

    public void setShutDownTimer(int n, Coordinator coordinator) throws MoAccessException {
        UpgradeTrace.debug(this.getClass(), (int)70, (String)"setShutDownTimer(int value, Coordinator c)", (String)("value: " + n + "\n\tcontext: " + Lib.toString((Coordinator)coordinator)));
    }

    public int getShutDownTimer(Coordinator coordinator) throws MoAccessException {
        UpgradeTrace.debug(this.getClass(), (int)70, (String)"getShutDownTimer(Coordinator c)", (String)("context: " + Lib.toString((Coordinator)coordinator)));
        return 0;
    }

    public void raiseAutoConfigurationAlarm(AdditionalInfo[] additionalInfoArray) {
        this.anAutoConfigurationAlarm.raiseAlarm(additionalInfoArray, this);
    }

    public void clearAutoConfigurationAlarm() {
        if (AlarmManager.getReporter().getActiveAlarm(7, (ManagedObject)this) != null) {
            this.anAutoConfigurationAlarm.clearAlarm(this);
        }
    }

    public void eventRaised(UnlinkedSignal unlinkedSignal, String string) {
        if (unlinkedSignal instanceof OsaXpNotifyInd) {
            try {
                OsaXpNotifyInd osaXpNotifyInd = (OsaXpNotifyInd)unlinkedSignal;
                this.dispatchProductData(osaXpNotifyInd.getOpProductNumber(), osaXpNotifyInd.getOpProductRevision(), osaXpNotifyInd.getOpSerialNumber());
                EquipmentMoImpl.instance().actionTriggerLastHwPiChange(null);
            }
            catch (Throwable throwable) {
                UpgradeTrace.error(this.getClass(), (String)"eventRaised()", (String)("Auto configuration of Fan failed: " + this.getLocalDistinguishedName()), (Throwable)throwable);
            }
        } else {
            MessageLog.info(this.getClass(), (String)("Unexpected signal: " + unlinkedSignal.getSigNo() + " received from sender: " + unlinkedSignal.getSender()));
        }
    }

    public void startAutoConfiguration() {
        try {
            this.dispatchProductData(this.getProductNumber(null), this.getRState(null), this.getSerialNumber(null));
        }
        catch (Throwable throwable) {
            UpgradeTrace.error(this.getClass(), (String)"startAutoConfiguration()", (String)("Auto configuration of Fan failed: " + this.getLocalDistinguishedName()), (Throwable)throwable);
        }
    }

    private synchronized void dispatchProductData(String string, String string2, String string3) throws Exception {
        if (this.checkProductData(string, string2)) {
            this.savePreviousSerialNumber(string3);
            AutoCreateFanMoAccess autoCreateFanMoAccess = (AutoCreateFanMoAccess)ServiceLocatorFacade.getRepository().getService(AutoCreateFanMoAccess.class);
            autoCreateFanMoAccess.create(string, string2, string3, this);
        }
    }

    private boolean checkProductData(String string, String string2) throws MoAccessException {
        if (string == null || string.equals("")) {
            UpgradeTrace.debug(this.getClass(), (int)72, (String)"checkProductData()", (String)"Auto configuration started with empty productNumber, the data will be discarded.");
            return false;
        }
        if (string2 == null || string2.equals("")) {
            UpgradeTrace.debug(this.getClass(), (int)72, (String)"checkProductData()", (String)"Auto configuration started with empty productRevision, the data will be discarded.");
            return false;
        }
        return true;
    }

    private void savePreviousSerialNumber(String string) {
        this.previousSerialNo = this.serialNo.equals("") ? string : this.serialNo;
        this.serialNo = string;
    }

    public String getPreviousSerialNo() {
        return this.previousSerialNo;
    }

    public String getProductionDate(Coordinator coordinator) throws MoAccessException {
        UpgradeTrace.debug(this.getClass(), (int)70, (String)"getProductionDate(Coordinator context)", (String)("context: " + Lib.toString((Coordinator)coordinator)));
        this.data.handleTransaction(coordinator, MoData.READ_ACCESS);
        String string = this.getFroAttributes(coordinator).getOpProductDate();
        if (string.length() == 8) {
            return string;
        }
        return ConvertWeekOfYearToDate.weekOfYearToDate((String)string);
    }

    public String getSerialNumber(Coordinator coordinator) throws MoAccessException {
        UpgradeTrace.debug(this.getClass(), (int)70, (String)"getSerialNumber(Coordinator context)", (String)("context: " + Lib.toString((Coordinator)coordinator)));
        this.data.handleTransaction(coordinator, MoData.READ_ACCESS);
        return this.getFroAttributes(coordinator).getOpSerialNumber();
    }

    public String getSubrackId(Coordinator coordinator) throws MoAccessException {
        UpgradeTrace.debug(this.getClass(), (int)70, (String)"getSubrackId(Coordinator context)", (String)("context: " + Lib.toString((Coordinator)coordinator)));
        this.data.handleTransaction(coordinator, MoData.READ_ACCESS);
        SubrackMoImpl subrackMoImpl = (SubrackMoImpl)this.getParent();
        return subrackMoImpl.getSubrackPosition(coordinator);
    }

    public String[] getSupportedVersions() {
        return SUPPORTED_VERSIONS;
    }

    public String[] getCurrentlySupportedVersions() throws SU_ConditionalException {
        return this.getSupportedVersions();
    }

    public int getSlotPosition(Coordinator coordinator) throws MoAccessException {
        UpgradeTrace.debug(this.getClass(), (int)70, (String)"getSlotPosition(Coordinator context)", (String)("context: " + Lib.toString((Coordinator)coordinator)));
        return 0;
    }

    public String getProductName(Coordinator coordinator) throws MoAccessException {
        UpgradeTrace.debug(this.getClass(), (int)70, (String)"getProductName(Coordinator context)", (String)("context: " + Lib.toString((Coordinator)coordinator)));
        this.data.handleTransaction(coordinator, MoData.READ_ACCESS);
        return this.getFroAttributes(coordinator).getOpProductName();
    }

    public String getProductNumber(Coordinator coordinator) throws MoAccessException {
        UpgradeTrace.debug(this.getClass(), (int)70, (String)"getProductNumber(Coordinator context)", (String)("context: " + Lib.toString((Coordinator)coordinator)));
        this.data.handleTransaction(coordinator, MoData.READ_ACCESS);
        return this.getFroAttributes(coordinator).getOpProductNumber();
    }

    public String getRState(Coordinator coordinator) throws MoAccessException {
        UpgradeTrace.debug(this.getClass(), (int)70, (String)"getRState(Coordinator context)", (String)("context: " + Lib.toString((Coordinator)coordinator)));
        this.data.handleTransaction(coordinator, MoData.READ_ACCESS);
        return this.getFroAttributes(coordinator).getOpProductRevision();
    }

    public FanMoAttributesInformation getFanAttributesInformation(Coordinator coordinator) throws MoAccessException {
        UpgradeTrace.debug(this.getClass(), (int)70, (String)"getFanAttributesInformation ( Coordinator aCoordinator )", (String)("aCoordinator: " + Lib.toString((Coordinator)coordinator)));
        OsaXpGetAttributesRsp osaXpGetAttributesRsp = this.getFroAttributes(coordinator);
        return new FanMoAttributesInformation(osaXpGetAttributesRsp.getHdlcAddress(), osaXpGetAttributesRsp.getAdministrativeState(), osaXpGetAttributesRsp.getHighAirTempAlarmLimit(), osaXpGetAttributesRsp.getCriticalAirTempAlarmLimit());
    }

    public void setFanAttributes(Coordinator coordinator, int n, String string, String string2, String string3, String string4, int n2, int n3, int n4) throws MoAccessException {
        OsaXpSetAttributesCfm osaXpSetAttributesCfm = xpProxy.sendOsaXpSetAttributesReq(MoAttributeValidator.getTransactionId((Coordinator)coordinator), this.resourceId.getValue(coordinator), n, string, string2, string3, string4, n2, n3, n4);
        this.checkSignal((Signal)osaXpSetAttributesCfm);
        if (osaXpSetAttributesCfm.getResult() != 1) {
            String string5 = xpProxy.getResultMsg(osaXpSetAttributesCfm.getResult());
            throw new FroRequestFailedException("Fan", "XP Fro", "setFanAttributes " + string5, osaXpSetAttributesCfm.getResult());
        }
    }

    public int getInvalidAdmStateValue() {
        return 11;
    }

    private void checkSignal(Signal signal) throws FroNotAccessibleException {
        UpgradeTrace.debug(this.getClass(), (int)70, (String)"checkSignal(enea.ose.system.Signal sig)", (String)("sig: " + signal));
        if (signal == null) {
            throw new FroNotAccessibleException("Fan", "Resource fRo is not accessible.");
        }
    }

    private OsaXpGetAttributesRsp getFroAttributes(Coordinator coordinator) throws MoAccessException {
        UpgradeTrace.debug(this.getClass(), (int)70, (String)"getFroAttributes(Coordinator c)", (String)("context: " + Lib.toString((Coordinator)coordinator)));
        this.data.handleTransaction(coordinator, MoData.READ_ACCESS);
        OsaXpGetAttributesRsp osaXpGetAttributesRsp = xpProxy.sendOsaXpGetAttributesReq(MoAttributeValidator.getTransactionId((Coordinator)coordinator), this.resourceId.getValue(coordinator));
        this.checkSignal((Signal)osaXpGetAttributesRsp);
        if (osaXpGetAttributesRsp.getResult() != 1) {
            String string = xpProxy.getResultMsg(osaXpGetAttributesRsp.getResult());
            throw new FroRequestFailedException("Fan", "XP Fro", "getFroAttributes " + string, osaXpGetAttributesRsp.getResult());
        }
        return osaXpGetAttributesRsp;
    }

    private ManagedObject findScu(ManagedObject managedObject, int n, String string, Coordinator coordinator) {
        ManagedObject managedObject2;
        UpgradeTrace.debug(this.getClass(), (int)70, (String)"findScu(ManagedObject subrackMo, int slotPosition, String productNumber, Coordinator c)", (String)("subrackMo" + managedObject + "\n\tslotPosition" + n + "\n\tcontext: " + Lib.toString((Coordinator)coordinator)));
        SlotMo slotMo = null;
        MoIterator moIterator = managedObject.getChildren();
        while (moIterator.hasMoreElements()) {
            managedObject2 = moIterator.nextMo();
            try {
                if (!(managedObject2 instanceof SlotMo) || ((SlotMo)managedObject2).getSlotNumber(coordinator) != n) continue;
                slotMo = (SlotMo)managedObject2;
                break;
            }
            catch (MoAccessException moAccessException) {
            }
        }
        if (slotMo == null) {
            return null;
        }
        managedObject2 = slotMo.getChildren();
        if (!managedObject2.hasMoreElements()) {
            return null;
        }
        PlugInUnitMo plugInUnitMo = (PlugInUnitMo)managedObject2.nextMo();
        if (plugInUnitMo == null) {
            return null;
        }
        MoIterator moIterator2 = plugInUnitMo.getChildren();
        ManagedObject managedObject3 = null;
        while (moIterator2.hasMoreElements()) {
            ManagedObject managedObject4 = moIterator2.nextMo();
            if (!(managedObject4 instanceof SwitchCoreUnitMarker)) continue;
            managedObject3 = managedObject4;
            break;
        }
        return managedObject3;
    }

    public synchronized void parameterChanged(FroLockInd froLockInd, String string) {
        UpgradeTrace.debug(this.getClass(), (int)70, (String)"parameterChanged(UnlinkedSignal inSig, String proxy)", (String)("inSig" + froLockInd.getSigNo() + "\n\tproxy" + string));
        if (froLockInd instanceof OsaXpAutoLockInd) {
            String[] stringArray = new String[]{"administrativeState"};
            Object[] objectArray = new Object[]{new Integer(0)};
            myNotifSender.pushAVC((ManagedObject)this, stringArray, objectArray);
        }
    }

    private static void checkCardinality(Coordinator coordinator, SubrackMo subrackMo) throws MoAccessException {
        int n = 0;
        SubrackProdTypeMo subrackProdTypeMo = (SubrackProdTypeMo)subrackMo.getSubrackProdTypeRef(coordinator);
        int n2 = subrackMo.getNumberOfDenibDevices(coordinator);
        int n3 = subrackProdTypeMo.getFanConfiguration(coordinator);
        if (n2 != -1) {
            n = n2 == 0 ? 10 : n2;
        } else {
            if (n3 == 0) {
                throw new MoCanNotBeCreatedException("Fan, Configuration of a Fan is not allowed according to given fanConfiguration");
            }
            n = n3 == 1 || n3 == 2 ? 1 : 2;
        }
        MoAttributeValidator.checkNoOfSiblings((ManagedObject)subrackMo, (String)"Fan", (int)n);
    }

    private static void checkFanNumber(Coordinator coordinator, ManagedObject managedObject, int n) throws MoAccessException {
        MoIterator moIterator = managedObject.getChildren();
        while (moIterator.hasMoreElements()) {
            ManagedObject managedObject2 = (ManagedObject)moIterator.nextElement();
            if (!(managedObject2 instanceof FanMo) || ((FanMo)managedObject2).getFanNumber(coordinator) != n) continue;
            throw new IllegalAttributeValueException("Fan MO already configured at fanNumber: " + n, "fanNumber", "Fan");
        }
    }

    private static int calculateDefaultFanNumber(ManagedObject managedObject, Coordinator coordinator) throws MoAccessException {
        int n = 1;
        TreeSet<Integer> treeSet = new TreeSet<Integer>();
        MoIterator moIterator = managedObject.getChildren();
        while (moIterator.hasMoreElements()) {
            ManagedObject managedObject2 = (ManagedObject)moIterator.nextElement();
            if (!(managedObject2 instanceof FanMo)) continue;
            treeSet.add(new Integer(((FanMo)managedObject2).getFanNumber(coordinator)));
        }
        for (int i = 1; i < 10; ++i) {
            if (!treeSet.contains(new Integer(n))) {
                return n;
            }
            ++n;
        }
        return n;
    }

    private class ResourceAutoConfigFan
    implements Resource,
    Runnable {
        private static final String THREAD_NAME = "Cma_Fan_Restart_Thread";

        public void commit() {
            Thread thread = new Thread((Runnable)this, THREAD_NAME);
            thread.start();
            FanMoImpl.this.coordinator = null;
        }

        public boolean prepare() {
            return true;
        }

        public void rollback() {
            FanMoImpl.this.coordinator = null;
        }

        public void run() {
            try {
                FanMoImpl.this.sendRestartRequest(2, null);
            }
            catch (Throwable throwable) {
                UpgradeTrace.error(this.getClass(), (String)"run()", (String)("Failed to order restart of this Fan: " + this), (Throwable)throwable);
            }
        }
    }
}

