/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.session;

import enea.ose.system.OseProcess;
import se.ericsson.cello.session.ServiceSubscriber;
import se.ericsson.cello.support.debug.MessageLog;
import se.ericsson.cello.support.sigutil.OseNameServer;
import se.ericsson.cello.support.sigutil.SubscriptionObserver;

public class NameServerWrapper
implements SubscriptionObserver {
    private static final int TRACEGROUP = 5;
    private String serviceName = "";
    private OseProcess oldPid = null;
    private ServiceSubscriber serviceSubscriber;

    public NameServerWrapper(String string, ServiceSubscriber serviceSubscriber) {
        this.serviceName = string;
        this.serviceSubscriber = serviceSubscriber;
        OseNameServer.addSubscriptionObserver((String)string, (SubscriptionObserver)this);
    }

    public void serviceAdded(String string) {
        try {
            MessageLog.trace((int)5, this.getClass(), (String)("serviceAdded = " + string + ", this.serviceName = " + this.serviceName));
            OseProcess oseProcess = OseNameServer.lookup((String)string);
            MessageLog.trace((int)5, this.getClass(), (String)("serviceAdded(): newPid=" + oseProcess + ", oldPid=" + this.oldPid));
            if (oseProcess == null) {
                if (this.oldPid != null) {
                    this.serviceSubscriber.serviceRemoved();
                    this.oldPid = null;
                }
            } else if (this.oldPid == null) {
                this.serviceSubscriber.serviceAdded();
                this.oldPid = oseProcess;
            } else if (this.oldPid.equals((Object)oseProcess)) {
                this.serviceSubscriber.serviceRemoved();
                this.serviceSubscriber.serviceAdded();
            } else if (!this.oldPid.equals((Object)oseProcess)) {
                this.serviceSubscriber.serviceRemoved();
                this.serviceSubscriber.serviceAdded();
                this.oldPid = oseProcess;
            }
        }
        catch (RuntimeException runtimeException) {
            MessageLog.traceError(this.getClass(), (String)"serviceAdded() caught runtime exception!", (Throwable)runtimeException);
        }
    }

    public void serviceRemoved(String string) {
        try {
            OseProcess oseProcess = OseNameServer.lookup((String)string);
            MessageLog.trace((int)5, this.getClass(), (String)("serviceRemoved(): newPid=" + oseProcess + ", oldPid=" + this.oldPid));
            if (oseProcess == null) {
                MessageLog.trace((int)5, this.getClass(), (String)("serviceRemoved = " + string + " currentOseProcessForFRO == null"));
                this.serviceSubscriber.serviceRemoved();
                this.oldPid = null;
            } else if (!oseProcess.equals((Object)this.oldPid) && !oseProcess.equals((Object)this.oldPid) && this.oldPid != null) {
                MessageLog.trace((int)5, this.getClass(), (String)("serviceRemoved = " + string + " newPid != oldPid"));
                this.serviceSubscriber.serviceRemoved();
                this.oldPid = null;
            }
        }
        catch (RuntimeException runtimeException) {
            MessageLog.traceError(this.getClass(), (String)"serviceRemoved() caught runtime exception!", (Throwable)runtimeException);
        }
    }

    public OseProcess lookup() {
        return OseNameServer.lookup((String)this.serviceName);
    }

    public String getServiceName() {
        return this.serviceName;
    }
}

