package org.conscrypt;

import java.util.HashSet;
import java.util.Set;

public final class EricssonCiphers {

	private static final Set ERICSSON_CIPHERS = new HashSet();
	
	
	public static boolean supported(final String cipher) {
		return ERICSSON_CIPHERS.contains(cipher);
	}

	static {
		ERICSSON_CIPHERS.add("TLS_DH_anon_WITH_SEED_CBC_SHA");
		ERICSSON_CIPHERS.add("TLS_DH_anon_WITH_CAMELLIA_128_CBC_SHA");
		ERICSSON_CIPHERS.add("TLS_ECDH_RSA_WITH_AES_128_GCM_SHA256");
		ERICSSON_CIPHERS.add("TLS_ECDH_ECDSA_WITH_AES_128_GCM_SHA256");
		ERICSSON_CIPHERS.add("TLS_ECDH_RSA_WITH_AES_128_CBC_SHA256");
		ERICSSON_CIPHERS.add("TLS_ECDH_ECDSA_WITH_AES_128_CBC_SHA256");
		ERICSSON_CIPHERS.add("TLS_ECDH_RSA_WITH_AES_128_CBC_SHA");
		ERICSSON_CIPHERS.add("TLS_ECDH_ECDSA_WITH_AES_128_CBC_SHA");
		ERICSSON_CIPHERS.add("TLS_RSA_WITH_AES_128_GCM_SHA256");
		ERICSSON_CIPHERS.add("TLS_RSA_WITH_AES_128_CBC_SHA256");
		ERICSSON_CIPHERS.add("TLS_RSA_WITH_AES_128_CBC_SHA");
		ERICSSON_CIPHERS.add("TLS_RSA_WITH_SEED_CBC_SHA");
		ERICSSON_CIPHERS.add("TLS_RSA_WITH_CAMELLIA_128_CBC_SHA");
		ERICSSON_CIPHERS.add("TLS_PSK_WITH_AES_128_CBC_SHA");
		ERICSSON_CIPHERS.add("TLS_ECDHE_RSA_WITH_RC4_128_SHA");
		ERICSSON_CIPHERS.add("TLS_ECDHE_ECDSA_WITH_RC4_128_SHA");
		ERICSSON_CIPHERS.add("TLS_ECDH_anon_WITH_RC4_128_SHA");
		ERICSSON_CIPHERS.add("TLS_DH_anon_WITH_RC4_128_MD5");
		ERICSSON_CIPHERS.add("TLS_ECDH_RSA_WITH_RC4_128_SHA");
		ERICSSON_CIPHERS.add("TLS_ECDH_ECDSA_WITH_RC4_128_SHA");
		ERICSSON_CIPHERS.add("TLS_RSA_WITH_RC4_128_SHA");
		ERICSSON_CIPHERS.add("SSL_CK_RC4_128_WITH_MD5");
		ERICSSON_CIPHERS.add("TLS_PSK_WITH_RC4_128_SHA");
		ERICSSON_CIPHERS.add("TLS_ECDHE_RSA_WITH_3DES_EDE_CBC_SHA");
		ERICSSON_CIPHERS.add("TLS_ECDHE_ECDSA_WITH_3DES_EDE_CBC_SHA");
		ERICSSON_CIPHERS.add("TLS_SRP_SHA_DSS_WITH_3DES_EDE_CBC_SHA");
		ERICSSON_CIPHERS.add("TLS_SRP_SHA_RSA_WITH_3DES_EDE_CBC_SHA");
		ERICSSON_CIPHERS.add("TLS_SRP_SHA_WITH_3DES_EDE_CBC_SHA");
		ERICSSON_CIPHERS.add("TLS_DHE_RSA_WITH_3DES_EDE_CBC_SHA");
		ERICSSON_CIPHERS.add("TLS_DHE_DSS_WITH_3DES_EDE_CBC_SHA");
		ERICSSON_CIPHERS.add("TLS_DH_RSA_WITH_3DES_EDE_CBC_SHA");
		ERICSSON_CIPHERS.add("TLS_DH_DSS_WITH_3DES_EDE_CBC_SHA");
		ERICSSON_CIPHERS.add("TLS_ECDH_anon_WITH_3DES_EDE_CBC_SHA");
		ERICSSON_CIPHERS.add("TLS_DH_anon_WITH_3DES_EDE_CBC_SHA");
		ERICSSON_CIPHERS.add("TLS_ECDH_RSA_WITH_3DES_EDE_CBC_SHA");
		ERICSSON_CIPHERS.add("TLS_ECDH_ECDSA_WITH_3DES_EDE_CBC_SHA");
		ERICSSON_CIPHERS.add("TLS_RSA_WITH_3DES_EDE_CBC_SHA");
		ERICSSON_CIPHERS.add("TLS_PSK_WITH_3DES_EDE_CBC_SHA");
		ERICSSON_CIPHERS.add("TLS_EMPTY_RENEGOTIATION_INFO_SCSV");
		ERICSSON_CIPHERS.add("TLS_FALLBACK_SCSV");
		ERICSSON_CIPHERS.add("TLS_ECDHE_RSA_WITH_AES_256_GCM_SHA384");
		ERICSSON_CIPHERS.add("TLS_ECDHE_ECDSA_WITH_AES_256_GCM_SHA384");
		ERICSSON_CIPHERS.add("TLS_ECDHE_RSA_WITH_AES_256_CBC_SHA384");
		ERICSSON_CIPHERS.add("TLS_ECDHE_ECDSA_WITH_AES_256_CBC_SHA384");
		ERICSSON_CIPHERS.add("TLS_ECDHE_RSA_WITH_AES_256_CBC_SHA");
		ERICSSON_CIPHERS.add("TLS_ECDHE_ECDSA_WITH_AES_256_CBC_SHA");
		ERICSSON_CIPHERS.add("TLS_SRP_SHA_DSS_WITH_AES_256_CBC_SHA");
		ERICSSON_CIPHERS.add("TLS_SRP_SHA_RSA_WITH_AES_256_CBC_SHA");
		ERICSSON_CIPHERS.add("TLS_SRP_SHA_WITH_AES_256_CBC_SHA");
		ERICSSON_CIPHERS.add("TLS_DH_DSS_WITH_AES_256_GCM_SHA384");
		ERICSSON_CIPHERS.add("TLS_DHE_DSS_WITH_AES_256_GCM_SHA384");
		ERICSSON_CIPHERS.add("TLS_DH_RSA_WITH_AES_256_GCM_SHA384");
		ERICSSON_CIPHERS.add("TLS_DHE_RSA_WITH_AES_256_GCM_SHA384");
		ERICSSON_CIPHERS.add("TLS_DHE_RSA_WITH_AES_256_CBC_SHA256");
		ERICSSON_CIPHERS.add("TLS_DHE_DSS_WITH_AES_256_CBC_SHA256");
		ERICSSON_CIPHERS.add("TLS_DH_RSA_WITH_AES_256_CBC_SHA256");
		ERICSSON_CIPHERS.add("TLS_DH_DSS_WITH_AES_256_CBC_SHA256");
		ERICSSON_CIPHERS.add("TLS_DHE_RSA_WITH_AES_256_CBC_SHA");
		ERICSSON_CIPHERS.add("TLS_DHE_DSS_WITH_AES_256_CBC_SHA");
		ERICSSON_CIPHERS.add("TLS_DH_RSA_WITH_AES_256_CBC_SHA");
		ERICSSON_CIPHERS.add("TLS_DH_DSS_WITH_AES_256_CBC_SHA");
		ERICSSON_CIPHERS.add("TLS_DHE_RSA_WITH_CAMELLIA_256_CBC_SHA");
		ERICSSON_CIPHERS.add("TLS_DHE_DSS_WITH_CAMELLIA_256_CBC_SHA");
		ERICSSON_CIPHERS.add("TLS_DH_RSA_WITH_CAMELLIA_256_CBC_SHA");
		ERICSSON_CIPHERS.add("TLS_DH_DSS_WITH_CAMELLIA_256_CBC_SHA");
		ERICSSON_CIPHERS.add("TLS_ECDH_anon_WITH_AES_256_CBC_SHA");
		ERICSSON_CIPHERS.add("TLS_DH_anon_WITH_AES_256_GCM_SHA384");
		ERICSSON_CIPHERS.add("TLS_DH_anon_WITH_AES_256_CBC_SHA256");
		ERICSSON_CIPHERS.add("TLS_DH_anon_WITH_AES_256_CBC_SHA");
		ERICSSON_CIPHERS.add("TLS_DH_anon_WITH_CAMELLIA_256_CBC_SHA");
		ERICSSON_CIPHERS.add("TLS_ECDH_RSA_WITH_AES_256_GCM_SHA384");
		ERICSSON_CIPHERS.add("TLS_ECDH_ECDSA_WITH_AES_256_GCM_SHA384");
		ERICSSON_CIPHERS.add("TLS_ECDH_RSA_WITH_AES_256_CBC_SHA384");
		ERICSSON_CIPHERS.add("TLS_ECDH_ECDSA_WITH_AES_256_CBC_SHA384");
		ERICSSON_CIPHERS.add("TLS_ECDH_RSA_WITH_AES_256_CBC_SHA");
		ERICSSON_CIPHERS.add("TLS_ECDH_ECDSA_WITH_AES_256_CBC_SHA");
		ERICSSON_CIPHERS.add("TLS_RSA_WITH_AES_256_GCM_SHA384");
		ERICSSON_CIPHERS.add("TLS_RSA_WITH_AES_256_CBC_SHA256");
		ERICSSON_CIPHERS.add("TLS_RSA_WITH_AES_256_CBC_SHA");
		ERICSSON_CIPHERS.add("TLS_RSA_WITH_CAMELLIA_256_CBC_SHA");
		ERICSSON_CIPHERS.add("TLS_PSK_WITH_AES_256_CBC_SHA");
		ERICSSON_CIPHERS.add("TLS_ECDHE_RSA_WITH_AES_128_GCM_SHA256");
		ERICSSON_CIPHERS.add("TLS_ECDHE_ECDSA_WITH_AES_128_GCM_SHA256");
		ERICSSON_CIPHERS.add("TLS_ECDHE_RSA_WITH_AES_128_CBC_SHA256");
		ERICSSON_CIPHERS.add("TLS_ECDHE_ECDSA_WITH_AES_128_CBC_SHA256");
		ERICSSON_CIPHERS.add("TLS_ECDHE_RSA_WITH_AES_128_CBC_SHA");
		ERICSSON_CIPHERS.add("TLS_ECDHE_ECDSA_WITH_AES_128_CBC_SHA");
		ERICSSON_CIPHERS.add("TLS_SRP_SHA_DSS_WITH_AES_128_CBC_SHA");
		ERICSSON_CIPHERS.add("TLS_SRP_SHA_RSA_WITH_AES_128_CBC_SHA");
		ERICSSON_CIPHERS.add("TLS_SRP_SHA_WITH_AES_128_CBC_SHA");
		ERICSSON_CIPHERS.add("TLS_DH_DSS_WITH_AES_128_GCM_SHA256");
		ERICSSON_CIPHERS.add("TLS_DHE_DSS_WITH_AES_128_GCM_SHA256");
		ERICSSON_CIPHERS.add("TLS_DH_RSA_WITH_AES_128_GCM_SHA256");
		ERICSSON_CIPHERS.add("TLS_DHE_RSA_WITH_AES_128_GCM_SHA256");
		ERICSSON_CIPHERS.add("TLS_DHE_RSA_WITH_AES_128_CBC_SHA256");
		ERICSSON_CIPHERS.add("TLS_DHE_DSS_WITH_AES_128_CBC_SHA256");
		ERICSSON_CIPHERS.add("TLS_DH_RSA_WITH_AES_128_CBC_SHA256");
		ERICSSON_CIPHERS.add("TLS_DH_DSS_WITH_AES_128_CBC_SHA256");
		ERICSSON_CIPHERS.add("TLS_DHE_RSA_WITH_AES_128_CBC_SHA");
		ERICSSON_CIPHERS.add("TLS_DHE_DSS_WITH_AES_128_CBC_SHA");
		ERICSSON_CIPHERS.add("TLS_DH_RSA_WITH_AES_128_CBC_SHA");
		ERICSSON_CIPHERS.add("TLS_DH_DSS_WITH_AES_128_CBC_SHA");
		ERICSSON_CIPHERS.add("TLS_DHE_RSA_WITH_SEED_CBC_SHA");
		ERICSSON_CIPHERS.add("TLS_DHE_DSS_WITH_SEED_CBC_SHA");
		ERICSSON_CIPHERS.add("TLS_DH_RSA_WITH_SEED_CBC_SHA");
		ERICSSON_CIPHERS.add("TLS_DH_DSS_WITH_SEED_CBC_SHA");
		ERICSSON_CIPHERS.add("TLS_DHE_RSA_WITH_CAMELLIA_128_CBC_SHA");
		ERICSSON_CIPHERS.add("TLS_DHE_DSS_WITH_CAMELLIA_128_CBC_SHA");
		ERICSSON_CIPHERS.add("TLS_DH_RSA_WITH_CAMELLIA_128_CBC_SHA");
		ERICSSON_CIPHERS.add("TLS_DH_DSS_WITH_CAMELLIA_128_CBC_SHA");
		ERICSSON_CIPHERS.add("TLS_ECDH_anon_WITH_AES_128_CBC_SHA");
		ERICSSON_CIPHERS.add("TLS_DH_anon_WITH_AES_128_GCM_SHA256");
		ERICSSON_CIPHERS.add("TLS_DH_anon_WITH_AES_128_CBC_SHA256");
		ERICSSON_CIPHERS.add("TLS_DH_anon_WITH_AES_128_CBC_SHA");
		ERICSSON_CIPHERS.add("TLS_DH_anon_WITH_SEED_CBC_SHA");
		ERICSSON_CIPHERS.add("TLS_DH_anon_WITH_CAMELLIA_128_CBC_SHA");
		ERICSSON_CIPHERS.add("TLS_ECDH_RSA_WITH_AES_128_GCM_SHA256");
		ERICSSON_CIPHERS.add("TLS_ECDH_ECDSA_WITH_AES_128_GCM_SHA256");
		ERICSSON_CIPHERS.add("TLS_ECDH_RSA_WITH_AES_128_CBC_SHA256");
		ERICSSON_CIPHERS.add("TLS_ECDH_ECDSA_WITH_AES_128_CBC_SHA256");
		ERICSSON_CIPHERS.add("TLS_ECDH_RSA_WITH_AES_128_CBC_SHA");
		ERICSSON_CIPHERS.add("TLS_ECDH_ECDSA_WITH_AES_128_CBC_SHA");
		ERICSSON_CIPHERS.add("TLS_RSA_WITH_AES_128_GCM_SHA256");
		ERICSSON_CIPHERS.add("TLS_RSA_WITH_AES_128_CBC_SHA256");
		ERICSSON_CIPHERS.add("TLS_RSA_WITH_AES_128_CBC_SHA");
		ERICSSON_CIPHERS.add("TLS_RSA_WITH_SEED_CBC_SHA");
		ERICSSON_CIPHERS.add("TLS_RSA_WITH_CAMELLIA_128_CBC_SHA");
		ERICSSON_CIPHERS.add("TLS_PSK_WITH_AES_128_CBC_SHA");
		ERICSSON_CIPHERS.add("TLS_ECDHE_RSA_WITH_RC4_128_SHA");
		ERICSSON_CIPHERS.add("TLS_ECDHE_ECDSA_WITH_RC4_128_SHA");
		ERICSSON_CIPHERS.add("TLS_ECDH_anon_WITH_RC4_128_SHA");
		ERICSSON_CIPHERS.add("TLS_DH_anon_WITH_RC4_128_MD5");
		ERICSSON_CIPHERS.add("TLS_ECDH_RSA_WITH_RC4_128_SHA");
		ERICSSON_CIPHERS.add("TLS_ECDH_ECDSA_WITH_RC4_128_SHA");
		ERICSSON_CIPHERS.add("TLS_RSA_WITH_RC4_128_SHA");
		ERICSSON_CIPHERS.add("SSL_CK_RC4_128_WITH_MD5");
		ERICSSON_CIPHERS.add("TLS_PSK_WITH_RC4_128_SHA");
		ERICSSON_CIPHERS.add("TLS_ECDHE_RSA_WITH_3DES_EDE_CBC_SHA");
		ERICSSON_CIPHERS.add("TLS_ECDHE_ECDSA_WITH_3DES_EDE_CBC_SHA");
		ERICSSON_CIPHERS.add("TLS_SRP_SHA_DSS_WITH_3DES_EDE_CBC_SHA");
		ERICSSON_CIPHERS.add("TLS_SRP_SHA_RSA_WITH_3DES_EDE_CBC_SHA");
		ERICSSON_CIPHERS.add("TLS_SRP_SHA_WITH_3DES_EDE_CBC_SHA");
		ERICSSON_CIPHERS.add("TLS_DHE_RSA_WITH_3DES_EDE_CBC_SHA");
		ERICSSON_CIPHERS.add("TLS_DHE_DSS_WITH_3DES_EDE_CBC_SHA");
		ERICSSON_CIPHERS.add("TLS_DH_RSA_WITH_3DES_EDE_CBC_SHA");
		ERICSSON_CIPHERS.add("TLS_DH_DSS_WITH_3DES_EDE_CBC_SHA");
		ERICSSON_CIPHERS.add("TLS_ECDH_anon_WITH_3DES_EDE_CBC_SHA");
		ERICSSON_CIPHERS.add("TLS_DH_anon_WITH_3DES_EDE_CBC_SHA");
		ERICSSON_CIPHERS.add("TLS_ECDH_RSA_WITH_3DES_EDE_CBC_SHA");
		ERICSSON_CIPHERS.add("TLS_ECDH_ECDSA_WITH_3DES_EDE_CBC_SHA");
		ERICSSON_CIPHERS.add("TLS_PSK_WITH_3DES_EDE_CBC_SHA");
		ERICSSON_CIPHERS.add("TLS_EMPTY_RENEGOTIATION_INFO_SCSV");
		ERICSSON_CIPHERS.add("TLS_FALLBACK_SCSV");
	}

}
