/* Copyright (C) 2015 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License. */

/* This file was generated by generate_constants.cc. */

package org.conscrypt;

/** @hide */
public final class NativeConstants {
    public static final boolean HAS_EVP_AEAD = false;
    public static final int OPENSSL_EC_NAMED_CURVE = 0x1;
    public static final int POINT_CONVERSION_COMPRESSED = 0x2;
    public static final int POINT_CONVERSION_UNCOMPRESSED = 0x4;
    public static final int EXFLAG_CA = 0x10;
    public static final int EXFLAG_CRITICAL = 0x200;
    public static final int EVP_PKEY_RSA = 0x6;
    public static final int EVP_PKEY_EC = 0x198;
    public static final int RSA_PKCS1_PADDING = 0x1;
    public static final int RSA_NO_PADDING = 0x3;
    public static final int RSA_PKCS1_OAEP_PADDING = 0x4;
    public static final int RSA_PKCS1_PSS_PADDING = 0x6;
    public static final int SSL_MODE_SEND_FALLBACK_SCSV = 0x80;
    public static final int SSL_MODE_CBC_RECORD_SPLITTING = Platform.MISSING_SSL_MODE_CBC_RECORD_SPLITTING;
    public static final int SSL_MODE_ENABLE_FALSE_START = Platform.MISSING_SSL_MODE_ENABLE_FALSE_START;
    public static final int SSL_OP_CIPHER_SERVER_PREFERENCE = 0x400000;
    public static final int SSL_OP_NO_TICKET = 0x4000;
    public static final int SSL_OP_NO_SESSION_RESUMPTION_ON_RENEGOTIATION = 0x10000;
    public static final int SSL_OP_NO_SSLv3 = 0x2000000;
    public static final int SSL_OP_NO_TLSv1 = 0x4000000;
    public static final int SSL_OP_NO_TLSv1_1 = 0x10000000;
    public static final int SSL_OP_NO_TLSv1_2 = 0x8000000;
    public static final int SSL_OP_NO_TLSv1_3 = 0x20000000;
    public static final int SSL_ERROR_NONE = 0x0;
    public static final int SSL_ERROR_WANT_READ = 0x2;
    public static final int SSL_ERROR_WANT_WRITE = 0x3;
    public static final int SSL_ERROR_ZERO_RETURN = 0x6;
    public static final int SSL_SENT_SHUTDOWN = 0x1;
    public static final int SSL_RECEIVED_SHUTDOWN = 0x2;
    public static final int TLS_CT_RSA_SIGN = 0x1;
    public static final int TLS_CT_ECDSA_SIGN = 0x40;
    public static final int TLS_CT_RSA_FIXED_DH = 0x3;
    public static final int TLS_CT_RSA_FIXED_ECDH = 0x41;
    public static final int TLS_CT_ECDSA_FIXED_ECDH = 0x42;
    public static final int SSL_VERIFY_NONE = 0x0;
    public static final int SSL_VERIFY_PEER = 0x1;
    public static final int SSL_VERIFY_FAIL_IF_NO_PEER_CERT = 0x2;
    public static final int SSL_ST_CONNECT = 0x1000;
    public static final int SSL_ST_ACCEPT = 0x2000;
    public static final int SSL_ST_MASK = 0xfff;
    public static final int SSL_ST_INIT = Platform.MISSING_SSL_ST_INIT;
    public static final int SSL_ST_OK = Platform.MISSING_SSL_ST_OK;
    public static final int SSL_ST_RENEGOTIATE = Platform.MISSING_SSL_ST_RENEGOTIATE;
    public static final int SSL_CB_LOOP = 0x1;
    public static final int SSL_CB_EXIT = 0x2;
    public static final int SSL_CB_READ = 0x4;
    public static final int SSL_CB_WRITE = 0x8;
    public static final int SSL_CB_ALERT = 0x4000;
    public static final int SSL_CB_READ_ALERT = 0x4004;
    public static final int SSL_CB_WRITE_ALERT = 0x4008;
    public static final int SSL_CB_ACCEPT_LOOP = 0x2001;
    public static final int SSL_CB_ACCEPT_EXIT = 0x2002;
    public static final int SSL_CB_CONNECT_LOOP = 0x1001;
    public static final int SSL_CB_CONNECT_EXIT = 0x1002;
    public static final int SSL_CB_HANDSHAKE_START = 0x10;
    public static final int SSL_CB_HANDSHAKE_DONE = 0x20;
    public static final int SSL3_RT_MAX_PLAIN_LENGTH = 0x4000;
    public static final int SSL3_RT_MAX_PACKET_SIZE = 0x4145;
    public static final int SSL3_RT_CHANGE_CIPHER_SPEC = 0x14;
    public static final int SSL3_RT_ALERT = 0x15;
    public static final int SSL3_RT_HANDSHAKE = 0x16;
    public static final int SSL3_RT_APPLICATION_DATA = 0x17;
    public static final int SSL3_RT_HEADER_LENGTH = 0x5;
}
