/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.crbs.cat.pmapplication;

import se.ericsson.crbs.cat.pmapplication.PmThreadSwitcherI;
import se.ericsson.crbs.cat.pmcommon.PmBase;
import se.ericsson.crbs.cat.pmcommon.PmMaps;
import se.ericsson.crbs.cat.pmproxy.PmProxyI;
import se.ericsson.crbs.cat.pmproxy.PmProxyListenerI;
import se.ericsson.crbs.cat.pmproxy.signals.PmBaseSignal;
import se.ericsson.crbs.cat.pmproxy.signals.PmSignals;

public class PmThreadSwitcher
extends PmBase
implements PmProxyListenerI,
PmThreadSwitcherI,
PmSignals.Internal.PmSignalReceiver {
    private final Object shared_lock = new Object();
    private final PmMaps.RunnableMap shared_runnables = new PmMaps.RunnableMap();
    private int shared_nextId = 0;
    private final PmProxyI m_proxy;

    public PmThreadSwitcher(PmProxyI proxy) {
        this.enter("PmThreadSwitcher");
        this.info("PmThreadSwitcher created");
        this.m_proxy = proxy;
        this.m_proxy.registerSignals(this, PmSignals.Internal.SignalDescriptors);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void executeInMainThread(Runnable runnable) {
        this.enter("executeInMainThread");
        if (runnable == null) {
            this.error("runnable must not be null");
            return;
        }
        int runnableId = 0;
        Object object = this.shared_lock;
        synchronized (object) {
            runnableId = this.shared_nextId++;
            if (!this.shared_runnables.add(runnableId, runnable)) {
                this.error("Failed to add runnable for runnableId: " + runnableId);
                return;
            }
        }
        PmSignals.Internal.PmInternalExecuteInMainThreadReq signal = new PmSignals.Internal.PmInternalExecuteInMainThreadReq();
        signal.runnableId = runnableId;
        this.general("Sending PM_INTERNAL_EXECUTE_IN_MAIN_THREAD_REQ");
        this.m_proxy.sendSignal(signal, this.m_proxy.getProxyPid());
    }

    public void receiveSignal(PmBaseSignal signal) {
        this.enter("receiveSignal");
        if (signal == null) {
            this.error("signal must not be null");
        }
        if (!PmSignals.Internal.receiveSignal(this, signal)) {
            this.error("Unrecognized signal: " + signal.toString());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handlePmInternalExecuteInMainThreadReq(PmSignals.Internal.PmInternalExecuteInMainThreadReq signal) {
        this.enter("handleInternalExecuteInMainThreadReq");
        int runnableId = signal.runnableId;
        Runnable runnable = null;
        Object object = this.shared_lock;
        synchronized (object) {
            runnable = this.shared_runnables.get(runnableId);
            this.shared_runnables.remove(runnableId);
        }
        if (runnable == null) {
            this.error("No runnable found for runnableId: " + runnableId);
            return;
        }
        runnable.run();
    }
}

