/*
 * Decompiled with CFR 0.152.
 */
package org.apache.log.output.jms;

import java.io.PrintWriter;
import java.io.StringWriter;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.Session;
import javax.jms.TextMessage;
import org.apache.log.ContextMap;
import org.apache.log.LogEvent;
import org.apache.log.format.Formatter;
import org.apache.log.output.jms.MessageBuilder;
import org.apache.log.output.jms.PropertyInfo;

public class TextMessageBuilder
implements MessageBuilder {
    private final PropertyInfo[] m_properties;
    private final Formatter m_formatter;

    public TextMessageBuilder(Formatter formatter) {
        this.m_properties = new PropertyInfo[0];
        this.m_formatter = formatter;
    }

    public TextMessageBuilder(PropertyInfo[] properties, Formatter formatter) {
        this.m_properties = properties;
        this.m_formatter = formatter;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Message buildMessage(Session session, LogEvent event) throws JMSException {
        Session session2 = session;
        synchronized (session2) {
            TextMessage message = session.createTextMessage();
            message.setText(this.getText(event));
            int i2 = 0;
            while (i2 < this.m_properties.length) {
                this.setProperty(message, i2, event);
                ++i2;
            }
            return message;
        }
    }

    private void setProperty(TextMessage message, int index, LogEvent event) throws JMSException {
        PropertyInfo info = this.m_properties[index];
        String name = info.getName();
        switch (info.getType()) {
            case 4: {
                message.setStringProperty(name, event.getMessage());
                break;
            }
            case 6: {
                message.setLongProperty(name, event.getRelativeTime());
                break;
            }
            case 5: {
                message.setLongProperty(name, event.getTime());
                break;
            }
            case 2: {
                message.setStringProperty(name, event.getCategory());
                break;
            }
            case 8: {
                message.setStringProperty(name, event.getPriority().getName());
                break;
            }
            case 3: {
                message.setStringProperty(name, this.getContextMap(event.getContextMap(), info.getAux()));
                break;
            }
            case 1: {
                message.setStringProperty(name, info.getAux());
                break;
            }
            case 7: {
                message.setStringProperty(name, this.getStackTrace(event.getThrowable()));
                break;
            }
            default: {
                throw new IllegalStateException("Unknown PropertyType: " + info.getType());
            }
        }
    }

    private String getText(LogEvent event) {
        if (null == this.m_formatter) {
            return event.getMessage();
        }
        return this.m_formatter.format(event);
    }

    private String getStackTrace(Throwable throwable) {
        if (null == throwable) {
            return "";
        }
        StringWriter stringWriter = new StringWriter();
        PrintWriter printWriter = new PrintWriter(stringWriter);
        throwable.printStackTrace(printWriter);
        return stringWriter.getBuffer().toString();
    }

    private String getContextMap(ContextMap map, String aux) {
        if (null == map) {
            return "";
        }
        return map.get(aux, "").toString();
    }
}

