/*
 * Decompiled with CFR 0.152.
 */
package org.jacorb.imrutility.imr.util;

import java.io.IOException;
import java.net.DatagramPacket;
import java.net.InetAddress;
import java.net.MulticastSocket;
import java.net.UnknownHostException;
import java.util.Vector;
import org.apache.avalon.framework.logger.Logger;
import org.jacorb.config.Configuration;
import org.jacorb.imrutility.imr.util.MulticastEvent;
import org.jacorb.imrutility.imr.util.MulticastListener;

public class MulticastServer {
    private final Vector listeners = new Vector();
    private final MulticastSocket s;
    private final InetAddress address;
    private boolean poll = true;
    private ServerThread st;
    private final Logger logger;

    public MulticastServer(Configuration configuration, int port) throws IOException, UnknownHostException {
        this.logger = configuration.getNamedLogger("jacorb.imr");
        this.s = new MulticastSocket(port);
        this.address = InetAddress.getByName("230.0.0.1");
        this.s.joinGroup(this.address);
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("MulticastServer is listening on port: " + port);
            this.logger.debug("MulticastServer has joined group: " + this.address);
        }
        this.st = new ServerThread();
        this.st.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addMulticastListener(MulticastListener ml) {
        Vector vector = this.listeners;
        synchronized (vector) {
            if (!this.listeners.contains(ml)) {
                this.listeners.addElement(ml);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeMulticastListener(MulticastListener ml) {
        Vector vector = this.listeners;
        synchronized (vector) {
            if (this.listeners.contains(ml)) {
                this.listeners.remove(ml);
            }
        }
    }

    public void close() {
        block2: {
            try {
                this.s.leaveGroup(this.address);
            }
            catch (Exception ex) {
                if (!this.logger.isDebugEnabled()) break block2;
                this.logger.warn("Exception in MulticastServer.close(): " + ex.getMessage());
            }
        }
        this.poll = false;
        this.st = null;
        this.s.close();
    }

    private class ServerThread
    extends Thread {
        private ServerThread() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            block8: {
                try {
                    while (MulticastServer.this.poll) {
                        byte[] returnData = null;
                        DatagramPacket returnPacket = null;
                        MulticastEvent me = null;
                        byte[] buf = new byte[1024];
                        DatagramPacket packet = new DatagramPacket(buf, buf.length);
                        MulticastServer.this.s.receive(packet);
                        if (packet.getData().length > 0) {
                            me = new MulticastEvent(packet.getData());
                            Vector vector = MulticastServer.this.listeners;
                            synchronized (vector) {
                                for (int i2 = 0; i2 < MulticastServer.this.listeners.size(); ++i2) {
                                    returnData = ((MulticastListener)MulticastServer.this.listeners.get(i2)).multicastEvent(me);
                                    if (returnData == null) continue;
                                    returnPacket = new DatagramPacket(returnData, returnData.length, packet.getAddress(), packet.getPort());
                                    MulticastServer.this.s.send(returnPacket);
                                }
                            }
                        }
                        ServerThread.sleep((long)(Math.random() * 5000.0));
                    }
                }
                catch (Exception ex) {
                    if (!MulticastServer.this.poll || !MulticastServer.this.logger.isDebugEnabled()) break block8;
                    MulticastServer.this.logger.error("Exception in MulticastServer$ServerThread.run(): ", ex);
                }
            }
        }
    }
}

