/*
 * Decompiled with CFR 0.152.
 */
package org.jacorb.orb.ft;

import java.util.Iterator;
import java.util.List;
import org.jacorb.config.Configuration;
import org.jacorb.orb.CDRInputStream;
import org.jacorb.orb.OriginalRememberingRebindRetryStrategy;
import org.jacorb.orb.ParsedIOROperations;
import org.jacorb.orb.RebindRetryStrategy;
import org.jacorb.util.Time;
import org.omg.CORBA.CompletionStatus;
import org.omg.CORBA.SystemException;
import org.omg.FT.FTRequestServiceContext;
import org.omg.FT.FTRequestServiceContextHelper;
import org.omg.IOP.ServiceContext;
import org.omg.TimeBase.UtcT;

public class FaultTolerantRebindRetryStrategy
extends OriginalRememberingRebindRetryStrategy {
    public FaultTolerantRebindRetryStrategy(Configuration config) {
        super(config);
    }

    public boolean doTryRebind(RebindRetryStrategy.RebindCallback callback, ParsedIOROperations failingIOR, SystemException cause, List serviceContexts) {
        boolean isRequestExpired = this.isRequestExpired(serviceContexts);
        if (isRequestExpired) {
            this.logger.info("cannot recover as request duration time is expired.");
            return false;
        }
        boolean hasMoreProfiles = failingIOR.selectNextProfile();
        if (hasMoreProfiles) {
            this.logger.debug("rebinding to next profile");
            boolean rebound = callback.rebind(failingIOR, true);
            this.logger.debug("rebound to next profile: " + rebound);
            return rebound;
        }
        this.logger.info("cannot recover as there are no more profiles available");
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isRequestExpired(List serviceContexts) {
        boolean isRequestExpired = false;
        Iterator i2 = serviceContexts.iterator();
        while (i2.hasNext()) {
            ServiceContext context = (ServiceContext)i2.next();
            if (context.context_id != 13) continue;
            CDRInputStream in = new CDRInputStream(context.context_data);
            try {
                in.openEncapsulatedArray();
                FTRequestServiceContext requestServiceContext = FTRequestServiceContextHelper.read(in);
                UtcT expirationTime = new UtcT(requestServiceContext.expiration_time, 0, 0, 0);
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug("request expiration time is: " + Time.javaDate(expirationTime));
                }
                if (!Time.hasPassed(expirationTime)) continue;
                isRequestExpired = true;
                break;
            }
            finally {
                in.close();
            }
        }
        return isRequestExpired;
    }

    protected boolean checkExceptionStatus(SystemException e2) {
        return e2.completed == CompletionStatus.COMPLETED_MAYBE || e2.completed == CompletionStatus.COMPLETED_NO;
    }

    public void pushIOR(ParsedIOROperations ior) {
    }
}

