/*
 * Decompiled with CFR 0.152.
 */
package org.jacorb.orb.giop;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.apache.avalon.framework.configuration.Configurable;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.configuration.ConfigurationException;
import org.apache.avalon.framework.logger.Logger;
import org.jacorb.orb.ORBConstants;
import org.jacorb.orb.giop.ClientGIOPConnection;
import org.jacorb.orb.giop.GIOPConnection;
import org.jacorb.orb.giop.ReplyListener;
import org.jacorb.orb.giop.RequestListener;
import org.jacorb.orb.giop.SelectionStrategy;
import org.jacorb.orb.giop.ServerGIOPConnection;
import org.jacorb.orb.giop.StatisticsProvider;
import org.jacorb.orb.util.CorbaLoc;
import org.jacorb.util.ObjectUtil;
import org.omg.CORBA.INTERNAL;
import org.omg.ETF.Connection;
import org.omg.ETF.Profile;

public class GIOPConnectionManager
implements Configurable {
    private org.jacorb.config.Configuration configuration = null;
    private Logger logger = null;
    private final List server_giop_connections = new LinkedList();
    private int max_server_giop_connections = 0;
    private Class statistics_provider_class = null;
    private SelectionStrategy selection_strategy = null;
    private int wait_for_idle_interval = 0;
    private ContextKey[] serviceContextKeyCache;
    private int svcId;
    private int usageCountMax;
    private int hashCount;
    private int contextCacheSize = 1000;
    private int shutdownTimeout = 0;

    public void configure(Configuration myConfiguration) throws ConfigurationException {
        boolean disableSvcNegotiation;
        block4: {
            this.configuration = (org.jacorb.config.Configuration)myConfiguration;
            this.logger = this.configuration.getNamedLogger("jacorb.orb.giop.conn");
            this.max_server_giop_connections = this.configuration.getAttributeAsInteger("jacorb.connection.max_server_connections", Integer.MAX_VALUE);
            this.contextCacheSize = this.configuration.getAttributeAsInteger("jacorb.key.cacheSize", 1000);
            this.selection_strategy = (SelectionStrategy)this.configuration.getAttributeAsObject("jacorb.connection.selection_strategy_class");
            this.wait_for_idle_interval = this.configuration.getAttributeAsInteger("jacorb.connection.wait_for_idle_interval", 500);
            this.shutdownTimeout = this.configuration.getAttributeAsInteger("jacorb.connection.server.shutdown_timeout", 0);
            String statisticsProviderProperty = "jacorb.connection.statistics_provider_class";
            if (this.configuration.isAttributeSet("jacorb.connection.statistics_provider_class")) {
                try {
                    this.statistics_provider_class = ObjectUtil.classForName(this.configuration.getAttribute("jacorb.connection.statistics_provider_class"));
                }
                catch (Exception e2) {
                    if (!this.logger.isErrorEnabled()) break block4;
                    this.logger.error("Unable to create class from property >jacorb.connection.statistics_provider_class<: " + e2.toString());
                }
            }
        }
        if (!(disableSvcNegotiation = this.configuration.getAttributeAsBoolean("jacorb.disableServiceContextNegotiation", false))) {
            this.serviceContextKeyCache = new ContextKey[this.contextCacheSize];
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ServerGIOPConnection createServerGIOPConnection(Profile profile, Connection transport, RequestListener request_listener, ReplyListener reply_listener) {
        List list;
        if (this.server_giop_connections.size() >= this.max_server_giop_connections) {
            if (this.selection_strategy == null) {
                if (this.logger.isErrorEnabled()) {
                    this.logger.error("No. of max server giop connections set, but no SelectionStrategy present");
                }
            } else {
                while (this.server_giop_connections.size() >= this.max_server_giop_connections) {
                    ServerGIOPConnection to_close = null;
                    list = this.server_giop_connections;
                    synchronized (list) {
                        to_close = this.selection_strategy.selectForClose(this.server_giop_connections);
                    }
                    if (to_close != null && to_close.tryClose()) break;
                    try {
                        Thread.sleep(this.wait_for_idle_interval);
                    }
                    catch (InterruptedException e2) {}
                }
            }
        }
        ServerGIOPConnection connection = new ServerGIOPConnection(profile, transport, request_listener, reply_listener, this.getStatisticsProvider(), this);
        try {
            connection.configure(this.configuration);
        }
        catch (ConfigurationException ce) {
            this.logger.warn("ConfigurationException", ce);
        }
        list = this.server_giop_connections;
        synchronized (list) {
            this.server_giop_connections.add(connection);
        }
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("GIOPConnectionManager: created new " + connection.toString());
        }
        return connection;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unregisterServerGIOPConnection(ServerGIOPConnection connection) {
        List list = this.server_giop_connections;
        synchronized (list) {
            this.server_giop_connections.remove(connection);
            this.server_giop_connections.notifyAll();
        }
    }

    public GIOPConnection createClientGIOPConnection(Profile profile, Connection transport, RequestListener request_listener, ReplyListener reply_listener) {
        ClientGIOPConnection connection = new ClientGIOPConnection(profile, transport, request_listener, reply_listener, null);
        try {
            connection.configure(this.configuration);
        }
        catch (ConfigurationException ce) {
            this.logger.warn("ConfigurationException", ce);
        }
        return connection;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shutdown(boolean wait_for_completion) {
        ArrayList connections = null;
        List list = this.server_giop_connections;
        synchronized (list) {
            connections = new ArrayList(this.server_giop_connections);
        }
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("GIOPConnectionManager.shutdown(), " + connections.size() + " connections");
        }
        boolean hasOutstandingConnections = false;
        Iterator i2 = connections.iterator();
        while (i2.hasNext()) {
            ServerGIOPConnection connection = (ServerGIOPConnection)i2.next();
            if (connection.tryClose()) continue;
            connection.setDiscardingMode(true);
            hasOutstandingConnections = true;
        }
        if (hasOutstandingConnections && this.shutdownTimeout > 0) {
            if (wait_for_completion) {
                this.closeOutstandingConnections();
            } else {
                Thread connectionCompletionThread = new Thread(){

                    public void run() {
                        GIOPConnectionManager.this.closeOutstandingConnections();
                    }
                };
                connectionCompletionThread.setName("GIOPConnectionDestructor");
                connectionCompletionThread.setDaemon(true);
                connectionCompletionThread.start();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void closeOutstandingConnections() {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("GIOPConnectionManager.closeOutstandingConnections(), " + this.server_giop_connections.size() + " connections still open. Will wait up to " + this.shutdownTimeout + " milliseconds for request completions.");
        }
        long expiryTime = System.currentTimeMillis() + (long)this.shutdownTimeout;
        while (!this.server_giop_connections.isEmpty()) {
            ArrayList connections = null;
            List list = this.server_giop_connections;
            synchronized (list) {
                try {
                    this.server_giop_connections.wait(this.wait_for_idle_interval);
                }
                catch (InterruptedException e2) {
                    // empty catch block
                }
                connections = new ArrayList(this.server_giop_connections);
            }
            Iterator i2 = connections.iterator();
            while (i2.hasNext()) {
                ServerGIOPConnection connection = (ServerGIOPConnection)i2.next();
                if (connection.tryClose() || expiryTime >= System.currentTimeMillis()) continue;
                if (this.logger.isWarnEnabled()) {
                    this.logger.warn(connection.toString() + ": GIOPConnectionManager.closeOutstandingConnections () -- Timeout expired. Forcing closure of connection with outstanding requests.");
                }
                connection.close();
            }
        }
    }

    private StatisticsProvider getStatisticsProvider() {
        StatisticsProvider result;
        block3: {
            result = null;
            if (this.statistics_provider_class != null) {
                try {
                    result = (StatisticsProvider)this.statistics_provider_class.newInstance();
                }
                catch (Exception e2) {
                    if (!this.logger.isErrorEnabled()) break block3;
                    this.logger.error("Unable to create instance from Class >" + this.statistics_provider_class + '<');
                }
            }
        }
        return result;
    }

    synchronized void removeContextKey(GIOPConnection gc, int index) {
        if (this.serviceContextKeyCache[index] != null) {
            if (gc != this.serviceContextKeyCache[index].gc) {
                this.logger.debug("Cannot purge context slot at " + index + " as now being used by a different GIOPConnection");
            } else {
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug("Removing context slot at index " + index + " with scopes content " + this.serviceContextKeyCache[index].getScopes() + " and svcId " + this.svcId);
                }
                this.serviceContextKeyCache[index] = null;
                ++this.hashCount;
                this.hashCount = this.hashCount < 0 ? 0 : this.hashCount;
                this.svcId = index - 1 < 0 ? 0 : index - 1;
            }
        } else {
            this.logger.warn("ContextKey element was already null for index " + index);
        }
    }

    synchronized byte[] addContextKey(GIOPConnection gc, byte[] object_key, byte[] oid, List scopes) {
        byte[] result = new byte[11];
        System.arraycopy(ORBConstants.JAC_TAG, 0, result, 0, 3);
        if (this.serviceContextKeyCache == null) {
            throw new INTERNAL("Should not be adding a context key without a cache");
        }
        if (this.svcId >= this.serviceContextKeyCache.length) {
            this.purgeCtxCache();
        } else if (this.serviceContextKeyCache[this.svcId] != null) {
            while (this.svcId < this.serviceContextKeyCache.length && this.serviceContextKeyCache[this.svcId] != null) {
                ++this.svcId;
            }
            if (this.svcId >= this.serviceContextKeyCache.length) {
                this.purgeCtxCache();
            }
        }
        result[3] = (byte)(this.svcId >> 24 & 0xFF);
        result[4] = (byte)(this.svcId >> 16 & 0xFF);
        result[5] = (byte)(this.svcId >> 8 & 0xFF);
        result[6] = (byte)(this.svcId & 0xFF);
        result[7] = (byte)(this.hashCount >> 24 & 0xFF);
        result[8] = (byte)(this.hashCount >> 16 & 0xFF);
        result[9] = (byte)(this.hashCount >> 8 & 0xFF);
        result[10] = (byte)(this.hashCount & 0xFF);
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("Adding context at index " + this.svcId + " with scopes content " + scopes + " for key " + CorbaLoc.parseKey(object_key));
        }
        this.serviceContextKeyCache[this.svcId] = new ContextKey(gc, object_key, oid, scopes, this.hashCount);
        ++this.hashCount;
        this.hashCount = this.hashCount < 0 ? 0 : this.hashCount;
        return result;
    }

    private synchronized void purgeCtxCache() {
        int removalCount = 0;
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("GIOPConnectionManager: purging cache with size " + this.contextCacheSize + " and usageCountMax " + this.usageCountMax + " and array " + this.serviceContextKeyCache.length);
        }
        for (int i2 = 0; i2 < this.contextCacheSize; ++i2) {
            if (this.serviceContextKeyCache[i2] == null || this.serviceContextKeyCache[i2].usageCount >= this.usageCountMax) continue;
            this.serviceContextKeyCache[i2] = null;
            ++removalCount;
        }
        if (removalCount == 0) {
            this.serviceContextKeyCache = new ContextKey[this.contextCacheSize];
            this.usageCountMax = 0;
            removalCount = this.contextCacheSize;
        } else if (removalCount == this.contextCacheSize) {
            this.usageCountMax = 0;
        }
        this.hashCount += removalCount;
        this.hashCount = this.hashCount < 0 ? 0 : this.hashCount;
        this.svcId = 0;
        while (this.svcId < this.contextCacheSize && this.serviceContextKeyCache[this.svcId] != null) {
            ++this.svcId;
        }
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("GIOPConnectionManager: purged " + removalCount + " slots.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    ContextKey getContextKey(GIOPConnection gc, byte[] key) {
        ContextKey result = null;
        int index = -1;
        int hash = -1;
        if (this.serviceContextKeyCache != null && key != null && key.length == 11 && key[0] == 74 && key[1] == 65 && key[2] == 67) {
            index = ((key[3] & 0xFF) << 24) + ((key[4] & 0xFF) << 16) + ((key[5] & 0xFF) << 8) + ((key[6] & 0xFF) << 0);
            hash = ((key[7] & 0xFF) << 24) + ((key[8] & 0xFF) << 16) + ((key[9] & 0xFF) << 8) + ((key[10] & 0xFF) << 0);
            GIOPConnectionManager gIOPConnectionManager = this;
            synchronized (gIOPConnectionManager) {
                try {
                    result = this.serviceContextKeyCache[index];
                }
                catch (ArrayIndexOutOfBoundsException e2) {
                    throw new INTERNAL("Cache out of bounds - unable to retrieve cached key entry for " + index);
                }
                if (result == null) {
                    throw new INTERNAL("Unable to retrieve cached key entry for " + index);
                }
                if (hash != result.hash) {
                    throw new INTERNAL("Cached entry for " + index + " has a different hash " + result.hash + " to this one " + hash);
                }
                if (gc != result.gc) {
                    throw new INTERNAL("Cached entry for " + index + " is being used by another GIOPConnection " + result.gc + " to this one " + gc);
                }
                result.usageCount++;
                if (result.usageCount > this.usageCountMax) {
                    this.usageCountMax = result.usageCount;
                } else if (result.usageCount < 0) {
                    result.usageCount = 0;
                    this.usageCountMax = 0;
                }
            }
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("getContextKey for " + index + " (usage: " + result.usageCount + ") returning scopes" + result.scopes.toString() + " and key " + CorbaLoc.parseKey(result.getKey()));
            }
        }
        return result;
    }

    public static final class ContextKey {
        private final List scopes;
        private final byte[] key;
        private final byte[] oid;
        private int usageCount;
        private int hash;
        private GIOPConnection gc;

        public ContextKey(GIOPConnection _gc, byte[] _key, byte[] _oid, List _scopes, int _hash) {
            this.gc = _gc;
            this.key = _key;
            this.scopes = _scopes;
            this.oid = _oid;
            this.hash = _hash;
        }

        public List getScopes() {
            return this.scopes;
        }

        public byte[] getOID() {
            return this.oid;
        }

        public byte[] getKey() {
            return this.key;
        }
    }
}

